/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginUtil;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.dbmgr.QxOperation2DBMaping;
import com.huawei.nglct.nemgr.dbmgr.TENEQxDbMgrInterface;
import com.huawei.nglct.nemgr.dbmgr.TEWebLCTDBGenCfgUtil;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.po.embeddednemgrmo.gencfg.TEWebLCTBoardGenCfgMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.xpic.TEWebLCTRtnXpicGroupMOPO;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEUpdateOrAddXpicToDB
implements TENEQxDbMgrInterface {
    private static final int ERR_XPIC_NOTEXIST = 42752;
    private final Logger logger = TELogFactory.getNormalLogger();
    private static final int DIRECTION_H = 0;
    private static final int DIRECTION_V = 1;
    private static List<String> REFERENCE_OPERS = new ArrayList<String>();
    private static Map<String, String> PARAM_MAP = new HashMap<String, String>();
    private static List<String> ODU_PARAM_LIST = new ArrayList<String>();

    public void processQxOperationFromDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        if (!REFERENCE_OPERS.contains(oper.getName())) {
            return;
        }
        this.logger.info("TEUpdateOrAddXpicToDB: start refactor operation from DB! the operation name is " + oper.getName());
        if ("NSCMD_CFG_ADD_XPIC_GROUP".equals(oper.getName())) {
            this.newXpicMO(ne, oper);
        } else if ("NSCMD_CFG_SET_RADIO_XPIC_ENABLE".equals(oper.getName())) {
            this.newSpanXpicMO(ne, oper);
        } else {
            this.UpdateMO(ne, oper);
        }
        this.logger.info("TEUpdateOrAddXpicToDB: end refactor operation from DB! the operation name is " + oper.getName());
    }

    private void newSpanXpicMO(TENE ne, Operation oper) {
        String xpicEnable = oper.getInput().getPart("W32PORT_ATTR_XPICENABLED").getValue();
        if (xpicEnable.equals("0")) {
            TEMODBMgr dbmgr = new TEMODBMgr();
            TECommonResult result = dbmgr.getMOFromDB(ne.getNEID(), TEWebLCTRtnXpicGroupMOPO.class);
            if (result != null && !((List)result.getReturnObject()).isEmpty()) {
                int size = ((List)result.getReturnObject()).size();
                for (int i = 0; i < size; ++i) {
                    TEWebLCTRtnXpicGroupMOPO xpicMO = (TEWebLCTRtnXpicGroupMOPO)((List)result.getReturnObject()).get(i);
                    dbmgr.delMOFromDB(ne.getNEID(), (Object)xpicMO);
                }
                TEErrInfoReturn errRes = new TEErrInfoReturn();
                errRes.setResult(0);
                this.refactorFault(oper, errRes);
            } else {
                TEErrInfoReturn errRes = new TEErrInfoReturn();
                errRes.setResult(42752);
                this.refactorFault(oper, errRes);
            }
        } else {
            TEWebLCTRtnXpicGroupMOPO xpicMO = new TEWebLCTRtnXpicGroupMOPO();
            xpicMO.setGroupID((short)0);
            xpicMO.setHSlotID(-1);
            xpicMO.setHPortID((short)-1);
            xpicMO.setVSlotID(-1);
            xpicMO.setVPortID((short)-1);
            xpicMO.setTFrequency(0L);
            TEMODBMgr dbmgr = new TEMODBMgr();
            TEErrInfoReturn result = dbmgr.createMOToDB(ne.getNEID(), (Object)xpicMO);
            this.refactorFault(oper, result);
        }
    }

    private void newXpicMO(TENE ne, Operation oper) {
        TEWebLCTRtnXpicGroupMOPO xpicMO = new TEWebLCTRtnXpicGroupMOPO();
        xpicMO.setGroupID(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"groupid", (String)"0")).shortValue());
        xpicMO.setHSlotID(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"hPolarBdid", (int)-1));
        xpicMO.setHPortID(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"hPolarPortid", (String)"-1")).shortValue());
        xpicMO.setVSlotID(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"vPolarBdid", (int)-1));
        xpicMO.setVPortID(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"vPolarPortid", (String)"-1")).shortValue());
        xpicMO.setTFrequency(Long.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"transmitFrequency", (String)"0")).longValue());
        TEMODBMgr dbmgr = new TEMODBMgr();
        TEErrInfoReturn result = dbmgr.createMOToDB(ne.getNEID(), (Object)xpicMO);
        if (result.getResult() == 0) {
            int hSlotID = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"hPolarBdid", (int)-1);
            int vSlotID = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"vPolarBdid", (int)-1);
            this.synchronizeGencfgMoWithXpicMO(ne.getNEID(), hSlotID, "W32BRD_ATTR_TRANSMITFRE", TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"transmitFrequency", (String)"0"));
            this.synchronizeGencfgMoWithXpicMO(ne.getNEID(), vSlotID, "W32BRD_ATTR_TRANSMITFRE", TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"transmitFrequency", (String)"0"));
        }
        this.refactorFault(oper, result);
    }

    private void UpdateMO(TENE ne, Operation oper) {
        TEWebLCTRtnXpicGroupMOPO xpicMO = this.getMOByID(ne, oper);
        if (xpicMO == null) {
            TEErrInfoReturn errRes = new TEErrInfoReturn();
            errRes.setResult(42752);
            this.refactorFault(oper, errRes);
            this.logger.info("TEUpdateOrAddXpicToDB:update failed, can not find MO!the operation name is " + oper.getName());
            return;
        }
        String operName = oper.getName();
        if ("NSCMD_CFG_SET_XPIC_ODU_TXPOWER".equals(operName)) {
            xpicMO.setTPower(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"transmitPower", (int)0));
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "transmitPower", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ODU_WORK".equals(operName)) {
            xpicMO.setWorkStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"workStatus", (String)"0")).shortValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "workStatus", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ATPC_ENABLE".equals(operName)) {
            xpicMO.setAtpcEnabledStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"atpcEnableStatus", (String)"0")).shortValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "atpcEnableStatus", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ATPCAUTOEN".equals(operName)) {
            xpicMO.setAtpcAutoStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"atpcAutoEnable", (String)"0")).shortValue());
        } else if ("NSCMD_CFG_SET_XPIC_ATPC_THRESHOLD".equals(operName)) {
            xpicMO.setAtpcUpTh(Integer.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"atpcUpperThreshold", (String)"0")).intValue());
            xpicMO.setAtpcDwTh(Integer.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"atpcLowerThreshold", (String)"0")).intValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "atpcUpperThreshold", "0");
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "atpcLowerThreshold", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ODU_TXFREQ".equals(operName)) {
            xpicMO.setTFrequency(Long.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"transmitFrequency", (String)"0")).longValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "transmitFrequency", "0");
        } else if ("NSCMD_CFG_SET_XPIC_BANDWIDTH".equals(operName)) {
            xpicMO.setBandWidth(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"bandwidth", (int)0));
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "bandwidth", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ODUTRSPACING".equals(operName)) {
            xpicMO.setTrInterval(Long.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"trInterval", (String)"0")).longValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "trInterval", "0");
        } else if ("NSCMD_CFG_SET_XPIC_ODUMAXTSL".equals(operName)) {
            xpicMO.setMaxTPower(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"maxTransmitPower", (int)0));
        } else if ("NSCMD_CFG_SET_XPIC_AMBOOST_ENABLE".equals(operName)) {
            xpicMO.setAmBoostStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"W32PORT_ATTR_XPICAMBOOSTSTATUS", (String)"0")).shortValue());
        } else if ("NSCMD_CFG_SET_XPIC_ACM_PARAM".equals(operName)) {
            xpicMO.setHAmStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"amstate", (String)"0")).shortValue());
            xpicMO.setHEnsureMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"ensuremode", (String)"255")).shortValue());
            xpicMO.setHFullMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"fullmode", (String)"255")).shortValue());
            xpicMO.setHManualMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"manualmode", (String)"1")).shortValue());
            xpicMO.setVAmStatus(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"amstate", (String)"0")).shortValue());
            xpicMO.setVEnsureMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"ensuremode", (String)"255")).shortValue());
            xpicMO.setVFullMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"fullmode", (String)"255")).shortValue());
            xpicMO.setVManualMode(Short.valueOf(TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"manualmode", (String)"1")).shortValue());
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "amstate", "0");
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "ensuremode", "255");
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "fullmode", "255");
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "manualmode", "1");
        } else if ("NSCMD_CFG_SET_XPIC_BDPOLAR_WBID".equals(operName)) {
            int direction = TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"W32PORT_ATTR_XPICDIRECTION", (int)-1);
            xpicMO.setHSlotID(-1);
            xpicMO.setHPortID((short)-1);
            xpicMO.setVSlotID(-1);
            xpicMO.setVPortID((short)-1);
            if (direction == 0) {
                xpicMO.setHSlotID(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"slotid", (int)-1));
                xpicMO.setHPortID((short)TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"port", (int)-1));
            } else if (direction == 1) {
                xpicMO.setVSlotID(TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"slotid", (int)-1));
                xpicMO.setVPortID((short)TEBeanPluginUtil.getInputPartValueInt((Operation)oper, (String)"port", (int)-1));
            }
            this.synXpicMOtoGenCfgMO(ne, xpicMO, oper, "amstate", "0");
        }
        TEMODBMgr dbmgr = new TEMODBMgr();
        TEErrInfoReturn result = dbmgr.updateMOToDB(ne.getNEID(), (Object)xpicMO);
        this.refactorFault(oper, result);
    }

    private void refactorFault(Operation oper, TEErrInfoReturn result) {
        Output output = oper.getOutput(0);
        output.clearFault();
        Fault fault = new Fault();
        if (0 == result.getResult()) {
            fault.setCode(String.valueOf(0));
        } else {
            fault.setCode(String.valueOf(result.getResult()));
        }
        oper.getOutput(0).addFault(fault);
    }

    private TEWebLCTRtnXpicGroupMOPO getMOByID(TENE ne, Operation oper) {
        TEWebLCTRtnXpicGroupMOPO pgMO = null;
        TEDaoNameValuePair groupIdPair = new TEDaoNameValuePair("GroupID", TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)"groupid", (String)"0"));
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        criteria.add(groupIdPair);
        TEMODBMgr dbmgr = new TEMODBMgr();
        TECommonResult result = dbmgr.getMOFromDB(ne.getNEID(), TEWebLCTRtnXpicGroupMOPO.class, criteria);
        if (result.getErrInfoRet().getResult() == 0 && ((List)result.getReturnObject()).size() > 0) {
            pgMO = (TEWebLCTRtnXpicGroupMOPO)((List)result.getReturnObject()).get(0);
        }
        return pgMO;
    }

    public void processQxOperationToDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        try {
            if (oper.getOutput().length <= 0) {
                return;
            }
            if (!"0".equals(oper.getOutput()[0].getFault()[0].getCode())) {
                return;
            }
            TEMODBMgr dbmgr = new TEMODBMgr();
            String slotidStr = oper.getInput().getPartValue("slotid");
            if (null == slotidStr || slotidStr.equals("")) {
                slotidStr = oper.getInput().getPartValue("ifslotid");
            }
            if (null == slotidStr || slotidStr.equals("")) {
                return;
            }
            int slotid = Integer.parseInt(slotidStr);
            String portid = oper.getInput().getPartValue("port");
            if (null == portid || portid.equals("")) {
                return;
            }
            String xpicEnableValue = oper.getInput().getPartValue("W32PORT_ATTR_XPICENABLED");
            if (null == xpicEnableValue || xpicEnableValue.equals("")) {
                return;
            }
            TEWebLCTBoardGenCfgMOPO ethBandMO = this.queryBoardGenCfgMO(ne, oper, "W32PORT_ATTR_XPICENABLED");
            if (ethBandMO != null) {
                ethBandMO.setAttrValue(xpicEnableValue);
                dbmgr.updateMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
            } else {
                ethBandMO = new TEWebLCTBoardGenCfgMOPO();
                ethBandMO.setAttrName("W32PORT_ATTR_XPICENABLED");
                ethBandMO.setAttrValue(xpicEnableValue);
                ethBandMO.setExtendPara1("");
                ethBandMO.setExtendPara2("");
                ethBandMO.setExtendPara3("");
                ethBandMO.setGrade(-1);
                ethBandMO.setLevel(-1);
                ethBandMO.setObjectType(61443);
                ethBandMO.setPath(-1);
                ethBandMO.setPort(Integer.parseInt(portid));
                ethBandMO.setSlotId(slotid);
                dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGetXpicInfoFromDB.processQxOperationToDB() fail!", (Throwable)e);
            return;
        }
    }

    private TEWebLCTBoardGenCfgMOPO queryBoardGenCfgMO(TENE ne, Operation oper, String attrName) {
        TEWebLCTBoardGenCfgMOPO resultMO = null;
        TEMODBMgr dbmgr = new TEMODBMgr();
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (null == slotidStr || slotidStr.equals("")) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        if (null == slotidStr || slotidStr.equals("")) {
            return null;
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue("port");
        if (null == portid || portid.equals("")) {
            return null;
        }
        ArrayList<TEDaoNameValuePair> criteriaList = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair = new TEDaoNameValuePair();
        pair.setName("Port");
        pair.setValue(portid);
        criteriaList.add(pair);
        pair = new TEDaoNameValuePair();
        pair.setName("AttrName");
        pair.setValue(attrName);
        criteriaList.add(pair);
        TECommonResult moResult = dbmgr.getMOFromDB(ne.getNEID(), slotid, TEWebLCTBoardGenCfgMOPO.class, criteriaList);
        if (moResult.getErrInfoRet().getResult() == 0 && moResult.getReturnObject() != null && ((List)moResult.getReturnObject()).size() > 0) {
            resultMO = (TEWebLCTBoardGenCfgMOPO)((List)moResult.getReturnObject()).get(0);
        }
        return resultMO;
    }

    private void synXpicMOtoGenCfgMO(TENE ne, TEWebLCTRtnXpicGroupMOPO xpicMO, Operation oper, String keyParamName, String defaultValue) {
        String relativeParamName = PARAM_MAP.get(keyParamName);
        int hSlotID = xpicMO.getHSlotID();
        int vSlotID = xpicMO.getVSlotID();
        if (ODU_PARAM_LIST.contains(keyParamName)) {
            if (hSlotID != -1) {
                hSlotID = TEIFODUCommonBean.getRelativeODUSlotID(ne.getNEID(), hSlotID);
            }
            if (vSlotID != -1) {
                vSlotID = TEIFODUCommonBean.getRelativeODUSlotID(ne.getNEID(), vSlotID);
            }
        }
        if (hSlotID != -1) {
            this.synchronizeGencfgMoWithXpicMO(ne.getNEID(), hSlotID, relativeParamName, TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)keyParamName, (String)defaultValue));
        }
        if (vSlotID != -1) {
            this.synchronizeGencfgMoWithXpicMO(ne.getNEID(), vSlotID, relativeParamName, TEBeanPluginUtil.getInputPartValueStr((Operation)oper, (String)keyParamName, (String)defaultValue));
        }
    }

    private void synchronizeGencfgMoWithXpicMO(int neid, int slotid, String attrName, String attrValue) {
        TEErrInfoReturn result;
        TEWebLCTDBGenCfgUtil util = new TEWebLCTDBGenCfgUtil(neid);
        TEWebLCTBoardGenCfgMOPO gencfgMO = util.queryAttrFromBoardDB(null, slotid, attrName);
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        if (currentNE.getBoard(slotid) == null) {
            return;
        }
        TEMODBMgr dbmgr = new TEMODBMgr();
        int bdType = currentNE.getBoard(slotid).getBoardType();
        boolean isIFBoard = TEConfigurationDataMgr.getInstance().isIFboard(bdType);
        boolean isAdd = false;
        if (gencfgMO == null) {
            gencfgMO = new TEWebLCTBoardGenCfgMOPO();
            gencfgMO.setAttrName(attrName);
            gencfgMO.setAttrValue(attrValue);
            gencfgMO.setExtendPara1("");
            gencfgMO.setExtendPara2("");
            gencfgMO.setExtendPara3("");
            gencfgMO.setGrade(-1);
            gencfgMO.setLevel(-1);
            gencfgMO.setObjectType(isIFBoard ? 61443 : 61442);
            gencfgMO.setPath(-1);
            gencfgMO.setPort(isIFBoard ? 1 : -1);
            gencfgMO.setSlotId(slotid);
            result = dbmgr.createMOToDB(neid, slotid, (Object)gencfgMO);
            isAdd = true;
        } else {
            gencfgMO.setAttrValue(attrValue);
            result = dbmgr.updateMOToDB(neid, slotid, (Object)gencfgMO);
            isAdd = false;
        }
        if (result.getResult() != 0) {
            this.logger.info("TEUpdateOrAddXpicToDB:" + attrName + ". Failed to Synchronize GencfgMo With XpicMO." + (isAdd ? "Add" : "Modify"));
        }
    }

    static {
        REFERENCE_OPERS.add("NSCMD_CFG_ADD_XPIC_GROUP");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ODU_TXPOWER");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ODU_WORK");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ATPC_ENABLE");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ATPCAUTOEN");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ATPC_THRESHOLD");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ODU_TXFREQ");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_BANDWIDTH");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ODUTRSPACING");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ODUMAXTSL");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_AMBOOST_ENABLE");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_ACM_PARAM");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_RADIO_XPIC_ENABLE");
        REFERENCE_OPERS.add("NSCMD_CFG_SET_XPIC_BDPOLAR_WBID");
        PARAM_MAP.put("transmitPower", "W32BRD_ATTR_TRANSMITPOWER");
        PARAM_MAP.put("workStatus", "W32BRD_ATTR_WORKSTATUS");
        PARAM_MAP.put("atpcEnableStatus", "W32PORT_ATTR_ATPCENABLE");
        PARAM_MAP.put("atpcUpperThreshold", "W32PORT_ATTR_ATPCUPPER");
        PARAM_MAP.put("atpcLowerThreshold", "W32PORT_ATTR_ATPCLOWER");
        PARAM_MAP.put("transmitFrequency", "W32BRD_ATTR_TRANSMITFRE");
        PARAM_MAP.put("bandwidth", "W32PORT_ATTR_CHANNELSPACE");
        PARAM_MAP.put("trInterval", "W32BRD_ATTR_TRINTERVAL");
        PARAM_MAP.put("amstate", "W32PORT_ATTR_ACMENABLESTATUS");
        PARAM_MAP.put("ensuremode", "W32PORT_ATTR_ENSURECALMODE");
        PARAM_MAP.put("fullmode", "W32PORT_ATTR_ALLCALMODE");
        PARAM_MAP.put("manualmode", "W32PORT_ATTR_MANUALMODE");
        ODU_PARAM_LIST.add("transmitPower");
        ODU_PARAM_LIST.add("workStatus");
        ODU_PARAM_LIST.add("transmitFrequency");
        ODU_PARAM_LIST.add("trInterval");
    }
}

