/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class TEModifyXPIC
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "xpic" + File.separator + "xpicres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String amboostValue;
        Param amboostParam;
        String workStatusStr;
        String transmitFrequencyCheck;
        String transmitPowerStr;
        String maxTransmitPowerStr;
        String bandwidthStr;
        String des = "";
        RowParams rowParams = null;
        rowParams = this.inputData.getBussinessParams().getRowParams(0);
        des = this.resourceUtil.getString("groupid") + ":" + rowParams.getParam("groupid").getValue() + ",";
        if (null != rowParams.getParam("bandwidth") && !"".equals(bandwidthStr = rowParams.getParam("bandwidth").getValue())) {
            des = des + this.resourceUtil.getString("bandwidth") + ":" + this.resourceUtil.getString("bandwidth" + bandwidthStr) + ",";
        }
        int len = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            Param atpcLowerThresholdParam;
            Param atpcUpperThresholdParam;
            Param atpcAdjustmentParam;
            String receivedPowerHStr;
            String receivedPowerVStr;
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            if (null != rowParams.getParam("W32BRD_ATTR_RECEIVEPOWER") && null != rowParams.getParam("receivedPowerVFalg") && !"".equals(receivedPowerVStr = rowParams.getParam("W32BRD_ATTR_RECEIVEPOWER").getValue())) {
                int receivedPowerV = Integer.parseInt(receivedPowerVStr);
                des = des + this.resourceUtil.getString("receivedPowerV") + ":" + (double)receivedPowerV * 0.1 + ",";
            }
            if (null != rowParams.getParam("W32BRD_ATTR_RECEIVEPOWER") && null != rowParams.getParam("receivedPowerHFalg") && !"".equals(receivedPowerHStr = rowParams.getParam("W32BRD_ATTR_RECEIVEPOWER").getValue())) {
                int receivedPowerH = Integer.parseInt(receivedPowerHStr);
                des = des + this.resourceUtil.getString("receivedPowerH") + ":" + (double)receivedPowerH * 0.1 + ",";
            }
            String atpcEnableStatusCheck = "";
            if (null != rowParams.getParam("atpcEnableStatus")) {
                atpcEnableStatusCheck = rowParams.getParam("atpcEnableStatus").getValue();
            }
            if (!"".equals(atpcEnableStatusCheck)) {
                int atpcEnableStatus = Integer.parseInt(atpcEnableStatusCheck);
                if (0 == atpcEnableStatus) {
                    des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("disable") + ",";
                } else if (1 == atpcEnableStatus) {
                    des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("enable") + ",";
                }
            }
            if ((atpcAdjustmentParam = rowParams.getParam("atpcAdjustment")) != null && !"".equals(atpcAdjustmentParam.getValue())) {
                int atpcAdjustment = Integer.parseInt(atpcAdjustmentParam.getValue()) / 10;
                des = des + this.resourceUtil.getString("atpcAdjustment") + ":" + atpcAdjustment + ",";
            }
            if ((atpcUpperThresholdParam = rowParams.getParam("atpcUpperThreshold")) != null && !"".equals(atpcUpperThresholdParam.getValue())) {
                int atpcUpperThreshold = Integer.parseInt(atpcUpperThresholdParam.getValue());
                des = des + this.resourceUtil.getString("atpcUpperThreshold") + ":" + (double)atpcUpperThreshold * 0.1 + ",";
            }
            if ((atpcLowerThresholdParam = rowParams.getParam("atpcLowerThreshold")) == null || "".equals(atpcLowerThresholdParam.getValue())) continue;
            int atpcLowerThreshold = Integer.parseInt(rowParams.getParam("atpcLowerThreshold").getValue());
            des = des + this.resourceUtil.getString("atpcLowerThreshold") + ":" + (double)atpcLowerThreshold * 0.1;
        }
        rowParams = this.inputData.getBussinessParams().getRowParams(0);
        if (null != rowParams.getParam("maxTransmitPower") && !"".equals(maxTransmitPowerStr = rowParams.getParam("maxTransmitPower").getValue())) {
            int maxTransmitPower = Integer.parseInt(rowParams.getParam("maxTransmitPower").getValue());
            des = des + this.resourceUtil.getString("transmitPower") + ":" + (double)maxTransmitPower * 0.1 + ",";
        }
        if (null != rowParams.getParam("transmitPower") && !"".equals(transmitPowerStr = rowParams.getParam("transmitPower").getValue())) {
            int transmitPower = Integer.parseInt(rowParams.getParam("transmitPower").getValue());
            des = des + this.resourceUtil.getString("transmitPower") + ":" + (double)transmitPower * 0.1 + ",";
        }
        if (this.isValidParam(rowParams.getParam("transmitFrequency")) && !"".equals(transmitFrequencyCheck = rowParams.getParam("transmitFrequency").getValue())) {
            DecimalFormat df = new DecimalFormat(".000");
            long transmitFrequency = Long.parseLong(transmitFrequencyCheck);
            float transmitFrequencyParse = (float)transmitFrequency / new Float(1000.0f).floatValue();
            des = des + this.resourceUtil.getString("transmitFrequency") + ":" + String.valueOf(df.format(transmitFrequencyParse)) + ",";
        }
        if (null != rowParams.getParam("workStatus") && !"".equals(workStatusStr = rowParams.getParam("workStatus").getValue())) {
            int workStatus = Integer.parseInt(rowParams.getParam("workStatus").getValue());
            if (0 == workStatus) {
                des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("sleep") + ",";
            } else if (1 == workStatus) {
                des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("shoot") + ",";
            }
        }
        if ((amboostParam = rowParams.getParam("W32PORT_ATTR_XPICAMBOOSTSTATUS")) != null && !"".equals(amboostValue = amboostParam.getValue())) {
            des = des + this.resourceUtil.getString("W32PORT_ATTR_XPICAMBOOSTSTATUS") + ":";
            int amboostStatus = Integer.parseInt(amboostValue);
            if (0 == amboostStatus) {
                des = des + this.resourceUtil.getString("disable") + ",";
            } else if (1 == amboostStatus) {
                des = des + this.resourceUtil.getString("enable") + ",";
            }
        }
        return des;
    }

    public void distinctErrorCodeItemFilter(Datainterface output) {
        int Paramscount = output.getBussinessParams().getRowParamsCount();
        RowParams rowParams = output.getBussinessParams().getRowParams()[Paramscount - 1];
        RowErrors[] rowErrors = rowParams.getRowErrors();
        int len = rowErrors.length;
        RowErrors tmp_rowerrors = null;
        RowErrors tmp_rowerrors_1 = null;
        for (int i = 0; i < len; ++i) {
            tmp_rowerrors = rowErrors[i];
            for (int j = len - 1; j > i; --j) {
                tmp_rowerrors_1 = rowErrors[j];
                if (!tmp_rowerrors.getErrorMessage().getErrorcode().equals(tmp_rowerrors_1.getErrorMessage().getErrorcode())) continue;
                rowParams.removeRowErrors(rowErrors[j]);
                --len;
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            try {
                this.distinctErrorCodeItemFilter(this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("handleMessage fail!", (Throwable)e);
            }
        }
    }

    private boolean isValidParam(Param param) {
        return param != null && param.getValue() != null && !param.getValue().isEmpty();
    }
}

