/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nemgr.dbmgr.QxOperation2DBMaping;
import com.huawei.nglct.nemgr.dbmgr.TENEQxDbMgrInterface;
import com.huawei.nglct.po.embeddednemgrmo.gencfg.TEWebLCTBoardGenCfgMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.xpic.TEWebLCTRtnXpicGroupMOPO;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEGetXpicInfoFromDB
implements TENEQxDbMgrInterface {
    private static final int ERR_QUERY_ISNULL = 38662;
    private final Logger logger = TELogFactory.getNormalLogger();
    private static List<String> REFERENCE_OPERS = new ArrayList<String>();

    public void processQxOperationFromDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        if (!REFERENCE_OPERS.contains(oper.getName())) {
            return;
        }
        this.logger.info("TEGetXpicInfoFromDB:start refactor operation from DB! the operation name is " + oper.getName());
        int neID = ne.getNEID();
        TEMODBMgr dbmgr = new TEMODBMgr();
        TECommonResult result = dbmgr.getMOFromDB(neID, TEWebLCTRtnXpicGroupMOPO.class);
        this.refactorOper((TECommonResult<List<TEWebLCTRtnXpicGroupMOPO>>)result, oper);
        this.logger.info("TEGetXpicInfoFromDB:end refactor operation from DB! the operation name is " + oper.getName());
    }

    private void refactorOper(TECommonResult<List<TEWebLCTRtnXpicGroupMOPO>> result, Operation oper) {
        TEErrInfoReturn errInfo = result.getErrInfoRet();
        if (errInfo.getResult() == 0) {
            if (result.getReturnObject() == null || ((List)result.getReturnObject()).isEmpty()) {
                if (oper.getName().equalsIgnoreCase("NSCMD_CFG_GET_RADIO_XPIC_ENABLE")) {
                    int slot = Integer.valueOf(oper.getInput().getPartValue("slotid"));
                    Output output = new Output();
                    Fault fault = new Fault();
                    fault.setCode(String.valueOf(0));
                    output.addFault(fault);
                    Part part = new Part();
                    part.setName("slotid");
                    part.setValue(String.valueOf(slot));
                    output.addPart(part);
                    part = new Part();
                    part.setName("subslotid");
                    part.setValue("255");
                    output.addPart(part);
                    part = new Part();
                    part.setName("port");
                    part.setValue("1");
                    output.addPart(part);
                    part = new Part();
                    part.setName("W32PORT_ATTR_XPICENABLED");
                    part.setValue("0");
                    output.addPart(part);
                    oper.clearOutput();
                    oper.addOutput(output);
                    return;
                }
                errInfo = new TEErrInfoReturn();
                errInfo.setResult(38662);
                this.logger.info("TEGetXpicInfoFromDB:no data return from DB!");
                this.refactorFault(oper, errInfo);
                return;
            }
            String operName = oper.getName();
            oper.clearOutput();
            int size = ((List)result.getReturnObject()).size();
            for (int i = 0; i < size; ++i) {
                TEWebLCTRtnXpicGroupMOPO xpicMO = (TEWebLCTRtnXpicGroupMOPO)((List)result.getReturnObject()).get(i);
                Output output = new Output();
                this.fillOutPut(operName, xpicMO, oper.getInput(), output);
                oper.addOutput(output);
            }
        } else {
            this.refactorFault(oper, errInfo);
        }
    }

    private void fillOutPut(String operName, TEWebLCTRtnXpicGroupMOPO xpicMO, Input input, Output output) {
        Fault fault = new Fault();
        fault.setCode(String.valueOf(0));
        output.addFault(fault);
        Part part = new Part();
        part.setName("groupid");
        part.setValue(String.valueOf(xpicMO.getGroupID()));
        output.addPart(part);
        if ("NSCMD_CFG_GET_XPIC_GROUP".equals(operName)) {
            part = new Part();
            part.setName("hPolarBdid");
            part.setValue(String.valueOf(xpicMO.getHSlotID()));
            output.addPart(part);
            part = new Part();
            part.setName("subcard1");
            part.setValue("255");
            output.addPart(part);
            part = new Part();
            part.setName("hPolarPortid");
            part.setValue(String.valueOf(xpicMO.getHPortID()));
            output.addPart(part);
            part = new Part();
            part.setName("vPolarBdid");
            part.setValue(String.valueOf(xpicMO.getVSlotID()));
            output.addPart(part);
            part = new Part();
            part.setName("subcard2");
            part.setValue("255");
            output.addPart(part);
            part = new Part();
            part.setName("vPolarPortid");
            part.setValue(String.valueOf(xpicMO.getVPortID()));
            output.addPart(part);
            part = new Part();
            part.setName("activeFlag");
            part.setValue("3");
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ATPC_ENABLE".equals(operName)) {
            part = new Part();
            part.setName("atpcEnableStatus");
            part.setValue(String.valueOf(xpicMO.getAtpcEnabledStatus()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ATPCAUTOEN".equals(operName)) {
            part = new Part();
            part.setName("atpcAutoEnable");
            part.setValue(String.valueOf(xpicMO.getAtpcAutoStatus()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ATPC_THRESHOLD".equals(operName)) {
            part = new Part();
            part.setName("atpcUpperThreshold");
            part.setValue(String.valueOf(xpicMO.getAtpcUpTh()));
            output.addPart(part);
            part = new Part();
            part.setName("atpcLowerThreshold");
            part.setValue(String.valueOf(xpicMO.getAtpcDwTh()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ODU_TXFREQ".equals(operName)) {
            part = new Part();
            part.setName("transmitFrequency");
            part.setValue(String.valueOf(xpicMO.getTFrequency()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ODU_TXPOWER".equals(operName)) {
            part = new Part();
            part.setName("transmitPower");
            part.setValue(String.valueOf(xpicMO.getTPower()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ODU_WORK".equals(operName)) {
            part = new Part();
            part.setName("workStatus");
            part.setValue(String.valueOf(xpicMO.getWorkStatus()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_BANDWIDTH".equals(operName)) {
            part = new Part();
            part.setName("bandwidth");
            part.setValue(String.valueOf(xpicMO.getBandWidth()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ODUMAXTSL".equals(operName)) {
            part = new Part();
            part.setName("maxTransmitPower");
            part.setValue(String.valueOf(xpicMO.getMaxTPower()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_ODUTRSPACING".equals(operName)) {
            part = new Part();
            part.setName("trInterval");
            part.setValue(String.valueOf(xpicMO.getTrInterval()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_AMBOOST_ENABLE".equals(operName)) {
            part = new Part();
            part.setName("W32PORT_ATTR_XPICAMBOOSTSTATUS");
            part.setValue(String.valueOf(xpicMO.getAmBoostStatus()));
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_AM_PARAM".equals(operName)) {
            String amState = "0";
            String ensureMode = "255";
            String fullMode = "255";
            String manualMode = "1";
            int slot = Integer.valueOf(input.getPartValue("slotid"));
            if (slot == xpicMO.getHSlotID()) {
                amState = String.valueOf(xpicMO.getHAmStatus());
                ensureMode = String.valueOf(xpicMO.getHEnsureMode());
                fullMode = String.valueOf(xpicMO.getHFullMode());
                manualMode = String.valueOf(xpicMO.getHManualMode());
            } else if (slot == xpicMO.getVSlotID()) {
                amState = String.valueOf(xpicMO.getVAmStatus());
                ensureMode = String.valueOf(xpicMO.getVEnsureMode());
                fullMode = String.valueOf(xpicMO.getVFullMode());
                manualMode = String.valueOf(xpicMO.getVManualMode());
            }
            part = new Part();
            part.setName("amstate");
            part.setValue(amState);
            output.addPart(part);
            part = new Part();
            part.setName("ensuremode");
            part.setValue(ensureMode);
            output.addPart(part);
            part = new Part();
            part.setName("fullmode");
            part.setValue(fullMode);
            output.addPart(part);
            part = new Part();
            part.setName("manualmode");
            part.setValue(manualMode);
            output.addPart(part);
        } else if ("NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM".equals(operName)) {
            fault.setCode(String.valueOf(38737));
        } else if ("NSCMD_CFG_GET_RADIO_XPIC_ENABLE".equals(operName)) {
            int slot = Integer.valueOf(input.getPartValue("slotid"));
            part = new Part();
            part.setName("slotid");
            part.setValue(String.valueOf(slot));
            output.addPart(part);
            part = new Part();
            part.setName("subslotid");
            part.setValue("255");
            output.addPart(part);
            part = new Part();
            part.setName("port");
            part.setValue("1");
            output.addPart(part);
            part = new Part();
            part.setName("W32PORT_ATTR_XPICENABLED");
            part.setValue("1");
            output.addPart(part);
        } else if ("NSCMD_CFG_GET_XPIC_BDPOLAR_WBID".equals(operName)) {
            int slot = Integer.valueOf(input.getPartValue("slotid"));
            part = new Part();
            part.setName("slotid");
            part.setValue(String.valueOf(slot));
            output.addPart(part);
            part = new Part();
            part.setName("subslotid");
            part.setValue("255");
            output.addPart(part);
            part = new Part();
            part.setName("port");
            part.setValue("1");
            output.addPart(part);
            if (xpicMO.getHSlotID() == slot) {
                part = new Part();
                part.setName("W32PORT_ATTR_XPICDIRECTION");
                part.setValue("0");
                output.addPart(part);
            } else if (xpicMO.getVSlotID() == slot) {
                part = new Part();
                part.setName("W32PORT_ATTR_XPICDIRECTION");
                part.setValue("1");
                output.addPart(part);
            } else {
                this.logger.error("Connot found H or V XPIC board in db for " + slot);
                fault.setCode(String.valueOf(38153));
            }
        }
    }

    private void refactorFault(Operation oper, TEErrInfoReturn result) {
        Output out = oper.getOutput(0);
        out.clearFault();
        Fault newFault = new Fault();
        if (0 == result.getResult()) {
            newFault.setCode(String.valueOf(0));
        } else {
            newFault.setCode(String.valueOf(result.getResult()));
        }
        oper.getOutput(0).addFault(newFault);
    }

    public void processQxOperationToDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        try {
            if (oper.getOutput().length <= 0) {
                return;
            }
            TEMODBMgr dbmgr = new TEMODBMgr();
            String slotidStr = oper.getInput().getPartValue("slotid");
            if (null == slotidStr || slotidStr.equals("")) {
                slotidStr = oper.getInput().getPartValue("ifslotid");
            }
            if (null == slotidStr || slotidStr.equals("")) {
                return;
            }
            int slotid = Integer.parseInt(slotidStr);
            String portid = oper.getInput().getPartValue("port");
            if (null == portid || portid.equals("")) {
                return;
            }
            String xpicEnableValue = oper.getOutput()[0].getPartValue("W32PORT_ATTR_XPICENABLED");
            if (null == xpicEnableValue || xpicEnableValue.equals("")) {
                return;
            }
            TEWebLCTBoardGenCfgMOPO ethBandMO = this.queryBoardGenCfgMO(ne, oper, "W32PORT_ATTR_XPICENABLED");
            if (ethBandMO != null) {
                ethBandMO.setAttrValue(xpicEnableValue);
                dbmgr.updateMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
            } else {
                ethBandMO = new TEWebLCTBoardGenCfgMOPO();
                ethBandMO.setAttrName("W32PORT_ATTR_XPICENABLED");
                ethBandMO.setAttrValue(xpicEnableValue);
                ethBandMO.setExtendPara1("");
                ethBandMO.setExtendPara2("");
                ethBandMO.setExtendPara3("");
                ethBandMO.setGrade(-1);
                ethBandMO.setLevel(-1);
                ethBandMO.setObjectType(61443);
                ethBandMO.setPath(-1);
                ethBandMO.setPort(Integer.parseInt(portid));
                ethBandMO.setSlotId(slotid);
                dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEGetXpicInfoFromDB.processQxOperationToDB() fail!", (Throwable)e);
            return;
        }
    }

    private TEWebLCTBoardGenCfgMOPO queryBoardGenCfgMO(TENE ne, Operation oper, String attrName) {
        TEWebLCTBoardGenCfgMOPO resultMO = null;
        TEMODBMgr dbmgr = new TEMODBMgr();
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (null == slotidStr || slotidStr.equals("")) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        if (null == slotidStr || slotidStr.equals("")) {
            return null;
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue("port");
        if (null == portid || portid.equals("")) {
            return null;
        }
        ArrayList<TEDaoNameValuePair> criteriaList = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair = new TEDaoNameValuePair();
        pair.setName("Port");
        pair.setValue(portid);
        criteriaList.add(pair);
        pair = new TEDaoNameValuePair();
        pair.setName("AttrName");
        pair.setValue(attrName);
        criteriaList.add(pair);
        TECommonResult moResult = dbmgr.getMOFromDB(ne.getNEID(), slotid, TEWebLCTBoardGenCfgMOPO.class, criteriaList);
        if (moResult.getErrInfoRet().getResult() == 0 && moResult.getReturnObject() != null && ((List)moResult.getReturnObject()).size() > 0) {
            resultMO = (TEWebLCTBoardGenCfgMOPO)((List)moResult.getReturnObject()).get(0);
        }
        return resultMO;
    }

    static {
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_GROUP");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ATPC_ENABLE");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ATPCAUTOEN");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ATPC_THRESHOLD");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ODU_TXFREQ");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ODU_TXPOWER");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ODU_WORK");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_BANDWIDTH");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ODUMAXTSL");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_ODUTRSPACING");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_AMBOOST_ENABLE");
        REFERENCE_OPERS.add("NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_AM_PARAM");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_XPIC_BDPOLAR_WBID");
        REFERENCE_OPERS.add("NSCMD_CFG_GET_RADIO_XPIC_ENABLE");
    }
}

