/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEAddXPIC
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "xpic" + File.separator + "xpicres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public int sendMessage(int neid) {
        OperationResult result;
        int retCode = 0;
        ArrayList<Operation> firstOperationList = new ArrayList<Operation>();
        firstOperationList.addAll(this.operationList.subList(0, 2));
        if (!this.isRTN600(neid)) {
            this.filterVertifyCommand(firstOperationList);
        }
        if (null != (result = TENECommMgr.getInstance().sendCommand(neid, firstOperationList, this.getTimeOut()))) {
            retCode = result.retCode;
        }
        if (0 != retCode) {
            return retCode;
        }
        Operation rtnoperation = firstOperationList.get(0);
        Output output = rtnoperation.getOutput(0);
        int faultCode1 = Integer.parseInt(output.getFault(0).getCode());
        if (faultCode1 == 0) {
            int faultCode2;
            if (this.isRTN600(neid) && (faultCode2 = Integer.parseInt((output = (rtnoperation = firstOperationList.get(1)).getOutput(0)).getFault(0).getCode())) != 0) {
                return faultCode2;
            }
            ArrayList<Operation> tmpOperationList = new ArrayList<Operation>();
            tmpOperationList.addAll(this.operationList.subList(2, this.operationList.size()));
            Operation operation1 = null;
            Operation operation2 = null;
            operation1 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_RADIO_LINKID");
            operation2 = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_RADIO_LINKID");
            String hPolarBdid = this.inputData.getBussinessParams().getRowParams(0).getParam("hPolarBdid").getValue();
            String hPolarPortid = "1";
            String vPolarBdid = this.inputData.getBussinessParams().getRowParams(0).getParam("vPolarBdid").getValue();
            String vPolarPortid = "1";
            String W32PORT_ATTR_RADIOLINKIDh = this.inputData.getBussinessParams().getRowParams(0).getParam("W32PORT_ATTR_RADIOLINKIDh").getValue();
            operation1.getInput().getPart("slotid").setValue(hPolarBdid);
            operation1.getInput().getPart("port").setValue(hPolarPortid);
            operation1.getInput().getPart("W32PORT_ATTR_RADIOLINKID").setValue(W32PORT_ATTR_RADIOLINKIDh);
            String W32PORT_ATTR_RADIOLINKIDv = this.inputData.getBussinessParams().getRowParams(0).getParam("W32PORT_ATTR_RADIOLINKIDv").getValue();
            operation2.getInput().getPart("slotid").setValue(vPolarBdid);
            operation2.getInput().getPart("port").setValue(vPolarPortid);
            operation2.getInput().getPart("W32PORT_ATTR_RADIOLINKID").setValue(W32PORT_ATTR_RADIOLINKIDv);
            tmpOperationList.add(operation1);
            tmpOperationList.add(operation2);
            if (!this.isRTN600(neid)) {
                this.filterVertifyCommand(tmpOperationList);
            }
            if (null != (result = TENECommMgr.getInstance().sendCommand(neid, tmpOperationList, this.getTimeOut()))) {
                retCode = result.retCode;
            }
        } else if (faultCode1 != 0) {
            retCode = faultCode1;
        }
        return retCode;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        String des = "";
        RowParams rowParams = null;
        rowParams = this.inputData.getBussinessParams().getRowParams(0);
        int hPolarBdid = Integer.parseInt(rowParams.getParam("hPolarBdid").getValue());
        int vPolarBdid = Integer.parseInt(rowParams.getParam("vPolarBdid").getValue());
        des = this.resourceUtil.getString("workMode") + ":" + this.resourceUtil.getString("workModeSeven") + ";" + this.resourceUtil.getString("pDH") + ":";
        des = des + String.valueOf(hPolarBdid) + this.resourceUtil.getString("sep") + this.getBoardName(hPolarBdid) + ";";
        des = des + this.resourceUtil.getString("pDV") + ":" + String.valueOf(vPolarBdid) + this.resourceUtil.getString("sep") + this.getBoardName(vPolarBdid) + ";";
        if (this.isValidParam(rowParams.getParam("transmitPower"))) {
            int transmitPower = Integer.parseInt(rowParams.getParam("transmitPower").getValue());
            des = des + this.resourceUtil.getString("transmitPower") + ";" + String.valueOf(transmitPower / 10) + ";";
        }
        if (this.isValidParam(rowParams.getParam("transmitFrequency"))) {
            long transmitFrequency = Long.parseLong(rowParams.getParam("transmitFrequency").getValue());
            des = des + this.resourceUtil.getString("transmitFrequency") + ":" + String.valueOf(transmitFrequency / 1000L) + ";";
        }
        if (this.isValidParam(rowParams.getParam("workStatus"))) {
            int workStatus = Integer.parseInt(rowParams.getParam("workStatus").getValue());
            if (0 == workStatus) {
                des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("sleep") + ";";
            } else if (1 == workStatus) {
                des = des + this.resourceUtil.getString("workStatus") + ":" + this.resourceUtil.getString("shoot") + ";";
            }
        }
        if (this.isValidParam(rowParams.getParam("atpcEnableStatus"))) {
            int atpcEnableStatus = Integer.parseInt(rowParams.getParam("atpcEnableStatus").getValue());
            if (0 == atpcEnableStatus) {
                des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("disable") + ";";
            } else if (1 == atpcEnableStatus) {
                des = des + this.resourceUtil.getString("atpcEnableStatus") + ":" + this.resourceUtil.getString("enable") + ";";
            }
            if (1 == atpcEnableStatus) {
                int atpcAdjustment = Integer.parseInt(rowParams.getParam("atpcAdjustment").getValue());
                double atpcUpperThreshold = Integer.parseInt(rowParams.getParam("atpcUpperThreshold").getValue());
                double atpcLowerThreshold = Integer.parseInt(rowParams.getParam("atpcLowerThreshold").getValue());
                des = des + this.resourceUtil.getString("atpcAdjustment") + ":" + String.valueOf(atpcAdjustment / 10) + ";";
                des = des + this.resourceUtil.getString("atpcUpperThreshold") + ":" + String.valueOf(atpcUpperThreshold / 10.0) + ";";
                des = des + this.resourceUtil.getString("atpcLowerThreshold") + ":" + String.valueOf(atpcLowerThreshold / 10.0) + ";";
            }
        }
        return des;
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }

    public void distinctErrorCodeItemFilter(Datainterface output) {
        int Paramscount = output.getBussinessParams().getRowParamsCount();
        RowParams rowParams = output.getBussinessParams().getRowParams()[Paramscount - 1];
        RowErrors[] rowErrors = rowParams.getRowErrors();
        int len = rowErrors.length;
        RowErrors tmp_rowerrors = null;
        RowErrors tmp_rowerrors_1 = null;
        for (int i = 0; i < len; ++i) {
            tmp_rowerrors = rowErrors[i];
            for (int j = len - 1; j > i; --j) {
                tmp_rowerrors_1 = rowErrors[j];
                if (!tmp_rowerrors.getErrorMessage().getErrorcode().equals(tmp_rowerrors_1.getErrorMessage().getErrorcode())) continue;
                rowParams.removeRowErrors(rowErrors[j]);
                --len;
            }
        }
    }

    private void filterVertifyCommand(List<Operation> opers) {
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Operation oper = iter.next();
            if (!"NSCMD_CFG_VERIFY".equalsIgnoreCase(oper.getName())) continue;
            iter.remove();
        }
    }

    private boolean isRTN600(int neid) {
        boolean isrtn600 = false;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int netype = neObj.getNEType();
        if (60 == netype || 54 == netype || 55 == netype || TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE")) {
            isrtn600 = true;
        }
        return isrtn600;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
            try {
                this.distinctErrorCodeItemFilter(this.outputData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("handleMessage fail!", (Throwable)e);
            }
        }
    }

    private boolean isValidParam(Param param) {
        return param != null && param.getValue() != null && !param.getValue().isEmpty();
    }
}

