/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.xpic;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.rtn.xpic.TEWebLCTRtnXpicGroupMOPO;
import com.huawei.nglct.util.errinfo.TECommonResult;
import java.util.List;
import org.slf4j.Logger;

public abstract class TEAbstractXpicScriptHandler
implements TEScriptHandler {
    protected static final String OBJECT_GAP = "-";
    protected static final String SUBCARD = "255";
    protected final Logger logger = TELogFactory.getNormalLogger();

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }

    public int doExport(int neID, int item) {
        this.logger.info("XPIC SCRIPT export start!");
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            this.logger.info("XPIC SCRIPT export.the device is not exist in nelist");
            return result;
        }
        TENE neobj = TENEListMgr.getInstance().getNE(neID);
        if (!neobj.isPreConfig()) {
            return 0;
        }
        return this.exportScript(neID, item);
    }

    private int exportScript(int neID, int item) {
        TEMODBMgr dbMgr = new TEMODBMgr();
        TECommonResult moList = dbMgr.getMOFromDB(neID, TEWebLCTRtnXpicGroupMOPO.class);
        if (0 != moList.getErrInfoRet().getResult()) {
            return 1092743443;
        }
        if (moList.getReturnObject() != null && !((List)moList.getReturnObject()).isEmpty()) {
            this.addComment(neID, item);
            int len = ((List)moList.getReturnObject()).size();
            for (int i = 0; i < len; ++i) {
                TEScriptCmd[] cmds;
                for (TEScriptCmd cmd : cmds = this.constructScriptCmd((TEWebLCTRtnXpicGroupMOPO)((List)moList.getReturnObject()).get(i), item)) {
                    int result;
                    if (cmd == null || (result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd)) == 0) continue;
                    this.logger.info("XPIC SCRIPT export.wriete command failed:" + result);
                    return result;
                }
            }
        }
        this.logger.info("XPIC SCRIPT export end!");
        return 0;
    }

    protected abstract TEScriptCmd[] constructScriptCmd(TEWebLCTRtnXpicGroupMOPO var1, int var2);

    protected abstract void addComment(int var1, int var2);
}

