/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_u2kv2r1c00;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.util.ArrayList;

public class TEQueryPLASlavePortBean
extends TENEExplorerBean {
    private static final int CASCADETYPE_YES = 1;
    private static final int SLAVE_INFO_LENGTH = 14;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        SubFunc needFun = (SubFunc)subFunc.clone();
        String cascadetype = inputData.getBussinessParams().getRowParams(0).getParam("cascadetype").getValue();
        if (Integer.valueOf(cascadetype) == 1) {
            QxMapping qx = needFun.getQxMapping(0);
            needFun.getQxMappingList().remove(qx);
        } else {
            QxMapping qx = needFun.getQxMapping(1);
            needFun.getQxMappingList().remove(qx);
        }
        return TEDataConverter.convertToOperation((SubFunc)needFun, (Datainterface)inputData, (int)neid);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        String cascadetype = this.inputData.getBussinessParams().getRowParams(0).getParam("cascadetype").getValue();
        if (Integer.valueOf(cascadetype) == 1) {
            this.handleCascadeArr();
        } else {
            this.handleNoCascadeArr();
        }
    }

    private void handleCascadeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data_rtn = this.outputData.getBussinessParams();
        int rowcount = data_rtn.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data_rtn.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        BussinessParams data_rtn_new = (BussinessParams)data_rtn.clone();
        data_rtn_new.clearRowParams();
        int size = data_rtn.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            row = data_rtn.getRowParams(i);
            RowParams temprow = new RowParams();
            String neID = row.getParam("neid").getValue();
            int slotid = Integer.parseInt(row.getParam("slotid").getValue());
            int portid = Integer.parseInt(row.getParam("portid").getValue());
            Param portpar = new Param();
            portpar.setName("neportname");
            int currentNeid = TENEListMgr.getInstance().getNE(this.neid).getRealNEID();
            if (Long.valueOf(neID).equals(currentNeid)) {
                TEBoard board = mgr.getBoard(this.neid, slotid);
                String portname = mgr.getPortNameForPTN(this.neid, slotid, board.getBoardType(), portid);
                portpar.setValue(slotid + "-" + board.getBoardName() + "-" + portname);
            } else {
                portpar.setValue(slotid + "-" + portid);
            }
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("blongne");
            if (Long.valueOf(neID).equals(currentNeid)) {
                portpar.setValue("0");
            } else {
                portpar.setValue("1");
            }
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portWorkStatus");
            portpar.setValue(row.getParam("portWorkStatus").getValue());
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portHardStatus");
            portpar.setValue(row.getParam("portHDStatus").getValue());
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portLinkStatus");
            portpar.setValue(row.getParam("portLineStatus").getValue());
            temprow.addParam(portpar);
            data_rtn_new.addRowParams(temprow);
        }
        data_rtn.clearRowParams();
        data_rtn.setRowParams(data_rtn_new.getRowParamList());
    }

    private void handleNoCascadeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data_rtn = this.outputData.getBussinessParams();
        int rowcount = data_rtn.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data_rtn.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        BussinessParams data_rtn_new = (BussinessParams)data_rtn.clone();
        data_rtn_new.clearRowParams();
        int size = data_rtn.getRowParamsCount();
        for (int i = 0; i < size; ++i) {
            row = data_rtn.getRowParams(i);
            RowParams temprow = null;
            int mainslotid = Integer.parseInt(row.getParam("mainslotid").getValue());
            int mainportid = Integer.parseInt(row.getParam("mainportid").getValue());
            TEBoard sboard = mgr.getBoard(this.neid, mainslotid);
            Param portpar = new Param();
            int slaveportid = mainportid;
            String slaveportname = mgr.getPortNameForPTN(this.neid, mainslotid, sboard.getBoardType(), slaveportid);
            temprow = new RowParams();
            portpar = new Param();
            portpar.setName("neportname");
            portpar.setValue(mainslotid + "-" + sboard.getBoardName() + "-" + slaveportname);
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("blongne");
            portpar.setValue("0");
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portWorkStatus");
            portpar.setValue(row.getParam("mainportWorkStatus").getValue());
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portHardStatus");
            portpar.setValue(row.getParam("mainportHDStatus").getValue());
            temprow.addParam(portpar);
            portpar = new Param();
            portpar.setName("portLinkStatus");
            portpar.setValue(row.getParam("mainportLineStatus").getValue());
            temprow.addParam(portpar);
            data_rtn_new.addRowParams(temprow);
            Param slaveportnumPar = row.getParam("slaveportnum");
            if (slaveportnumPar == null || slaveportnumPar.getValue().isEmpty()) continue;
            Param slavesloidsPar = row.getParam("slaveslotids");
            String slavesloidsvar = slavesloidsPar.getValue();
            int slaveportnums = Integer.parseInt(slaveportnumPar.getValue());
            for (int j = 1; j <= slaveportnums; ++j) {
                temprow = new RowParams();
                String eatchRowDate = slavesloidsvar.substring((j - 1) * 14, j * 14);
                int slavesloid = Integer.parseInt(this.convertSlaveSlot(eatchRowDate), 16);
                int slaveport = Integer.parseInt(this.convertSlavePort(eatchRowDate), 16);
                int slaveportHardStatus = Integer.parseInt(this.convertHDStatus(eatchRowDate), 16);
                int slaveportLinkStatus = Integer.parseInt(this.convertLinkStatus(eatchRowDate), 16);
                int slaveportWorkStatus = Integer.parseInt(this.convertWorkStatus(eatchRowDate), 16);
                sboard = mgr.getBoard(this.neid, slavesloid);
                portpar = new Param();
                slaveportid = slaveport;
                slaveportname = mgr.getPortNameForPTN(this.neid, slavesloid, sboard.getBoardType(), slaveportid);
                portpar = new Param();
                portpar.setName("neportname");
                portpar.setValue(slavesloid + "-" + sboard.getBoardName() + "-" + slaveportname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("blongne");
                portpar.setValue("0");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("portWorkStatus");
                portpar.setValue(slaveportWorkStatus + "");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("portHardStatus");
                portpar.setValue(slaveportHardStatus + "");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("portLinkStatus");
                portpar.setValue(slaveportLinkStatus + "");
                temprow.addParam(portpar);
                data_rtn_new.addRowParams(temprow);
            }
        }
        data_rtn.clearRowParams();
        data_rtn.setRowParams(data_rtn_new.getRowParamList());
    }

    private String convertSlaveSlot(String arr) {
        String slaveslot = arr.substring(0, 4);
        return slaveslot;
    }

    private String convertSlavePort(String arr) {
        String slaveslot = arr.substring(6, 8);
        return slaveslot;
    }

    private String convertHDStatus(String arr) {
        String slaveslot = arr.substring(8, 10);
        return slaveslot;
    }

    private String convertLinkStatus(String arr) {
        String slaveslot = arr.substring(10, 12);
        return slaveslot;
    }

    private String convertWorkStatus(String arr) {
        String slaveslot = arr.substring(12, 14);
        return slaveslot;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }
}

