/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_u2kv2r1c00;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryPLABean
extends TENEExplorerBean {
    private static final String QUERY_MINUPLINKTH = "NSCMD_CFG_GET_PLA_MINUPLINK_TH";
    private static final String QUERY_PORTSTATEATTR = "NSCMD_CFG_GET_NBPLA_STATE ";
    private static final String VERIFY_FAILED = "42293";
    private static final int SLAVE_INFO_LENGTH = 10;
    private static final int CASCADETYPE_YES = 1;
    private static final int CASCADETYPE_NO = 0;
    private static final int TYPE_PLA = 0;
    private static final int TYPE_EPLA = 1;
    private static final int STATUS_SLAVE = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
        this.handlePrototypeArr();
    }

    public Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    this.handleRowData(neid, subfunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        this.handleRowData(neid, subfunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!rErrors.getErrorMessage().getErrorcode().equals(VERIFY_FAILED)) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    public void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Input input, Output output) {
        String groupid = output.getPartValue("ggroupid");
        if (Integer.valueOf(groupid) == -1) {
            return;
        }
        if (output.getPartValue("nestatus") == null) {
            String cascadeTypeValue = String.valueOf(0);
            Param param = new Param();
            param.setName("cascadetype");
            param.setValue(cascadeTypeValue);
            rowparams.addParam(param);
            param = new Param();
            param.setName("ggroupid");
            param.setValue(output.getPartValue("ggroupid"));
            rowparams.addParam(param);
            param = new Param();
            param.setName("ggrouptype");
            param.setValue(output.getPartValue("ggrouptype"));
            rowparams.addParam(param);
            param = new Param();
            param.setName("protecttype");
            param.setValue("-");
            rowparams.addParam(param);
            param = new Param();
            param.setName("nestatus");
            param.setValue("-");
            rowparams.addParam(param);
            String mainslotid = output.getPartValue("mainslotid");
            String mainportid = output.getPartValue("mainportid");
            String mainportname = this.getPortShowName(Integer.parseInt(mainslotid), Integer.parseInt(mainportid));
            param = new Param();
            param.setName("mainportname");
            param.setValue(mainportname);
            rowparams.addParam(param);
            param = new Param();
            param.setName("conport");
            param.setValue("-");
            rowparams.addParam(param);
            param = new Param();
            param.setName("mainportWorkStatus");
            param.setValue("-");
            rowparams.addParam(param);
        } else {
            int conportnum;
            String conports;
            String mainportid;
            String mainslotid;
            String cascadeTypeValue = String.valueOf(1);
            Param param = new Param();
            param.setName("cascadetype");
            param.setValue(cascadeTypeValue);
            rowparams.addParam(param);
            param = new Param();
            param.setName("ggroupid");
            param.setValue(output.getPartValue("ggroupid"));
            rowparams.addParam(param);
            int aggtype = Integer.valueOf(output.getPartValue("ggrouptype"));
            String ggrouptype = aggtype % 2 == 0 ? String.valueOf(0) : String.valueOf(1);
            param = new Param();
            param.setName("ggrouptype");
            param.setValue(ggrouptype);
            rowparams.addParam(param);
            param = new Param();
            param.setName("protecttype");
            param.setValue(output.getPartValue("protecttype"));
            rowparams.addParam(param);
            param = new Param();
            param.setName("nestatus");
            param.setValue(output.getPartValue("nestatus"));
            rowparams.addParam(param);
            Output stateOut = null;
            if (Integer.valueOf(output.getPartValue("nestatus")) == 0) {
                mainslotid = output.getPartValue("mainslotid");
                mainportid = output.getPartValue("mainportid");
            } else {
                stateOut = this.queryPortStateAttr(rowparams, groupid);
                mainslotid = stateOut.getPartValue("slotid");
                mainportid = stateOut.getPartValue("portid");
            }
            String mainportname = this.getPortShowName(Integer.parseInt(mainslotid), Integer.parseInt(mainportid));
            param = new Param();
            param.setName("mainportname");
            param.setValue(mainportname);
            rowparams.addParam(param);
            int lcconportnum = Integer.parseInt(output.getPartValue("lcneportnum"));
            int nbneportnum = Integer.parseInt(output.getPartValue("nbneportnum"));
            if (lcconportnum != 0) {
                conports = output.getPartValue("lcneports");
                conportnum = lcconportnum;
            } else {
                conports = output.getPartValue("nbneports");
                conportnum = nbneportnum;
            }
            String eatchPortData = "";
            int conslotid = -1;
            int conportid = -1;
            StringBuffer conpathid = new StringBuffer();
            for (int j = 1; j <= conportnum; ++j) {
                eatchPortData = conports.substring((j - 1) * 10, j * 10);
                conslotid = Integer.parseInt(this.convertSlot(eatchPortData));
                conportid = Integer.parseInt(this.convertPort(eatchPortData));
                conpathid.append(this.convertPath(eatchPortData));
                if (j == conportnum) continue;
                conpathid.append(",");
            }
            String conportname = this.getPortShowName(conslotid, conportid) + "-" + conpathid.toString();
            param = new Param();
            param.setName("conport");
            param.setValue(conportname);
            rowparams.addParam(param);
            param = new Param();
            param.setName("conslotid");
            param.setValue(conslotid + "");
            rowparams.addParam(param);
            param = new Param();
            param.setName("conportid");
            param.setValue(conportid + "");
            rowparams.addParam(param);
            param = new Param();
            param.setName("mainportWorkStatus");
            String status = stateOut == null ? String.valueOf(0) : stateOut.getPartValue("portWorkStatus");
            param.setValue(status);
            rowparams.addParam(param);
        }
    }

    private String getPortShowName(int slotid, int portid) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = mgr.getBoard(this.neid, slotid);
        String bdname = board.getBoardName();
        String portname = mgr.getPortNameForPTN(this.neid, slotid, board.getBoardType(), portid);
        StringBuffer sb = new StringBuffer();
        sb.append(slotid).append("-");
        sb.append(bdname).append("-");
        sb.append(portname);
        return sb.toString();
    }

    private void handlePrototypeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data = this.outputData.getBussinessParams();
        int rowcount = data.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        for (int i = 0; i < data.getRowParamsCount(); ++i) {
            row = data.getRowParams(i);
            this.queryMinLinkValue(row);
        }
    }

    private Output queryPortStateAttr(RowParams row, String groupid) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_PORTSTATEATTR);
        Input input = operation.getInput();
        input.getPart("ggroupid").setValue(groupid);
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        if (result == 0) {
            for (int i = 0; i < operations.size(); ++i) {
                Operation oper = (Operation)operations.get(i);
                Output out = oper.getOutput(0);
                String portStatus = out.getPartValue("portWorkStatus");
                if (!"1".equals(portStatus)) continue;
                return out;
            }
        }
        return null;
    }

    private void queryMinLinkValue(RowParams row) {
        String groupid = row.getParam("ggroupid").getValue();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_MINUPLINKTH);
        Input input = operation.getInput();
        input.getPart("ggroupid").setValue(groupid);
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        if (result == 0) {
            for (int i = 0; i < operations.size(); ++i) {
                Operation oper = (Operation)operations.get(i);
                Output out = oper.getOutput(0);
                String minUpLinkTH = out.getPartValue("minUpLinkTH");
                Param portpar = new Param();
                portpar.setName("minUpLinkTH");
                if (minUpLinkTH != null) {
                    portpar.setValue(minUpLinkTH);
                } else {
                    portpar.setValue("-");
                }
                row.addParam(portpar);
            }
        }
    }

    private String convertSlot(String arr) {
        String slaveslot = arr.substring(0, 4);
        return slaveslot;
    }

    private String convertPort(String arr) {
        String slaveslot = arr.substring(6, 8);
        return slaveslot;
    }

    private String convertPath(String arr) {
        String path = arr.substring(9, 10);
        return path;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44941);
        list.add(44936);
        return list;
    }
}

