/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_u2kv2r1c00;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEFindPortResourceBean
extends TENEExplorerBean {
    private String attrName;
    private int resourceType;
    private int funDomainType;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        Param[] paramArr = rowParams[0].getParam();
        int len = paramArr.length;
        for (int i = 1; i < len; ++i) {
            if (paramArr[i].getName().equals("supportAttrName")) {
                this.attrName = paramArr[i].getValue();
            }
            if (paramArr[i].getName().equals("resourceType")) {
                this.resourceType = Integer.parseInt(paramArr[i].getValue());
            }
            if (!paramArr[i].getName().equals("funDomainType")) continue;
            this.funDomainType = Integer.parseInt(paramArr[i].getValue());
        }
        Datainterface outputData = new Datainterface();
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        outputData.setBussinessParams(this.findPortResource(this.attrName, this.funDomainType));
        return outputData;
    }

    private BussinessParams findPortResource(String attrName, int funDomainType) {
        BussinessParams bussinessParams = new BussinessParams();
        Map mapAndPorts = TEGenCfgModel.getAllSupportPortListInNE((int)this.neid, (String)attrName);
        RowParams rowparams = null;
        TEBoard board2 = null;
        TEGenCfgPortAttribute port = null;
        int slotId = -1;
        Set boards = mapAndPorts.keySet();
        ArrayList boardList = new ArrayList(boards);
        Comparator<TEBoard> boardCompara = new Comparator<TEBoard>(){

            @Override
            public int compare(TEBoard o1, TEBoard o2) {
                return o1.getSlotID() - o2.getSlotID();
            }
        };
        Collections.sort(boardList, boardCompara);
        Collections.sort(boardList, boardCompara);
        for (TEBoard board2 : boardList) {
            slotId = board2.getSlotID();
            String boardName = board2.getBoardName();
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
            String slotIdStr = String.valueOf(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId));
            List portList = (List)mapAndPorts.get(board2);
            if (portList == null || portList.isEmpty()) continue;
            for (int i = 0; i < portList.size(); ++i) {
                rowparams = new RowParams();
                port = (TEGenCfgPortAttribute)portList.get(i);
                if (subrackName != "") {
                    rowparams.addParam("boardname", subrackName + "-" + slotIdStr + "-" + boardName);
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotId, board2.getBoardType(), port.getPort(), funDomainType));
                } else {
                    rowparams.addParam("boardname", slotIdStr + "-" + boardName);
                    rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortNameForPTN(this.neid, slotId, board2.getBoardType(), port.getPort(), funDomainType));
                }
                rowparams.addParam("slotId", String.valueOf(slotId));
                rowparams.addParam("portId", String.valueOf(port.getPort()));
                bussinessParams.addRowParams(rowparams);
            }
        }
        return bussinessParams;
    }
}

