/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_u2kv2r1c00;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaFilter;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.List;

public class TECreatePLABean
extends TECommonWriteLogBean {
    private static final int CASCADETYPE_YES = 1;

    protected void modifyInputParams() {
        int cascadetype = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("cascadetype").getValue());
        if (cascadetype == 1) {
            this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("neportnum", this.inputData.getBussinessParams().getRowParams(0).getParam("lcneportnum").getValue()));
        }
        this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("neports", ""));
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        String mainslotid = this.inputData.getBussinessParams().getRowParams(0).getParam("mainslotid").getValue();
        String mainportid = this.inputData.getBussinessParams().getRowParams(0).getParam("mainportid").getValue();
        String mainBdName = currentNE.getBoard(Integer.parseInt(mainslotid)).getBoardName();
        String mainString = mainslotid + "-" + mainBdName + "-" + mainportid;
        this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("mainboardname", mainString));
        if (cascadetype == 1) {
            if (Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("lcneportnum").getValue()) != 0) {
                String lcneslotids = this.inputData.getBussinessParams().getRowParams(0).getParam("lcneslotids").getValue();
                String lcneports = this.inputData.getBussinessParams().getRowParams(0).getParam("lcneports").getValue();
                this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("lcneboardport", this.getPortString(currentNE, lcneslotids, lcneports)));
            }
            if (Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("nbneportnum").getValue()) != 0) {
                String nbneslotids = this.inputData.getBussinessParams().getRowParams(0).getParam("nbneslotids").getValue();
                String nbneports = this.inputData.getBussinessParams().getRowParams(0).getParam("nbneports").getValue();
                this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("nbneboardport", this.getPortString(currentNE, nbneslotids, nbneports)));
            }
            this.handelConArr(this.inputData);
        }
        if (Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("slaveportnum").getValue()) != 0) {
            String slaveslotids = this.inputData.getBussinessParams().getRowParams(0).getParam("slaveslotids").getValue();
            String slaveportids = this.inputData.getBussinessParams().getRowParams(0).getParam("slaveportids").getValue();
            this.inputData.getBussinessParams().getRowParams(0).addParam(new Param("slaveboardport", this.getPortString(currentNE, slaveslotids, slaveportids)));
            this.handelSlaveArr(this.inputData);
        }
        TERtnPlaFilter.getInstance().setPlaPortRefreshFlag(this.neid);
    }

    private String getPortString(TENE currentNE, String slotids, String portids) {
        String[] slotArr = slotids.split(",");
        String[] portArr = portids.split(",");
        String portString = "";
        StringBuilder portSb = new StringBuilder("");
        for (int k = 0; k < slotArr.length; ++k) {
            int tmpSlot = Integer.parseInt(slotArr[k]);
            String[] portPathArr = portArr[k].split("-");
            int tmpPort = Integer.parseInt(portPathArr[0]);
            String tmpBdName = currentNE.getBoard(tmpSlot).getBoardName();
            portSb.append(tmpSlot).append('-').append(tmpBdName).append('-').append(tmpPort).append(',');
        }
        if (portSb.length() > 0) {
            portString = portSb.substring(0, portSb.length() - 1);
        }
        return portString;
    }

    private void handelSlaveArr(Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        StringBuilder sb = new StringBuilder();
        String slaveSlot = row.getParam("slaveslotids").getValue();
        String slavePort = row.getParam("slaveportids").getValue();
        String[] slaveSlotArr = slaveSlot.split(",");
        String[] slavePortArr = slavePort.split(",");
        int iLength = slaveSlotArr.length;
        for (int i = 0; i < iLength; ++i) {
            if (slaveSlotArr[i] == null || slaveSlotArr[i].isEmpty()) continue;
            sb.append(this.convertString(slaveSlotArr[i], "slot"));
            sb.append("ff");
            sb.append(this.convertString(slavePortArr[i], "port"));
        }
        row.getParam("slaveslotids").setValue(sb.toString());
    }

    private void handelConArr(Datainterface inputData) {
        int nbnePortNum;
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        StringBuilder sb = new StringBuilder();
        int lcnePortNum = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("lcneportnum").getValue());
        if (lcnePortNum != 0) {
            String lcneslotids = row.getParam("lcneslotids").getValue();
            String lcneportids = row.getParam("lcneports").getValue();
            sb.append(this.gerSlotPortStr(lcneslotids, lcneportids));
        }
        sb.append((nbnePortNum = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("nbneportnum").getValue())) == 0 ? "00" : "0" + nbnePortNum);
        if (nbnePortNum != 0) {
            String nbneslotids = row.getParam("nbneslotids").getValue();
            String nbneports = row.getParam("nbneports").getValue();
            sb.append(this.gerSlotPortStr(nbneslotids, nbneports));
        }
        row.getParam("neports").setValue(sb.toString());
    }

    private String gerSlotPortStr(String lcneslotids, String lcneportids) {
        StringBuilder sb = new StringBuilder();
        String[] slotArr = lcneslotids.split(",");
        String[] portArr = lcneportids.split(",");
        int iLength = slotArr.length;
        for (int i = 0; i < iLength; ++i) {
            if (slotArr[i] == null || slotArr[i].isEmpty()) continue;
            sb.append(this.convertString(slotArr[i], "slot"));
            sb.append("ff");
            String[] portPathAttr = portArr[i].split("-");
            sb.append(this.convertString(portPathAttr[0], "port"));
            sb.append("0" + portPathAttr[1]);
        }
        return sb.toString();
    }

    private String convertString(String arr, String flag) {
        StringBuffer sb = new StringBuffer();
        String[] stringArr = arr.split(",");
        for (int i = 0; i < stringArr.length; ++i) {
            String addstr;
            int id = Integer.parseInt(stringArr[i]);
            if (id > 15) {
                addstr = "";
            } else if (id == 0) {
                addstr = "00";
                if (flag.endsWith("slot")) {
                    addstr = "0000";
                }
            } else {
                addstr = "0";
                if (flag.endsWith("slot")) {
                    addstr = "000";
                }
            }
            sb.append(addstr).append(Integer.toHexString(id));
        }
        return sb.toString();
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String BASE_PATH = "rtn" + File.separator + "res";
        String STRING_SOURCE = BASE_PATH + File.separator + "pla" + File.separator + "plamgr_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = TESecurityVerify.getSuperUserID();
                }
            }
            this.subfunc = subfunc;
            this.outputData = outputData;
            String operObj = this.getOperObj();
            String operName = this.getOperateName();
            List loginfoList = this.getLogInfoList(inputData);
            TELogInfo loginfo = null;
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(operName);
                loginfo.setOperateObject(operObj);
                if (((TELogInfo)loginfoList.get(i)).getErrCode() == 0) {
                    RowParams row = inputData.getBussinessParams().getRowParams(0);
                    String ggidValue = row.getParam("ggroupid").getValue();
                    String mainValue = row.getParam("mainboardname").getValue();
                    String slaveValue = row.getParam("slaveboardport") == null ? "" : row.getParam("slaveboardport").getValue();
                    Param ggrouptypeParam = row.getParam("ggrouptype");
                    int ggrouptype = 0;
                    if (ggrouptypeParam != null && ggrouptypeParam.getValue() != null) {
                        ggrouptype = Integer.parseInt(ggrouptypeParam.getValue());
                    }
                    String mergeValue = resourceUtil.getString("cascadetype") + ":" + resourceUtil.getString("cascadetype_" + ggrouptype / 2) + "," + resourceUtil.getString("aggType") + ":" + resourceUtil.getString("aggType_" + ggrouptype % 2) + "," + resourceUtil.getString("ggroupid") + ":" + ggidValue + "," + resourceUtil.getString("mainboardname") + ":" + mainValue + "," + resourceUtil.getString("slaveboardport") + ":" + slaveValue;
                    if (row.getParam("lcneboardport") != null) {
                        mergeValue = mergeValue + "," + resourceUtil.getString("conportres") + ":" + row.getParam("lcneboardport").getValue();
                    }
                    if (row.getParam("nbneboardport") != null) {
                        mergeValue = mergeValue + "," + resourceUtil.getString("conportres") + ":" + row.getParam("nbneboardport").getValue();
                    }
                    ((TELogInfo)loginfoList.get(i)).setOperateDesc(mergeValue);
                }
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

