/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_smart;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.jni.nelist.TEGetLogicNEIDService;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndex;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIBasicNameInfo;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoReq;
import com.huawei.nglct.nemgr.f_interface.fiber.AsnJNIGetBasicNameInfoRsp;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TENEUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import net.commustru.fstru.FStruct;

public class TEQueryPLASlavePortBean_Smart
extends TENEExplorerBean {
    private static final int SLAVE_INFO_LENGTH = 22;
    private static final int UNKNOWN_NEID = -1;
    private static final int NE_SHELF_SLOT_PORT_NAME = 15;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid + 0;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid + 0, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
                this.handlePrototypeArr();
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam_rtn2 = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam_rtn2 != null && isLogFlagParam_rtn2.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private void handlePrototypeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data_rtn3 = this.outputData.getBussinessParams();
        int rowcount = data_rtn3.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data_rtn3.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        String mainneid = null;
        String mainneslotid = null;
        String mainneportid = null;
        String mainneHDStatus = null;
        String mainneLinkStatus = null;
        String mainneWorkStatus = null;
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        for (int i = 0; i < data_rtn3.getRowParamsCount(); ++i) {
            row = data_rtn3.getRowParams(i);
            mainneid = row.getParam("mainneid").getValue();
            mainneslotid = row.getParam("mainneslotid").getValue();
            mainneportid = row.getParam("mainneportid").getValue();
            mainneHDStatus = row.getParam("mainneHDStatus").getValue();
            mainneLinkStatus = row.getParam("mainneLinkStatus").getValue();
            mainneWorkStatus = row.getParam("mainneWorkStatus").getValue();
            Param slaveportnumPar = row.getParam("slavenenum");
            RowParams temprow = null;
            if (slaveportnumPar == null || slaveportnumPar.getValue().isEmpty()) continue;
            Param slavesloidsPar = row.getParam("slaveneids");
            String slavesloidsvar = slavesloidsPar.getValue();
            data_rtn3.clearRowParams();
            int slaveportnums = Integer.parseInt(slaveportnumPar.getValue());
            for (int j = 1; j <= slaveportnums; ++j) {
                temprow = new RowParams();
                String eatchRowDate = slavesloidsvar.substring((j - 1) * 22, j * 22);
                String slaveneid = this.convertSlaveNeID(eatchRowDate);
                int slavesloid = Integer.parseInt(this.convertSlaveSlot(eatchRowDate), 16);
                int slaveport = Integer.parseInt(this.convertSlavePort(eatchRowDate), 16);
                int slaveportHardStatus = Integer.parseInt(this.convertHDStatus(eatchRowDate), 16);
                int slaveportLinkStatus = Integer.parseInt(this.convertLinkStatus(eatchRowDate), 16);
                int slaveportWorkStatus = Integer.parseInt(this.convertWorkStatus(eatchRowDate), 16);
                Param portpar = new Param();
                portpar.setName("mainne");
                portpar.setValue(mainneid);
                temprow.addParam(portpar);
                String mainlogicid = mainneid;
                int tempmainneid = -1;
                if (Long.parseLong(mainneid) != 0xFFFFFFFFL) {
                    try {
                        tempmainneid = Integer.parseInt(mainneid);
                    }
                    catch (NumberFormatException e) {
                        TELogFactory.getNormalLogger().error("Parse neid in PLA error:", (Throwable)e);
                    }
                    if (-1 != tempmainneid) {
                        mainlogicid = TENEUtils.formatNEID((int)tempmainneid);
                    }
                }
                String mainslotname = "-1";
                String mainportname = "-1";
                if (-1 != tempmainneid) {
                    TENE mainNE = TENEListMgr.getInstance().getPhyNE(tempmainneid);
                    if (null == mainNE) {
                        int logicNeID;
                        mainslotname = "65535";
                        mainportname = "255";
                        if (TESysManagerBean.getInstance().isIntegratedStatus() && (logicNeID = TEGetLogicNEIDService.getLogicNEID((int)tempmainneid)) != -1) {
                            try {
                                int mainneslotidInt = Integer.parseInt(mainneslotid);
                                int mainneportidInt = Integer.parseInt(mainneportid);
                                AsnJNIBasicNameInfo basicInfo = TEQueryPLASlavePortBean_Smart.getNameFromOtherMgr(logicNeID, mainneslotidInt, mainneportidInt);
                                if (basicInfo != null) {
                                    mainslotname = new String(basicInfo.boardName);
                                    mainportname = new String(basicInfo.portName);
                                }
                            }
                            catch (Exception e) {
                                TELogFactory.getNormalLogger().info("", (Throwable)e);
                            }
                        }
                    } else {
                        TEBoard mainboard = mgr.getBoard(mainNE.getNEID(), Integer.parseInt(mainneslotid));
                        if (null != mainboard) {
                            mainslotname = mainboard.getBoardName();
                            mainportname = mgr.getPortName(mainNE.getNEID(), Integer.parseInt(mainneslotid), mainboard.getBoardType(), Integer.parseInt(mainneportid));
                        }
                    }
                }
                portpar = new Param();
                portpar.setName("mainslotname");
                portpar.setValue(mainslotname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainportname");
                portpar.setValue(mainportname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainnelogicid");
                portpar.setValue(mainlogicid);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainneslotid");
                portpar.setValue(mainneslotid);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainneportid");
                portpar.setValue(mainneportid);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainneHDStatus");
                portpar.setValue(mainneHDStatus);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainneLinkStatus");
                portpar.setValue(mainneLinkStatus);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("mainneWorkStatus");
                portpar.setValue(mainneWorkStatus);
                temprow.addParam(portpar);
                String slavelogicid = Long.parseLong(slaveneid, 16) + "";
                int tempslaveneid = -1;
                if (Long.parseLong(slavelogicid) != 0xFFFFFFFFL) {
                    try {
                        tempslaveneid = Integer.parseInt(slaveneid, 16);
                    }
                    catch (NumberFormatException e) {
                        TELogFactory.getNormalLogger().error("Parse neid in PLA error:", (Throwable)e);
                    }
                    if (-1 != tempslaveneid) {
                        slavelogicid = TENEUtils.formatNEID((int)tempslaveneid);
                    }
                }
                String slaveslotname = "-1";
                String slaveportname = "-1";
                if (-1 != tempslaveneid) {
                    TENE slaveNE = TENEListMgr.getInstance().getPhyNE(tempslaveneid);
                    if (null == slaveNE) {
                        AsnJNIBasicNameInfo basicInfo;
                        int logicNeID;
                        slaveslotname = "65535";
                        slaveportname = "255";
                        if (TESysManagerBean.getInstance().isIntegratedStatus() && (logicNeID = TEGetLogicNEIDService.getLogicNEID((int)tempslaveneid)) != -1 && (basicInfo = TEQueryPLASlavePortBean_Smart.getNameFromOtherMgr(logicNeID, slavesloid, slaveport)) != null) {
                            slaveslotname = new String(basicInfo.boardName);
                            slaveportname = new String(basicInfo.portName);
                        }
                    } else {
                        TEBoard slaveboard = mgr.getBoard(slaveNE.getNEID(), slavesloid);
                        if (null != slaveboard) {
                            slaveslotname = slaveboard.getBoardName();
                            slaveportname = mgr.getPortName(slaveNE.getNEID(), slavesloid, slaveboard.getBoardType(), slaveport);
                        }
                    }
                }
                portpar = new Param();
                portpar.setName("slaveslotname");
                portpar.setValue(slaveslotname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportname");
                portpar.setValue(slaveportname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slavenelogicid");
                portpar.setValue(slavelogicid);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slavene");
                portpar.setValue(Long.parseLong(slaveneid, 16) + "");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveneslotid");
                portpar.setValue(String.valueOf(slavesloid));
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportid");
                portpar.setValue(String.valueOf(slaveport));
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveneHardStatus");
                portpar.setValue(String.valueOf(slaveportHardStatus));
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveneLinkStatus");
                portpar.setValue(String.valueOf(slaveportLinkStatus));
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveneWorkStatus");
                portpar.setValue(String.valueOf(slaveportWorkStatus));
                temprow.addParam(portpar);
                data_rtn3.addRowParams(temprow);
            }
        }
    }

    private static AsnJNIBasicNameInfo getNameFromOtherMgr(int neid, int slotID, int portID) {
        try {
            AsnJNIGetBasicNameInfoReq aReq = new AsnJNIGetBasicNameInfoReq();
            AsnJNIGetBasicNameInfoRsp aRsp = new AsnJNIGetBasicNameInfoRsp();
            AsnPortIndex portIndex = new AsnPortIndex();
            portIndex.neID = neid;
            portIndex.slotID = slotID;
            portIndex.portID = 0x100000 + portID;
            aReq.flag = 15;
            aReq.portIndexList.add((Object)portIndex);
            TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String((Object)aReq));
            int retCode = (int)TEJNIFacadeUtil.sendJNIMessage((int)201, (FStruct)aReq, (FStruct)aRsp);
            TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String((Object)aRsp));
            if (0 != retCode) {
                return null;
            }
            if (aRsp.nameInfoList != null && !aRsp.nameInfoList.isEmpty()) {
                return (AsnJNIBasicNameInfo)aRsp.nameInfoList.get(0);
            }
            return null;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("get name fail!", (Throwable)e);
            return null;
        }
    }

    private String convertSlaveNeID(String arr) {
        String slaveneid = arr.substring(0, 8);
        return slaveneid;
    }

    private String convertSlaveSlot(String arr) {
        String slaveslot = arr.substring(8, 12);
        return slaveslot;
    }

    private String convertSlavePort(String arr) {
        String slaveslot = arr.substring(14, 16);
        return slaveslot;
    }

    private String convertHDStatus(String arr) {
        String slaveslot = arr.substring(16, 18);
        return slaveslot;
    }

    private String convertLinkStatus(String arr) {
        String slaveslot = arr.substring(18, 20);
        return slaveslot;
    }

    private String convertWorkStatus(String arr) {
        String slaveslot = arr.substring(20, 22);
        return slaveslot;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }
}

