/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla_smart;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryPLABean_Smart
extends TENEExplorerBean {
    private static final String QUERY_MINUPLINKTH = "NSCMD_RTN_CFG_GET_PLA_MINUPLINK_TH";
    private static final String VERIFY_FAILED = "42293";
    private static final int SLAVE_INFO_LENGTH = 8;
    private int shelfType = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            this.shelfType = neObj.shelfTypeQ2E(neObj.getNEType(), neObj.getShelfType());
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
                this.handlePrototypeArr();
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    public Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, filterErrorCodeList);
        Operation operation = null;
        if (null == operationList || 0 == operationList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Input input = null;
        Output output = null;
        boolean succ = false;
        boolean fault = false;
        boolean row_succ = false;
        boolean verify_succ = true;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        int len = operationList.size();
        block0: for (int i = 0; i < len; ++i) {
            operation = (Operation)operationList.get(i);
            TEDataConverter.handleSpecialStr((Operation)operation);
            input = operation.getInput();
            if (operation.getOutputCount() == 0) {
                succ = true;
            }
            int size = operation.getOutputCount();
            for (int row = 0; row < size; ++row) {
                output = operation.getOutput(row);
                rowparams = new RowParams();
                row_succ = TEDataConverter.handleRowError((Output)output, filterErrorCodeList);
                if (row_succ) {
                    succ = true;
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int a = 0; a < errorSize; ++a) {
                        if (filterErrorCodeList.contains(Integer.valueOf(output.getFault(a).getCode()))) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue block0;
                    this.handleRowData(neid, subfunc, rowparams, input, output);
                    flag = false;
                } else if (1 == operation.getOutputCount()) {
                    boolean hasDefault = true;
                    int count = operation.getOutput(0).getPartCount();
                    for (int index = 0; index < count; ++index) {
                        if (operation.getOutput(0).getPart(index).hasDefault()) continue;
                        hasDefault = false;
                        break;
                    }
                    if (hasDefault) {
                        this.handleRowData(neid, subfunc, rowparams, input, output);
                    }
                }
                if (0 != rowparams.getParamCount()) {
                    outputData.getBussinessParams().addRowParams(rowparams);
                }
                row_succ = false;
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            fault = true;
            rowparams = new RowParams();
            RowErrors rErrors = null;
            int size = errorData.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorData.get(i);
                rowparams.addRowErrors(rErrors);
                if (!rErrors.getErrorMessage().getErrorcode().equals(VERIFY_FAILED)) continue;
                verify_succ = false;
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (succ && !fault) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!succ && fault || !verify_succ) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
        return outputData;
    }

    public void handleRowData(int neid, SubFunc subfunc, RowParams rowparams, Input input, Output output) {
        Param param = new Param();
        param.setName("ggroupid");
        param.setValue(output.getPartValue("ggroupid"));
        rowparams.addParam(param);
        String ifslotid = output.getPartValue("ifslotid");
        String ifportid = output.getPartValue("ifportid");
        String ifportname = this.getPortShowName(Integer.parseInt(ifslotid), Integer.parseInt(ifportid));
        param = new Param();
        param.setName("ifportname");
        param.setValue(ifportname);
        rowparams.addParam(param);
        param = new Param();
        param.setName("ifslotid");
        param.setValue(ifslotid);
        rowparams.addParam(param);
        param = new Param();
        param.setName("ifportid");
        param.setValue(ifportid);
        rowparams.addParam(param);
        String serviceslotid = "-";
        String serviceportid = "-";
        String serviceportname = "-";
        if (this.shelfType != 18 && this.shelfType != 25 && this.shelfType != 26) {
            serviceslotid = output.getPartValue("serviceslotid");
            serviceportid = output.getPartValue("serviceportid");
            serviceportname = this.getPortShowName(Integer.parseInt(serviceslotid), Integer.parseInt(serviceportid));
        }
        param = new Param();
        param.setName("serviceportname");
        param.setValue(serviceportname);
        rowparams.addParam(param);
        param = new Param();
        param.setName("serviceslotid");
        param.setValue(serviceslotid);
        rowparams.addParam(param);
        param = new Param();
        param.setName("serviceportid");
        param.setValue(serviceportid);
        rowparams.addParam(param);
        int conportnum = Integer.parseInt(output.getPartValue("conportnum"));
        String conports = output.getPartValue("conports");
        String eatchPortData = "";
        int conslotid = -1;
        int conportid = -1;
        for (int i = 1; i <= conportnum; ++i) {
            eatchPortData = conports.substring((i - 1) * 8, i * 8);
            conslotid = Integer.parseInt(this.convertSlaveSlot(eatchPortData));
            conportid = Integer.parseInt(this.convertSlavePort(eatchPortData));
        }
        String conportname = this.getPortShowName(conslotid, conportid);
        param = new Param();
        param.setName("conportname");
        param.setValue(conportname);
        rowparams.addParam(param);
        param = new Param();
        param.setName("conslotid");
        param.setValue(conslotid + "");
        rowparams.addParam(param);
        param = new Param();
        param.setName("conportid");
        param.setValue(conportid + "");
        rowparams.addParam(param);
        param = new Param();
        param.setName("nestatus");
        param.setValue(output.getPartValue("nestatus"));
        rowparams.addParam(param);
        param = new Param();
        param.setName("protecttype");
        param.setValue(output.getPartValue("protecttype"));
        rowparams.addParam(param);
    }

    private String getPortShowName(int slotid, int portid) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = mgr.getBoard(this.neid, slotid);
        String bdname = board.getBoardName();
        String portname = mgr.getPortNameForPTN(this.neid, slotid, board.getBoardType(), portid);
        StringBuffer sb = new StringBuffer();
        sb.append(slotid).append("-");
        sb.append(bdname).append("-");
        sb.append(portname);
        return sb.toString();
    }

    private void handlePrototypeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data = this.outputData.getBussinessParams();
        int rowcount = data.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        for (int i = 0; i < data.getRowParamsCount(); ++i) {
            row = data.getRowParams(i);
            this.queryPortStatus(row);
        }
    }

    private void queryPortStatus(RowParams row) {
        String groupid = row.getParam("ggroupid").getValue();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_MINUPLINKTH);
        Input input = operation.getInput();
        input.getPart("ggroupid").setValue(groupid);
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        if (result == 0) {
            for (int i = 0; i < operations.size(); ++i) {
                Operation oper = (Operation)operations.get(i);
                Output out = oper.getOutput(0);
                if (!out.getFault(0).getCode().equals(String.valueOf(0))) {
                    TELogFactory.getNormalLogger().error("TEQueryPLABean_Smart queryPortStatus fail! errCode:" + out.getFault(0).getCode());
                    continue;
                }
                String minUpLinkTH = out.getPartValue("minUpLinkTH");
                Param portpar = new Param();
                portpar.setName("minUpLinkTH");
                portpar.setValue(minUpLinkTH);
                row.addParam(portpar);
            }
        }
    }

    private String convertSlaveSlot(String arr) {
        String slaveslot = arr.substring(0, 4);
        return slaveslot;
    }

    private String convertSlavePort(String arr) {
        String slaveslot = arr.substring(6, 8);
        return slaveslot;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        list.add(44941);
        return list;
    }
}

