/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla.plugin;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaFilter;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaUtil;
import com.huawei.nglct.nemgr.rtn.pla.plugin.TEPLAMoDataMgr;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import org.slf4j.Logger;

public class TEPLAUploadHandler
implements TECIUpLoadHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private static final int ITEM_UPLOAD_PLA_ID = 131151;
    private static final String ITEM_UPLOAD_PLA_NAME = "PLA attrib";

    public int upLoad(TEDataCfgUploadPara pPara) {
        if (pPara == null || pPara.getTmpNEInfo() == null) {
            logger.info("Upload PLA failed.The TEDataCfgUploadPara is null.");
            return 1090650122;
        }
        TEDataCfgNEInfo neInfo = pPara.getTmpNEInfo();
        int neID = neInfo.getNeID();
        if (!TERtnPlaUtil.isSupportPLA((int)neID) && !TERtnPlaUtil.isSupportEPLA((int)neID)) {
            return 0;
        }
        if (TERtnPlaUtil.isRtn9051C((int)neID)) {
            return 0;
        }
        logger.info("Upload PLA begi,neID->" + neInfo.getNeID());
        int retCode = 0;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne && 1 != ne.getLogStatus()) {
            logger.info("begin to connect SBI,neID->" + neID);
            retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
            logger.info("end to connect SBI,neID->" + neID + ", result->" + retCode);
        }
        if (0 != retCode) {
            String tipStr = "upload PLA fail! Can not connect to  ne";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            logger.error(tipStr);
            return retCode;
        }
        int errRet = TEPLAMoDataMgr.uploadPLA(neID);
        TERtnPlaFilter.getInstance().setPlaPortRefreshFlag(neID);
        logger.info("Upload PLA end. neID->" + neID + ",result->" + errRet);
        return errRet;
    }

    public int getItemID() {
        return 131151;
    }

    public String getItemName() {
        return ITEM_UPLOAD_PLA_NAME;
    }

    public TECfgItem getOperIF(int OperType) {
        return null;
    }
}

