/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla.plugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaUtil;
import com.huawei.nglct.po.embeddednemgrmo.rtn.pla.TEPTNPLAContainerMOPO;
import com.huawei.nglct.po.embeddednemgrmo.rtn.pla.TEPTNPLAGroupMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEPLAMoDataMgr {
    public static final String DEL_CMD = "NSCMD_CFG_DEL_PLA_GROUP";
    public static final String CREATE_CMD_PLA = "NSCMD_CFG_ADD_PLA_GROUP";
    public static final String CREATE_CMD_EPLA = "NSCMD_CFG_ADD_PLA_GROUP_EXT";
    public static final String QUERY_CMD_PLA = "NSCMD_CFG_GET_PLA_GROUP";
    public static final String QUERY_CMD_EPLA = "NSCMD_CFG_GET_PLA_GROUP_EXT";
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEPLAMoDataMgr() {
    }

    public static TEPTNPLAContainerMOPO getPLAContainer(int neID, TEErrInfoReturn errRet) {
        List objList;
        String FUNC_NAME = "TEPLABeanPluginMgr.getPLAContainer";
        TEBeanPluginLog.logFuncBegin((String)"TEPLABeanPluginMgr.getPLAContainer");
        TEPTNPLAContainerMOPO plaContainerMOPO = null;
        TEDaoOperationResult dbResult = null;
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEPLAMoDataMgr.logNullNEError(neID);
                TEPLAMoDataMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.getPLAContainer");
                return plaContainerMOPO;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEPTNPLAContainerMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEPTNPLAContainerMOPO.class);
        }
        catch (Exception e) {
            TEPLAMoDataMgr.logNullErrorOnGet(neID);
            TEPLAMoDataMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.getPLAContainer");
        }
        if (null == dbResult) {
            TEPLAMoDataMgr.logNullErrorOnGet(neID);
            TEPLAMoDataMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.getPLAContainer");
        }
        if (null != dbResult && 0 == dbResult.getResult() && null != (objList = dbResult.getData()) && !objList.isEmpty()) {
            plaContainerMOPO = (TEPTNPLAContainerMOPO)objList.get(0);
        }
        return plaContainerMOPO;
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e1) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e1);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCodeMode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCodeMode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEPLAMoDataMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCodeMode).getErrList());
    }

    private static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCodeMode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEPLAMoDataMgr.getObjName(objName));
        errInfo.setErrorCode(retCodeMode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    private static String getObjName(String[] objNameMode) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objNameMode.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objNameMode[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    public static List<TEPTNPLAGroupMOPO> getDBMOFromOperInput(List<Operation> operations, String cmd) {
        ArrayList<TEPTNPLAGroupMOPO> moList = new ArrayList<TEPTNPLAGroupMOPO>();
        for (Operation operation : operations) {
            if (!cmd.equals(operation.getName())) continue;
            for (int i = 0; i < operation.getOutput().length; ++i) {
                Output output = operation.getOutput()[i];
                Input input = operation.getInput();
                if (!output.getFault()[0].getCode().equals("0") || input == null) continue;
                TEPTNPLAGroupMOPO mo = new TEPTNPLAGroupMOPO();
                int groupId = Integer.valueOf(input.getPartValue("ggroupid"));
                int slaveNum = Integer.valueOf(input.getPartValue("slaveportnum"));
                String slaveSlotIds = input.getPartValue("slaveslotids");
                String mainSlotId = input.getPartValue("mainslotid");
                String mainPortId = input.getPartValue("mainportid");
                String slaveObjs = TERtnPlaUtil.decodeSlaveObjs((int)slaveNum, (String)slaveSlotIds);
                mo.setGroupID(groupId);
                mo.setMajorPort(mainSlotId + "-" + mainPortId);
                mo.setLagSlavePortList(slaveObjs);
                moList.add(mo);
            }
        }
        return moList;
    }

    public static List<TEPTNPLAGroupMOPO> getDBMOFromOperInput(List<Operation> operations) {
        ArrayList<TEPTNPLAGroupMOPO> moList = new ArrayList<TEPTNPLAGroupMOPO>();
        for (Operation operation : operations) {
            if (!CREATE_CMD_PLA.equals(operation.getName()) && !CREATE_CMD_EPLA.equals(operation.getName())) continue;
            for (int i = 0; i < operation.getOutput().length; ++i) {
                Output output = operation.getOutput()[i];
                Input input = operation.getInput();
                if (!output.getFault()[0].getCode().equals("0") || input == null) continue;
                TEPTNPLAGroupMOPO mo = new TEPTNPLAGroupMOPO();
                int groupId = Integer.valueOf(input.getPartValue("ggroupid"));
                int slaveNum = Integer.valueOf(input.getPartValue("slaveportnum"));
                String slaveSlotIds = input.getPartValue("slaveslotids");
                String mainSlotId = input.getPartValue("mainslotid");
                String mainPortId = input.getPartValue("mainportid");
                String slaveObjs = TERtnPlaUtil.decodeSlaveObjs((int)slaveNum, (String)slaveSlotIds);
                mo.setGroupID(groupId);
                mo.setMajorPort(mainSlotId + "-" + mainPortId);
                mo.setLagSlavePortList(slaveObjs);
                moList.add(mo);
            }
        }
        return moList;
    }

    public static void updateMOToDB(int neID, TEPTNPLAContainerMOPO container, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEPLABeanPluginMgr.updataMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEPLABeanPluginMgr.updataMOToDB");
        if (null == container) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)container) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)container);
        }
        catch (Exception e) {
            TEPLAMoDataMgr.logExceptionErrorOnUpdate(neID, e);
            TEPLAMoDataMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.updataMOToDB");
            return;
        }
        if (null == dbResult) {
            TEPLAMoDataMgr.logNullErrorOnUpdate(neID);
            TEPLAMoDataMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.updataMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEPLAMoDataMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEPLAMoDataMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEPLABeanPluginMgr.updataMOToDB");
    }

    public static List<TEPTNPLAGroupMOPO> getDBMOFromOperOutput(List<Operation> operations, String cmd) {
        ArrayList<TEPTNPLAGroupMOPO> moList = new ArrayList<TEPTNPLAGroupMOPO>();
        for (Operation operation : operations) {
            if (!cmd.equals(operation.getName())) continue;
            for (int i = 0; i < operation.getOutput().length; ++i) {
                Output output = operation.getOutput()[i];
                if (!output.getFault()[0].getCode().equals("0")) continue;
                TEPTNPLAGroupMOPO mo = new TEPTNPLAGroupMOPO();
                int groupId = Integer.valueOf(output.getPartValue("ggroupid"));
                int slaveNum = Integer.valueOf(output.getPartValue("slaveportnum"));
                String slaveSlotIds = output.getPartValue("slaveslotids");
                String mainSlotId = output.getPartValue("mainslotid");
                String mainPortId = output.getPartValue("mainportid");
                String slaveObjs = TERtnPlaUtil.decodeSlaveObjs((int)slaveNum, (String)slaveSlotIds);
                mo.setGroupID(groupId);
                mo.setMajorPort(mainSlotId + "-" + mainPortId);
                mo.setLagSlavePortList(slaveObjs);
                moList.add(mo);
            }
        }
        return moList;
    }

    public static List<TEPTNPLAGroupMOPO> getDBMOFromOperOutput(List<Operation> operations) {
        ArrayList<TEPTNPLAGroupMOPO> moList = new ArrayList<TEPTNPLAGroupMOPO>();
        for (Operation operation : operations) {
            if (!QUERY_CMD_PLA.equals(operation.getName()) && !QUERY_CMD_EPLA.equals(operation.getName())) continue;
            for (int i = 0; i < operation.getOutput().length; ++i) {
                Output output = operation.getOutput()[i];
                if (!output.getFault()[0].getCode().equals("0")) continue;
                TEPTNPLAGroupMOPO mo = new TEPTNPLAGroupMOPO();
                int groupId = Integer.valueOf(output.getPartValue("ggroupid"));
                int slaveNum = Integer.valueOf(output.getPartValue("slaveportnum"));
                String slaveSlotIds = output.getPartValue("slaveslotids");
                String mainSlotId = output.getPartValue("mainslotid");
                String mainPortId = output.getPartValue("mainportid");
                String slaveObjs = TERtnPlaUtil.decodeSlaveObjs((int)slaveNum, (String)slaveSlotIds);
                mo.setGroupID(groupId);
                mo.setMajorPort(mainSlotId + "-" + mainPortId);
                mo.setLagSlavePortList(slaveObjs);
                moList.add(mo);
            }
        }
        return moList;
    }

    public static int uploadPLA(int neID) {
        Datainterface outputData = TERtnPlaUtil.queryPLAData((int)neID);
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errorCode) {
            String tipStr = "Query NE PLA sloltid from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, errCode:%d]", neID, errorCode);
            logger.error(tipStr);
        }
        return errorCode;
    }
}

