/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public class TEQueryPLASlavePortBean
extends TENEExplorerBean {
    private static final int SLAVE_INFO_LENGTH = 14;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.modifyInputParams();
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid + 0, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid + 0);
            if (result == 0) {
                this.handleMessage(neid + 0, this.operationList, subFunc);
                this.handlePrototypeArr();
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            Param isLogFlagParam_rtn1 = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag");
            if (isLogFlagParam_rtn1 != null && isLogFlagParam_rtn1.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid + 0, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!!!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private void handlePrototypeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data_rtn = this.outputData.getBussinessParams();
        int rowcount = data_rtn.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data_rtn.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        for (int i = 0; i < data_rtn.getRowParamsCount(); ++i) {
            row = data_rtn.getRowParams(i);
            Param slaveportnumPar = row.getParam("slaveportnum");
            String plaID = row.getParam("ggroupid").getValue();
            RowParams temprow = null;
            if (slaveportnumPar == null || slaveportnumPar.getValue().isEmpty()) continue;
            Param slavesloidsPar = row.getParam("slaveslotids");
            String slavesloidsvar = slavesloidsPar.getValue();
            data_rtn.clearRowParams();
            int slaveportnums = Integer.parseInt(slaveportnumPar.getValue());
            for (int j = 1; j <= slaveportnums; ++j) {
                temprow = new RowParams();
                String eatchRowDate = slavesloidsvar.substring((j - 1) * 14, j * 14);
                int slavesloid = Integer.parseInt(this.convertSlaveSlot(eatchRowDate), 16);
                int slaveport = Integer.parseInt(this.convertSlavePort(eatchRowDate), 16);
                int slaveportHardStatus = Integer.parseInt(this.convertHDStatus(eatchRowDate), 16);
                int slaveportLinkStatus = Integer.parseInt(this.convertLinkStatus(eatchRowDate), 16);
                int slaveportWorkStatus = Integer.parseInt(this.convertWorkStatus(eatchRowDate), 16);
                TEBoard sboard = mgr.getBoard(this.neid, slavesloid);
                Param portpar = new Param();
                portpar.setName("slaveboardname");
                portpar.setValue(slavesloid + "-" + sboard.getBoardName());
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("ggroupid");
                portpar.setValue(plaID);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slavesloid");
                portpar.setValue(String.valueOf(slavesloid));
                temprow.addParam(portpar);
                int slaveportid = slaveport;
                String slaveportname = mgr.getPortNameForPTN(this.neid, slavesloid, sboard.getBoardType(), slaveportid);
                portpar = new Param();
                portpar.setName("slaveportname");
                portpar.setValue(slaveportname);
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportid");
                portpar.setValue(String.valueOf(slaveportid));
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportHardStatus");
                portpar.setValue(slaveportHardStatus + "");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportLinkStatus");
                portpar.setValue(slaveportLinkStatus + "");
                temprow.addParam(portpar);
                portpar = new Param();
                portpar.setName("slaveportWorkStatus");
                portpar.setValue(slaveportWorkStatus + "");
                temprow.addParam(portpar);
                data_rtn.addRowParams(temprow);
            }
        }
    }

    private String convertSlaveSlot(String arr) {
        String slaveslot = arr.substring(0, 4);
        return slaveslot;
    }

    private String convertSlavePort(String arr) {
        String slaveslot = arr.substring(6, 8);
        return slaveslot;
    }

    private String convertHDStatus(String arr) {
        String slaveslot = arr.substring(8, 10);
        return slaveslot;
    }

    private String convertLinkStatus(String arr) {
        String slaveslot = arr.substring(10, 12);
        return slaveslot;
    }

    private String convertWorkStatus(String arr) {
        String slaveslot = arr.substring(12, 14);
        return slaveslot;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }
}

