/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryPLABean
extends TENEExplorerBean {
    private static final String QUERY_STATUS = "NSCMD_CFG_GET_PLA_STATUS";
    private static final String QUERY_MINUPLINKTH = "NSCMD_CFG_GET_PLA_MINUPLINK_TH";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc);
        this.handlePrototypeArr();
    }

    private void handlePrototypeArr() {
        if (!"0".equals(this.outputData.getErrorMessage().getErrorcode()) && !"1".equals(this.outputData.getErrorMessage().getErrorcode())) {
            return;
        }
        BussinessParams data = this.outputData.getBussinessParams();
        int rowcount = data.getRowParamsCount();
        if (rowcount <= 0) {
            return;
        }
        RowParams row = data.getRowParams(0);
        if (row.getRowErrorsCount() != 0) {
            return;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        for (int i = 0; i < data.getRowParamsCount(); ++i) {
            row = data.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            Param mainslotid = row.getParam("mainslotid");
            int mainslot = Integer.valueOf(mainslotid.getValue());
            Param portpar = new Param();
            portpar.setName("mainboardname");
            portpar.setValue(mainslotid.getValue() + "-" + mgr.getBoardName(this.neid, mainslot));
            row.addParam(portpar);
            Param mainportid = row.getParam("mainportid");
            int mainport = Integer.valueOf(mainportid.getValue());
            String portname = mgr.getPortNameForPTN(this.neid, mainslot, mainport);
            portpar = new Param();
            portpar.setName("mainportname");
            portpar.setValue(portname);
            row.addParam(portpar);
            this.queryPortStatus(row);
        }
    }

    private void queryPortStatus(RowParams row) {
        String groupid = row.getParam("ggroupid").getValue();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_STATUS);
        Input input = operation.getInput();
        input.getPart("ggroupid").setValue(groupid);
        ArrayList<Operation> operations = new ArrayList<Operation>();
        operations.add(operation);
        operation = TECreateObjectFactory.getOperation((int)this.neid, (String)QUERY_MINUPLINKTH);
        input = operation.getInput();
        input.getPart("ggroupid").setValue(groupid);
        operations.add(operation);
        int result = this.sendMessage(this.neid, operations);
        if (result == 0) {
            for (int i = 0; i < operations.size(); ++i) {
                Param portpar;
                Operation oper = (Operation)operations.get(i);
                Output out = oper.getOutput(0);
                String operName = oper.getName();
                if (QUERY_STATUS.equals(operName) && "0".equals(out.getFault(0).getCode())) {
                    String mainportstut = out.getPartValue("mainportWorkStatus");
                    portpar = new Param();
                    portpar.setName("mainportWorkStatus");
                    portpar.setValue(mainportstut);
                    row.addParam(portpar);
                    String mainportHardStatus = out.getPartValue("mainportHDStatus");
                    portpar = new Param();
                    portpar.setName("mainportHDStatus");
                    portpar.setValue(mainportHardStatus);
                    row.addParam(portpar);
                    String mainportLinkStatus = out.getPartValue("mainportLineStatus");
                    portpar = new Param();
                    portpar.setName("mainportLinkStatus");
                    portpar.setValue(mainportLinkStatus);
                    row.addParam(portpar);
                }
                if (!QUERY_MINUPLINKTH.equals(operName) || !"0".equals(out.getFault(0).getCode())) continue;
                String minUpLinkTH = out.getPartValue("minUpLinkTH");
                portpar = new Param();
                portpar.setName("minUpLinkTH");
                portpar.setValue(minUpLinkTH);
                row.addParam(portpar);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38662);
        return list;
    }
}

