/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.ptn.infconfig.AsnPTNCommonPort;
import com.huawei.nglct.nemgr.f_interface.ptn.infconfig.dsl.AsnPTNGetXDSLPortResReq;
import com.huawei.nglct.nemgr.f_interface.ptn.infconfig.dsl.AsnPTNGetXDSLPortResRsp;
import com.huawei.nglct.nemgr.rtn.pla.TEQueryPLABean;
import com.huawei.nglct.nemgr.rtn.pla_smart.TEQueryPLABean_Smart;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEStringUtils;
import java.math.BigInteger;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEPlaGetHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    public static final int TECMDCODE_RTN_QUERY_PLA_GROUP = 2179777;
    public static final int TECMDCODE_RTN_QUERY_PLA_GROUP_EXT = 2180150;

    protected int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        SubFunc subFunc;
        int neType;
        int errorCode = -1;
        AsnPTNGetXDSLPortResReq req = (AsnPTNGetXDSLPortResReq)qReq;
        AsnPTNGetXDSLPortResRsp rsp = (AsnPTNGetXDSLPortResRsp)qRsp;
        int neid = req.neID.intValue();
        e2eLogger.info("handleRequestImpl: begin: req->" + req.toString());
        TENEExplorerBean bean = null;
        TENE neObjPlaFo = TENEListMgr.getInstance().getNE(neid);
        if (null == neObjPlaFo) {
            TELogFactory.getNormalLogger().info("The NE Not Fount in NEList:" + neid);
            return 2;
        }
        if (1 != neObjPlaFo.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
        }
        if ((neType = neObjPlaFo.getNEType()) == 95 || neType == 92 && neType == 115) {
            subFunc = TEPlaGetHandler.createSubFunc(neid, 2180150);
            bean = new TEQueryPLABean_Smart(){

                public boolean isNeedOperationlog() {
                    return false;
                }
            };
        } else {
            subFunc = TEPlaGetHandler.createSubFunc(neid, 2179777);
            bean = new TEQueryPLABean(){

                public boolean isNeedOperationlog() {
                    return false;
                }
            };
        }
        Datainterface inputData = this.createInputData(neid);
        Datainterface outputData = bean.performBussinessProcess(neid, subFunc, inputData, new Datainterface(), null, null);
        if (outputData == null || outputData.getBussinessParams() == null || outputData.getBussinessParams().getRowParams() == null) {
            return errorCode;
        }
        this.fillResData(outputData, rsp);
        e2eLogger.info("handleRequestImpl: end. rsq->" + rsp.toString());
        return 0;
    }

    private void fillResData(Datainterface outputData, AsnPTNGetXDSLPortResRsp rsp) {
        String errCode = outputData.getErrorMessage().getErrorcode();
        if ("0".equals(errCode) || "1".equals(errCode)) {
            for (RowParams rows : outputData.getBussinessParams().getRowParams()) {
                Param ggroupid = rows.getParam("ggroupid");
                Param ggrouptype = rows.getParam("ggrouptype");
                if (TEStringUtils.isParamEmpty((Param)ggroupid)) continue;
                AsnPTNCommonPort pla = new AsnPTNCommonPort();
                pla.slotID = BigInteger.valueOf(Long.parseLong(ggroupid.getValue()));
                int gtype = 0;
                if (ggrouptype != null && ggrouptype.getValue() != null && !ggrouptype.getValue().isEmpty()) {
                    gtype = Integer.parseInt(ggrouptype.getValue());
                }
                pla.portID = BigInteger.valueOf(gtype);
                rsp.portList.add((Object)pla);
            }
            rsp.result.isSuccess = true;
            rsp.result.retCode = BigInteger.valueOf(0L);
        } else {
            rsp.result.isSuccess = false;
            rsp.result.retCode = BigInteger.valueOf(Long.parseLong(errCode));
        }
    }

    private Datainterface createInputData(int neID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        this.appendParam(rowparams, "neid", String.valueOf(neID));
        this.appendParam(rowparams, "ggroupid", "0");
        bussiness.addRowParams(rowparams);
        return inputData;
    }

    private void appendParam(RowParams rowParams, String paramName, String paramValue) {
        Param param = null;
        param = new Param();
        param.setName(paramName);
        param.setValue(paramValue);
        rowParams.addParam(param);
    }

    public static SubFunc createSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            TELogFactory.getE2ELogger().error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        return subFunc;
    }
}

