/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class TEGetAvailablePortResBean
extends TENEExplorerBean {
    protected static final int INVALID_SLOT = 65535;
    protected List<PortObj> availablePorts = new ArrayList<PortObj>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        this.getPhysicsPorts();
        Collections.sort(this.availablePorts);
        PortObj portObj = null;
        RowParams rowParams = null;
        int m = this.availablePorts.size();
        for (int i = 0; i < m; ++i) {
            portObj = this.availablePorts.get(i);
            rowParams = new RowParams();
            rowParams.addParam("slotid", String.valueOf(portObj.slotId));
            rowParams.addParam("boardname", String.valueOf(portObj.boardName));
            rowParams.addParam("portid", String.valueOf(portObj.portId));
            rowParams.addParam("portname", String.valueOf(portObj.portName));
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        return this.outputData;
    }

    protected void getPhysicsPorts() {
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        ArrayList portList = null;
        TEPort port = null;
        TEBoard board = null;
        int slotId = -1;
        int boardType = -1;
        int portId = -1;
        Vector boardVec = cfgMgr.getNE(this.neid).getClonedBoardList();
        int m = boardVec.size();
        for (int i = 0; i < m; ++i) {
            portList = new ArrayList();
            board = (TEBoard)boardVec.get(i);
            slotId = board.getSlotID();
            boardType = board.getBoardType();
            if (boardType == 2266 || boardType == 2267 || boardType == 2475 || 2468 == boardType || boardType == 3062 || boardType == 2079 || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CREAT_EPLA", "TE_ATTR_RTN_IFBOARD_SUPPORT_EPLA")) {
                portList.addAll(cfgMgr.getPortList(this.neid, slotId, 1802));
            }
            int n = portList.size();
            for (int j = 0; j < n; ++j) {
                port = (TEPort)portList.get(j);
                portId = port.getPortNo();
                this.availablePorts.add(new PortObj(slotId, boardType, board.getBoardName(), portId, cfgMgr.getPortNameForPTN(this.neid, slotId, boardType, portId)));
            }
        }
    }

    protected static class PortObj
    implements Comparable<PortObj> {
        public int slotId = 65535;
        public int boardType = -1;
        public String boardName = "UNKNOWN";
        public int portId = -1;
        public String portName = "";

        public PortObj() {
        }

        public PortObj(int slotId, int portId) {
            this.slotId = slotId;
            this.portId = portId;
        }

        public PortObj(int slotId, int boardType, String boardName, int portId, String portName) {
            this.slotId = slotId;
            this.boardType = boardType;
            this.boardName = boardName;
            this.portId = portId;
            this.portName = portName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.slotId;
            result = 31 * result + this.portId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortObj other = (PortObj)obj;
            if (this.slotId != other.slotId) {
                return false;
            }
            return this.portId == other.portId;
        }

        @Override
        public int compareTo(PortObj o) {
            if (this.slotId == o.slotId) {
                return this.portId - o.portId;
            }
            return this.slotId - o.slotId;
        }
    }
}

