/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.pla;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.necommon.rtn.pla.TERtnPlaFilter;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.List;

public class TECreatePLABean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        String mainslotid = inputData.getBussinessParams().getRowParams(0).getParam("mainslotid").getValue();
        String mainportid = inputData.getBussinessParams().getRowParams(0).getParam("mainportid").getValue();
        String mainBdName = currentNE.getBoard(Integer.parseInt(mainslotid)).getBoardName();
        String mainString = mainslotid + "-" + mainBdName + "-" + mainportid;
        String slaveslotids = inputData.getBussinessParams().getRowParams(0).getParam("slaveslotids").getValue();
        String slaveportids = inputData.getBussinessParams().getRowParams(0).getParam("slaveportids").getValue();
        String[] slotArr = slaveslotids.split(",");
        String[] portArr = slaveportids.split(",");
        String slaveString = "";
        StringBuilder slaveSb = new StringBuilder("");
        for (int k = 0; k < slotArr.length; ++k) {
            int tmpSlot = Integer.parseInt(slotArr[k]);
            int tmpPort = Integer.parseInt(portArr[k]);
            String tmpBdName = currentNE.getBoard(tmpSlot).getBoardName();
            slaveSb.append(tmpSlot).append('-').append(tmpBdName).append('-').append(tmpPort).append(',');
        }
        if (slaveSb.length() > 0) {
            slaveString = slaveSb.substring(0, slaveSb.length() - 1);
        }
        inputData.getBussinessParams().getRowParams(0).addParam(new Param("mainboardname", mainString));
        inputData.getBussinessParams().getRowParams(0).addParam(new Param("slaveboardport", slaveString));
        this.handelSlaveArr(inputData);
        TERtnPlaFilter.getInstance().setPlaPortRefreshFlag(neid);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private void handelSlaveArr(Datainterface inputData) {
        RowParams row = inputData.getBussinessParams().getRowParams(0);
        StringBuilder sb = new StringBuilder();
        String slaveSlot = row.getParam("slaveslotids").getValue();
        String slavePort = row.getParam("slaveportids").getValue();
        String[] slaveSlotArr = slaveSlot.split(",");
        String[] slavePortArr = slavePort.split(",");
        int iLength = slaveSlotArr.length;
        for (int i = 0; i < iLength; ++i) {
            if (slaveSlotArr[i] == null || slaveSlotArr[i].isEmpty()) continue;
            sb.append(this.convertString(slaveSlotArr[i], "slot"));
            sb.append("ff");
            sb.append(this.convertString(slavePortArr[i], "port"));
        }
        row.getParam("slaveslotids").setValue(sb.toString());
    }

    private String convertString(String arr, String flag) {
        StringBuffer sb = new StringBuffer();
        String[] stringArr = arr.split(",");
        for (int i = 0; i < stringArr.length; ++i) {
            String addstr;
            int id = Integer.parseInt(stringArr[i]);
            if (id > 15) {
                addstr = "";
            } else if (id == 0) {
                addstr = "00";
                if (flag.endsWith("slot")) {
                    addstr = "0000";
                }
            } else {
                addstr = "0";
                if (flag.endsWith("slot")) {
                    addstr = "000";
                }
            }
            sb.append(addstr).append(Integer.toHexString(id));
        }
        return sb.toString();
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String BASE_PATH = "rtn" + File.separator + "res";
        String STRING_SOURCE = BASE_PATH + File.separator + "pla" + File.separator + "plamgr_" + LANGUAGE + ".ini";
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = TESecurityVerify.getSuperUserID();
                }
            }
            this.subfunc = subfunc;
            this.outputData = outputData;
            String operObj = this.getOperObj();
            String operName = this.getOperateName();
            List loginfoList = this.getLogInfoList(inputData);
            TELogInfo loginfo = null;
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(operName);
                loginfo.setOperateObject(operObj);
                if (((TELogInfo)loginfoList.get(i)).getErrCode() == 0) {
                    RowParams row = inputData.getBussinessParams().getRowParams(0);
                    String ggidValue = row.getParam("ggroupid").getValue();
                    String mainValue = row.getParam("mainboardname").getValue();
                    String slaveValue = row.getParam("slaveboardport").getValue();
                    Param ggrouptypeParam = row.getParam("ggrouptype");
                    int ggrouptype = 0;
                    if (ggrouptypeParam != null && ggrouptypeParam.getValue() != null) {
                        ggrouptype = Integer.parseInt(ggrouptypeParam.getValue());
                    }
                    String mergeValue = resourceUtil.getString("aggType") + ":" + resourceUtil.getString("aggType_" + ggrouptype) + "," + resourceUtil.getString("ggroupid") + ":" + ggidValue + "," + resourceUtil.getString("mainboardname") + ":" + mainValue + "," + resourceUtil.getString("slaveboardport") + ":" + slaveValue;
                    ((TELogInfo)loginfoList.get(i)).setOperateDesc(mergeValue);
                }
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

