/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.rtn.performance.TERTNCurrentPFMStruc;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;

public class TERTNSaveCurrentPFMAsXLS
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final String QUERY_CURRENT_PFM = "1";
    private static final int BUFFER_CAPACITY = 50;
    private static final String[] error_arr = new String[]{"IF_ES", "IF_SES", "IF_CSES", "IF_UAS", "IF_BBE", "FEC_BEF_COR_ER"};

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String pfm_type = req.getParameter("pfm_type");
        if (pfm_type.equals(QUERY_CURRENT_PFM)) {
            this.saveCurrentPFMAsXLS(req, res);
        } else {
            this.saveHistroyPFMAsXLS(req, res);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHistroyPFMAsXLS(HttpServletRequest req, HttpServletResponse response) {
        try {
            int i;
            int neid = Integer.parseInt(req.getParameter("neid"));
            String srcNeName = req.getParameter("srcNeName");
            String snkNeName = req.getParameter("snkNeName");
            String currAttr = req.getParameter("currAttr");
            int srcNum = 6;
            int snkNum = 6;
            ArrayList<String> srcList = new ArrayList<String>();
            ArrayList<String> snkList = new ArrayList<String>();
            if (currAttr != null && !currAttr.isEmpty()) {
                String[] attr;
                for (String temp : attr = currAttr.split(",")) {
                    if (temp.indexOf("src") != -1) {
                        ++srcNum;
                        srcList.add(temp);
                        continue;
                    }
                    ++snkNum;
                    snkList.add(temp);
                }
            }
            HSSFWorkbook wb = new HSSFWorkbook();
            TEResourceUtil res = this.getLinkPFMRes(neid);
            HSSFSheet sheet = wb.createSheet(res.getString("histroypfm"));
            sheet.setDefaultRowHeight((short)250);
            sheet.setDefaultColumnWidth(20);
            HSSFCellStyle cellStyle = wb.createCellStyle();
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)2);
            Row row = sheet.createRow(0);
            row.createCell(0).setCellValue("");
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 0));
            Cell cell = null;
            cell = row.createCell(1);
            cell.setCellValue(srcNeName);
            cell.setCellStyle((CellStyle)cellStyle);
            cell = row.createCell(1 + srcNum);
            cell.setCellValue(snkNeName);
            cell.setCellStyle((CellStyle)cellStyle);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 1, srcNum));
            sheet.addMergedRegion(new CellRangeAddress(0, 0, srcNum + 1, srcNum + snkNum));
            ArrayList<String> tableHead = new ArrayList<String>();
            tableHead.add(res.getString("endtime"));
            int size = srcList.size();
            for (i = 0; i < size; ++i) {
                tableHead.add((String)srcList.get(i));
            }
            size = error_arr.length;
            for (i = 0; i < size; ++i) {
                tableHead.add(error_arr[i]);
            }
            size = snkList.size();
            for (i = 0; i < size; ++i) {
                tableHead.add((String)snkList.get(i));
            }
            size = error_arr.length;
            for (i = 0; i < size; ++i) {
                tableHead.add(error_arr[i]);
            }
            row = sheet.createRow(1);
            size = tableHead.size();
            for (i = 0; i < size; ++i) {
                row.createCell(i).setCellValue(res.getString((String)tableHead.get(i)));
            }
            String inputDataStr = req.getParameter("inputdata");
            inputDataStr = URLDecoder.decode(inputDataStr, "utf-8");
            Datainterface inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (int i2 = 0; i2 < len; ++i2) {
                RowParams tempParams = inputData.getBussinessParams().getRowParams(i2);
                row = sheet.createRow(i2 + 2);
                int rowNum = 0;
                int size2 = tempParams.getParamCount();
                for (int j = 0; j < size2; ++j) {
                    row.createCell(rowNum++).setCellValue(tempParams.getParam(j).getValue());
                }
            }
            String fileName = "histroypfm.csv";
            ServletOutputStream out = null;
            FilterOutputStream bos = null;
            try {
                out = response.getOutputStream();
                response.setHeader("Content-Type", "application/force-download");
                response.setHeader("Content-disposition", "attachment;filename=" + fileName);
                response.setHeader("Expires", "0");
                response.setHeader("Pragma", "public");
                response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                response.setHeader("Cache-Control", "public");
                bos = new BufferedOutputStream((OutputStream)out);
                wb.write((OutputStream)bos);
            }
            catch (IOException e) {
                log.info("Radio link performance save current performance as csv error!", (Throwable)e);
            }
            finally {
                bos.close();
            }
        }
        catch (Exception e) {
            log.info("Radio link performance save current performance as csv error!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCurrentPFMAsXLS(HttpServletRequest req, HttpServletResponse res) throws IOException {
        try {
            int neid = Integer.parseInt(req.getParameter("neid"));
            String inputDataStr = req.getParameter("inputdata");
            inputDataStr = URLDecoder.decode(inputDataStr, "utf-8");
            Datainterface inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
            TERTNCurrentPFMStruc snkStruct = new TERTNCurrentPFMStruc();
            TERTNCurrentPFMStruc srcStruct = new TERTNCurrentPFMStruc();
            this.handleCurrentRowParams(rowParams[0], snkStruct);
            this.handleCurrentRowParams(rowParams[1], srcStruct);
            TEResourceUtil pfm_res = this.getLinkPFMRes(neid);
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet(pfm_res.getString("currentpfm"));
            Row row = sheet.createRow(0);
            this.setPowerRowValue((Sheet)sheet, row, 0, "", snkStruct.neName, srcStruct.neName);
            row = sheet.createRow(1);
            this.setPowerRowValue((Sheet)sheet, row, 1, pfm_res.getString("rePwrRow"), snkStruct.rePwr, srcStruct.rePwr);
            row = sheet.createRow(2);
            this.setPowerRowValue((Sheet)sheet, row, 2, pfm_res.getString("realrePwrRow"), snkStruct.realrePwr, srcStruct.realrePwr);
            row = sheet.createRow(3);
            this.setPowerRowValue((Sheet)sheet, row, 3, pfm_res.getString("sdPwrRow"), snkStruct.sdPwr, srcStruct.sdPwr);
            row = sheet.createRow(4);
            this.setPowerRowValue((Sheet)sheet, row, 4, pfm_res.getString("realsdPwrRow"), snkStruct.realsdPwr, srcStruct.realsdPwr);
            row = sheet.createRow(5);
            this.setErrorRowValue(row, "", pfm_res.getString("minute"), pfm_res.getString("hour"), pfm_res.getString("minute"), pfm_res.getString("hour"));
            row = sheet.createRow(6);
            this.setErrorRowValue(row, pfm_res.getString("IF_ES"), snkStruct.es15, snkStruct.es24, srcStruct.es15, srcStruct.es24);
            row = sheet.createRow(7);
            this.setErrorRowValue(row, pfm_res.getString("IF_SES"), snkStruct.ses15, snkStruct.ses24, srcStruct.ses15, srcStruct.ses24);
            row = sheet.createRow(8);
            this.setErrorRowValue(row, pfm_res.getString("IF_CSES"), snkStruct.cses15, snkStruct.cses24, srcStruct.cses15, srcStruct.cses24);
            row = sheet.createRow(9);
            this.setErrorRowValue(row, pfm_res.getString("IF_UAS"), snkStruct.uas15, snkStruct.uas24, srcStruct.uas15, srcStruct.uas24);
            row = sheet.createRow(10);
            this.setErrorRowValue(row, pfm_res.getString("IF_BBE"), snkStruct.bbe15, snkStruct.bbe24, srcStruct.bbe15, srcStruct.bbe24);
            row = sheet.createRow(11);
            this.setErrorRowValue(row, pfm_res.getString("FEC_BEF_COR_ER"), snkStruct.fec15, snkStruct.fec24, srcStruct.fec15, srcStruct.fec24);
            row = sheet.createRow(12);
            this.setErrorRowValue(row, pfm_res.getString("start_time"), snkStruct.startTime15, snkStruct.startTime24, srcStruct.startTime15, srcStruct.startTime24);
            String fileName = "currentpfm.csv";
            ServletOutputStream out = null;
            FilterOutputStream bos = null;
            try {
                out = res.getOutputStream();
                res.setHeader("Content-Type", "application/force-download");
                res.setHeader("Content-disposition", "attachment;filename=" + fileName);
                res.setHeader("Expires", "0");
                res.setHeader("Pragma", "public");
                res.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
                res.setHeader("Cache-Control", "public");
                bos = new BufferedOutputStream((OutputStream)out);
                wb.write((OutputStream)bos);
            }
            catch (IOException e) {
                log.info("Radio link performance save current performance as csv error!", (Throwable)e);
            }
            finally {
                bos.close();
            }
        }
        catch (Exception e) {
            log.info("Radio link performance save current performance as csv error!", (Throwable)e);
        }
    }

    private void handleCurrentRowParams(RowParams rowParams, TERTNCurrentPFMStruc struct) {
        struct.neName = rowParams.getParam("neName").getValue();
        struct.rePwr = rowParams.getParam("rePwr").getValue();
        struct.realrePwr = rowParams.getParam("realrePwr").getValue();
        struct.sdPwr = rowParams.getParam("sdPwr").getValue();
        struct.realsdPwr = rowParams.getParam("realsdPwr").getValue();
        struct.es15 = rowParams.getParam("es15").getValue();
        struct.es24 = rowParams.getParam("es24").getValue();
        struct.ses15 = rowParams.getParam("ses15").getValue();
        struct.ses24 = rowParams.getParam("ses24").getValue();
        struct.cses15 = rowParams.getParam("cses15").getValue();
        struct.cses24 = rowParams.getParam("cses24").getValue();
        struct.uas15 = rowParams.getParam("uas15").getValue();
        struct.uas24 = rowParams.getParam("uas24").getValue();
        struct.bbe15 = rowParams.getParam("bbe15").getValue();
        struct.bbe24 = rowParams.getParam("bbe24").getValue();
        struct.fec15 = rowParams.getParam("fec15").getValue();
        struct.fec24 = rowParams.getParam("fec24").getValue();
        struct.startTime15 = rowParams.getParam("startTime15").getValue();
        struct.startTime24 = rowParams.getParam("startTime24").getValue();
    }

    private void setPowerRowValue(Sheet sheet, Row row, int rowCode, String str0, String str1, String str2) {
        row.createCell(0).setCellValue(str0);
        sheet.addMergedRegion(new CellRangeAddress(rowCode, rowCode, 0, 0));
        row.createCell(1).setCellValue(str1);
        row.createCell(3).setCellValue(str2);
        sheet.addMergedRegion(new CellRangeAddress(rowCode, rowCode, 1, 2));
        sheet.addMergedRegion(new CellRangeAddress(rowCode, rowCode, 3, 4));
    }

    private void setErrorRowValue(Row row, String str0, String str1, String str2, String str3, String str4) {
        row.createCell(0).setCellValue(str0);
        row.createCell(1).setCellValue(str1);
        row.createCell(2).setCellValue(str2);
        row.createCell(3).setCellValue(str3);
        row.createCell(4).setCellValue(str4);
    }

    private TEResourceUtil getLinkPFMRes(int neid) {
        StringBuffer filePath = new StringBuffer(50);
        filePath.append("rtn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("linkpfm").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        return TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
    }
}

