/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.performance;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmEventsDataLoader;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPFMInput;
import com.huawei.nglct.nemgr.rtn.performance.TERTNRowError;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;

public final class TERTNPFMUtility {
    public static final String TRANSMITPOWER = "W32BRD_ATTR_TRANSMITPOWER";
    public static final String ACTTRANSMITPOWER = "W32BRD_ATTR_ACTTRANSMITPOWER";
    public static final String RECEIVEPOWER = "W32BRD_ATTR_RECEIVEPOWER";
    public static final String ACTRECEIVEPOWER = "W32BRD_ATTR_ACTRECEIVEPOWER";
    public static final String NSCMD_CFG_GET_ODU_TXPOWER = "NSCMD_CFG_GET_ODU_TXPOWER";
    public static final String NSCMD_CFG_GET_ODU_SRSL = "NSCMD_CFG_GET_ODU_SRSL";
    public static final String NSCMD_CFG_GET_ODU_RPOWER = "NSCMD_CFG_GET_ODU_RPOWER";
    public static final String NSCMD_PER_GET_CURDATA_NEW = "NSCMD_PER_GET_CURDATA_NEW";
    public static final String NSCMD_PER_GET_CURDATA = "NSCMD_PER_GET_CURDATA";
    public static final String NSCMD_PER_GET_HISDATA_NEW = "NSCMD_PER_GET_HISDATA_NEW";
    public static final String NSCMD_PER_GET_HISDATA = "NSCMD_PER_GET_HISDATA";
    public static final String TIME_15_MINUTE = "1";
    public static final String TIME_24_HOUR = "2";
    public static final String OBJ_IF_PORT = "110";
    public static final String OBJ_RF_PORT = "111";
    public static final String RESERVE_BYTE = "255";
    public static final int IF_BBE = 14941;
    public static final int IF_ES = 14942;
    public static final int IF_SES = 14943;
    public static final int IF_UAS = 14944;
    public static final int IF_CSES = 14945;
    public static final int FEC_BEF_COR_ER = 252;
    public static final int RSBBE = 1;
    public static final int RSES = 2;
    public static final int RSSES = 3;
    public static final int RSUAS = 6;
    public static final int RSCSES = 7;
    public static final String DEFAULT = "0";
    public static final String DEFAULT_ERROR = "/";
    public static final int DEFAULT_PORT = 1;
    public static final int DEFAULT_SUBCARDID = 255;
    public static final int RSL_MAX = 8606;
    public static final int RSL_MIN = 8607;
    public static final int RSL_CUR = 8608;
    public static final int RSL_AVG = 15043;
    public static final int TSL_MAX = 8609;
    public static final int TSL_MIN = 8610;
    public static final int[] pfmId = new int[]{14942, 14943, 14945, 14944, 14941, 252};
    public static final int[] pfmId_old = new int[]{1, 2, 3, 6, 7, 252};
    public static final int[] histroy_power_pfmId = new int[]{8606, 8607, 8608, 15043, 8609, 8610};
    public static final int[] pfmId_eband = new int[]{14942, 14943, 14945, 14944, 14941};
    public static final int TE_PERF_FLOAT = 6;
    public static final String FROM_REG_NUM = "1";
    public static final String TO_REG_15_NUM = "16";
    public static final String TO_REG_24_NUM = "6";
    public static final int HOUR = 3600000;
    public static final int MINUTE = 60000;
    public static final int SECOND = 1000;
    private static final int TYPE_605 = 60;
    private static final int TYPE_610 = 54;
    private static final int TYPE_620 = 55;
    private static final int TYPE_RTN_380 = 115;
    private static final DecimalFormatSymbols US_Symbols = new DecimalFormatSymbols(Locale.US);

    private TERTNPFMUtility() {
    }

    public static void setSlotId(Operation operation, String slotID) {
        if (null == operation) {
            return;
        }
        Input input = operation.getInput();
        input.setPartValue("slotid", slotID);
    }

    public static void constructLongPFMOperation(TERTNPFMInput longPFMInput, List operationList) {
        TEPfmMonObjID monObj = new TEPfmMonObjID();
        monObj.setSlotID(Integer.parseInt(longPFMInput.soltID));
        monObj.setPortID(1);
        monObj.setSubcardID(255);
        int neid = longPFMInput.neid;
        TELParamMgr objTypeMgr = new TELParamMgr(neid);
        TEObjectParam objParam = objTypeMgr.getObjectParam(longPFMInput.objtype, monObj);
        String paralen = objParam.getParamLength();
        String objpara = objParam.getObjParam();
        Operation oper = null;
        oper = longPFMInput.beginTime == null ? TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PER_GET_CURDATA_NEW) : TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PER_GET_HISDATA_NEW);
        int[] pfmID = longPFMInput.pfmId;
        Operation operClone = null;
        int len = pfmID.length;
        for (int i = 0; i < len; ++i) {
            operClone = (Operation)oper.clone();
            Input input = operClone.getInput();
            input.setPartValue("peid", String.valueOf(pfmID[i]));
            input.setPartValue("period", String.valueOf(longPFMInput.period));
            input.setPartValue("reserve", RESERVE_BYTE);
            input.setPartValue("objtype", longPFMInput.objtype);
            input.setPartValue("paralen", paralen);
            input.setPartValue("objpara", objpara);
            if (longPFMInput.beginTime != null) {
                input.setPartValue("beginTime", longPFMInput.beginTime);
                input.setPartValue("endTime", longPFMInput.endTime);
            }
            operationList.add(operClone);
        }
    }

    public static void constructShortPFMOperation(TERTNPFMInput shortPFMInput, List operationList) {
        int neid = shortPFMInput.neid;
        int[] pfmID = shortPFMInput.pfmId;
        Operation oper = null;
        oper = shortPFMInput.beginTime == null ? TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PER_GET_CURDATA) : TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_PER_GET_HISDATA);
        Operation operClone = null;
        int len = pfmID.length;
        for (int i = 0; i < len; ++i) {
            operClone = (Operation)oper.clone();
            Input input = operClone.getInput();
            input.setPartValue("slotID", String.valueOf(shortPFMInput.soltID));
            input.setPartValue("portID", String.valueOf(1));
            input.setPartValue("pathID", String.valueOf(1));
            input.setPartValue("peid", String.valueOf(pfmID[i]));
            input.setPartValue("period", String.valueOf(shortPFMInput.period));
            if (shortPFMInput.beginTime != null) {
                input.setPartValue("fromReg", "1");
                String toReg = shortPFMInput.period.equalsIgnoreCase("1") ? TO_REG_15_NUM : TO_REG_24_NUM;
                input.setPartValue("toReg", toReg);
            }
            operationList.add(operClone);
        }
    }

    public static String convertQX5Power(String value) {
        if (!DEFAULT_ERROR.equals(value) && !"-".equals(value)) {
            int temp = new BigInteger(value).intValue();
            short shortTemp = (short)temp;
            return Float.toString((float)shortTemp / 10.0f);
        }
        return value;
    }

    public static String qx5Value2PfmValue(int neid, String value, int peid) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)value);
        long qx5Value = IOStreamConvertor.readLong((byte[])t, (int)0);
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return "-1";
        }
        if (peid == 0) {
            return "-1";
        }
        TEPfmBsEvent event = TERTNPFMUtility.getPfmBsEvent(neid, peid);
        if (null == event) {
            return "-1";
        }
        if (event.isCounter()) {
            if (6.0 == event.m_dUnit) {
                long expMUM = qx5Value & 0xFFFFL;
                long tmpValue = qx5Value;
                double baseNUM = (double)(tmpValue >>= 16) / 100.0;
                pfmValue = baseNUM * Math.pow(10.0, expMUM * -1L);
                pfmValue = new BigDecimal(pfmValue, new MathContext(4)).doubleValue();
            } else {
                pfmValue = qx5Value;
            }
        } else {
            DecimalFormat df = new DecimalFormat("#0.0", US_Symbols);
            pfmValue = (double)qx5Value * event.m_dUnit;
            return df.format(pfmValue);
        }
        return String.valueOf(pfmValue);
    }

    public static int getValueFromRecord(String record) {
        byte[] bValue = record.getBytes();
        byte[] bTmp = new byte[8];
        System.arraycopy(bValue, 10, bTmp, 0, 8);
        return IOStreamConvertor.readPositiveLong((byte[])bTmp, (int)0);
    }

    public static String qx5Value2PfmValue(int neid, int qx5Value, int peid) {
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return "-1";
        }
        if (peid == 0) {
            return "-1";
        }
        TEPfmBsEvent event = TERTNPFMUtility.getPfmBsEvent(neid, peid);
        if (null == event) {
            return "-1";
        }
        if (!event.isCounter()) {
            DecimalFormat df = new DecimalFormat("#0.0", US_Symbols);
            pfmValue = (double)qx5Value * event.m_dUnit;
            return df.format(pfmValue);
        }
        pfmValue = qx5Value;
        return String.valueOf(pfmValue);
    }

    public static TERTNRowError getErrorMessage(int neid, String errorCode) {
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        if (!"".equals(errorCode)) {
            errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        } else {
            errorMessage.setErrorinfo("");
        }
        rowError.setErrorMessage(errorMessage);
        String neName = "";
        neName = TENEListMgr.getInstance().getNE(neid) != null ? TENEListMgr.getInstance().getNE(neid).getNEName() : "NE" + neid;
        errorparam = new Param("nename", neName);
        rowError.addParam(errorparam);
        return new TERTNRowError(neid, rowError);
    }

    public static String getDisplayNeName(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int phyNeId = ne.getRealNEID();
        String neName = ne.getNEName();
        return neName + DEFAULT_ERROR + phyNeId / 65536 + "-" + phyNeId % 65536;
    }

    public static String getDetailStr(int neid, int slotId, SubFunc subFunc) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String neName = ne.getNEName();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        String boardName = mgr.getBoardTypeName(neid, mgr.getBoardType(neid, slotId));
        StringBuffer sb = new StringBuffer();
        sb.append(neName).append('-').append(slotId).append('-').append(boardName);
        return sb.toString();
    }

    public static int[] getPFMFromNe(int neid, int ifsoltId) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = cfgDataMgr.getBoard(neid, ifsoltId);
        if (board != null && (board.getBoardType() == 1548 || board.getBoardType() == 1549 || TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_ONETOUCHTEST_IS_LIKE_IFH_BOARD"))) {
            return pfmId;
        }
        if (neType == 60 || neType == 54 || neType == 55 || TESpecialAttrMgr.getInstance().isNESupportByType(neType, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE")) {
            return pfmId_old;
        }
        if (neType == 115) {
            return pfmId_eband;
        }
        return pfmId;
    }

    public static TEPfmBsEvent getPfmBsEvent(int neid, int peid) {
        return TEPfmEventsDataLoader.getInstance().getPfmBsEvent(neid, peid);
    }

    public static boolean validatePart(Part part, String name) {
        return part.getName().equalsIgnoreCase(name) && part.getValue() != null;
    }

    public static String millisTOStr(long millis) {
        int hour = (int)(millis / 3600000L);
        int min = (int)((millis - (long)(hour * 3600000)) / 60000L);
        int second = (int)(millis - (long)(hour * 3600000) - (long)(min * 60000)) / 1000;
        return TERTNPFMUtility.addZero(hour) + ":" + TERTNPFMUtility.addZero(min) + ":" + TERTNPFMUtility.addZero(second);
    }

    public static String addZero(int field) {
        String temp = String.valueOf(field);
        return field < 10 ? DEFAULT + temp : temp;
    }

    public static int getODUSoltID(int neid, String soltID) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        int neType = ne.getNEType();
        int snkSlotRelation = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return Integer.parseInt(soltID) + snkSlotRelation;
    }
}

