/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeAutoLogin;
import com.huawei.nglct.nemgr.rtn.performance.TERTNHistoryRow;
import com.huawei.nglct.nemgr.rtn.performance.TERTNHistoryRowStruc;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPFMInput;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPFMUtility;
import com.huawei.nglct.nemgr.rtn.performance.TERTNRowError;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TERTNGetHistroyPFMBean
extends TENEExplorerBean {
    private boolean long_flag = true;
    private static final int NSERR_PFM_NULL_OBJECT = 38416;
    private static final int TEERR_PER_NULL_OBJECT = 38429;
    private Set<TERTNRowError> errorsSet = new HashSet<TERTNRowError>();
    private TimeZoneDateBean timeProccessor = null;
    private Calendar pageBeginTime = null;
    private Calendar pageEndTime = null;
    private int period_type = 0;
    private boolean isSingle = true;
    private boolean isFarFlag = false;
    private Map<String, TERTNHistoryRowStruc> map = new HashMap<String, TERTNHistoryRowStruc>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.isFarFlag = "true".equals(inputData.getBussinessParams().getRowParams(0).getParam("isFar").getValue());
            TENE currentNE = TENEListMgr.getInstance().getNE(neid);
            if (null == currentNE) {
                this.handleNotLoginRSLData(neid);
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(1090596385)));
                this.filterErrorCode(this.errorsSet);
                return this.outputData;
            }
            this.isSingle = TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts();
            this.timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            ArrayList<Operation> operList = new ArrayList<Operation>();
            RowParams inputRowParam = inputData.getBussinessParams().getRowParams(0);
            this.pageBeginTime = this.getTimeIsSingle(inputRowParam.getParam("beginTime").getValue(), this.timeProccessor);
            this.pageEndTime = this.getTimeIsSingle(inputRowParam.getParam("endTime").getValue(), this.timeProccessor);
            this.period_type = Integer.parseInt(inputRowParam.getParam("period").getValue());
            if (!this.isSingle && 1 != currentNE.getLogStatus()) {
                TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
            }
            if (!TERtnNeAutoLogin.isNeLogin(currentNE)) {
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(37926)));
                this.handleNotLoginRSLData(neid);
                this.filterErrorCode(this.errorsSet);
                this.processMapData(inputRowParam);
                return this.outputData;
            }
            this.constructHistroyOperation(inputRowParam, operList);
            int result = super.sendMessage(neid, operList);
            if (result == 0) {
                this.handleHisPFMOpreationData(neid, !this.isFarFlag, operList);
                this.getMaxMinRxPower(neid, !this.isFarFlag);
            } else {
                this.handleNotLoginRSLData(neid);
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(result)));
            }
            this.filterErrorCode(this.errorsSet);
            this.processMapData(inputRowParam);
            return this.outputData;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TERTNGetHistroyPFMBean performBussinessProcess fail!", (Throwable)e);
            return null;
        }
    }

    private void getMaxMinRxPower(int neid, boolean bFlag) {
        String neName = TERTNPFMUtility.getDisplayNeName(neid);
        RowParams rowParams = new RowParams();
        rowParams.addParam("neName", neName);
        ArrayList<TERTNHistoryRowStruc> rowList = new ArrayList<TERTNHistoryRowStruc>();
        rowList.addAll(this.map.values());
        TERTNHistoryRowStruc row2 = null;
        ArrayList<Float> maxRxList = new ArrayList<Float>();
        ArrayList<Float> minRxList = new ArrayList<Float>();
        String maxRxPower = "";
        String minRxPower = "";
        int maxRxNum = 0;
        int minRxNum = 0;
        for (TERTNHistoryRowStruc row2 : rowList) {
            if (bFlag) {
                maxRxPower = row2.getSrcRow().getMaxRxPower();
                minRxPower = row2.getSrcRow().getMinRxPower();
            } else {
                maxRxPower = row2.getSnkRow().getMaxRxPower();
                minRxPower = row2.getSnkRow().getMinRxPower();
            }
            if (maxRxPower.equals("/")) {
                ++maxRxNum;
            } else {
                maxRxList.add(Float.valueOf(Float.parseFloat(maxRxPower)));
            }
            if (minRxPower.equals("/")) {
                ++minRxNum;
                continue;
            }
            minRxList.add(Float.valueOf(Float.parseFloat(minRxPower)));
        }
        if (maxRxNum == rowList.size()) {
            rowParams.addParam("maxRxPower", "/");
        } else {
            rowParams.addParam("maxRxPower", String.valueOf(Collections.max(maxRxList)));
        }
        if (minRxNum == rowList.size()) {
            rowParams.addParam("minRxPower", "/");
        } else {
            rowParams.addParam("minRxPower", String.valueOf(Collections.min(minRxList)));
        }
        this.outputData.getBussinessParams().addRowParams(rowParams);
    }

    private void processMapData(RowParams nearRowParams) {
        ArrayList<TERTNHistoryRowStruc> rowList = new ArrayList<TERTNHistoryRowStruc>();
        rowList.addAll(this.map.values());
        Collections.sort(rowList);
        TERTNHistoryRowStruc row2 = null;
        RowParams rowParams = null;
        TERTNHistoryRow historyRow = null;
        boolean isShowAll = rowList.size() < 4;
        for (TERTNHistoryRowStruc row2 : rowList) {
            rowParams = new RowParams();
            if (!this.isFarFlag) {
                historyRow = row2.getSrcRow();
                rowParams.addParam("isFar", "false");
            } else {
                historyRow = row2.getSnkRow();
                rowParams.addParam("isFar", "true");
            }
            rowParams.addParam("startTime", row2.getStartTime());
            if (isShowAll || row2.isbFlag()) {
                rowParams.addParam("showTime", row2.showTime);
            } else {
                rowParams.addParam("showTime", "");
            }
            rowParams.addParam("MaxRxPower", historyRow.getMaxRxPower());
            rowParams.addParam("MinRxPower", historyRow.getMinRxPower());
            rowParams.addParam("RxPower", historyRow.getRxPower());
            rowParams.addParam("AvgRxPower", historyRow.getAvgRxPower());
            rowParams.addParam("MaxTxPower", historyRow.getMaxTxPower());
            rowParams.addParam("MinTxPower", historyRow.getMinTxPower());
            rowParams.addParam("ES", historyRow.getEs());
            rowParams.addParam("SES", historyRow.getSes());
            rowParams.addParam("CSES", historyRow.getCses());
            rowParams.addParam("UAS", historyRow.getUas());
            rowParams.addParam("BBE", historyRow.getBbe());
            rowParams.addParam("FEC", historyRow.getFec());
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void handleNotLoginRSLData(int neid) {
        RowParams rowParams = new RowParams();
        String neName = "null";
        if (neid == 0) {
            rowParams.addParam("neName", neName);
        } else {
            neName = TERTNPFMUtility.getDisplayNeName(neid);
        }
        rowParams.addParam("neName", neName);
        rowParams.addParam("maxRxPower", "/");
        rowParams.addParam("minRxPower", "/");
        this.outputData.getBussinessParams().addRowParams(rowParams);
    }

    private void handleHisPFMOpreationData(int neid, boolean bFlag, List<Operation> operList) {
        Operation oper = null;
        Output[] outputArr = null;
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            oper = operList.get(i);
            int peid = Integer.parseInt(oper.getInput().getPartValue("peid"));
            outputArr = oper.getOutput();
            int len = outputArr.length;
            for (int j = 0; j < len; ++j) {
                if (this.long_flag) {
                    this.processHisLongPFMData(neid, peid, bFlag, outputArr[j]);
                    continue;
                }
                this.processHisShortPFMData(neid, peid, bFlag, outputArr[j]);
            }
        }
    }

    private void processHisShortPFMData(int neid, int peid, boolean bFlag, Output output) {
        TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        String errorCode = output.getFault(0).getCode();
        if (errorCode != null && Integer.parseInt(errorCode) == 0) {
            Part[] partArr = output.getPart();
            Calendar startTime = null;
            String peValue = "";
            int len = partArr.length;
            for (int i = 0; i < len; ++i) {
                if (TERTNPFMUtility.validatePart(partArr[i], "startTime")) {
                    startTime = TEDateUtils.byteStrToCalendar((String)partArr[i].getValue());
                    if (this.period_type == Integer.parseInt("1")) {
                        startTime.add(12, 15);
                    } else {
                        startTime.add(10, 24);
                    }
                    timeProccessor.changeCalendarToTime(startTime);
                    continue;
                }
                if (!TEPfmUtility.validatePart((Part)partArr[i], (String)"record")) continue;
                String strValue = partArr[i].getValue();
                peValue = TERTNPFMUtility.qx5Value2PfmValue(neid, TERTNPFMUtility.getValueFromRecord(strValue), peid);
            }
            this.setValue2Map(bFlag, peid, startTime, peValue);
        } else if (!this.getPFMErrorList().contains(Integer.valueOf(errorCode))) {
            this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, errorCode));
        }
    }

    private void processHisLongPFMData(int neid, int peid, boolean bFlag, Output output) {
        TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        Part[] partArr = output.getPart();
        int paralen = 0;
        Calendar startTime = null;
        String peValue = "";
        String errorCode = output.getFault(0).getCode();
        if (errorCode != null && Integer.parseInt(errorCode) == 0) {
            int len = partArr.length;
            for (int i = 0; i < len; ++i) {
                if (TERTNPFMUtility.validatePart(partArr[i], "startTime")) {
                    startTime = TEDateUtils.byteStrToCalendar((String)partArr[i].getValue());
                    if (this.period_type == Integer.parseInt("1")) {
                        startTime.add(12, 15);
                    } else {
                        startTime.add(10, 24);
                    }
                    timeProccessor.changeCalendarToTime(startTime);
                    continue;
                }
                if (TEPfmUtility.validatePart((Part)partArr[i], (String)"paralen")) {
                    paralen = Integer.parseInt(partArr[i].getValue());
                    continue;
                }
                if (!TEPfmUtility.validatePart((Part)partArr[i], (String)"objpara")) continue;
                String strValue = partArr[i].getValue().substring(paralen * 2 + 2);
                String strTmp = strValue.substring(4, 20);
                peValue = TERTNPFMUtility.qx5Value2PfmValue(neid, strTmp, peid);
            }
            this.setValue2Map(bFlag, peid, startTime, peValue);
        } else if (!this.getPFMErrorList().contains(Integer.valueOf(errorCode))) {
            this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, errorCode));
        }
    }

    private void setValue2Map(boolean bFlag, int peid, Calendar startTime, String peValue) {
        if (startTime.compareTo(this.pageBeginTime) < 0 || startTime.compareTo(this.pageEndTime) > 0) {
            return;
        }
        TERTNGetHistroyPFMBean tERTNGetHistroyPFMBean = this;
        String formatTime = TEDateUtils.calendarToStr((Calendar)startTime, (String)tERTNGetHistroyPFMBean.timeProccessor.getTimeConvertFormat());
        String showTime = "";
        String collectTime = "";
        if (this.period_type == Integer.parseInt("1")) {
            showTime = TEDateUtils.calendarToStr((Calendar)startTime, (String)"HH:mm");
            collectTime = formatTime;
        } else {
            showTime = TEDateUtils.calendarToStr((Calendar)startTime, (String)"MM-dd");
            collectTime = TEDateUtils.calendarToStr((Calendar)startTime, (String)"yyyy-MM-dd");
        }
        TERTNHistoryRowStruc rowStruc = this.map.get(collectTime);
        if (rowStruc == null) {
            rowStruc = new TERTNHistoryRowStruc();
            if (this.period_type == Integer.parseInt("1")) {
                rowStruc.setbFlag(startTime.get(12) == 0);
            } else {
                rowStruc.setbFlag(true);
            }
            rowStruc.setShowTime(showTime);
            rowStruc.setStartTime(collectTime);
            this.map.put(collectTime, rowStruc);
        }
        TERTNHistoryRow row = null;
        row = bFlag ? rowStruc.getSrcRow() : rowStruc.getSnkRow();
        switch (peid) {
            case 8606: {
                row.setMaxRxPower(peValue);
                break;
            }
            case 8607: {
                row.setMinRxPower(peValue);
                break;
            }
            case 8608: {
                row.setRxPower(peValue);
                break;
            }
            case 15043: {
                row.setAvgRxPower(peValue);
                break;
            }
            case 8609: {
                row.setMaxTxPower(peValue);
                break;
            }
            case 8610: {
                row.setMinTxPower(peValue);
                break;
            }
            case 1: 
            case 14941: {
                row.setBbe(peValue);
                break;
            }
            case 2: 
            case 14942: {
                row.setEs(peValue);
                break;
            }
            case 3: 
            case 14943: {
                row.setSes(peValue);
                break;
            }
            case 6: 
            case 14944: {
                row.setUas(peValue);
                break;
            }
            case 7: 
            case 14945: {
                row.setCses(peValue);
                break;
            }
            case 252: {
                row.setFec(peValue);
                break;
            }
        }
    }

    private void constructHistroyOperation(RowParams rowParam, List operList) {
        Operation oper;
        int neid = Integer.parseInt(rowParam.getParam("neid").getValue());
        String period = rowParam.getParam("period").getValue();
        String oduSoltID = rowParam.getParam("oduSoltID").getValue();
        String ifsoltID = rowParam.getParam("ifsoltID").getValue();
        String beginTime = this.timeProccessor.calendarToUTC(TEDateUtils.strToCalendar((String)rowParam.getParam("beginTime").getValue()));
        String endTime = this.timeProccessor.calendarToUTC(TEDateUtils.strToCalendar((String)rowParam.getParam("endTime").getValue()));
        int[] pfmId = TERTNPFMUtility.getPFMFromNe(neid, Integer.parseInt(ifsoltID));
        if (!TEStringUtils.isNumber((String)oduSoltID)) {
            oduSoltID = String.valueOf(TERTNPFMUtility.getODUSoltID(neid, ifsoltID));
        }
        if ((oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PER_GET_HISDATA_NEW")) == null) {
            this.long_flag = false;
            TERTNPFMInput shortPFMInput = new TERTNPFMInput(neid, oduSoltID, TERTNPFMUtility.histroy_power_pfmId, period, null, beginTime, endTime);
            TERTNPFMUtility.constructShortPFMOperation(shortPFMInput, operList);
            shortPFMInput = new TERTNPFMInput(neid, ifsoltID, pfmId, period, null, beginTime, endTime);
            TERTNPFMUtility.constructShortPFMOperation(shortPFMInput, operList);
        } else {
            this.long_flag = true;
            TERTNPFMInput longPFMInput = new TERTNPFMInput(neid, oduSoltID, TERTNPFMUtility.histroy_power_pfmId, period, "111", beginTime, endTime);
            TERTNPFMUtility.constructLongPFMOperation(longPFMInput, operList);
            longPFMInput = new TERTNPFMInput(neid, ifsoltID, pfmId, period, "110", beginTime, endTime);
            TERTNPFMUtility.constructLongPFMOperation(longPFMInput, operList);
        }
    }

    private void filterErrorCode(Set<TERTNRowError> errorsSet) {
        if (errorsSet.isEmpty()) {
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090650117));
        RowErrors[] errorsArray = new RowErrors[errorsSet.size()];
        TERTNRowError rtnRowError2 = null;
        int i = 0;
        for (TERTNRowError rtnRowError2 : errorsSet) {
            errorsArray[i] = rtnRowError2.getRowErrors();
            ++i;
        }
        this.outputData.getBussinessParams().getRowParams(0).setRowErrors(errorsArray);
    }

    private List getPFMErrorList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38410);
        errorList.add(38416);
        errorList.add(38429);
        return errorList;
    }

    private Calendar getTimeIsSingle(String time, TimeZoneDateBean timeProccessor) {
        if (this.isSingle) {
            return TEDateUtils.strToCalendar((String)time, (String)timeProccessor.getTimeConvertFormat());
        }
        return TEDateUtils.strToCalendar((String)time);
    }
}

