/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.performance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeAutoLogin;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPFMInput;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPFMUtility;
import com.huawei.nglct.nemgr.rtn.performance.TERTNRowError;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TERTNGetCurrentPFMBean
extends TENEExplorerBean {
    private static final String SUFFIX_15 = "15";
    private static final String SUFFIX_24 = "24";
    private static final int NSERR_PFM_NULL_OBJECT = 38416;
    private static final int TEERR_PER_NULL_OBJECT = 38429;
    private static final String NSCMD_CFG_GET_DATE = "NSCMD_CFG_GET_DATE";
    private static final String NSCMD_CFG_GET_TIME = "NSCMD_CFG_GET_TIME";
    private Set<TERTNRowError> errorsSet = new HashSet<TERTNRowError>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            TENE currentNE = TENEListMgr.getInstance().getNE(neid);
            RowParams rowparams = new RowParams();
            ArrayList operList = null;
            String soltID = "";
            String ODUSoltID = "";
            if (null == currentNE) {
                this.setDataNull(rowparams, "");
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(1090596385)));
                this.filterErrorCode(this.errorsSet);
                this.outputData.getBussinessParams().addRowParams(rowparams);
                return this.outputData;
            }
            String neName = TERTNPFMUtility.getDisplayNeName(neid);
            soltID = inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
            ODUSoltID = String.valueOf(TERTNPFMUtility.getODUSoltID(neid, soltID));
            String disNeName = TERTNPFMUtility.getDetailStr(neid, Integer.parseInt(soltID), subFunc);
            rowparams.addParam("neName", neName);
            rowparams.addParam("disNeName", disNeName);
            rowparams.addParam("ODUSoltId", String.valueOf(ODUSoltID));
            this.outputData.getBussinessParams().addRowParams(rowparams);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() && 1 != currentNE.getLogStatus()) {
                TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
            }
            if (!TERtnNeAutoLogin.isNeLogin(currentNE)) {
                this.setNotLoginFarPFM(rowparams, "/");
                this.outputData.getBussinessParams().addRowParams(rowparams);
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(37926)));
                this.filterErrorCode(this.errorsSet);
                return this.outputData;
            }
            operList = (ArrayList)this.constructOperation(neid, ODUSoltID, soltID);
            int result = super.sendMessage(neid, operList);
            if (result == 0) {
                this.handleOpreationData(neid, operList, rowparams);
            } else {
                this.setDataNull(rowparams, "/");
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, String.valueOf(result)));
                this.filterErrorCode(this.errorsSet);
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TERTNGetCurrentPFMBean performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.filterErrorCode(this.errorsSet);
        return this.outputData;
    }

    private void setDataNull(RowParams rowParams, String value) {
        rowParams.addParam("neName", value);
        rowParams.addParam("disNeName", value);
        rowParams.addParam("ODUSoltId", value);
        this.setNotLoginFarPFM(rowParams, value);
    }

    private void filterErrorCode(Set<TERTNRowError> errorsSet) {
        if (errorsSet.isEmpty()) {
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        RowErrors[] errorsArray = new RowErrors[errorsSet.size()];
        TERTNRowError rtnRowError2 = null;
        int i = 0;
        for (TERTNRowError rtnRowError2 : errorsSet) {
            errorsArray[i] = rtnRowError2.getRowErrors();
            ++i;
        }
        this.outputData.getBussinessParams().getRowParams(0).setRowErrors(errorsArray);
    }

    private List<Operation> constructOperation(int neid, String oudSoltID, String soltID) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation neDateOperation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_DATE);
        operationList.add(neDateOperation);
        Operation neTimeOperation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_TIME);
        operationList.add(neTimeOperation);
        Operation sendPowerOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ODU_TXPOWER");
        TERTNPFMUtility.setSlotId(sendPowerOperation, oudSoltID);
        operationList.add(sendPowerOperation);
        Operation recPowerOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ODU_SRSL");
        TERTNPFMUtility.setSlotId(recPowerOperation, oudSoltID);
        operationList.add(recPowerOperation);
        Operation realPowerOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ODU_RPOWER");
        TERTNPFMUtility.setSlotId(realPowerOperation, oudSoltID);
        operationList.add(realPowerOperation);
        Operation curDataOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PER_GET_CURDATA_NEW");
        int[] pfmId = TERTNPFMUtility.getPFMFromNe(neid, Integer.parseInt(soltID));
        if (curDataOperation == null) {
            TERTNPFMInput shortPFMInput = new TERTNPFMInput(neid, soltID, pfmId, "1", null, null, null);
            TERTNPFMUtility.constructShortPFMOperation(shortPFMInput, operationList);
            shortPFMInput = new TERTNPFMInput(neid, soltID, pfmId, "2", "110", null, null);
            TERTNPFMUtility.constructShortPFMOperation(shortPFMInput, operationList);
        } else {
            TERTNPFMInput longPFMInput = new TERTNPFMInput(neid, soltID, pfmId, "1", "110", null, null);
            TERTNPFMUtility.constructLongPFMOperation(longPFMInput, operationList);
            longPFMInput = new TERTNPFMInput(neid, soltID, pfmId, "2", "110", null, null);
            TERTNPFMUtility.constructLongPFMOperation(longPFMInput, operationList);
        }
        return operationList;
    }

    private void setNotLoginFarPFM(RowParams rowParams, String value) {
        String[] array = new String[]{"sdPwr", "rePwr", "realsdPwr", "realrePwr", "ES15", "SES15", "CSES15", "UAS15", "BBE15", "FEC15", "ES24", "SES24", "CSES24", "UAS24", "BBE24", "FEC24", "startTime15", "startTime24"};
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            rowParams.addParam(array[i], value);
        }
    }

    private void handleOpreationData(int neid, List<Operation> operationList, RowParams rowparams) {
        Operation oper2 = null;
        Output output = null;
        long neTime = this.getNeTime(neid, operationList);
        for (Operation oper2 : operationList) {
            output = oper2.getOutput()[0];
            if (oper2.getName().equals("NSCMD_CFG_GET_ODU_TXPOWER")) {
                this.setPartValue(neid, "W32BRD_ATTR_TRANSMITPOWER", output, rowparams, "sdPwr");
                continue;
            }
            if (oper2.getName().equals("NSCMD_CFG_GET_ODU_SRSL")) {
                this.setPartValue(neid, "W32BRD_ATTR_RECEIVEPOWER", output, rowparams, "rePwr");
                continue;
            }
            if (oper2.getName().equals("NSCMD_CFG_GET_ODU_RPOWER")) {
                this.setPartValue(neid, "W32BRD_ATTR_ACTTRANSMITPOWER", output, rowparams, "realsdPwr");
                this.setPartValue(neid, "W32BRD_ATTR_ACTRECEIVEPOWER", output, rowparams, "realrePwr");
                continue;
            }
            if (!oper2.getName().equals("NSCMD_PER_GET_CURDATA_NEW") && !oper2.getName().equals("NSCMD_PER_GET_CURDATA")) continue;
            this.processCurErrPfmEvent(neid, neTime, oper2, rowparams);
        }
        if (rowparams.getParam("startTime15") == null) {
            rowparams.addParam("startTime15", "/");
            rowparams.addParam("15HourStartTime", "/");
        }
        if (rowparams.getParam("startTime24") == null) {
            rowparams.addParam("startTime24", "/");
            rowparams.addParam("24HourStartTime", "/");
        }
    }

    private long getNeTime(int neid, List<Operation> operationList) {
        Operation oper2 = null;
        Output output = null;
        long neTime = 0L;
        String neYear = "";
        String neMonth = "";
        String neDay = "";
        String neHour = "";
        String neMinute = "";
        String neSecond = "";
        for (Operation oper2 : operationList) {
            output = oper2.getOutput()[0];
            if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
            if (oper2.getName().equals(NSCMD_CFG_GET_DATE)) {
                neYear = output.getPartValue("neyear");
                neMonth = output.getPartValue("nemonth");
                neDay = output.getPartValue("neday");
                continue;
            }
            if (!oper2.getName().equals(NSCMD_CFG_GET_TIME)) continue;
            neHour = output.getPartValue("nehour");
            neMinute = output.getPartValue("neminute");
            neSecond = output.getPartValue("nesecond");
            break;
        }
        if (!(neYear.equals("") || neMonth.equals("") || neDay.equals("") || neHour.equals("") || neMinute.equals("") || neSecond.equals(""))) {
            neTime = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getNEUTCTime(Integer.parseInt(neYear), Integer.parseInt(neMonth), Integer.parseInt(neDay), Integer.parseInt(neHour), Integer.parseInt(neMinute), Integer.parseInt(neSecond)).getTimeInMillis();
        }
        if (neTime == 0L) {
            Calendar locCal = Calendar.getInstance();
            Date utcDate = new Date(locCal.getTimeInMillis() - (long)(locCal.get(15) + locCal.get(16)));
            neTime = utcDate.getTime();
        }
        return neTime;
    }

    private void setPartValue(int neid, String attrib, Output output, RowParams rowparams, String paramName) {
        String errorCode = output.getFault(0).getCode();
        if (errorCode != null && Integer.parseInt(errorCode) == 0) {
            String value = output.getPartValue(attrib);
            rowparams.addParam(paramName, TERTNPFMUtility.convertQX5Power(value));
        } else {
            rowparams.addParam(paramName, "/");
        }
    }

    private void processCurErrPfmEvent(int neid, long neTime, Operation oper, RowParams rowparams) {
        Input input = oper.getInput();
        int peid = Integer.parseInt(input.getPartValue("peid"));
        switch (peid) {
            case 1: 
            case 14941: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "BBE");
                break;
            }
            case 2: 
            case 14942: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "ES");
                break;
            }
            case 3: 
            case 14943: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "SES");
                break;
            }
            case 6: 
            case 14944: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "UAS");
                break;
            }
            case 7: 
            case 14945: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "CSES");
                break;
            }
            case 252: {
                this.setPfmEventValue(neid, neTime, oper, rowparams, "FEC");
                break;
            }
        }
    }

    private void setPfmEventValue(int neid, long neTime, Operation oper, RowParams rowparams, String eventName) {
        Input input = oper.getInput();
        String period = input.getPartValue("period");
        int peid = Integer.parseInt(input.getPartValue("peid"));
        Output output = oper.getOutput()[0];
        String extendName = period.equals("1") ? SUFFIX_15 : SUFFIX_24;
        String outputName = eventName + extendName;
        String errorCode = output.getFault(0).getCode();
        if (errorCode != null && Integer.parseInt(errorCode) == 0) {
            String pfmValue = null;
            if (output.getPart("peValue") != null) {
                String peValue = output.getPartValue("peValue");
                pfmValue = TERTNPFMUtility.qx5Value2PfmValue(neid, peValue, peid);
            } else {
                String record = output.getPartValue("record");
                pfmValue = String.valueOf(TERTNPFMUtility.qx5Value2PfmValue(neid, TERTNPFMUtility.getValueFromRecord(record), peid));
            }
            rowparams.addParam(outputName, pfmValue);
            this.setStartTime(neTime, rowparams, output, period);
        } else {
            if (!this.getPFMErrorList().contains(Integer.valueOf(errorCode))) {
                this.errorsSet.add(TERTNPFMUtility.getErrorMessage(neid, errorCode));
            }
            rowparams.addParam(outputName, "/");
        }
    }

    private List<Integer> getPFMErrorList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(38410);
        errorList.add(38416);
        errorList.add(38429);
        return errorList;
    }

    private void setStartTime(long neTime, RowParams rowparams, Output output, String period) {
        String startTime = output.getPartValue("startTime");
        Calendar cal = TEDateUtils.byteStrToCalendar((String)startTime);
        long lapseTimeMillis = neTime - cal.getTimeInMillis();
        String lapseTime = TERTNPFMUtility.millisTOStr(lapseTimeMillis);
        if (period.equals("1") && rowparams.getParam("startTime15") == null) {
            rowparams.addParam("startTime15", lapseTime);
            rowparams.addParam("15HourStartTime", this.getStartTimeForU2000(cal));
        }
        if (period.equals("2") && rowparams.getParam("startTime24") == null) {
            rowparams.addParam("startTime24", lapseTime);
            rowparams.addParam("24HourStartTime", this.getStartTimeForU2000(cal));
        }
    }

    private String getStartTimeForU2000(Calendar cal) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(cal.getTime());
    }
}

