/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.performance;

import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.performance.TERTNCurrentPFMKey;
import com.huawei.nglct.nemgr.rtn.performance.TERTNCurrentPFMStruc;
import com.huawei.nglct.nemgr.rtn.performance.TERTNPeerCurrentPFMInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TERTNCurrentPFMInfoCache {
    private Map<TERTNCurrentPFMKey, TERTNPeerCurrentPFMInfo> map = new HashMap<TERTNCurrentPFMKey, TERTNPeerCurrentPFMInfo>();
    private static TERTNCurrentPFMInfoCache cacheInstance = new TERTNCurrentPFMInfoCache();

    private TERTNCurrentPFMInfoCache() {
    }

    public static TERTNCurrentPFMInfoCache getInstance() {
        return cacheInstance;
    }

    public synchronized void addCache(TERTNCurrentPFMKey cacheKey, RowParams rowparams, boolean isFarFlag) {
        TERTNPeerCurrentPFMInfo pfmInfo = null;
        if (this.map.get(cacheKey) == null) {
            pfmInfo = new TERTNPeerCurrentPFMInfo();
            this.map.put(cacheKey, pfmInfo);
        } else {
            pfmInfo = this.map.get(cacheKey);
        }
        if (!isFarFlag) {
            this.setCurrentPFMInfo(pfmInfo.snkStruct, rowparams);
        } else {
            this.setCurrentPFMInfo(pfmInfo.srcStruct, rowparams);
        }
    }

    public synchronized void clearCurrPFMCache(int neid) {
        TENE tene = TENEListMgr.getInstance().getNE(neid);
        String userName = tene.getCurUser();
        Set<TERTNCurrentPFMKey> set = this.map.keySet();
        for (TERTNCurrentPFMKey temp : set) {
            if (temp.getNeid() != neid || !temp.getUserName().equals(userName)) continue;
            this.map.remove(temp);
            return;
        }
    }

    public synchronized TERTNPeerCurrentPFMInfo getCurrentPFMInfo(int neid, String nmUser, int soltid) {
        TERTNCurrentPFMKey key = new TERTNCurrentPFMKey(neid, nmUser, soltid);
        Set<TERTNCurrentPFMKey> set = this.map.keySet();
        for (TERTNCurrentPFMKey temp : set) {
            if (!temp.equals(key)) continue;
            return this.map.get(temp);
        }
        return null;
    }

    private void setCurrentPFMInfo(TERTNCurrentPFMStruc pfmStruc, RowParams rowParams) {
        pfmStruc.neName = rowParams.getParam("neName").getValue();
        pfmStruc.sdPwr = rowParams.getParam("sdPwr").getValue();
        pfmStruc.rePwr = rowParams.getParam("rePwr").getValue();
        pfmStruc.realsdPwr = rowParams.getParam("realsdPwr").getValue();
        pfmStruc.realrePwr = rowParams.getParam("realrePwr").getValue();
        pfmStruc.es15 = rowParams.getParam("ES15").getValue();
        pfmStruc.ses15 = rowParams.getParam("SES15").getValue();
        pfmStruc.cses15 = rowParams.getParam("CSES15").getValue();
        pfmStruc.uas15 = rowParams.getParam("UAS15").getValue();
        pfmStruc.bbe15 = rowParams.getParam("BBE15").getValue();
        pfmStruc.fec15 = rowParams.getParam("FEC15").getValue();
        pfmStruc.startTime15 = rowParams.getParam("startTime15").getValue();
        pfmStruc.es24 = rowParams.getParam("ES24").getValue();
        pfmStruc.ses24 = rowParams.getParam("SES24").getValue();
        pfmStruc.cses24 = rowParams.getParam("CSES24").getValue();
        pfmStruc.uas24 = rowParams.getParam("UAS24").getValue();
        pfmStruc.bbe24 = rowParams.getParam("BBE24").getValue();
        pfmStruc.fec24 = rowParams.getParam("FEC24").getValue();
        pfmStruc.startTime24 = rowParams.getParam("startTime24").getValue();
    }
}

