/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.oppositeneauosearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnNeSlotPortStruct;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnPeerNeDetailInfor;
import com.huawei.nglct.nemgr.rtn.oppositeneauosearch.TERtnPeerNeInforCache;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import java.util.Vector;

public class TERtnBatchQueryOppositeNeTask
extends TimerTask {
    private int neid = -1;
    private int phyneid = -1;
    private TENE currentNE;
    private Operation startFiberSearchOper;
    private Operation queryFiberResultOper;
    private static final int TIMEOUT = 10;
    private static final int WAIT_TIME = 5;
    private static List<Integer> phyNeList = new ArrayList<Integer>();

    public TERtnBatchQueryOppositeNeTask(int neid) {
        this.neid = neid;
        this.currentNE = TENEListMgr.getInstance().getNE(neid);
        this.phyneid = this.currentNE.getRealNEID();
        if (!TERtnBatchQueryOppositeNeTask.isTimeTaskOfThisNeStarted(neid)) {
            phyNeList.add(this.phyneid);
        }
        this.startFiberSearchOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_FIBERSEARCH");
        this.queryFiberResultOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_FIBERSEARCH");
    }

    @Override
    public void run() {
        try {
            if (this.isNeedStopThisTimeTask()) {
                this.stopTimeTaskofThisNe();
                TELogFactory.getNormalLogger().info("Stop This Ne[" + this.currentNE.getNEName() + "] Hop AutoSearch Time Task.");
                return;
            }
            this.doBusiness();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("periodic Query Opposite Ne Fail", (Throwable)e);
        }
    }

    public void doBusiness() {
        Vector bdList = this.currentNE.getBoardList();
        ArrayList<Integer> IFBoardList = new ArrayList<Integer>();
        for (TEBoard board : bdList) {
            int slotid = board.getSlotID();
            int boardtype = board.getBoardType();
            if (!TEConfigurationDataMgr.getInstance().isIFboard(boardtype)) continue;
            IFBoardList.add(slotid);
        }
        boolean successFlag = this.sendStartFiberSearchCommond(IFBoardList);
        List<TERtnPeerNeDetailInfor> hopRelationList = null;
        if (successFlag) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().warn("RTN_QueryAllOppositeNe: [" + this.currentNE.getNEName() + "]: Sleep Exception");
            }
        } else {
            TELogFactory.getNormalLogger().warn("Send startFiberSearchCommond Fail.");
            return;
        }
        hopRelationList = this.sendQueryFiberCommond(IFBoardList);
        TERtnPeerNeInforCache.getInstance().removeAppointedNe(this.phyneid);
        for (TERtnPeerNeDetailInfor hopRelation : hopRelationList) {
            TERtnPeerNeDetailInfor tmpPeerNeInforDetailCache = new TERtnPeerNeDetailInfor(hopRelation.getSnkStruct(), hopRelation.getSrcStruct());
            TERtnPeerNeInforCache.getInstance().add(tmpPeerNeInforDetailCache);
        }
    }

    private boolean sendStartFiberSearchCommond(List<Integer> IFBoardList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        for (Integer integer : IFBoardList) {
            Operation operation = (Operation)this.startFiberSearchOper.clone();
            operation.getInput().getPart("slotid").setValue(integer.toString());
            operationList.add(operation);
        }
        if (operationList.isEmpty()) {
            return false;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
        if (0 == result.retCode) {
            for (Operation operation : operationList) {
                int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
                if (0 != errorCode) continue;
                return true;
            }
        }
        return false;
    }

    private List<TERtnPeerNeDetailInfor> sendQueryFiberCommond(List<Integer> IFBoardList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        for (Integer integer : IFBoardList) {
            Operation operation = (Operation)this.queryFiberResultOper.clone();
            operation.getInput().getPart("neid").setValue(String.valueOf(this.currentNE.getRealNEID()));
            operation.getInput().getPart("slotid").setValue(integer.toString());
            operationList.add(operation);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 10);
        ArrayList<TERtnPeerNeDetailInfor> returnList = new ArrayList<TERtnPeerNeDetailInfor>();
        if (0 == result.retCode) {
            for (Operation operation : operationList) {
                TERtnNeSlotPortStruct srcStruct;
                TERtnNeSlotPortStruct snkStruct;
                int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
                if (0 != errorCode || (snkStruct = this.setIFInformation(operation, "snk")).equals(srcStruct = this.setIFInformation(operation, "src"))) continue;
                TERtnPeerNeDetailInfor tmpPeerNeInfor = new TERtnPeerNeDetailInfor(snkStruct, srcStruct);
                returnList.add(tmpPeerNeInfor);
            }
        }
        return returnList;
    }

    private TERtnNeSlotPortStruct setIFInformation(Operation operation, String flag) {
        if (!"src".equals(flag) & !"snk".equals(flag)) {
            return null;
        }
        int tmpNeId = Integer.parseInt(operation.getOutput(0).getPartValue(flag + "neid"));
        int tmpSlotId = Integer.parseInt(operation.getOutput(0).getPartValue(flag + "slotid"));
        int tmpPortId = Integer.parseInt(operation.getOutput(0).getPartValue(flag + "portid"));
        TERtnNeSlotPortStruct srcStruct = new TERtnNeSlotPortStruct(tmpNeId, tmpSlotId, tmpPortId);
        return srcStruct;
    }

    public static boolean isTimeTaskOfThisNeStarted(int neid) {
        boolean isContains = false;
        TENE tmptNE = TENEListMgr.getInstance().getNE(neid);
        int tmpPhyNeID = tmptNE.getRealNEID();
        for (int phyneid_InList : phyNeList) {
            if (phyneid_InList != tmpPhyNeID) continue;
            isContains = true;
            break;
        }
        return isContains;
    }

    private boolean isNeedStopThisTimeTask() {
        boolean isNeedRemove = true;
        TIntArrayList neList = TENEListMgr.getInstance().getNEIDList();
        for (int i = 0; i < neList.size(); ++i) {
            TENE tmpNE = TENEListMgr.getInstance().getNE(neList.get(i));
            int realNeId = tmpNE.getRealNEID();
            if (this.phyneid != realNeId || tmpNE.getLogStatus() != 1) continue;
            isNeedRemove = false;
        }
        return isNeedRemove;
    }

    private void stopTimeTaskofThisNe() {
        Iterator<Integer> iterator = phyNeList.iterator();
        while (iterator.hasNext()) {
            Integer tmpphyneid = iterator.next();
            if (tmpphyneid != this.phyneid) continue;
            iterator.remove();
        }
        this.cancel();
    }
}

