/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.oduloopbacktest;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.oduloopbacktest.TEIFPrbsTestBean;
import com.huawei.nglct.nemgr.rtn.oduloopbacktest.TEIFPrbsTestResult;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEStartIFODULoopbackTest
extends TECommonWriteLogBean {
    Map<Integer, TEIFPrbsTestResult> oduLoopbackResult = new HashMap<Integer, TEIFPrbsTestResult>();
    List<Integer> allSupportLoopBackOduList;
    static int JING_XIN_ODU = 3;
    private static final int IN_LOOP = 1;
    private static final int NO_LOOP = 0;
    private static final int ERR_BOARD_NOT_SUPPORT = 1090614034;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData.setBussinessParams(new BussinessParams());
            ArrayList<Integer> ifSlotList = new ArrayList<Integer>();
            ArrayList operlist = new ArrayList();
            if (this.isSetODULoopback(neid, inputData, operlist)) {
                Collection<TEIFPrbsTestResult> oduResultSet = this.oduLoopbackResult.values();
                for (TEIFPrbsTestResult loopbackResult : oduResultSet) {
                    if (!loopbackResult.isSucess()) continue;
                    ifSlotList.add(loopbackResult.getIFSlotid());
                }
            }
            Param naNameParam = this.getNeNameParam();
            RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
            int period = Integer.parseInt(rowParamsArr[0].getParam("testperiod").getValue());
            TEIFPrbsTestBean prbsTestBean = new TEIFPrbsTestBean(neid, ifSlotList, period);
            int doPrbsTestResult = prbsTestBean.doPrbsTest();
            this.releaseAllODULoop();
            boolean hasSucess = false;
            boolean hasFailed = false;
            if (doPrbsTestResult == 0) {
                this.handleEveryError(neid, naNameParam, prbsTestBean, hasSucess, hasFailed);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)doPrbsTestResult));
            }
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void handleEveryError(int neid, Param naNameParam, TEIFPrbsTestBean prbsTestBean, boolean hasSucess, boolean hasFailed) {
        this.refreshTestResult(prbsTestBean);
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        keyList.addAll(this.oduLoopbackResult.keySet());
        Collections.sort(keyList, Collections.reverseOrder());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            int oduSlotid = (Integer)it.next();
            TEIFPrbsTestResult prbsTestResult = this.oduLoopbackResult.get(oduSlotid);
            RowParams rowParams = new RowParams();
            if (prbsTestResult.isSucess()) {
                rowParams.addParam("neid", String.valueOf(neid));
                rowParams.addParam(naNameParam);
                rowParams.addParam("ifSlotid", String.valueOf(prbsTestResult.getIFSlotid()));
                rowParams.addParam("errBitRate", String.valueOf(prbsTestResult.getErrBitRate()));
                rowParams.addParam("errBitNum", String.valueOf(prbsTestResult.getErrBitNum()));
                hasSucess = true;
            } else {
                RowErrors rowError = TEDataConverter.handleErrorData((int)prbsTestResult.getRetCode());
                rowError.addParam(new Param("neid", String.valueOf(neid)));
                rowError.addParam(new Param("ifSlotid", String.valueOf(prbsTestResult.getIFSlotid())));
                rowError.addParam(new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardName(neid, prbsTestResult.getIFSlotid())));
                TENE neObj = TENEListMgr.getInstance().getNE(neid);
                rowError.addParam(new Param("nename", neObj.getNEName()));
                rowParams.addRowErrors(rowError);
                hasFailed = true;
            }
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
        if (hasSucess && !hasFailed) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (!hasSucess && hasFailed) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }

    private void refreshTestResult(TEIFPrbsTestBean prbsTestBean) {
        Map<Integer, TEIFPrbsTestResult> prbsResult = prbsTestBean.getTestResult();
        for (TEIFPrbsTestResult prbsTestResult : prbsResult.values()) {
            int oduslotid = this.getODUSlotidByIfSlotid(prbsTestResult.getIFSlotid());
            this.oduLoopbackResult.remove(oduslotid);
            this.oduLoopbackResult.put(oduslotid, prbsTestResult);
        }
    }

    private int getODUSlotidByIfSlotid(int ifslotid) {
        for (TEIFPrbsTestResult prbsTestResult : this.oduLoopbackResult.values()) {
            if (prbsTestResult.getIFSlotid() != ifslotid) continue;
            return prbsTestResult.getOduSlotid();
        }
        return -1;
    }

    private Param getNeNameParam() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String nename = neObj.getNEName();
        return new Param("nename", nename);
    }

    private List<Integer> getAllSupportLoopBackTestOdu(int neid, Datainterface inputData) {
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        ArrayList<Integer> supportODUList = new ArrayList<Integer>();
        ArrayList<Operation> oduInfoOperList = new ArrayList<Operation>();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            Param oduSlotidParam = rowParamsArr[i].getParam("oduSlotid");
            Param ifSlotidParam = rowParamsArr[i].getParam("ifSlotid");
            if (oduSlotidParam == null || ifSlotidParam == null) continue;
            try {
                int oduSlotid = Integer.parseInt(oduSlotidParam.getValue());
                Operation oduOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_PTN_CFG_GET_ODU_INFO");
                oduOperation.getInput().setPartValue("slotid", String.valueOf(oduSlotid));
                oduInfoOperList.add(oduOperation);
                int ifSlotid = Integer.parseInt(ifSlotidParam.getValue());
                TEIFPrbsTestResult oduresult = new TEIFPrbsTestResult();
                oduresult.setOduSlotid(oduSlotid);
                oduresult.setIFSlotid(ifSlotid);
                this.oduLoopbackResult.put(oduSlotid, oduresult);
                continue;
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().error("parseInt fail!", (Throwable)ex);
            }
        }
        if (!oduInfoOperList.isEmpty()) {
            int sendResult = super.sendMessage(neid, oduInfoOperList);
            if (sendResult == 0) {
                for (int i = 0; i < oduInfoOperList.size(); ++i) {
                    Operation oduinfoOper = (Operation)oduInfoOperList.get(i);
                    if (!super.isOutputSuccess(oduinfoOper.getOutput(0))) continue;
                    int oduSlotid = Integer.parseInt(oduinfoOper.getInput().getPart("slotid").getValue());
                    int factoryCode = Integer.parseInt(TENEExplorerBean.getOutputPart((Operation)oduinfoOper, (String)"W32BRD_ATTR_FACTORYCODE").getValue());
                    if (this.isSupportLookBackFactory(factoryCode)) {
                        supportODUList.add(oduSlotid);
                        continue;
                    }
                    this.oduLoopbackResult.get(oduSlotid).setRetCode(1090614034);
                    TELogFactory.getNormalLogger().info("Unsupport test ODU is " + factoryCode);
                }
            } else {
                TELogFactory.getNormalLogger().info("Send get ODU info command failed[" + sendResult + "]!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)sendResult));
                this.setAllResult(sendResult);
            }
        }
        return supportODUList;
    }

    private void setAllResult(int errCode) {
        for (TEIFPrbsTestResult prbsResult : this.oduLoopbackResult.values()) {
            prbsResult.setRetCode(errCode);
        }
    }

    private boolean isSupportLookBackFactory(int factoryCode) {
        return factoryCode != JING_XIN_ODU;
    }

    private void releaseAllODULoop() {
        ArrayList<Operation> operlist = new ArrayList<Operation>();
        if (this.allSupportLoopBackOduList != null) {
            int len = this.allSupportLoopBackOduList.size();
            for (int i = 0; i < len; ++i) {
                int oduslot = this.allSupportLoopBackOduList.get(i);
                Operation oduOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_RFLOOP");
                oduOperation.getInput().setPartValue("slotid", String.valueOf(oduslot));
                oduOperation.getInput().setPartValue("W32BRD_ATTR_RFLOOPBACK", String.valueOf(0));
                operlist.add(oduOperation);
            }
            if (!operlist.isEmpty()) {
                this.sendMessage(this.neid, operlist);
            }
        }
    }

    private boolean isSetODULoopback(int neid, Datainterface inputData, ArrayList operlist) {
        this.allSupportLoopBackOduList = this.getAllSupportLoopBackTestOdu(neid, inputData);
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            Param oduSlotidParam = rowParamsArr[i].getParam("oduSlotid");
            Param ifSlotidParam = rowParamsArr[i].getParam("ifSlotid");
            if (oduSlotidParam == null || ifSlotidParam == null) continue;
            try {
                int oduSlotid = Integer.parseInt(oduSlotidParam.getValue());
                if (!this.allSupportLoopBackOduList.contains(oduSlotid)) continue;
                Operation oduOperation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SET_RFLOOP");
                oduOperation.getInput().setPartValue("slotid", String.valueOf(oduSlotid));
                oduOperation.getInput().setPartValue("W32BRD_ATTR_RFLOOPBACK", String.valueOf(1));
                operlist.add(oduOperation);
                continue;
            }
            catch (NumberFormatException ex) {
                TELogFactory.getNormalLogger().error("parseInt fail!", (Throwable)ex);
            }
        }
        if (!operlist.isEmpty()) {
            int result = this.sendMessage(neid, operlist);
            if (result == 0) {
                for (int i = 0; i < operlist.size(); ++i) {
                    Operation loopbackOper = (Operation)operlist.get(i);
                    if (!super.isOutputSuccess(loopbackOper.getOutput(0))) {
                        int oduSlotid = Integer.parseInt(loopbackOper.getInput().getPart("slotid").getValue());
                        this.oduLoopbackResult.get(oduSlotid).setRetCode(Integer.parseInt(loopbackOper.getOutput(0).getFault(0).getCode()));
                        continue;
                    }
                    TELogFactory.getNormalLogger().info("Set ODU loopback sucess");
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                this.setAllResult(result);
                return false;
            }
        }
        return true;
    }
}

