/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.oduloopbacktest;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nemgr.rtn.oduloopbacktest.TEIFPrbsTestResult;
import com.huawei.nglct.nemgr.sdh.bittest_u2kv1r7c00.TEBitDataMgr;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TEIFPrbsTestBean {
    private static final int IF_PORT_ID = 1;
    static final int START_TEST = 1;
    static final int STOP_TEST = 0;
    static final int SHOT_TIME = 1;
    static final int LONG_TIME = 2;
    static final int LONGER_TEST = 3;
    private static final int QX_OPERATION_TIMEOUT = 30;
    private List<Integer> ifSlotList = new ArrayList<Integer>();
    private int neid;
    private Map<Integer, TEIFPrbsTestResult> testResult = new Hashtable<Integer, TEIFPrbsTestResult>();
    private int testTime;

    public Map<Integer, TEIFPrbsTestResult> getTestResult() {
        return this.testResult;
    }

    public TEIFPrbsTestBean(int neID, List<Integer> slotList, int time) {
        this.ifSlotList = slotList;
        this.neid = neID;
        this.testTime = time;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public List<Integer> getIfSlotList() {
        return this.ifSlotList;
    }

    public void setIfSlotList(List<Integer> ifSlotList) {
        this.ifSlotList = ifSlotList;
    }

    public ArrayList getPrbsOperation(int actionType) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        for (int i = 0; i < this.ifSlotList.size(); ++i) {
            Operation prbsOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_SET_IF_BITTEST_EX_WBID");
            prbsOperation.getInput().setPartValue("slotid", String.valueOf(this.ifSlotList.get(i)));
            prbsOperation.getInput().setPartValue("portid", String.valueOf(1));
            prbsOperation.getInput().setPartValue("testaction", String.valueOf(actionType));
            prbsOperation.getInput().setPartValue("reportcycle", String.valueOf(1));
            prbsOperation.getInput().setPartValue("testtime", String.valueOf(this.testTime));
            operationList.add(prbsOperation);
        }
        return operationList;
    }

    public int doPrbsTest() {
        ArrayList operationList = this.getPrbsOperation(1);
        if (!operationList.isEmpty()) {
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, operationList, 30, null);
            if (result.retCode == 0) {
                return this.handleStartMessage(operationList);
            }
            return result.retCode;
        }
        return 0;
    }

    public int handleStartMessage(ArrayList operationList) {
        ArrayList<Integer> successStartSlotList = new ArrayList<Integer>();
        for (int i = 0; i < operationList.size(); ++i) {
            Operation operation = (Operation)operationList.get(i);
            int ifslotid = Integer.parseInt(operation.getInput().getPart("slotid").getValue());
            Output output = operation.getOutput(0);
            int faultCode = Integer.parseInt(output.getFault(0).getCode());
            if (faultCode == 0) {
                successStartSlotList.add(ifslotid);
                continue;
            }
            TEIFPrbsTestResult result = new TEIFPrbsTestResult(ifslotid, faultCode);
            TELogFactory.getNormalLogger().info(result.toString());
            this.testResult.put(ifslotid, result);
        }
        try {
            Thread.sleep((this.testTime + 5) * 1000);
        }
        catch (InterruptedException e) {
            TELogFactory.getNormalLogger().error("Thread sleep interrupt.", (Throwable)e);
        }
        return this.queryPrbsTestResult(successStartSlotList);
    }

    public int queryPrbsTestResult(List<Integer> successStartSlotList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        for (int i = 0; i < successStartSlotList.size(); ++i) {
            Operation prbsOperation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_IF_BITTEST_RESULT_EX_WBID");
            prbsOperation.getInput().setPartValue("slotid", String.valueOf(successStartSlotList.get(i)));
            prbsOperation.getInput().setPartValue("portid", String.valueOf(1));
            operationList.add(prbsOperation);
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, operationList, 30, null);
        if (result.retCode == 0) {
            for (int i = 0; i < operationList.size(); ++i) {
                Operation operation = (Operation)operationList.get(i);
                int ifslotid = Integer.parseInt(operation.getInput().getPart("slotid").getValue());
                Output output = operation.getOutput(operation.getOutputCount() - 1);
                int faultCode = Integer.parseInt(output.getFault(0).getCode());
                if (faultCode == 0) {
                    int tmpDatatypenum = Integer.parseInt(output.getPartValue("datatypenum"));
                    String tmpBitdata = output.getPartValue("bitdata");
                    String[] errData = TEBitDataMgr.getErrData((int)this.neid, (int)tmpDatatypenum, (String)tmpBitdata);
                    TEIFPrbsTestResult prbsTestResult = new TEIFPrbsTestResult(ifslotid, errData[0], errData[1]);
                    TELogFactory.getNormalLogger().info(prbsTestResult.toString());
                    this.testResult.put(ifslotid, prbsTestResult);
                    continue;
                }
                TEIFPrbsTestResult prbsTestResult = new TEIFPrbsTestResult(ifslotid, faultCode);
                TELogFactory.getNormalLogger().info(prbsTestResult.toString());
                this.testResult.put(ifslotid, prbsTestResult);
            }
        }
        return result.retCode;
    }
}

