/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.oduinterface;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TEQueryOduInterfaceBean
extends TEGenCfgQueryBean {
    private static final String FACTORYINFO = "W32BRD_ATTR_FACTORYINFO";
    private static final String TRANSMITPOWER = "W32BRD_ATTR_TRANSMITPOWER";
    private static final String MAXTRANSMITPOWER = "W32BRD_ATTR_MAXTRANSMITPOWER";
    private static final String TXTHRESHOLDHIGH = "W32BRD_ATTR_TXTHRESHOLDHIGH";
    private static final String TXTHRESHOLDLOW = "W32BRD_ATTR_TXTHRESHOLDLOW";
    private static final String RXTHRESHOLDHIGH = "W32BRD_ATTR_RXTHRESHOLDHIGH";
    private static final String RXTHRESHOLDLOW = "W32BRD_ATTR_RXTHRESHOLDLOW";
    private static final String RECEIVEPOWER = "W32BRD_ATTR_RECEIVEPOWER";
    private static final String ACTTRANSMITPOWER = "W32BRD_ATTR_ACTTRANSMITPOWER";
    private static final String ACTRECEIVEPOWER = "W32BRD_ATTR_ACTRECEIVEPOWER";
    private static final String TRANSMITFRE = "W32BRD_ATTR_TRANSMITFRE";
    private static final String TRINTERVAL = "W32BRD_ATTR_TRINTERVAL";
    private static final String ACTTRANSMITFRE = "W32BRD_ATTR_ACTTRANSMITFRE";
    private static final String ACTTRECEIVEFRE = "W32BRD_ATTR_ACTTRECEIVEFRE";
    private static final String ACTTRINTERVAL = "W32BRD_ATTR_ACTTRINTERVAL";
    private static final String WORKRANGE = "W32BRD_ATTR_WORKRANGE";
    private static final String LOWFRE = "LOWFRE";
    private static final String LOWPOWER = "LOWPOWER";
    private static final String ACTRANGEOFPOWER = "W32BRD_ATTR_ACTRANGEOFPOWER";
    private static final String W32BRD_ATTR_CURFILTERBANDWIDTH = "W32BRD_ATTR_CURFILTERBANDWIDTH";
    private static final String W32BRD_ATTR_CURFILTERBANDWIDTH_NUM = "W32BRD_ATTR_CURFILTERBANDWIDTH_NUM";
    private static final String W32BRD_ATTR_CURFILTERBANDWIDTH_ALL = "W32BRD_ATTR_CURFILTERBANDWIDTH_ALL";
    private static final String W32BRD_ATTR_TRINTERVAL_NUM = "W32BRD_ATTR_TRINTERVAL_NUM";
    private static final String W32BRD_ATTR_TRINTERVAL_LIST = "W32BRD_ATTR_TRINTERVAL_LIST";
    private static final String W32BRD_ATTR_INTERFREBANDWIDTH = "W32BRD_ATTR_INTERFREBANDWIDTH";
    private static final String NOTSUPPORTCOMMAND = "38751";
    private boolean needRepair = false;
    private String neVersion;
    private String ifBandwidth = "0";
    private static final DecimalFormatSymbols US_Symbols = new DecimalFormatSymbols(Locale.US);

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operationList = super.getQueryOperationList(funCmd, inputData);
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        this.neVersion = ne.getHostVersion();
        if (this.neVersion.compareTo("5.54.03.13") >= 0 || TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_RTN_CFG_ODUINTERFACE", "TE_ATTR_RTN_ODU_NEED_COMPENSATE") || null == operationList || operationList.isEmpty()) {
            return operationList;
        }
        try {
            int i;
            RowParams row = inputData.getBussinessParams().getRowParams(0);
            for (i = 0; i < row.getParamCount() && !row.getParam(i).getValue().equals(ACTRECEIVEPOWER); ++i) {
            }
            if (i >= row.getParamCount()) {
                return operationList;
            }
            String slotID = row.getParam("slotid").getValue();
            int neType = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEType();
            int slotRelation = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.valueOf(slotID) - slotRelation);
            if (boardType == 1032 || boardType == 1033 || boardType == 1548 || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_IF_IS_IF1AB") || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_IF_IS_IFH2")) {
                Operation odu_soft_ver_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_BD_VER");
                odu_soft_ver_oper.getInput().setPartValue("slotID", slotID);
                operationList.add(odu_soft_ver_oper);
                if (boardType != 1548 && !TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_IF_IS_IFH2")) {
                    Operation if_mode_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_IFMODE");
                    if_mode_oper.getInput().setPartValue("slotid", String.valueOf(Integer.valueOf(slotID) - slotRelation));
                    if_mode_oper.getInput().setPartValue("port", "0");
                    operationList.add(if_mode_oper);
                } else {
                    Operation if_bandwidth_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_IF_BANDWIDTH");
                    if_bandwidth_oper.getInput().setPartValue("slotid", String.valueOf(Integer.valueOf(slotID) - slotRelation));
                    if_bandwidth_oper.getInput().setPartValue("portid", "0");
                    operationList.add(if_bandwidth_oper);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryOduInterfaceBean.getQueryOperationList() fail!", (Throwable)e);
        }
        return operationList;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        if (null != operationList) {
            int count = 0;
            Operation oper = null;
            for (int i = operationList.size() - 1; i >= 0; --i) {
                oper = (Operation)operationList.get(i);
                String name = oper.getName();
                if (name.equalsIgnoreCase("NSCMD_CFG_GET_RADIO_IFMODE") || name.equalsIgnoreCase("NSCMD_CFG_GET_IF_BANDWIDTH")) {
                    operList.add((Operation)oper.clone());
                    operationList.remove(i);
                    if (++count == 2) break;
                }
                if (!name.equalsIgnoreCase("NSCMD_CFG_GET_BD_VER")) continue;
                this.needRepair = this.getODUVersion((Operation)oper.clone());
                operationList.remove(i);
                if (++count == 2) break;
            }
        }
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        this.repairRSSI(operList);
        int slotId = 0;
        int boardType = 0;
        TEGenCfgModel genCfgModel = null;
        Param param = null;
        RowParams rowparams = null;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String numStr;
            int fIndex;
            int flen;
            List allFilters;
            String allFilterBandWidth;
            int num;
            String trintervalNum;
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getParamCount() == 0) continue;
            slotId = Integer.valueOf(rowparams.getParam("slotid").getValue());
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotId);
            genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
            if (this.needRepair) {
                rowparams.addParam("ifBandwidth", this.ifBandwidth);
            }
            this.handleRfloopback(genCfgModel, rowparams);
            this.handleMAXTRANSMITPOWER(rowparams);
            this.handleTXTHRESHOLDHIGH(rowparams);
            this.handleTXTHRESHOLDLOW(rowparams);
            this.handleRXTHRESHOLDHIGH(rowparams);
            this.handleRXTHRESHOLDLOW(rowparams);
            this.handleTRANSMITPOWER(rowparams);
            this.handleRECEIVEPOWER(genCfgModel, rowparams);
            this.handleACTTRANSMITPOWER(rowparams);
            this.handleACTRECEIVEPOWER(rowparams);
            this.handleLOWPOWER(rowparams);
            this.handleACTRANGEOFPOWER(rowparams);
            this.handleTRANSMITFRE(rowparams);
            this.handleTRINTERVAL(rowparams);
            if (null != rowparams.getParam(W32BRD_ATTR_TRINTERVAL_NUM) && null != rowparams.getParam(W32BRD_ATTR_TRINTERVAL_LIST) && !"/".equals(trintervalNum = rowparams.getParam(W32BRD_ATTR_TRINTERVAL_NUM).getValue()) && !"-".equals(trintervalNum)) {
                num = Integer.parseInt(trintervalNum);
                param = rowparams.getParam(W32BRD_ATTR_TRINTERVAL_LIST);
                allFilterBandWidth = param.getValue();
                if (!"/".equals(allFilterBandWidth) && !"-".equals(allFilterBandWidth)) {
                    allFilters = TEStringUtils.prototypeToValues((String)allFilterBandWidth, (int)num);
                    flen = allFilters.size();
                    for (fIndex = 0; fIndex < flen; ++fIndex) {
                        param.addOption(new Option(String.valueOf((double)((Integer)allFilters.get(fIndex)).intValue() / 1000.0)));
                    }
                }
            }
            this.handleACTTRANSMITFRE(rowparams);
            this.handleACTTRECEIVEFRE(rowparams);
            this.handleACTTRINTERVAL(rowparams);
            this.handleLOWFRE(rowparams);
            this.handleWORKRANGE(rowparams);
            this.handleFACTORYINFO(rowparams);
            this.handleCURFILTERBANDWIDTH(rowparams);
            this.handleINTERFREBANDWIDTH(rowparams);
            if (null == rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH_NUM) || null == rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH_ALL) || "/".equals(numStr = rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH_NUM).getValue()) || "-".equals(numStr)) continue;
            num = Integer.parseInt(numStr);
            param = rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH_ALL);
            allFilterBandWidth = param.getValue();
            if ("/".equals(allFilterBandWidth) || "-".equals(allFilterBandWidth)) continue;
            allFilters = TEStringUtils.prototypeToValues((String)allFilterBandWidth, (int)num);
            flen = allFilters.size();
            for (fIndex = 0; fIndex < flen; ++fIndex) {
                param.addOption(new Option(String.valueOf((Integer)allFilters.get(fIndex) / 1000)));
            }
        }
    }

    private void handleCURFILTERBANDWIDTH(RowParams rowparams) {
        String curFilterBandWidth;
        if (null != rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH) && !"/".equals(curFilterBandWidth = rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH).getValue()) && !"-".equals(curFilterBandWidth)) {
            long temp = Long.parseLong(curFilterBandWidth);
            rowparams.getParam(W32BRD_ATTR_CURFILTERBANDWIDTH).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleINTERFREBANDWIDTH(RowParams rowparams) {
        if (null != rowparams.getParam(W32BRD_ATTR_INTERFREBANDWIDTH)) {
            String bandWidth = rowparams.getParam(W32BRD_ATTR_INTERFREBANDWIDTH).getValue();
            String tmpBandWidth = rowparams.getParam(W32BRD_ATTR_INTERFREBANDWIDTH).getValue();
            if (bandWidth.equals("150")) {
                tmpBandWidth = "250";
            } else if (bandWidth.equals("151")) {
                tmpBandWidth = "500";
            } else if (bandWidth.equals("152")) {
                tmpBandWidth = "750";
            }
            rowparams.getParam(W32BRD_ATTR_INTERFREBANDWIDTH).setValue(tmpBandWidth);
        }
    }

    private void handleFACTORYINFO(RowParams rowparams) {
        if (null != rowparams.getParam(FACTORYINFO)) {
            String factoryInfo = rowparams.getParam(FACTORYINFO).getValue();
            if ("-1".equalsIgnoreCase(factoryInfo = IOStreamConvertor.replaceSpecialStr((String)factoryInfo).trim())) {
                rowparams.getParam(FACTORYINFO).setValue("/");
            } else {
                rowparams.getParam(FACTORYINFO).setValue(factoryInfo);
            }
        }
    }

    private void handleWORKRANGE(RowParams rowparams) {
        String workrange;
        if (null != rowparams.getParam(WORKRANGE) && !"/".equals(workrange = rowparams.getParam(WORKRANGE).getValue()) && !"-".equals(workrange)) {
            long temp = Long.parseLong(workrange);
            DecimalFormat format = new DecimalFormat("0.000", US_Symbols);
            rowparams.getParam(WORKRANGE).setValue(String.valueOf(format.format((double)temp / 1000.0)).replaceAll(",", ""));
        }
    }

    private void handleLOWFRE(RowParams rowparams) {
        String workrange;
        if (null != rowparams.getParam(LOWFRE) && !"/".equals(workrange = rowparams.getParam(LOWFRE).getValue()) && !"-".equals(workrange)) {
            long temp = Long.parseLong(workrange);
            DecimalFormat format = new DecimalFormat("0.000", US_Symbols);
            rowparams.getParam(LOWFRE).setValue(String.valueOf(format.format((double)temp / 1000.0)).replaceAll(",", ""));
        }
    }

    private void handleACTTRINTERVAL(RowParams rowparams) {
        String acttrinterval;
        if (null != rowparams.getParam(ACTTRINTERVAL) && !"/".equals(acttrinterval = rowparams.getParam(ACTTRINTERVAL).getValue()) && !"-".equals(acttrinterval)) {
            long temp = Long.parseLong(acttrinterval);
            rowparams.getParam(ACTTRINTERVAL).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleACTTRECEIVEFRE(RowParams rowparams) {
        String acttreceivefre;
        if (null != rowparams.getParam(ACTTRECEIVEFRE) && !"/".equals(acttreceivefre = rowparams.getParam(ACTTRECEIVEFRE).getValue()) && !"-".equals(acttreceivefre)) {
            long temp = Long.parseLong(acttreceivefre);
            rowparams.getParam(ACTTRECEIVEFRE).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleACTTRANSMITFRE(RowParams rowparams) {
        String acttransmitfre;
        if (null != rowparams.getParam(ACTTRANSMITFRE) && !"/".equals(acttransmitfre = rowparams.getParam(ACTTRANSMITFRE).getValue()) && !"-".equals(acttransmitfre)) {
            long temp = Long.parseLong(acttransmitfre);
            rowparams.getParam(ACTTRANSMITFRE).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleTRINTERVAL(RowParams rowparams) {
        String trinterval;
        if (null != rowparams.getParam(TRINTERVAL) && !"/".equals(trinterval = rowparams.getParam(TRINTERVAL).getValue()) && !"-".equals(trinterval)) {
            long temp = Long.parseLong(trinterval);
            rowparams.getParam(TRINTERVAL).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleTRANSMITFRE(RowParams rowparams) {
        String transmitfre;
        if (null != rowparams.getParam(TRANSMITFRE) && !"/".equals(transmitfre = rowparams.getParam(TRANSMITFRE).getValue()) && !"-".equals(transmitfre)) {
            long temp = Long.parseLong(transmitfre);
            rowparams.getParam(TRANSMITFRE).setValue(String.valueOf((double)temp / 1000.0));
        }
    }

    private void handleACTRANGEOFPOWER(RowParams rowparams) {
        String lowpower;
        if (null != rowparams.getParam(ACTRANGEOFPOWER) && !"/".equals(lowpower = rowparams.getParam(ACTRANGEOFPOWER).getValue()) && !"-".equals(lowpower)) {
            int temp = new BigInteger(lowpower).intValue();
            short value = (short)temp;
            rowparams.getParam(ACTRANGEOFPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleLOWPOWER(RowParams rowparams) {
        String lowpower;
        if (null != rowparams.getParam(LOWPOWER) && !"/".equals(lowpower = rowparams.getParam(LOWPOWER).getValue()) && !"-".equals(lowpower)) {
            int temp = new BigInteger(lowpower).intValue();
            short value = (short)temp;
            rowparams.getParam(LOWPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleACTRECEIVEPOWER(RowParams rowparams) {
        String actreceivepower;
        if (null != rowparams.getParam(ACTRECEIVEPOWER) && !"/".equals(actreceivepower = rowparams.getParam(ACTRECEIVEPOWER).getValue()) && !"-".equals(actreceivepower)) {
            int temp = new BigInteger(actreceivepower).intValue();
            short value = (short)temp;
            rowparams.getParam(ACTRECEIVEPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleACTTRANSMITPOWER(RowParams rowparams) {
        String acttransmitpower;
        if (null != rowparams.getParam(ACTTRANSMITPOWER) && !"/".equals(acttransmitpower = rowparams.getParam(ACTTRANSMITPOWER).getValue()) && !"-".equals(acttransmitpower)) {
            int temp = new BigInteger(acttransmitpower).intValue();
            short value = (short)temp;
            rowparams.getParam(ACTTRANSMITPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleTRANSMITPOWER(RowParams rowparams) {
        String transmitpower;
        if (null != rowparams.getParam(TRANSMITPOWER) && !"/".equals(transmitpower = rowparams.getParam(TRANSMITPOWER).getValue()) && !"-".equals(transmitpower)) {
            int temp = new BigInteger(transmitpower).intValue();
            short value = (short)temp;
            rowparams.getParam(TRANSMITPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleRXTHRESHOLDLOW(RowParams rowparams) {
        String rxthresholdlow;
        if (null != rowparams.getParam(RXTHRESHOLDLOW) && !"/".equals(rxthresholdlow = rowparams.getParam(RXTHRESHOLDLOW).getValue()) && !"-".equals(rxthresholdlow)) {
            int temp = new BigInteger(rxthresholdlow).intValue();
            short value = (short)temp;
            rowparams.getParam(RXTHRESHOLDLOW).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleRECEIVEPOWER(TEGenCfgModel genCfgModel, RowParams rowparams) {
        if (null != rowparams.getParam(RECEIVEPOWER)) {
            Param param = rowparams.getParam(RECEIVEPOWER);
            String receivepower = param.getValue();
            if (!"/".equals(receivepower) && !"-".equals(receivepower)) {
                int temp = new BigInteger(receivepower).intValue();
                short value = (short)temp;
                param.setValue(Float.toString((float)value / 10.0f));
            }
            TEGenCfgAttribute attribute = genCfgModel.getAttrFromId(RECEIVEPOWER);
            String minValue = attribute.getMinvalue();
            String maxValue = attribute.getMaxvalue();
            if (null != minValue && null != maxValue) {
                param.addOption(new Option(attribute.getMinvalue()));
                param.addOption(new Option(attribute.getMaxvalue()));
            }
        }
    }

    private void handleRXTHRESHOLDHIGH(RowParams rowparams) {
        String rxthresholdhigh;
        if (null != rowparams.getParam(RXTHRESHOLDHIGH) && !"/".equals(rxthresholdhigh = rowparams.getParam(RXTHRESHOLDHIGH).getValue()) && !"-".equals(rxthresholdhigh)) {
            int temp = new BigInteger(rxthresholdhigh).intValue();
            short value = (short)temp;
            rowparams.getParam(RXTHRESHOLDHIGH).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleTXTHRESHOLDLOW(RowParams rowparams) {
        String txthresholdlow;
        if (null != rowparams.getParam(TXTHRESHOLDLOW) && !"/".equals(txthresholdlow = rowparams.getParam(TXTHRESHOLDLOW).getValue()) && !"-".equals(txthresholdlow)) {
            int temp = new BigInteger(txthresholdlow).intValue();
            short value = (short)temp;
            rowparams.getParam(TXTHRESHOLDLOW).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleTXTHRESHOLDHIGH(RowParams rowparams) {
        String txthresholdhigh;
        if (null != rowparams.getParam(TXTHRESHOLDHIGH) && !"/".equals(txthresholdhigh = rowparams.getParam(TXTHRESHOLDHIGH).getValue()) && !"-".equals(txthresholdhigh)) {
            int temp = new BigInteger(txthresholdhigh).intValue();
            short value = (short)temp;
            rowparams.getParam(TXTHRESHOLDHIGH).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleMAXTRANSMITPOWER(RowParams rowparams) {
        String transmitpower;
        if (null != rowparams.getParam(MAXTRANSMITPOWER) && !"/".equals(transmitpower = rowparams.getParam(MAXTRANSMITPOWER).getValue()) && !"-".equals(transmitpower)) {
            int temp = new BigInteger(transmitpower).intValue();
            short value = (short)temp;
            rowparams.getParam(MAXTRANSMITPOWER).setValue(Float.toString((float)value / 10.0f));
        }
    }

    private void handleRfloopback(TEGenCfgModel genCfgModel, RowParams rowparams) {
        if (null == rowparams.getParam("W32BRD_ATTR_RFLOOPBACK")) {
            Param param = new Param("W32BRD_ATTR_RFLOOPBACK", "-");
            rowparams.addParam(param);
        } else {
            Param param = rowparams.getParam("W32BRD_ATTR_RFLOOPBACK");
            TEGenCfgAttribute attribute = genCfgModel.getAttrFromId("W32BRD_ATTR_RFLOOPBACK");
            ArrayList dList = attribute.getDomainList();
            if (null != dList && !dList.isEmpty()) {
                int m = dList.size();
                for (int k = 0; k < m; ++k) {
                    param.addOption(new Option(String.valueOf((Integer)dList.get(k))));
                }
            }
        }
    }

    private void repairRSSI(List<Operation> operList) {
        if (this.needRepair) {
            Operation oper = null;
            for (int i = operList.size() - 1; i >= 0; --i) {
                oper = operList.get(i);
                this.needRepair = this.getIFBandwidth(oper);
            }
        }
    }

    private boolean getODUVersion(Operation oper) {
        Output output = oper.getOutput(0);
        if (output.getFault(0).getCode().equals("0") && !output.getPart("softVerHighBit").getValue().equals("") && !output.getPart("softVerLowBit").getValue().equals("")) {
            String tempSoftVer;
            float softVer;
            String softVerLowBit = output.getPart("softVerLowBit").getValue();
            if (softVerLowBit.length() < 2) {
                softVerLowBit = "0" + softVerLowBit;
            }
            if ((double)(softVer = Float.valueOf(tempSoftVer = output.getPart("softVerHighBit").getValue() + "." + softVerLowBit).floatValue()) < 2.0) {
                return true;
            }
        }
        return false;
    }

    private boolean getIFBandwidth(Operation oper) {
        Output output = oper.getOutput(0);
        if (output.getFault(0).getCode().equals("0")) {
            if (null != output.getPart("W32PORT_ATTR_RADIOWORKMODE")) {
                this.ifBandwidth = output.getPart("W32PORT_ATTR_RADIOWORKMODE").getValue();
            } else if (null != output.getPart("bandwidth")) {
                this.ifBandwidth = output.getPart("bandwidth").getValue();
            }
        }
        return "12".equals(this.ifBandwidth) || "2".equals(this.ifBandwidth) || "3".equals(this.ifBandwidth) || "6".equals(this.ifBandwidth);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(NOTSUPPORTCOMMAND));
        codeList.add(1091634631);
        codeList.add(1090777617);
        return codeList;
    }
}

