/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.nplus1;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TENplus1Query
extends TENEExplorerBean {
    private static final int RESULT_NULL_ERROR = 38662;
    private static final int ACTIVE_FLAG = 3;
    private static final int STA_PROTOCOL_UNSTART = 4;
    private static final int STA_PROTOCOL_STARTED = 1;
    private static final int STA_PROTOCOL_STARTING = 2;
    private static final int STA_PROTOCOL_PART_STARTED = 3;
    private static final int STA_UNKNOW = 255;
    private static final int STA_IDLE = 0;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams businessParam = new BussinessParams();
        RowParams rtnRowParams = new RowParams();
        businessParam.addRowParams(rtnRowParams);
        this.outputData.setBussinessParams(businessParam);
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            int retcode = 0;
            if (operation.getName().equals("NSCMD_CFG_GET_NJ1_PG")) {
                retcode = this.handlegroup(operation);
                if (retcode == 3 || retcode == 38662) {
                    this.setErrorDate(0);
                    return;
                }
            } else if (operation.getName().equals("NSCMD_CFG_GET_NJ1_SWSTATE")) {
                retcode = this.handelgruopstate(operation);
            } else if (operation.getName().equals("NSCMD_CFG_GET_NJ1_SDFLAG")) {
                retcode = this.handelSd(operation);
            } else if (operation.getName().equals("NSCMD_CFG_GET_NJ1_WTR")) {
                retcode = this.handelwtr(operation);
            } else if (operation.getName().equals("NSCMD_CFG_GET_NJ1_BDMAP")) {
                retcode = this.handelgruopmap(operation);
            }
            if (retcode == 0) continue;
            this.setErrorDate(retcode);
            return;
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }

    private int handelgruopstate(Operation operation) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            int protectid;
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("protectUnit");
            int protectUnit = Integer.parseInt(value);
            int switchState = Integer.parseInt(output.getPartValue("switchStatue"));
            int switchrequest = Integer.parseInt(output.getPartValue("switchrequest"));
            int tmpState = this.getSwitchState(switchState, switchrequest);
            String endIndication = output.getPartValue("endIndication");
            String protectidstr = output.getPartValue("reserveByte");
            if (4 != tmpState && 2 != tmpState) {
                rowparas[0].addParam("switchStatue" + protectUnit, tmpState + "");
            } else {
                rowparas[0].addParam("switchStatue" + protectUnit, switchrequest + "");
            }
            if (j == 0) {
                rowparas[0].addParam("protocol", output.getPartValue("switchStatue"));
            }
            if ((protectid = Integer.parseInt(protectidstr)) == 255) {
                rowparas[0].addParam("protectedunit" + protectUnit, "");
            } else {
                String v = rowparas[0].getParam("line" + protectid).getValue();
                rowparas[0].addParam("protectedunit" + protectUnit, v);
            }
            rowparas[0].addParam("endIndication" + protectUnit, endIndication);
        }
        return 0;
    }

    private int getSwitchState(int switchState, int switchrequest) {
        int tmpState = 0;
        if (switchState == 0) {
            tmpState = 4;
        } else if (switchState == 255) {
            tmpState = 2;
        } else if (switchState == 1) {
            tmpState = 0;
        } else if (switchState == 4) {
            switch (switchrequest) {
                case 0: 
                case 32: 
                case 64: 
                case 96: 
                case 128: 
                case 176: 
                case 208: 
                case 224: 
                case 240: {
                    tmpState = switchrequest;
                    break;
                }
                default: {
                    tmpState = 255;
                    break;
                }
            }
        } else {
            tmpState = 255;
        }
        return tmpState;
    }

    private int handelgruopmap(Operation operation) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("protectUnit");
            int protectUnit = new Integer(value);
            String slotid = output.getPartValue("slotid");
            String port = output.getPartValue("port");
            rowparas[0].addParam("slot" + protectUnit, slotid);
            rowparas[0].addParam("port" + protectUnit, port);
            rowparas[0].addParam("line" + protectUnit, this.getname(slotid, port));
        }
        return 0;
    }

    private String getname(String slotid, String port) {
        int slotidt = new Integer(slotid);
        int portt = new Integer(port);
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotidt);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotidt, boardtype, portt);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        StringBuffer name = new StringBuffer();
        name.append(slotid).append("-").append(boardname).append("-").append(portname);
        return name.toString();
    }

    private int handelwtr(Operation operation) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("revertiveTime");
            int mode = new Integer(value);
            rowparas[0].addParam("revertiveTime", mode + "");
        }
        return 0;
    }

    private int handelSd(Operation operation) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("sdEnable");
            int mode = new Integer(value);
            rowparas[0].addParam("sdEnable", mode + "");
        }
        return 0;
    }

    private int handlegroup(Operation operation) {
        RowParams[] rowparas = this.outputData.getBussinessParams().getRowParams();
        Output[] outputArr = operation.getOutput();
        for (int j = 0; j < outputArr.length; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode != 0) {
                return retCode;
            }
            String value = output.getPartValue("groupID");
            int mode = new Integer(value);
            rowparas[0].addParam("groupID", mode + "");
            value = output.getPartValue("worknum");
            mode = new Integer(value);
            rowparas[0].addParam("worknum", mode + "");
            value = output.getPartValue("activeFlag");
            mode = new Integer(value);
            if (mode == 3) continue;
            return 3;
        }
        return 0;
    }

    private void setErrorDate(int retCode) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)retCode));
    }
}

