/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.nplus1;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TENplus1ProtocolMgr
extends TENEExplorerBean {
    private static final int START_PROTOCOL = 1;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res";
    private static final String STRING_SOURCE = BASE_PATH + File.separator + "nplus1" + File.separator + "nplus1res_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<String> operationNameList = new ArrayList<String>();
        int startFlag = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("startFlag").getValue());
        if (startFlag == 1) {
            operationNameList.add("NSCMD_CFG_START_NJ1_PROTOCOL");
        } else {
            operationNameList.add("NSCMD_CFG_STOP_NJ1_PROTOCOL");
        }
        return TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, operationNameList);
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        RowErrors rowErrors = null;
        String groupID = rowparams.getParam("groupID").getValue();
        int errorCount = errorRowParams.getRowErrorsCount();
        for (int index = 0; index < errorCount; ++index) {
            rowErrors = errorRowParams.getRowErrors(index);
            if (!rowErrors.getParam("groupID").getValue().equals(groupID)) continue;
            return Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
        }
        return 0;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        StringBuffer des = new StringBuffer("");
        RowParams rowParams = null;
        int pcount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < pcount; ++i) {
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            String groupID_Str = rowParams.getParam("groupID").getValue();
            des.append(this.resourceUtil.getString("groupid")).append(":").append(groupID_Str).append(" , ");
            int startFlag = Integer.parseInt(rowParams.getParam("startFlag").getValue());
            if (0 == startFlag) {
                des.append(this.resourceUtil.getString("END_PROTOCOL")).append(";");
                continue;
            }
            if (1 != startFlag) continue;
            des.append(this.resourceUtil.getString("START_PROTOCOL")).append(";");
        }
        return des.toString();
    }
}

