/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.nplus1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeResQueryBean
implements TENEMgrInterface {
    private static final int BDTYPE_EFT4 = 1066;
    private int neid;
    private Datainterface output;
    private Logger log = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.output = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        try {
            if (null != neObj) {
                this.getAvaliableBoard();
            } else {
                this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            }
        }
        catch (Exception e) {
            this.log.error("Get Avaliable IPA Board Fail!\n", (Throwable)e);
            this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
        }
        return this.output;
    }

    private void getAvaliableBoard() {
        this.output.setBussinessParams(new BussinessParams());
        RowParams rowparams = null;
        TEBoard board = null;
        int bdType = 0;
        int slotID = 0;
        int port = 0;
        String bdName = "";
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        Collections.sort(boardList);
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            bdType = board.getBoardType();
            slotID = board.getSlotID();
            bdName = board.getBoardName();
            if (bdType == 1066 || bdType == 1210 || bdType == 1176 || bdType == 1177 || bdType == 1178 || bdType == 1548 || bdType == 2057 || bdType == 2102 || bdType == 2423 || bdType == 2439 || bdType == 2455 || bdType == 2469 || TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_RTN_LINKCONFIG", "TE_ATTR_RTN_ONETOUCHTEST_BOARD_NOTSUPPORT_NJ1")) continue;
            ArrayList portList = null;
            if (TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotID)) {
                portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotID, (int)bdType);
            } else if (TEConfigurationDataMgr.getInstance().isIFboard(bdType)) {
                portList = this.getIFPorts(slotID);
            }
            if (null == portList) continue;
            Collections.sort(portList);
            int portLen = portList.size();
            for (int portIndex = 0; portIndex < portLen; ++portIndex) {
                port = (Integer)portList.get(portIndex);
                rowparams = new RowParams();
                rowparams.addParam("slotid", String.valueOf(slotID));
                rowparams.addParam("boardname", bdName);
                rowparams.addParam("port", String.valueOf(port));
                rowparams.addParam("portname", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotID, bdType, port));
                this.output.getBussinessParams().addRowParams(rowparams);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private ArrayList getIFPorts(int slotid) {
        ArrayList ports = (ArrayList)TEConfigurationDataMgr.getInstance().getPortList(this.neid, slotid, 2817);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        int size = ports.size();
        for (int i = 0; i < size; ++i) {
            int portid = ((TEPort)ports.get(i)).getPortNo();
            portList.add(portid);
        }
        return portList;
    }
}

