/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.neattribute;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TENEAttribute
extends TENEExplorerBean {
    private static final String GNG_TYPE_PARAM = "gnetype";
    private static final String GNG_ADDRESS_PARAM = "gneAddress";
    private static final String GNG_PORT_PARAM = "gnePort";
    private static final String BAUD_RATE_PARAM = "baudRate";
    private static final String NE_NOT_LOGIN = "37926";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        BussinessParams bussinessParams;
        RowParams rowparams;
        RowErrors rowErrors;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        String tmpHostVersion = neObj.getHostVersion();
        neObj.queryNEAttribute();
        if ("".equals(neObj.getHostVersion())) {
            neObj.setHostVersion(tmpHostVersion);
        }
        Operation operation = new Operation();
        operation.setInput(new Input());
        Output output = new Output();
        Part part = new Part();
        Fault fault = new Fault();
        fault.setCode("0");
        part.setName(GNG_ADDRESS_PARAM);
        if (neObj.getNEGWType() == 3) {
            part.setValue("COM" + neObj.getPort());
        } else {
            part.setValue(neObj.getNEGWAddress());
        }
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(GNG_TYPE_PARAM);
        part.setValue(String.valueOf(neObj.getNEGWType()));
        output.addPart(part);
        output.addFault(fault);
        operation.addOutput(output);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(GNG_PORT_PARAM);
        part.setValue(neObj.getPort());
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        operation = new Operation();
        operation.setInput(new Input());
        output = new Output();
        part = new Part();
        part.setName(BAUD_RATE_PARAM);
        part.setValue(neObj.getBaudRate());
        output.addPart(part);
        operation.addOutput(output);
        output.addFault(fault);
        operationList.add(operation);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0") && (rowErrors = (rowparams = (bussinessParams = this.outputData.getBussinessParams()).getRowParams(1)).getRowErrors(0)).getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
            for (int i = rowparams.getRowErrorsCount() - 1; i >= 0; --i) {
                rowparams.removeRowErrors(rowparams.getRowErrors(i));
            }
        }
        RowParams rowparam = this.outputData.getBussinessParams().getRowParams(0);
        int shelfType = Integer.valueOf(rowparam.getParam("shelfType").getValue());
        rowparam.getParam("shelfType").setValue(String.valueOf(this.shelfTypeQ2E(neObj.getNEType(), shelfType)));
        int neType = Integer.valueOf(rowparam.getParam("deviceType").getValue());
        int devType = TEGetNEDomainVersion.getInstance().getDevType(neType);
        if (rowparam.getParam("deviceType") == null) {
            rowparam.addParam(new Param("deviceType", ""));
        }
        rowparam.getParam("deviceType").setValue(TEEquipmentDescription.getInstance().getTypeName(devType));
    }

    public String getDetailStr(RowParams rowparams) {
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (errorCode != 0) {
            return this.subfunc.getSubFuncDes(this.neid);
        }
        StringBuffer strBuf = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        this.neid = TENEListMgr.getInstance().getNE(this.neid).getRealNEID();
        String neidShow = (this.neid - this.neid % 65536) / 65536 + "-" + this.neid % 65536;
        filePath.append("rtn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("neattribute").append(File.separator).append("neattrres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        strBuf.append(res.getString("NEID")).append(":").append(neidShow).append(";");
        RowParams rowparm = this.outputData.getBussinessParams().getRowParams(0);
        String devicetype = rowparm.getParam("deviceType").getValue();
        strBuf.append(res.getString("deviceType")).append(":").append(devicetype).append(";");
        strBuf.append(res.getString("baseid")).append(":").append(this.neid % 65536).append(";");
        strBuf.append(res.getString("eid")).append(":").append((this.neid - this.neid % 65536) / 65536).append(";");
        strBuf.append(res.getString("neName")).append(":");
        if (!rowparm.getParam("neName").getValue().trim().equals("")) {
            strBuf.append(rowparm.getParam("neName").getValue().trim()).append(";");
        } else {
            strBuf.append("NE(").append(this.neid / 65536).append("-").append(this.neid % 65536).append(");");
        }
        strBuf.append(res.getString("neMeno")).append(":");
        if (!rowparm.getParam("neMeno").getValue().trim().equals("")) {
            strBuf.append(rowparm.getParam("neMeno").getValue().trim()).append(";");
        } else {
            strBuf.append("-").append(";");
        }
        strBuf.append(res.getString("shelfType")).append(":");
        StringBuffer shelfTypeStr = new StringBuffer();
        shelfTypeStr.append("shelftype[").append(rowparm.getParam("shelfType").getValue()).append("]");
        strBuf.append(res.getString(shelfTypeStr.toString())).append(";");
        strBuf.append(res.getString(GNG_TYPE_PARAM)).append(":");
        String gnetypeStr = "-";
        switch (Integer.parseInt(rowparm.getParam(GNG_TYPE_PARAM).getValue())) {
            case 1: {
                gnetypeStr = res.getString("ipGate");
                break;
            }
            case 2: {
                gnetypeStr = res.getString("isoGate");
                break;
            }
            case 3: {
                gnetypeStr = res.getString("serialGate");
                break;
            }
            default: {
                gnetypeStr = "-";
            }
        }
        strBuf.append(gnetypeStr).append(";");
        strBuf.append(res.getString(GNG_ADDRESS_PARAM)).append(":").append(rowparm.getParam(GNG_ADDRESS_PARAM).getValue()).append(";");
        strBuf.append(res.getString(GNG_PORT_PARAM)).append(":").append(rowparm.getParam(GNG_PORT_PARAM).getValue());
        Param busModeParam = rowparm.getParam("busMode");
        if (busModeParam != null && busModeParam.getValue() != null) {
            strBuf.append(gnetypeStr).append(";");
            strBuf.append(res.getString("busMode")).append(":");
            StringBuffer busModeStr = new StringBuffer();
            busModeStr.append("busMode[").append(rowparm.getParam("busMode").getValue()).append("]");
            strBuf.append(res.getString(busModeStr.toString())).append(";");
        }
        return strBuf.toString();
    }

    int shelfTypeQ2E(int eType, int qx) {
        int ems = qx;
        switch (qx) {
            case 1: {
                ems = 16;
                break;
            }
            case 2: {
                ems = 17;
                break;
            }
            case 3: {
                ems = 18;
                break;
            }
            case 4: {
                if (95 == eType) {
                    ems = 25;
                    break;
                }
                ems = 24;
                break;
            }
            case 5: {
                ems = 26;
                break;
            }
            default: {
                ems = qx;
            }
        }
        return ems;
    }
}

