/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.microwaveinterface;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TEMicroInterfaceQueryBean
extends TEGenCfgQueryBean {
    private static final String INVALID_ATTRI = "/";
    private static final String REGMENT = " ";
    private static final String REGMENT1 = "-";
    public static final long INVALID_IP = 0xFFFFFFFFL;
    public static final int IPTYPE_UNSET = 255;
    public static final String LAYER3_ATTRI = "3";
    public static final String LAYER2_ATTRI = "2";

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterList) {
        subfunc.setPortType(String.valueOf(11));
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(37898);
        filterErrorCodeList.add(42949);
        filterErrorCodeList.add(38751);
        filterErrorCodeList.add(38737);
        filterErrorCodeList.add(42693);
        filterErrorCodeList.add(42165);
        filterErrorCodeList.add(38664);
        List<String> errports = this.errCodeIsExsit(operationList, String.valueOf(42693));
        if (!errports.isEmpty()) {
            this.processOpersPre(operationList, errports);
        }
        if (null == operationList || operationList.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return;
        }
        super.handleMessage(neid, subfunc, operationList, filterErrorCodeList);
        if (null == this.outputData || null == this.outputData.getBussinessParams()) {
            return;
        }
        if (this.outputData.getBussinessParams().getRowParamsCount() == 0) {
            return;
        }
        this.adjustAttributes();
    }

    private void adjustAttributes() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParamses = bussinessParams.getRowParams();
        RowParams rowParams = null;
        String temp = "";
        String portId = "";
        String portName = "";
        long ip = 0L;
        Param param = null;
        for (int i = bussinessParams.getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            if (rowParams.getParamCount() == 0) continue;
            if (null != rowParams.getParam("port")) {
                portId = rowParams.getParam("port").getValue();
            }
            if (null != rowParams.getParam("SDHPORT_ATTR_NAME")) {
                portName = rowParams.getParam("SDHPORT_ATTR_NAME").getValue();
            }
            if (!"".equals(portName)) {
                rowParams.getParam("portname").setValue(portId + "(" + portName + ")");
            }
            if (null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE") && !INVALID_ATTRI.equals(temp = rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").getValue())) {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE").setValue(this.insertToValue(temp, REGMENT, 2));
            }
            if (null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_PORTMAC") && !INVALID_ATTRI.equals(temp = rowParams.getParam("ATTR_ETHOVERPTN_MAC_PORTMAC").getValue())) {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_PORTMAC").setValue(this.insertToValue(temp, REGMENT1, 2));
            }
            if (null != rowParams.getParam("W32PORT_ATTR_CHANNELSPACE") && null != rowParams.getParam("W32PORT_ATTR_CHANNELSPACE").getValue() && !rowParams.getParam("W32PORT_ATTR_CHANNELSPACE").getValue().isEmpty()) {
                int channelwidth = Integer.parseInt(rowParams.getParam("W32PORT_ATTR_CHANNELSPACE").getValue());
                if (channelwidth == 9 || channelwidth == 8 || channelwidth == 7) {
                    rowParams.addParam("IFPORTNA_ATTR_IFBDWIDTHMODE", "FCC");
                } else {
                    rowParams.addParam("IFPORTNA_ATTR_IFBDWIDTHMODE", "ETSI");
                }
            }
            if (null != rowParams.getParam("SDHPORT_ATTR_MODE") && null != rowParams.getParam("ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE") && null == rowParams.getParam("ATTR_ETHOVERPTN_MAC_QINQ_TYPE") && LAYER2_ATTRI.equals(rowParams.getParam("SDHPORT_ATTR_MODE").getValue())) {
                bussinessParams.removeRowParams(i);
                continue;
            }
            param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPADDRESS");
            if (null == param || INVALID_ATTRI.equals(param.getValue()) || "".equals(param.getValue())) continue;
            ip = Long.valueOf(param.getValue());
            if (0xFFFFFFFFL == ip) {
                rowParams.getParam("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").setValue(String.valueOf(255));
            }
            param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
            param = rowParams.getParam("ATTR_ETHOVERPTN_MAC_IPMARSK");
            param.setValue(TEConvertUtil.ipToString((long)Long.valueOf(param.getValue())));
        }
    }

    private String insertToValue(String value, String regment, int intervalcount) {
        StringBuffer temp = new StringBuffer(0);
        for (int i = 0; i < value.length(); i += intervalcount) {
            temp.append(value.substring(i, i + intervalcount)).append(regment);
        }
        if (temp.length() > 1) {
            return temp.toString().substring(0, temp.length() - 1);
        }
        return INVALID_ATTRI;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    private void processOpersPre(ArrayList opers, List<String> errports) {
        Iterator iter = opers.iterator();
        while (iter.hasNext()) {
            Operation oper = (Operation)iter.next();
            Input in = oper.getInput();
            String port = in.getPartValue("slotid") + REGMENT1 + in.getPartValue("port");
            if (!errports.contains(port)) continue;
            iter.remove();
        }
    }

    private List<String> errCodeIsExsit(ArrayList opers, String code) {
        ArrayList<String> errPorts = new ArrayList<String>(0);
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Input in;
            String port;
            Operation oper = (Operation)opers.get(i);
            if (!code.equals(oper.getOutput()[0].getFault()[0].getCode()) || errPorts.contains(port = (in = oper.getInput()).getPartValue("slotid") + REGMENT1 + in.getPartValue("port"))) continue;
            errPorts.add(port);
        }
        return errPorts;
    }
}

