/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.radiolinkloop;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.maintenance.radiolinkloop.TERadioLinkLoopUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetRadioLinkLoopBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = new ArrayList();
            int modifiedRecordNum = inputData.getBussinessParams().getRowParamsCount();
            try {
                for (int i = 0; i < modifiedRecordNum; ++i) {
                    RowParams currentRowParam = inputData.getBussinessParams().getRowParams(i);
                    String loopStatus = currentRowParam.getParam("loopstatus").getValue();
                    String slotid = currentRowParam.getParam("slotid").getValue();
                    String portid = currentRowParam.getParam("portid").getValue();
                    String attrName = currentRowParam.getParam("attrid").getValue();
                    String qxStr = TERadioLinkLoopUtil.getSetQxByAtt(attrName);
                    Operation oper_rtn = TECreateObjectFactory.getOperation((int)neid, (String)qxStr);
                    oper_rtn.getInput().getPart("slotid").setValue(slotid);
                    if (oper_rtn.getInput().getPart("port") != null) {
                        oper_rtn.getInput().getPart("port").setValue(portid);
                    }
                    oper_rtn.getInput().getPart(TERadioLinkLoopUtil.getSetValueByQx(qxStr)).setValue(loopStatus);
                    this.operationList.add(oper_rtn);
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TESetNELoopBean.performBussinessProcess() fail!", (Throwable)e);
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result_rtn = this.sendMessage(neid);
            if (result_rtn == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result_rtn));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetNELoopBean fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        RowErrors rowErrors = null;
        Param tmpParam_rtn = null;
        boolean succFlag = true;
        int errorCount = errorRowParams.getRowErrorsCount();
        for (int index = 0; index < errorCount; ++index) {
            rowErrors = errorRowParams.getRowErrors(index);
            if (rowErrors.getErrorMessage() != null) {
                succFlag = false;
            }
            tmpParam_rtn = rowErrors.getParam("portname");
            Param attrParam_rtn = rowErrors.getParam("attrId");
            if (null == tmpParam_rtn || null == attrParam_rtn) continue;
            try {
                TERadioLinkLoopUtil.getPortName(this.neid, Integer.parseInt(rowErrors.getParam("slotid").getValue()), Integer.parseInt(rowErrors.getParam("port").getValue()), TERadioLinkLoopUtil.getPortTypeByAtt(attrParam_rtn.getValue()));
                continue;
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("PORTNAME instead fail!", (Throwable)ex);
            }
        }
        if (!succFlag) {
            return Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
        }
        return 0;
    }

    public String getDetailInfo(RowParams[] rowParams) {
        StringBuffer operDesc = new StringBuffer();
        StringBuffer filePath = new StringBuffer();
        filePath.append("rtn").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("maintenance").append(File.separator).append("radiolinkloop_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        for (int i = 0; i < rowParams.length; ++i) {
            int slotid = Integer.parseInt(rowParams[i].getParam("slotid").getValue());
            int portid = Integer.parseInt(rowParams[i].getParam("portid").getValue());
            String attrid = rowParams[i].getParam("attrid").getValue();
            String loopstatus = rowParams[i].getParam("loopstatus").getValue();
            TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
            operDesc.append(neObj.getNEName()).append("-");
            operDesc.append(slotid).append("-");
            operDesc.append(mgr.getBoardName(this.neid, slotid)).append("-");
            operDesc.append(TERadioLinkLoopUtil.getPortName(this.neid, slotid, portid, TERadioLinkLoopUtil.getPortTypeByAtt(attrid))).append(":");
            operDesc.append(res.getString(attrid)).append(":");
            operDesc.append(res.getString("loopstatus_" + loopstatus));
        }
        return operDesc.toString();
    }
}

