/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.radiolinkloop;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import java.util.ArrayList;
import java.util.List;

public class TERadioLinkLoopUtil {
    private static final String[] supportAttrs = new String[]{"W32PORT_ATTR_PORTLOOPBACK", "W32BRD_ATTR_RFLOOPBACK"};
    private static final String[] queryOperLoopQxs = new String[]{"NSCMD_CFG_GET_RADIO_IFLOOP", "NSCMD_CFG_GET_RFLOOP"};
    private static final String[] setOperLoopQxs = new String[]{"NSCMD_CFG_SET_RADIO_IFLOOP", "NSCMD_CFG_SET_RFLOOP"};
    private static final String[] setValueName = new String[]{"W32PORT_ATTR_PORTLOOPBACK", "W32BRD_ATTR_RFLOOPBACK"};
    private static final int[] portTypes = new int[]{11, 1803};

    public static String[] getTableAttrs() {
        return supportAttrs;
    }

    public static String getQueryAttByQx(String qxStr) {
        return TERadioLinkLoopUtil.getStrByStr(supportAttrs, queryOperLoopQxs, qxStr);
    }

    public static String getQueryQxByAtt(String attrName) {
        return TERadioLinkLoopUtil.getStrByStr(queryOperLoopQxs, supportAttrs, attrName);
    }

    public static String getSetQxByAtt(String attrName) {
        return TERadioLinkLoopUtil.getStrByStr(setOperLoopQxs, supportAttrs, attrName);
    }

    public static String getSetValueByQx(String qxStr) {
        return TERadioLinkLoopUtil.getStrByStr(setValueName, setOperLoopQxs, qxStr);
    }

    public static boolean isExitUpTableQueryQx(String qxStr) {
        return TERadioLinkLoopUtil.isExit(queryOperLoopQxs, qxStr);
    }

    public static boolean isExitUpTableAtrr(String attrName) {
        return TERadioLinkLoopUtil.isExit(supportAttrs, attrName);
    }

    public static int getPortTypeByAtt(String attrName) {
        return TERadioLinkLoopUtil.getIntByStr(portTypes, supportAttrs, attrName);
    }

    public static String getPortName(int neid, int slotid, int port, Integer portType) {
        String portName_rtn = "";
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        if (portType != null) {
            if (portType == 1803) {
                int netype = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
                if (115 == netype || 92 == netype || TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IFBOARD_AND_ODUBOARD_INTEGRATION")) {
                    return port + "(RF-" + port + ")";
                }
                return port + "(ODU-" + port + ")";
            }
            List<Integer> portTypes = TERadioLinkLoopUtil.getPortTypes(portType);
            int len = portTypes.size();
            for (int i = 0; i < len; ++i) {
                portName_rtn = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, port, portTypes.get(i).intValue());
                if ("".equals(portName_rtn)) continue;
                portName_rtn = port + "(" + portName_rtn + ")";
                break;
            }
        }
        if ("".equals(portName_rtn)) {
            portName_rtn = TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardType, port);
        }
        return portName_rtn;
    }

    private static List<Integer> getPortTypes(int portType) {
        ArrayList<Integer> portTypelist_rtn = new ArrayList<Integer>();
        if (portType == 11) {
            portTypelist_rtn.add(2817);
            portTypelist_rtn.add(1802);
        }
        return portTypelist_rtn;
    }

    private static Integer getIntByStr(int[] toInts, String[] fromStrs, String curStr) {
        int index = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return toInts[index];
        }
        return null;
    }

    private static String getStrByStr(String[] toStrs, String[] fromStrs, String curStr) {
        int index = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return toStrs[index];
        }
        return null;
    }

    private static boolean isExit(String[] fromStrs, String curStr) {
        int index = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index = i;
            break;
        }
        return index != -1;
    }
}

