/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.radiolinkloop;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.rtn.maintenance.radiolinkloop.TERadioLinkLoopUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEQueryRadioLinkLoopBean
extends TECommonWriteLogBean {
    private static final String UNLOOPSTR = "";
    private static final String NOLOOPSTR = "0";
    private static final String INLOOPSTR = "1";
    private static final String OUTLOOPSTR = "2";
    private static final String CHECKEDSTR = "1";
    private static final String UNCHECKEDSTR = "0";
    private static final String FILE_NAME = "nemgr" + File.separator + "rtn" + File.separator + "res" + File.separator + "maintenance" + File.separator + "radiolinkloop_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private TEResourceUtil res = TEResourceUtil.getInstance((String)FILE_NAME);
    private int ifslotid;
    private int rfslotid;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        try {
            this.ifslotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("ifslotid").getValue());
            this.rfslotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("rfslotid").getValue());
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error(ex.getMessage());
        }
        Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> upMapAndPorts = this.getAllSupportPortListInNEMap(neid, TERadioLinkLoopUtil.getTableAttrs(), true);
        this.convertToOutPutData(upMapAndPorts);
        return this.outputData;
    }

    private Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> getAllSupportPortListInNEMap(int neid, String[] attrNames, boolean includeBoardLevel) {
        HashMap<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> rs = new HashMap<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>>();
        for (String attrName : attrNames) {
            HashSet<Integer> slotSet = null;
            if (attrName.equals("W32PORT_ATTR_PORTLOOPBACK")) {
                slotSet = new HashSet<Integer>();
                slotSet.add(this.ifslotid);
            } else if (attrName.equals("W32BRD_ATTR_RFLOOPBACK")) {
                slotSet = new HashSet();
                slotSet.add(this.rfslotid);
            }
            rs.put(attrName, TEGenCfgModel.getAllSupportPortListInNE((int)neid, slotSet, (String)attrName, (boolean)includeBoardLevel));
        }
        return rs;
    }

    public void convertToOutPutData(Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> upMapAndPorts) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (null == upMapAndPorts) {
            TELogFactory.getNormalLogger().error("Get link port is null!");
            return;
        }
        BussinessParams upBussinessParams = new BussinessParams();
        HashMap<String, Set<String>> attPortMap = new HashMap<String, Set<String>>();
        HashMap<String, RowParams> attPortParamsMap = new HashMap<String, RowParams>();
        this.addParamsData(attPortParamsMap, attPortMap, upBussinessParams, upMapAndPorts);
        Map<String, String> portLoopMap = this.queryPortLoopStatus(attPortMap);
        if (portLoopMap != null) {
            this.refreshPortLoop(attPortParamsMap, portLoopMap);
        }
        this.sortParamList(upBussinessParams);
        this.outputData.setBussinessParams(upBussinessParams);
    }

    private void sortParamList(BussinessParams bussinessParams) {
        Comparator<RowParams> comparator = new Comparator<RowParams>(){

            @Override
            public int compare(RowParams arg0, RowParams arg1) {
                int boardComp;
                RowParams params0 = arg0;
                String param0_board = params0.getParam("slotid").getValue();
                String param0_port = null;
                if (params0.getParam("portid") != null) {
                    param0_port = params0.getParam("portid").getValue();
                }
                RowParams params1 = arg1;
                String param1_board = params1.getParam("slotid").getValue();
                String param1_port = null;
                if (params1.getParam("portid") != null) {
                    param1_port = params1.getParam("portid").getValue();
                }
                if ((boardComp = Integer.parseInt(param0_board) - Integer.parseInt(param1_board)) == 0) {
                    if (param0_port == null && param1_port == null) {
                        return boardComp;
                    }
                    if (param0_port != null && param1_port == null) {
                        return 1;
                    }
                    if (param1_port != null && param0_port == null) {
                        return -1;
                    }
                    return Integer.parseInt(param0_port) - Integer.parseInt(param1_port);
                }
                return boardComp;
            }
        };
        Collections.sort(bussinessParams.getRowParamList(), comparator);
    }

    private void refreshPortLoop(Map<String, RowParams> attPortParamsMap, Map<String, String> portLoopMap) {
        if (portLoopMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, RowParams> boardPortEntry : attPortParamsMap.entrySet()) {
            String attrport = boardPortEntry.getKey();
            String loopValue = portLoopMap.get(attrport);
            if (loopValue == null) continue;
            String attrName = attrport.substring(0, attrport.indexOf(45));
            RowParams portParams = boardPortEntry.getValue();
            Param attrParam = portParams.getParam("attrid");
            if (attrParam == null) continue;
            if ("0".equals(loopValue)) {
                portParams.getParam("inloop").setValue("0");
                portParams.getParam("outloop").setValue("0");
            } else if ("1".equals(loopValue)) {
                portParams.getParam("inloop").setValue("1");
                portParams.getParam("outloop").setValue("0");
            } else if (OUTLOOPSTR.equals(loopValue)) {
                portParams.getParam("inloop").setValue("0");
                portParams.getParam("outloop").setValue("1");
            }
            if (!attrName.equals("W32BRD_ATTR_RFLOOPBACK")) continue;
            portParams.getParam("outloop").setValue(UNLOOPSTR);
        }
    }

    private void addParamsData(Map<String, RowParams> attPortValueMap, Map<String, Set<String>> attPortMap, BussinessParams bussinessParams, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> mapAndPorts) {
        RowParams portRowparams = null;
        if (mapAndPorts != null) {
            HashMap<String, RowParams> portParamMap = new HashMap<String, RowParams>();
            int index = 0;
            for (Map.Entry<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> attrMapEntry : mapAndPorts.entrySet()) {
                String attrName = attrMapEntry.getKey();
                HashSet<String> portSet = new HashSet<String>();
                Map<TEBoard, ArrayList<TEGenCfgPortAttribute>> boardAndPorts = attrMapEntry.getValue();
                for (Map.Entry<TEBoard, ArrayList<TEGenCfgPortAttribute>> boardPortEntry : boardAndPorts.entrySet()) {
                    TEBoard board = boardPortEntry.getKey();
                    String slotid = String.valueOf(board.getSlotID());
                    ArrayList<TEGenCfgPortAttribute> portList = boardPortEntry.getValue();
                    if (portList == null) {
                        int portID = 1;
                        String key = slotid + '-' + String.valueOf(portID);
                        StringBuilder sbkey = new StringBuilder(attrName);
                        sbkey.append('-').append(key);
                        portRowparams = this.createRowParams(String.valueOf(++index), String.valueOf(this.neid), slotid, String.valueOf(portID), attrName, this.getObjectName(slotid, board, portID, attrName), UNLOOPSTR, UNLOOPSTR);
                        bussinessParams.addRowParams(portRowparams);
                        portParamMap.put(key, portRowparams);
                        portSet.add(key);
                        attPortValueMap.put(sbkey.toString(), portRowparams);
                        continue;
                    }
                    int m = portList.size();
                    for (int j = 0; j < m; ++j) {
                        TEGenCfgPortAttribute portAtt = portList.get(j);
                        String key = slotid + '-' + String.valueOf(portAtt.getPort());
                        StringBuilder sbkey = new StringBuilder(attrName);
                        sbkey.append('-').append(key);
                        if (attPortValueMap.containsKey(sbkey.toString())) continue;
                        portRowparams = this.createRowParams(String.valueOf(++index), String.valueOf(this.neid), slotid, String.valueOf(portAtt.getPort()), attrName, this.getObjectName(slotid, board, portAtt.getPort(), attrName), UNLOOPSTR, UNLOOPSTR);
                        bussinessParams.addRowParams(portRowparams);
                        portSet.add(key);
                        attPortValueMap.put(sbkey.toString(), portRowparams);
                    }
                }
                attPortMap.put(attrName, portSet);
            }
        }
    }

    private String getObjectName(String slotid, TEBoard board, int portID, String attrName) {
        StringBuilder sb = new StringBuilder();
        sb.append(slotid).append('-').append(board.getBoardName()).append('-').append(TERadioLinkLoopUtil.getPortName(this.neid, board.getSlotID(), portID, TERadioLinkLoopUtil.getPortTypeByAtt(attrName))).append('(').append(this.res.getString(attrName)).append(')');
        return sb.toString();
    }

    private RowParams createRowParams(String id, String neID, String slotID, String portID, String attrName, String nodeName, String inloop, String outloop) {
        RowParams rowParams = new RowParams();
        rowParams.addParam("id", id);
        rowParams.addParam("neid", neID);
        rowParams.addParam("slotid", slotID);
        rowParams.addParam("portid", portID);
        rowParams.addParam("attrid", attrName);
        rowParams.addParam("interface", nodeName);
        rowParams.addParam("inloop", inloop);
        rowParams.addParam("outloop", outloop);
        return rowParams;
    }

    private List<Operation> getQueryPortsOperation(Map<String, Set<String>> attPortMap) {
        ArrayList<Operation> loopOperationList = new ArrayList<Operation>();
        for (Map.Entry<String, Set<String>> attrMapEntry : attPortMap.entrySet()) {
            String queryQx = TERadioLinkLoopUtil.getQueryQxByAtt(attrMapEntry.getKey());
            Set<String> boardPortSet = attrMapEntry.getValue();
            if (queryQx == null) continue;
            Operation operLoop = TECreateObjectFactory.getOperation((int)this.neid, (String)queryQx);
            for (String boardPortStr : boardPortSet) {
                String[] boardPorts = boardPortStr.split("-");
                operLoop.getInput().getPart("slotid").setValue(boardPorts[0]);
                if (operLoop.getInput().getPart("port") == null) {
                    loopOperationList.add((Operation)operLoop.clone());
                    continue;
                }
                operLoop.getInput().getPart("port").setValue(boardPorts[1]);
                loopOperationList.add((Operation)operLoop.clone());
            }
        }
        return loopOperationList;
    }

    private Map<String, String> queryPortLoopStatus(Map<String, Set<String>> attPortMap) {
        HashMap<String, String> rs_rtn = new HashMap<String, String>();
        List<Operation> operationListLoop_rtn = this.getQueryPortsOperation(attPortMap);
        if (!operationListLoop_rtn.isEmpty()) {
            OperationResult result1 = TENECommMgr.getInstance().sendCommand(this.neid, operationListLoop_rtn, this.getTimeOut());
            if (result1.retCode == 0) {
                int len = operationListLoop_rtn.size();
                for (int i = 0; i < len; ++i) {
                    Operation operation_rtn = operationListLoop_rtn.get(i);
                    String qxStr = operation_rtn.getName();
                    for (Output output_rtn : operation_rtn.getOutput()) {
                        if (!output_rtn.getFault()[0].getCode().equals(String.valueOf(0))) continue;
                        String outputPortid = null;
                        outputPortid = output_rtn.getPart("port") == null ? "1" : output_rtn.getPart("port").getValue();
                        String outputSlotid = output_rtn.getPart("slotid").getValue();
                        Part valuePart = this.getValuePart(output_rtn, qxStr);
                        String valueName = valuePart.getName();
                        StringBuilder sb_rtn = new StringBuilder(valueName);
                        sb_rtn.append('-').append(outputSlotid).append('-').append(outputPortid);
                        String value = valuePart.getValue();
                        String attPortStr = (String)rs_rtn.get(sb_rtn.toString());
                        if (attPortStr == null) {
                            rs_rtn.put(sb_rtn.toString(), value);
                            continue;
                        }
                        if (attPortStr.equals(value)) continue;
                        rs_rtn.put(sb_rtn.toString(), attPortStr + '@' + value);
                    }
                }
            } else {
                TELogFactory.getNormalLogger().error("Query radio link port loopback fail! " + result1.retCode);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result1.retCode));
                return null;
            }
        }
        return rs_rtn;
    }

    private Part getValuePart(Output tmpOut, String qxStr) {
        Part rs = tmpOut.getPart(tmpOut.getPartCount() - 1);
        rs.setName(TERadioLinkLoopUtil.getQueryAttByQx(qxStr));
        return rs;
    }
}

