/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.neloop;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.maintenance.neloop.TENELoopAttrQxMapUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TESetNELoopBean
extends TECommonWriteLogBean {
    private static final String FILE_NAME = "nemgr" + File.separator + "rtn" + File.separator + "res" + File.separator + "maintenance" + File.separator + "radiolinkloop_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private TEResourceUtil res = TEResourceUtil.getInstance((String)FILE_NAME);
    private Map<String, Integer> opResultMap = new HashMap<String, Integer>();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = new ArrayList();
            int modifiedRecordNum = inputData.getBussinessParams().getRowParamsCount();
            try {
                for (int i = 0; i < modifiedRecordNum; ++i) {
                    RowParams currentRowParam = inputData.getBussinessParams().getRowParams(i);
                    Param attridParam = currentRowParam.getParam("attrid");
                    if (attridParam == null) continue;
                    String attridParamStr = attridParam.getValue();
                    String[] valueAttrids = attridParamStr.split("=");
                    String value = valueAttrids[0];
                    String[] portAttrids = valueAttrids[1].split("-");
                    String slotid = portAttrids[1];
                    String portid = portAttrids[2];
                    String attriStr = portAttrids[3];
                    String[] attris = attriStr.split(";");
                    int attrCount = attris.length;
                    for (int j = 0; j < attrCount; ++j) {
                        String attrName = attris[j].split("@")[0];
                        String qxStr = TENELoopAttrQxMapUtil.getSetQxByAtt(attrName);
                        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)qxStr);
                        oper.getInput().getPart("slotid").setValue(slotid);
                        if (oper.getInput().getPart("port") != null) {
                            oper.getInput().getPart("port").setValue(portid);
                        }
                        if (TENELoopAttrQxMapUtil.isExitUpTableAtrr(attrName)) {
                            oper.getInput().getPart(TENELoopAttrQxMapUtil.getSetValueByUpQx(qxStr)).setValue(value);
                        } else if (oper.getInput().getPart("loopBackType") != null && oper.getInput().getPart("loopBackMode") != null) {
                            if ("ATTR_ETHOVERPTN_MAC_MAC_LOOPBACK".equals(attrName)) {
                                oper.getInput().getPart("loopBackType").setValue("1");
                                oper.getInput().getPart("loopBackMode").setValue(value);
                            } else if ("ATTR_ETHOVERPTN_MAC_PHY_LOOPBACK".equals(attrName)) {
                                oper.getInput().getPart("loopBackType").setValue("2");
                                oper.getInput().getPart("loopBackMode").setValue(value);
                            }
                        }
                        this.operationList.add(oper);
                    }
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TESetNELoopBean.performBussinessProcess() fail!", (Throwable)e);
            }
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.hanleOperationList(this.operationList);
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESetNELoopBean fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private void hanleOperationList(List<Operation> opList) {
        for (Operation op : opList) {
            StringBuilder keysb = new StringBuilder(16);
            for (Part part : op.getInput().getPart()) {
                keysb.append(part.getName());
                keysb.append(part.getValue());
            }
            int erroCode = Integer.parseInt(op.getOutput()[0].getFault()[0].getCode());
            this.opResultMap.put(keysb.toString(), erroCode);
        }
    }

    public int getOperResult(RowParams rowparams, RowParams errorRowParams) {
        String key = this.parseRowParam(rowparams);
        return this.opResultMap.get(key);
    }

    private String parseRowParam(RowParams rp) {
        StringBuffer keySb = new StringBuffer(16);
        String currentRow = rp.getParam("attrid").getValue();
        String[] valueAttrids = currentRow.split("=");
        String value = valueAttrids[0];
        String[] portAttrids = valueAttrids[1].split("-");
        String slotid = portAttrids[1];
        String portid = portAttrids[2];
        String attriStr = portAttrids[3];
        String[] attris = attriStr.split(";");
        keySb.append("slotid");
        keySb.append(slotid);
        keySb.append("port");
        keySb.append(portid);
        int attrCount = attris.length;
        for (int j = 0; j < attrCount; ++j) {
            String attrName = attris[j].split("@")[0];
            keySb.append(attrName);
            keySb.append(value);
        }
        return keySb.toString();
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        StringBuffer descb = new StringBuffer(16);
        if (rParamsArr.length != 0) {
            String neid = rParamsArr[0].getParam("neid").getValue();
            String currentRow = rParamsArr[0].getParam("attrid").getValue();
            String[] valueAttrids = currentRow.split("=");
            String[] portAttrids = valueAttrids[1].split("-");
            String slotid = portAttrids[1];
            TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(Integer.parseInt(neid), Integer.parseInt(slotid));
            boolean isIFFlag = TEConfigurationDataMgr.getInstance().isIFboard(board.getBoardType());
            String portid = portAttrids[2];
            String attriStr = portAttrids[3];
            String[] attris = attriStr.split(";");
            String portName = "";
            portName = isIFFlag && !this.isOptFromIF(attris[0]) ? portid + "(IF-" + portid + ")" : (this.isODU(board.getBoardType()) ? portid + "(ODU-" + portid + ")" : TEConfigurationDataMgr.getInstance().getPortName(Integer.parseInt(neid), Integer.parseInt(slotid), board.getBoardType(), Integer.parseInt(portid)));
            descb.append(slotid);
            descb.append('-');
            descb.append(board.getBoardName());
            descb.append('-');
            descb.append(portName);
            int attrCount = attris.length;
            for (int j = 0; j < attrCount; ++j) {
                String[] attr = attris[j].split("@");
                descb.append(' ');
                descb.append(this.res.getString(attr[0]));
                descb.append(':');
                descb.append(this.res.getString("loopstatus_" + valueAttrids[0]));
                descb.append(';');
            }
        }
        return descb.toString();
    }

    private boolean isODU(int bdtype) {
        return bdtype == 1035 || bdtype == 1220 || bdtype == 1405 || bdtype == 1593;
    }

    private boolean isOptFromIF(String attr) {
        return attr.startsWith("SDHVC4_ATTR_OPTICALLOOPBACK");
    }
}

