/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.neloop;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.rtn.maintenance.neloop.TENELoopAttrQxMapUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEQueryNELoopBean
extends TECommonWriteLogBean {
    private static final String UpPos = "0";
    private static final String DownPos = "1";
    private static final String BoardNodeStr = "-1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Map upMapAndPorts = TEGenCfgModel.getAllSupportPortListInNEMap((int)neid, (String[])TENELoopAttrQxMapUtil.getUpTableAttrs(), (boolean)true);
        Map downMacMapAndPorts = TEGenCfgModel.getAllSupportPortListInNEMap((int)neid, (String[])TENELoopAttrQxMapUtil.getDownMacTableAttrs(), (boolean)true);
        Map downPhyMapAndPorts = TEGenCfgModel.getAllSupportPortListInNEMap((int)neid, (String[])TENELoopAttrQxMapUtil.getDownPhyTableAttrs(), (boolean)true);
        this.convertToOutPutData(upMapAndPorts, downMacMapAndPorts, downPhyMapAndPorts);
        return this.outputData;
    }

    public void convertToOutPutData(Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> upMapAndPorts, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> downMacMapAndPorts, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> downPhyMapAndPorts) {
        this.outputData = new Datainterface();
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (null == upMapAndPorts && null == downMacMapAndPorts && null == downPhyMapAndPorts) {
            TELogFactory.getNormalLogger().error("Get port is null! ");
            return;
        }
        BussinessParams upBussinessParams = new BussinessParams();
        HashMap<String, Set<String>> attPortMap = new HashMap<String, Set<String>>();
        HashMap<String, RowParams> attPortParamsMap = new HashMap<String, RowParams>();
        this.addParamsData(attPortParamsMap, attPortMap, upBussinessParams, upMapAndPorts, UpPos, false, null, null);
        BussinessParams downBussinessParams = new BussinessParams();
        this.addParamsData(attPortParamsMap, attPortMap, downBussinessParams, downMacMapAndPorts, downPhyMapAndPorts, DownPos);
        Map<String, String> portLoopMap = this.queryPortLoopStatus(attPortMap, this.outputData);
        if (portLoopMap != null) {
            this.refreshPortLoop(attPortParamsMap, portLoopMap);
        }
        this.sortParamList(upBussinessParams);
        this.sortParamList(downBussinessParams);
        upBussinessParams.getRowParamList().addAll(downBussinessParams.getRowParamList());
        this.outputData.setBussinessParams(upBussinessParams);
    }

    private void sortParamList(BussinessParams bussinessParams) {
        Comparator<RowParams> comparator = new Comparator<RowParams>(){

            @Override
            public int compare(RowParams arg0, RowParams arg1) {
                RowParams params0 = arg0;
                String param0_board = params0.getParam("slotid").getValue();
                String param0_port = null;
                if (params0.getParam("portid") != null) {
                    param0_port = params0.getParam("portid").getValue();
                }
                RowParams params1 = arg1;
                String param1_board = params1.getParam("slotid").getValue();
                String param1_port = null;
                if (params1.getParam("portid") != null) {
                    param1_port = params1.getParam("portid").getValue();
                }
                int boardComp = Integer.parseInt(param0_board) - Integer.parseInt(param1_board);
                if (param0_port == null && param1_port == null) {
                    return boardComp;
                }
                if (param0_port != null && param1_port == null) {
                    return 1;
                }
                if (param1_port != null && param0_port == null) {
                    return -1;
                }
                return Integer.parseInt(param0_port) - Integer.parseInt(param1_port);
            }
        };
        Collections.sort(bussinessParams.getRowParamList(), comparator);
        ArrayList rowParamList = bussinessParams.getRowParamList();
        HashMap<String, String> boardIndexMap = new HashMap<String, String>();
        int index = 0;
        int size = rowParamList.size();
        for (int i = 0; i < size; ++i) {
            RowParams rowParams = (RowParams)rowParamList.get(i);
            String pid = rowParams.getParam("pid").getValue();
            String slotID = rowParams.getParam("slotid").getValue();
            rowParams.getParam("id").setValue(String.valueOf(++index));
            if (BoardNodeStr.equals(pid)) {
                boardIndexMap.put(slotID, String.valueOf(index));
                continue;
            }
            rowParams.getParam("pid").setValue((String)boardIndexMap.get(slotID));
        }
    }

    private void refreshPortLoop(Map<String, RowParams> attPortParamsMap, Map<String, String> portLoopMap) {
        if (portLoopMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, RowParams> boardPortEntry : attPortParamsMap.entrySet()) {
            String attrport = boardPortEntry.getKey();
            String loopValue = portLoopMap.get(attrport);
            if (loopValue == null) continue;
            String attrName = attrport.substring(0, attrport.indexOf(45));
            RowParams portParams = boardPortEntry.getValue();
            if (UpPos.equals(portParams.getParam("pos").getValue())) {
                Param attrParam = portParams.getParam("attrid");
                if (attrParam == null) continue;
                String attrsStr = attrParam.getValue();
                attrsStr = attrsStr.replaceFirst(attrName, attrName + '@' + loopValue);
                attrParam.setValue(attrsStr);
                continue;
            }
            Param macAttrParam = portParams.getParam("attrid_mac");
            if (macAttrParam == null) continue;
            String macAttrsStr = macAttrParam.getValue();
            macAttrsStr = macAttrsStr.replaceFirst(attrName, attrName + '@' + loopValue);
            macAttrParam.setValue(macAttrsStr);
            Param phyAttrParam = portParams.getParam("attrid_phy");
            if (phyAttrParam == null) continue;
            String phyAttrsStr = phyAttrParam.getValue();
            phyAttrsStr = phyAttrsStr.replaceFirst(attrName, attrName + '@' + loopValue);
            phyAttrParam.setValue(phyAttrsStr);
        }
    }

    private void addParamsData(Map<String, RowParams> attPortValueMap, Map<String, Set<String>> attPortMap, BussinessParams bussinessParams, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> macMapAndPorts, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> phyMapAndPorts, String pos) {
        HashMap<String, RowParams> portParamMap = new HashMap<String, RowParams>();
        HashMap<String, String> slotIDMap = new HashMap<String, String>();
        this.addParamsData(attPortValueMap, attPortMap, bussinessParams, macMapAndPorts, pos, true, portParamMap, slotIDMap);
        this.addParamsData(attPortValueMap, attPortMap, bussinessParams, phyMapAndPorts, pos, false, portParamMap, slotIDMap);
    }

    private void addParamsData(Map<String, RowParams> attPortValueMap, Map<String, Set<String>> attPortMap, BussinessParams bussinessParams, Map<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> mapAndPorts, String pos, boolean macCol, Map<String, RowParams> portParamMap, Map<String, String> slotIDMap) {
        RowParams portRowparams = null;
        if (mapAndPorts != null) {
            if (portParamMap == null) {
                portParamMap = new HashMap<String, RowParams>();
            }
            if (slotIDMap == null) {
                slotIDMap = new HashMap<String, String>();
            }
            int index = 0;
            for (Map.Entry<String, Map<TEBoard, ArrayList<TEGenCfgPortAttribute>>> attrMapEntry : mapAndPorts.entrySet()) {
                String attrName = attrMapEntry.getKey();
                HashSet<String> portSet = new HashSet<String>();
                Map<TEBoard, ArrayList<TEGenCfgPortAttribute>> boardAndPorts = attrMapEntry.getValue();
                for (Map.Entry<TEBoard, ArrayList<TEGenCfgPortAttribute>> boardPortEntry : boardAndPorts.entrySet()) {
                    ArrayList<TEGenCfgPortAttribute> portList;
                    TEBoard board = boardPortEntry.getKey();
                    String slotid = String.valueOf(board.getSlotID());
                    if (!slotIDMap.containsKey(slotid)) {
                        RowParams boardRowparams = new RowParams();
                        boardRowparams.addParam("pos", pos);
                        boardRowparams.addParam("id", String.valueOf(++index));
                        boardRowparams.addParam("pid", BoardNodeStr);
                        boardRowparams.addParam("slotid", slotid);
                        boardRowparams.addParam("nodename", slotid + '-' + board.getBoardName());
                        slotIDMap.put(slotid, String.valueOf(index));
                        bussinessParams.addRowParams(boardRowparams);
                    }
                    if ((portList = boardPortEntry.getValue()) == null) {
                        int portID = 1;
                        String key = slotid + '-' + String.valueOf(portID);
                        StringBuilder sbkey = new StringBuilder(attrName);
                        sbkey.append('-').append(key);
                        portRowparams = this.createRowParams(pos, macCol, String.valueOf(++index), slotIDMap.get(slotid), slotid, String.valueOf(portID), attrName, TENELoopAttrQxMapUtil.getPortName(this.neid, board.getSlotID(), portID, TENELoopAttrQxMapUtil.getPortTypeByAtt(attrName)));
                        bussinessParams.addRowParams(portRowparams);
                        portParamMap.put(key, portRowparams);
                        portSet.add(key);
                        attPortValueMap.put(sbkey.toString(), portRowparams);
                        continue;
                    }
                    int m = portList.size();
                    for (int j = 0; j < m; ++j) {
                        TEGenCfgPortAttribute portAtt = portList.get(j);
                        String key = slotid + '-' + String.valueOf(portAtt.getPort());
                        StringBuilder sbkey = new StringBuilder(attrName);
                        sbkey.append('-').append(key);
                        if (pos.equals(UpPos)) {
                            if (attPortValueMap.containsKey(sbkey.toString())) continue;
                            portRowparams = this.createRowParams(pos, macCol, String.valueOf(++index), slotIDMap.get(slotid), slotid, String.valueOf(portAtt.getPort()), attrName, TENELoopAttrQxMapUtil.getPortName(this.neid, board.getSlotID(), portAtt.getPort(), TENELoopAttrQxMapUtil.getPortTypeByAtt(attrName)));
                            bussinessParams.addRowParams(portRowparams);
                            portSet.add(key);
                            attPortValueMap.put(sbkey.toString(), portRowparams);
                            continue;
                        }
                        RowParams oldparams = portParamMap.get(key);
                        if (oldparams != null) {
                            String paramName = macCol ? "attrid_mac" : "attrid_phy";
                            Param attParam = oldparams.getParam(paramName);
                            if (attParam == null) {
                                oldparams.addParam(paramName, attrName);
                                attPortValueMap.put(sbkey.toString(), oldparams);
                                continue;
                            }
                            String attrValue = attParam.getValue();
                            if (attrValue.indexOf(attrName) > -1) continue;
                            StringBuilder sb = new StringBuilder(attrValue);
                            sb.append(';').append(attrName);
                            attParam.setValue(sb.toString());
                            attPortValueMap.put(sbkey.toString(), oldparams);
                            continue;
                        }
                        portRowparams = this.createRowParams(pos, macCol, String.valueOf(++index), slotIDMap.get(slotid), slotid, String.valueOf(portAtt.getPort()), attrName, TENELoopAttrQxMapUtil.getPortName(this.neid, board.getSlotID(), portAtt.getPort(), TENELoopAttrQxMapUtil.getPortTypeByAtt(attrName)));
                        bussinessParams.addRowParams(portRowparams);
                        portParamMap.put(key, portRowparams);
                        portSet.add(key);
                        attPortValueMap.put(sbkey.toString(), portRowparams);
                    }
                }
                attPortMap.put(attrName, portSet);
            }
        }
    }

    private RowParams createRowParams(String pos, boolean macCol, String id, String pid, String slotID, String portID, String attrName, String nodeName) {
        RowParams rowParams = new RowParams();
        rowParams.addParam("pos", pos);
        rowParams.addParam("id", id);
        rowParams.addParam("pid", pid);
        rowParams.addParam("slotid", slotID);
        rowParams.addParam("portid", portID);
        rowParams.addParam(pos.equals(UpPos) ? "attrid" : (macCol ? "attrid_mac" : "attrid_phy"), attrName);
        rowParams.addParam("nodename", nodeName);
        return rowParams;
    }

    private List<Operation> getQueryPortsOperation(Map<String, Set<String>> attPortMap) {
        ArrayList<Operation> loopOperationList = new ArrayList<Operation>();
        for (Map.Entry<String, Set<String>> attrMapEntry : attPortMap.entrySet()) {
            String queryQx = TENELoopAttrQxMapUtil.getQueryQxByAtt(attrMapEntry.getKey());
            Set<String> boardPortSet = attrMapEntry.getValue();
            if (queryQx == null) continue;
            Operation operLoop = TECreateObjectFactory.getOperation((int)this.neid, (String)queryQx);
            for (String boardPortStr : boardPortSet) {
                String[] boardPorts = boardPortStr.split("-");
                operLoop.getInput().getPart("slotid").setValue(boardPorts[0]);
                if (operLoop.getInput().getPart("port") == null) {
                    loopOperationList.add((Operation)operLoop.clone());
                    continue;
                }
                operLoop.getInput().getPart("port").setValue(boardPorts[1]);
                loopOperationList.add((Operation)operLoop.clone());
            }
        }
        return loopOperationList;
    }

    private Map<String, String> queryPortLoopStatus(Map<String, Set<String>> attPortMap, Datainterface outputData) {
        HashMap<String, String> rs = new HashMap<String, String>();
        List<Operation> operationListLoop = this.getQueryPortsOperation(attPortMap);
        if (!operationListLoop.isEmpty()) {
            OperationResult result1 = TENECommMgr.getInstance().sendCommand(this.neid, operationListLoop, this.getTimeOut());
            if (result1.retCode == 0) {
                int len = operationListLoop.size();
                for (int i = 0; i < len; ++i) {
                    Operation operation = operationListLoop.get(i);
                    String qxStr = operation.getName();
                    for (Output output : operation.getOutput()) {
                        if (!output.getFault()[0].getCode().equals(String.valueOf(0))) continue;
                        String outputPortid = null;
                        outputPortid = output.getPart("port") == null ? DownPos : output.getPart("port").getValue();
                        String outputSlotid = output.getPart("slotid").getValue();
                        Part valuePart = this.getValuePart(output, qxStr);
                        String valueName = valuePart.getName();
                        StringBuilder sb = new StringBuilder(valueName);
                        sb.append('-').append(outputSlotid).append('-').append(outputPortid);
                        String value = valuePart.getValue();
                        String attPortStr = (String)rs.get(sb.toString());
                        if (attPortStr == null) {
                            rs.put(sb.toString(), value);
                            continue;
                        }
                        if (attPortStr.equals(value)) continue;
                        rs.put(sb.toString(), attPortStr + '@' + value);
                    }
                }
            } else {
                TELogFactory.getNormalLogger().error("Query port loopback fail! " + result1.retCode);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result1.retCode));
                return null;
            }
        }
        return rs;
    }

    private Part getValuePart(Output tmpOut, String qxStr) {
        Part rs = null;
        if (TENELoopAttrQxMapUtil.isExitUpTableQueryQx(qxStr)) {
            rs = tmpOut.getPart(tmpOut.getPartCount() - 1);
            rs.setName(TENELoopAttrQxMapUtil.getQueryAttByUpQx(qxStr));
        } else if (tmpOut.getPart("loopBackType") != null && tmpOut.getPart("loopBackType").getValue() != null) {
            if (tmpOut.getPart("loopBackType").getValue().equals(DownPos) && tmpOut.getPart("loopBackMode") != null) {
                rs = tmpOut.getPart("loopBackMode");
                rs.setName("ATTR_ETHOVERPTN_MAC_MAC_LOOPBACK");
            } else if (tmpOut.getPart("loopBackType").getValue().equals("2") && tmpOut.getPart("loopBackMode") != null) {
                rs = tmpOut.getPart("loopBackMode");
                rs.setName("ATTR_ETHOVERPTN_MAC_PHY_LOOPBACK");
            }
        }
        return rs;
    }
}

