/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance.neloop;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.util.ArrayList;
import java.util.List;

public class TENELoopAttrQxMapUtil {
    protected static final String MAC_LOOPBACK_TYPE = "1";
    protected static final String PHY_LOOPBACK_TYPE = "2";
    private static final String[] upSupportAttrs = new String[]{"W32PORT_ATTR_PORTLOOPBACK", "W32BRD_ATTR_RFLOOPBACK", "SDHVC4_ATTR_OPTICALLOOPBACK", "PDHPATH_ATTR_LOOPBACK"};
    private static final String[] upQueryOperLoopQxs = new String[]{"NSCMD_CFG_GET_RADIO_IFLOOP", "NSCMD_CFG_GET_RFLOOP", "NSCMD_CFG_GET_OPTICALLOOP", "NSCMD_CFG_GET_LOOP"};
    private static final String[] upSetOperLoopQxs = new String[]{"NSCMD_CFG_SET_RADIO_IFLOOP", "NSCMD_CFG_SET_RFLOOP", "NSCMD_CFG_SET_OPTICALLOOP", "NSCMD_CFG_SET_LOOP"};
    private static final String[] upSetValueName = new String[]{"W32PORT_ATTR_PORTLOOPBACK", "W32BRD_ATTR_RFLOOPBACK", "SDHVC4_ATTR_OPTICALLOOPBACK", "PDHPATH_ATTR_LOOPBACK"};
    private static final int[] upPortTypes = new int[]{11, 1803, 130, 129};
    private static final String[] downMacSupportAttrs = new String[]{"ATTR_ETHOVERPTN_MAC_MAC_LOOPBACK"};
    private static final String[] downMacQueryOperLoopQxs = new String[]{"NSCMD_PTNETY_GET_LOOPMODE"};
    private static final String[] downMacSetOperLoopQxs = new String[]{"NSCMD_PTNETY_SET_LOOPMODE"};
    private static final int[] downMacPortTypes = new int[]{4};
    private static final String[] downPhySupportAttrs = new String[]{"ATTR_ETHOVERPTN_MAC_PHY_LOOPBACK"};
    private static final String[] downPhyQueryOperLoopQxs = new String[]{"NSCMD_PTNETY_GET_LOOPMODE"};
    private static final String[] downPhySetOperLoopQxs = new String[]{"NSCMD_PTNETY_SET_LOOPMODE"};
    private static final int[] downPhyPortTypes = new int[]{4};

    public static String[] getUpTableAttrs() {
        return upSupportAttrs;
    }

    public static String[] getDownMacTableAttrs() {
        return downMacSupportAttrs;
    }

    public static String[] getDownPhyTableAttrs() {
        return downPhySupportAttrs;
    }

    public static String getQueryQxByAtt(String attrName) {
        String upQueryQx = TENELoopAttrQxMapUtil.getQueryQxByUpAtt(attrName);
        if (upQueryQx == null) {
            String dowMacQueryQx = TENELoopAttrQxMapUtil.getQueryQxByDownMacAtt(attrName);
            return dowMacQueryQx == null ? TENELoopAttrQxMapUtil.getQueryQxByDownPhyAtt(attrName) : dowMacQueryQx;
        }
        return upQueryQx;
    }

    public static String getQueryAttByUpQx(String qxStr) {
        return TENELoopAttrQxMapUtil.getStrByStr(upSupportAttrs, upQueryOperLoopQxs, qxStr);
    }

    public static String getQueryQxByUpAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(upQueryOperLoopQxs, upSupportAttrs, attrName);
    }

    public static String getQueryQxByDownMacAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(downMacQueryOperLoopQxs, downMacSupportAttrs, attrName);
    }

    public static String getQueryQxByDownPhyAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(downPhyQueryOperLoopQxs, downPhySupportAttrs, attrName);
    }

    public static String getSetQxByAtt(String attrName) {
        String upQxStr = TENELoopAttrQxMapUtil.getSetQxByUpAtt(attrName);
        if (upQxStr == null) {
            String downMacQxStr = TENELoopAttrQxMapUtil.getSetQxByDownMacAtt(attrName);
            return downMacQxStr == null ? TENELoopAttrQxMapUtil.getSetQxByDownPhyAtt(attrName) : downMacQxStr;
        }
        return upQxStr;
    }

    public static String getSetQxByUpAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(upSetOperLoopQxs, upSupportAttrs, attrName);
    }

    public static String getSetValueByUpQx(String qxStr) {
        return TENELoopAttrQxMapUtil.getStrByStr(upSetValueName, upSetOperLoopQxs, qxStr);
    }

    public static String getSetQxByDownMacAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(downMacSetOperLoopQxs, downMacSupportAttrs, attrName);
    }

    public static String getSetQxByDownPhyAtt(String attrName) {
        return TENELoopAttrQxMapUtil.getStrByStr(downPhySetOperLoopQxs, downPhySupportAttrs, attrName);
    }

    public static boolean isExitUpTableQueryQx(String qxStr) {
        return TENELoopAttrQxMapUtil.isExit(upQueryOperLoopQxs, qxStr);
    }

    public static boolean isExitUpTableAtrr(String attrName) {
        return TENELoopAttrQxMapUtil.isExit(upSupportAttrs, attrName);
    }

    public static String getPortName(int neid, int slotid, int port, Integer portType) {
        String portName = "";
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        if (portType != null) {
            if (portType == 1803) {
                int netype = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
                if (115 == netype || 92 == netype) {
                    return port + "(RF-" + port + ")";
                }
                return port + "(ODU-" + port + ")";
            }
            List<Integer> portTypes = TENELoopAttrQxMapUtil.getPortTypes(portType);
            int len = portTypes.size();
            for (int i = 0; i < len; ++i) {
                portName = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardType, port, portTypes.get(i).intValue());
                if ("".equals(portName)) continue;
                portName = port + "(" + portName + ")";
                break;
            }
        }
        if ("".equals(portName)) {
            portName = TEConfigurationDataMgr.getInstance().getPortNameForNARTN(neid, slotid, boardType, port);
        }
        return portName;
    }

    private static List<Integer> getPortTypes(int portType) {
        ArrayList<Integer> portTypelist = new ArrayList<Integer>();
        if (portType == 11) {
            portTypelist.add(2817);
            portTypelist.add(1802);
        }
        return portTypelist;
    }

    public static int getPortTypeByAtt(String attrName) {
        Integer upPortType = TENELoopAttrQxMapUtil.getIntByStr(upPortTypes, upSupportAttrs, attrName);
        if (upPortType == null) {
            Integer downMacPortType = TENELoopAttrQxMapUtil.getIntByStr(downMacPortTypes, downMacSupportAttrs, attrName);
            downMacPortType = downMacPortType == null ? TENELoopAttrQxMapUtil.getIntByStr(downPhyPortTypes, downPhySupportAttrs, attrName) : downMacPortType;
            upPortType = downMacPortType == null ? 11 : downMacPortType;
        }
        return upPortType;
    }

    private static Integer getIntByStr(int[] toInts, String[] fromStrs, String curStr) {
        int index_rtn = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index_rtn = i;
            break;
        }
        if (index_rtn != -1) {
            return toInts[index_rtn];
        }
        return null;
    }

    private static String getStrByStr(String[] toStrs, String[] fromStrs, String curStr) {
        int index_rtn1 = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index_rtn1 = i;
            break;
        }
        if (index_rtn1 != -1) {
            return toStrs[index_rtn1];
        }
        return null;
    }

    private static boolean isExit(String[] fromStrs, String curStr) {
        int index_rtn2 = -1;
        int size = fromStrs.length;
        for (int i = 0; i < size; ++i) {
            if (!curStr.equals(fromStrs[i])) continue;
            index_rtn2 = i;
            break;
        }
        return index_rtn2 != -1;
    }
}

