/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.Input;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.Output;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.rtn.maintenance.TEMaintenanceConstants;
import com.huawei.nglct.nemgr.rtn.maintenance.TETestBase;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TETestForODUAttr
extends TETestBase {
    @Override
    protected String getErrBody() {
        StringBuilder res = new StringBuilder("");
        BussinessParams bus = this.outputData.getBussinessParams();
        RowParams row = null;
        int errCount = 0;
        int iLen = bus.getRowParamsCount();
        for (int i = 0; i < iLen; ++i) {
            row = bus.getRowParams(i);
            RowErrors rowErrs = null;
            int jLen = row.getRowErrorsCount();
            for (int j = 0; j < jLen; ++j) {
                rowErrs = row.getRowErrors(j);
                res.append("(").append(++errCount).append(")").append(" ");
                res.append(rowErrs.getParam("board").getValue()).append(",");
                res.append(rowErrs.getErrorMessage().getErrorinfo()).append("(").append(rowErrs.getErrorMessage().getErrorcode()).append(")");
                res.append(this.lineSep);
            }
        }
        return res.toString();
    }

    @Override
    protected byte[] getHeadRemark() {
        StringBuilder res = new StringBuilder("");
        res.append("####");
        res.append(this.resourceUtil.getString("ne_odu_attr"));
        res.append("####");
        res.append(this.lineSep);
        return res.toString().getBytes();
    }

    @Override
    protected String[] getHeads() {
        return TEMaintenanceConstants.ODUATTR_TAB_HEADS;
    }

    @Override
    protected SubFunc getSubFunc(String params) {
        SubFunc subFunc = new SubFunc();
        Input input = new Input();
        subFunc.setInput(input);
        Output output = new Output();
        subFunc.setOutput(output);
        OperObject operObj = new OperObject();
        subFunc.setOperObject(operObj);
        QxMapping qxMap = new QxMapping();
        qxMap.setContent("NSCMD_CFG_GET_ODU_RFREQ");
        subFunc.addQxMapping(qxMap);
        qxMap = new QxMapping();
        qxMap.setContent("NSCMD_CFG_GET_ODU_RPOWER");
        subFunc.addQxMapping(qxMap);
        Param param = new Param();
        param.setName("neid");
        operObj.addParam(param);
        subFunc.getInput().addParam(param);
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("slotid");
        operObj.addParam(param);
        subFunc.getInput().addParam(param);
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("W32BRD_ATTR_ACTTRANSMITFRE");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("W32BRD_ATTR_ACTTRECEIVEFRE");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("W32BRD_ATTR_ACTTRANSMITPOWER");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("W32BRD_ATTR_ACTRECEIVEPOWER");
        subFunc.getOutput().addParam(param);
        return subFunc;
    }

    @Override
    protected Datainterface parseParams(String params) {
        String[] slotids = params.split(";");
        Datainterface inputData = new Datainterface();
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        int len = slotids.length;
        for (int i = 0; i < len; ++i) {
            row = new RowParams();
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("neid");
            param.setValue(String.valueOf(this.neid));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("slotid");
            param.setValue(slotids[i]);
            row.addParam(param);
            bus.addRowParams(row);
        }
        inputData.setBussinessParams(bus);
        return inputData;
    }

    @Override
    protected void refactor() {
        BussinessParams bus = this.outputData.getBussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        if (!String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) {
            int iLen = bus.getRowParamsCount();
            for (int i = 0; i < iLen; ++i) {
                row = bus.getRowParams(i);
                RowErrors rowErr = null;
                int jLen = row.getRowErrorsCount();
                for (int j = 0; j < jLen; ++j) {
                    rowErr = row.getRowErrors(j);
                    StringBuilder tmp = new StringBuilder("");
                    tmp.append(rowErr.getParam("nename").getValue());
                    tmp.append("-");
                    tmp.append(rowErr.getParam("slotid").getValue());
                    tmp.append("-");
                    tmp.append(rowErr.getParam("boardname").getValue());
                    param = new com.huawei.nglct.common.datainterface.Param();
                    param.setName("board");
                    param.setValue(tmp.toString());
                    rowErr.addParam(param);
                }
                this.filterDBErr(row);
            }
        }
        if (!String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode()) || !String.valueOf(1).equals(this.outputData.getErrorMessage().getErrorcode())) {
            int len = bus.getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                row = bus.getRowParams(i);
                if (row.getRowErrors().length > 0) continue;
                StringBuilder tmp = new StringBuilder("");
                tmp.append(row.getParam("nename").getValue());
                tmp.append("-");
                tmp.append(row.getParam("slotid").getValue());
                tmp.append("-");
                tmp.append(row.getParam("boardname").getValue());
                param = new com.huawei.nglct.common.datainterface.Param();
                param.setName("board");
                param.setValue(tmp.toString());
                row.addParam(param);
                param = row.getParam("W32BRD_ATTR_ACTTRANSMITFRE");
                long freVal = Long.parseLong(param.getValue());
                param.setValue(String.valueOf((double)freVal / 1000.0));
                param = row.getParam("W32BRD_ATTR_ACTTRECEIVEFRE");
                freVal = Long.parseLong(param.getValue());
                param.setValue(String.valueOf((double)freVal / 1000.0));
                param = row.getParam("W32BRD_ATTR_ACTTRANSMITPOWER");
                int pwVal = new BigInteger(param.getValue()).intValue();
                short spwVal = (short)pwVal;
                param.setValue(Float.toString((float)spwVal / 10.0f));
                param = row.getParam("W32BRD_ATTR_ACTRECEIVEPOWER");
                pwVal = new BigInteger(param.getValue()).intValue();
                spwVal = (short)pwVal;
                param.setValue(Float.toString((float)spwVal / 10.0f));
            }
        }
    }

    private void filterDBErr(RowParams row) {
        ArrayList<RowErrors> tmpList = new ArrayList<RowErrors>();
        RowErrors rowErr = null;
        int jLen = row.getRowErrorsCount();
        for (int j = 0; j < jLen; ++j) {
            rowErr = row.getRowErrors(j);
            if (this.isExist(rowErr, tmpList)) continue;
            tmpList.add(rowErr);
        }
        RowErrors[] errArr = new RowErrors[tmpList.size()];
        int iLen = errArr.length;
        for (int i = 0; i < iLen; ++i) {
            errArr[i] = (RowErrors)tmpList.get(i);
        }
        row.setRowErrors(errArr);
    }

    private boolean isExist(RowErrors err, List<RowErrors> errs) {
        if (errs.isEmpty()) {
            return false;
        }
        RowErrors rowErr = null;
        int len = errs.size();
        for (int i = 0; i < len; ++i) {
            rowErr = errs.get(i);
            if (!rowErr.getParam("board").getValue().equals(err.getParam("board").getValue()) || !rowErr.getErrorMessage().getErrorcode().equals(err.getErrorMessage().getErrorcode())) continue;
            return true;
        }
        return false;
    }
}

