/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.Output;
import com.huawei.nglct.common.functions.Param;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.rtn.maintenance.ColInfoBean;
import com.huawei.nglct.nemgr.rtn.maintenance.TEMaintenanceConstants;
import com.huawei.nglct.nemgr.rtn.maintenance.TETestBase;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TETestForAM
extends TETestBase {
    private Map<String, Map<String, String>> amAttrs = new HashMap<String, Map<String, String>>();
    private Map<String, Datainterface> dataInterfaces = new HashMap<String, Datainterface>();
    private Map<String, List<ColInfoBean>> colInfos = new HashMap<String, List<ColInfoBean>>();
    private TimeZoneDateBean timeProccessor = null;

    @Override
    public byte[] startTest(int neid, String params, String extendparam) {
        return this.startTest(neid, params);
    }

    @Override
    public byte[] startTest(int neid, String params) {
        this.neid = neid;
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)resPath);
        this.heads = this.getHeads();
        this.inputData = this.parseParams(params);
        this.subFunc = this.getSubFunc(params);
        this.timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
        if (this.getAmAttr(params) != 0) {
            return this.getTestResInBytes();
        }
        if (this.setAmState(params, false) != 0) {
            return this.getTestResInBytes();
        }
        if (this.resetPfmValue(params) != 0) {
            return this.getTestResInBytes();
        }
        if (this.setAmState(params, true) != 0) {
            return this.getTestResInBytes();
        }
        try {
            Thread.sleep(10000L);
            if (this.getPfmValue(params) == 0) {
                this.resetAmAtrr(params);
            }
            return this.getTestResInBytes();
        }
        catch (InterruptedException e) {
            ErrorMessage err = new ErrorMessage();
            err.setErrorcode(String.valueOf(2));
            err.setErrorinfo(e.getMessage());
            this.outputData.setErrorMessage(err);
            TELogFactory.getNormalLogger().error("sleep fail!");
            return this.getTestResInBytes();
        }
    }

    @Override
    protected byte[] getBody() {
        StringBuilder res = new StringBuilder("");
        String errCode = this.outputData.getErrorMessage().getErrorcode();
        if (!String.valueOf(0).equals(errCode)) {
            res.append(this.outputData.getErrorMessage().getErrorinfo()).append(this.lineSep);
            res.append(this.lineSep);
            return res.toString().getBytes();
        }
        Iterator<String> keys = this.dataInterfaces.keySet().iterator();
        String slotId = null;
        StringBuilder result = new StringBuilder("");
        boolean isQueryNull = true;
        while (keys.hasNext()) {
            isQueryNull = false;
            slotId = keys.next();
            this.outputData = this.dataInterfaces.get(slotId);
            this.colInfo = this.colInfos.get(slotId);
            result.append(new String(super.getBody()));
            if (!String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) continue;
            result.append(this.getTestResult());
        }
        if (isQueryNull && String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) {
            result.append(this.getTestResult());
        }
        return result.toString().getBytes();
    }

    @Override
    protected String getErrBody() {
        return " ";
    }

    @Override
    protected byte[] getHeadRemark() {
        int netype = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEType();
        boolean isEband = netype == 115;
        StringBuilder res = new StringBuilder("");
        res.append("####");
        if (isEband) {
            res.append(this.resourceUtil.getString("ne_amac_test"));
        } else {
            res.append(this.resourceUtil.getString("ne_am_test"));
        }
        res.append("####");
        res.append(this.lineSep);
        return res.toString().getBytes();
    }

    @Override
    protected String[] getHeads() {
        return TEMaintenanceConstants.AMTEST_TAB_HEADS;
    }

    @Override
    protected SubFunc getSubFunc(String params) {
        SubFunc subFunc = new SubFunc();
        com.huawei.nglct.common.functions.Input input = new com.huawei.nglct.common.functions.Input();
        subFunc.setInput(input);
        Output output = new Output();
        subFunc.setOutput(output);
        OperObject operObj = new OperObject();
        subFunc.setOperObject(operObj);
        Param param = new Param();
        param.setName("neid");
        subFunc.getInput().addParam(param);
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("slotid");
        operObj.addParam(param);
        subFunc.getInput().addParam(param);
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("amstate");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("fullmode");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("ensuremode");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("manualmode");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("startTime");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("peValue");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("validFlag");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("objpara");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("peid");
        subFunc.getOutput().addParam(param);
        param = new Param();
        param.setName("period");
        subFunc.getOutput().addParam(param);
        return subFunc;
    }

    @Override
    protected Datainterface parseParams(String params) {
        String[] slotids = params.split(";");
        Datainterface inputData = new Datainterface();
        BussinessParams bus = new BussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        int len = slotids.length;
        for (int i = 0; i < len; ++i) {
            row = new RowParams();
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("neid");
            param.setValue(String.valueOf(this.neid));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("slotid");
            param.setValue(slotids[i]);
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("portid");
            param.setValue(TEMaintenanceConstants.PARAM_DEFAULT_VALUE.toString());
            row.addParam(param);
            bus.addRowParams(row);
        }
        inputData.setBussinessParams(bus);
        return inputData;
    }

    private int getAmAttr(String params) {
        this.subFunc.clearQxMapping();
        QxMapping qxMap = new QxMapping();
        qxMap.setContent("NSCMD_CFG_GET_AM_PARAM");
        this.subFunc.addQxMapping(qxMap);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)this.neid);
        if (this.opers.size() == 0) {
            return 0;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, this.opers, 60, null);
        if (result.retCode == 0) {
            int len = this.opers.size();
            for (int i = 0; i < len; ++i) {
                Datainterface dataInterface;
                Operation oper = (Operation)this.opers.get(i);
                com.huawei.uflight.qxprotocol.definitions.Output outPut = oper.getOutput(0);
                if (outPut.getFault(0).getCode().equals(String.valueOf(0))) {
                    if (outPut.getPartValue("amstate").equals("0")) {
                        dataInterface = new Datainterface();
                        ErrorMessage err = new ErrorMessage();
                        err.setErrorcode(String.valueOf(1090605056));
                        int slotid = Integer.valueOf(outPut.getPartValue("slotid"));
                        StringBuilder info = new StringBuilder("");
                        info.append(this.resourceUtil.getString("test_result"));
                        info.append(slotid + "-").append(TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid).getBoardName()).append(",");
                        info.append(this.resourceUtil.getString("need_amenable"));
                        err.setErrorinfo(info.toString());
                        dataInterface.setErrorMessage(err);
                        this.dataInterfaces.put(String.valueOf(slotid), dataInterface);
                        continue;
                    }
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("amstate", outPut.getPartValue("amstate"));
                    data.put("fullmode", outPut.getPartValue("fullmode"));
                    data.put("ensuremode", outPut.getPartValue("ensuremode"));
                    data.put("manualmode", outPut.getPartValue("manualmode"));
                    this.amAttrs.put(outPut.getPartValue("slotid"), data);
                    continue;
                }
                dataInterface = new Datainterface();
                Input input = oper.getInput();
                int slotid = Integer.valueOf(input.getPartValue("slotid"));
                dataInterface.setErrorMessage(this.getErr(oper));
                this.dataInterfaces.put(String.valueOf(slotid), dataInterface);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
        return result.retCode;
    }

    private int setAmState(String params, boolean flg) {
        this.initSetAmParam(params, flg);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)this.neid);
        if (this.opers.size() == 0) {
            return 2;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, this.opers, 60, null);
        if (result.retCode == 0) {
            int len = this.opers.size();
            for (int i = 0; i < len; ++i) {
                Operation oper = (Operation)this.opers.get(i);
                com.huawei.uflight.qxprotocol.definitions.Output outPut = oper.getOutput(0);
                if (outPut.getFault(0).getCode().equals(String.valueOf(0))) continue;
                Datainterface dataInterface = new Datainterface();
                dataInterface.setErrorMessage(this.getErr(oper));
                this.dataInterfaces.put(oper.getInput().getPartValue("slotid"), dataInterface);
                this.amAttrs.put(String.valueOf(oper.getInput().getPartValue("slotid")), null);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
        return result.retCode;
    }

    private int getPfmValue(String params) {
        this.initPfmParam(params);
        this.subFunc.clearQxMapping();
        QxMapping qxMap = new QxMapping();
        qxMap.setContent("NSCMD_PER_GET_CURDATA_NEW");
        this.subFunc.addQxMapping(qxMap);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)this.neid);
        if (this.opers.size() == 0) {
            return 2;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neid, this.opers, 60, null);
        if (result.retCode == 0) {
            int len = this.opers.size();
            for (int i = 0; i < len; ++i) {
                Operation oper = (Operation)this.opers.get(i);
                com.huawei.uflight.qxprotocol.definitions.Output outPut = oper.getOutput(0);
                if (!outPut.getFault(0).getCode().equals(String.valueOf(0))) {
                    Datainterface dataInterface = new Datainterface();
                    ErrorMessage em = this.getErr(oper);
                    if (this.isQueryNull(em.getErrorcode())) continue;
                    dataInterface.setErrorMessage(em);
                    this.dataInterfaces.put(oper.getInput().getPartValue("slotid"), dataInterface);
                    continue;
                }
                ArrayList<Operation> tmpOpers = new ArrayList<Operation>();
                tmpOpers.add(oper);
                this.handleMessage(this.neid, tmpOpers, this.subFunc);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
        return result.retCode;
    }

    private boolean isQueryNull(String errorcode) {
        return "38410".equals(errorcode) || "38662".equals(errorcode) || "38153".equals(errorcode) || "40357".equals(errorcode) || "39326".equals(errorcode);
    }

    private ErrorMessage getErr(Operation oper) {
        com.huawei.uflight.qxprotocol.definitions.Output outPut = oper.getOutput(0);
        Input input = oper.getInput();
        int slotid = Integer.valueOf(input.getPartValue("slotid"));
        ErrorMessage err = new ErrorMessage();
        err.setErrorcode(outPut.getFault(0).getCode());
        StringBuilder info = new StringBuilder("");
        info.append(this.resourceUtil.getString("test_result"));
        info.append(slotid + "-").append(TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid).getBoardName()).append(",");
        info.append(TEErrorResourceUtil.getErrorMessage((int)Integer.valueOf(outPut.getFault(0).getCode())).getErrorinfo());
        err.setErrorinfo(info.toString());
        return err;
    }

    private int resetPfmValue(String params) {
        this.initPfmParam(params);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)this.neid);
        if (this.opers.size() == 0) {
            return 2;
        }
        OperationResult result_rtn = TECommuNEMgr.getInstance().sendCommand(this.neid, this.opers, 60, null);
        if (result_rtn.retCode == 0) {
            int len = this.opers.size();
            for (int i = 0; i < len; ++i) {
                Operation oper_rtn = (Operation)this.opers.get(i);
                com.huawei.uflight.qxprotocol.definitions.Output outPut = oper_rtn.getOutput(0);
                if (outPut.getFault(0).getCode().equals(String.valueOf(0))) continue;
                Datainterface dataInterface = new Datainterface();
                dataInterface.setErrorMessage(this.getErr(oper_rtn));
                this.dataInterfaces.put(oper_rtn.getInput().getPartValue("slotid"), dataInterface);
                this.amAttrs.put(String.valueOf(oper_rtn.getInput().getPartValue("slotid")), null);
            }
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result_rtn.retCode));
        return result_rtn.retCode;
    }

    private TEPfmMonObjID getPfmMonObj(int slotid) {
        TEPfmMonObjID pfmmonobj = new TEPfmMonObjID();
        pfmmonobj.m_ulNEID = this.neid;
        pfmmonobj.m_usSlotID = slotid;
        pfmmonobj.m_usPortID = TEMaintenanceConstants.NEATTR_TEST_ITEM;
        pfmmonobj.m_usPathID = TEMaintenanceConstants.NEATTR_TEST_ITEM;
        pfmmonobj.m_usFBType = TEMaintenanceConstants.FB_FEC;
        pfmmonobj.decPathID();
        return pfmmonobj;
    }

    private void initSetAmParam(String params, boolean flg) {
        this.subFunc.clearQxMapping();
        QxMapping qxMap = new QxMapping();
        qxMap.setContent("NSCMD_CFG_SET_AM_PARAM");
        this.subFunc.addQxMapping(qxMap);
        this.inputData = this.parseParams(params);
        BussinessParams bus = this.inputData.getBussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        for (int i = 0; i < bus.getRowParamsCount(); ++i) {
            row = bus.getRowParams(i);
            Map<String, String> tmpAmAttr = this.amAttrs.get(row.getParam("slotid").getValue());
            if (tmpAmAttr == null) {
                bus.removeRowParams(row);
                --i;
                continue;
            }
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("amstate");
            if (flg) {
                param.setValue(String.valueOf("1"));
            } else {
                param.setValue(String.valueOf(0));
            }
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("ensuremode");
            if (flg) {
                param.setValue(tmpAmAttr.get("fullmode"));
            } else {
                param.setValue("255");
            }
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("fullmode");
            if (flg) {
                param.setValue(tmpAmAttr.get("fullmode"));
            } else {
                param.setValue("255");
            }
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("manualmode");
            if (flg) {
                param.setValue("255");
            } else {
                param.setValue(tmpAmAttr.get("ensuremode"));
            }
            row.addParam(param);
        }
    }

    private void initPfmParam(String params) {
        this.subFunc.clearQxMapping();
        this.subFunc.getOperObject().clearParam();
        QxMapping qxMap = new QxMapping();
        qxMap.setContent("NSCMD_PER_CLEAR_CURDATA_NEW");
        this.subFunc.addQxMapping(qxMap);
        Param fparam = new Param();
        fparam.setName("peid");
        this.subFunc.getOperObject().addParam(fparam);
        fparam = new Param();
        fparam.setName("objpara");
        this.subFunc.getOperObject().addParam(fparam);
        this.inputData = this.parseParams(params);
        BussinessParams bus = this.inputData.getBussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        RowParams tmpRow = null;
        TELParamMgr objTypeMgr = new TELParamMgr(this.neid);
        TEObjectParam objParam = null;
        for (int i = 0; i < bus.getRowParamsCount(); ++i) {
            row = bus.getRowParams(i);
            String slotid = row.getParam("slotid").getValue();
            Map<String, String> tmpAmAttr = this.amAttrs.get(slotid);
            if (tmpAmAttr == null) {
                bus.removeRowParams(row);
                --i;
                continue;
            }
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("peid");
            param.setValue(String.valueOf(136));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("period");
            param.setValue(String.valueOf(TEMaintenanceConstants.NEATTR_TEST_ITEM));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("reserve");
            param.setValue("255");
            row.addParam(param);
            List objParams = objTypeMgr.getObjectParams(this.getPfmMonObj(Integer.valueOf(slotid)), 252);
            int jLen = objParams.size();
            for (int j = 0; j < jLen; ++j) {
                tmpRow = (RowParams)row.clone();
                objParam = (TEObjectParam)objParams.get(j);
                param = new com.huawei.nglct.common.datainterface.Param();
                param.setName("objtype");
                param.setValue(objParam.getObjType());
                tmpRow.addParam(param);
                param = new com.huawei.nglct.common.datainterface.Param();
                param.setName("paralen");
                param.setValue(objParam.getParamLength());
                tmpRow.addParam(param);
                param = new com.huawei.nglct.common.datainterface.Param();
                param.setName("objpara");
                param.setValue(objParam.getObjParam());
                tmpRow.addParam(param);
                bus.addRowParams(tmpRow);
            }
            bus.removeRowParams(row);
        }
    }

    @Override
    protected void handleMessage(int neid, ArrayList<Operation> opers, SubFunc subFunc) {
        super.handleMessage(neid, opers, subFunc);
        if (String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode()) || String.valueOf(1).equals(this.outputData.getErrorMessage().getErrorcode())) {
            this.getTableColInfo();
        }
        this.dataInterfaces.put(this.getSlotidFromObjPara().toString(), this.outputData);
    }

    @Override
    protected void getTableColInfo() {
        ArrayList<ColInfoBean> cols = new ArrayList<ColInfoBean>();
        ColInfoBean col = null;
        int len = this.heads.length;
        for (int i = 0; i < len; ++i) {
            col = new ColInfoBean();
            col.id = this.heads[i];
            col.colName = this.resourceUtil.getString(this.heads[i]);
            col.colLen = this.getMaxLen(col);
            cols.add(col);
        }
        this.colInfos.put(this.getSlotidFromObjPara().toString(), cols);
    }

    @Override
    protected void refactor() {
        TEPfmMonObjID pfmMonObjID = this.getPfmMonObj(this.getSlotidFromObjPara());
        BussinessParams bus = this.outputData.getBussinessParams();
        RowParams row = bus.getRowParams(0);
        com.huawei.nglct.common.datainterface.Param param = new com.huawei.nglct.common.datainterface.Param();
        param.setName("pfmMonObj");
        param.setValue(pfmMonObjID.toString());
        row.addParam(param);
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent((int)pfmMonObjID.m_ulNEID, (int)pfmMonObjID.m_usSlotID, (int)Integer.valueOf(row.getParam("peid").getValue()));
        param = new com.huawei.nglct.common.datainterface.Param();
        param.setName("peName");
        param.setValue(event.getPeName());
        row.addParam(param);
        if (row.getParam("period") == null) {
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("period");
            param.setValue(this.resourceUtil.getString("period" + row.getParam("period").getValue()));
            row.addParam(param);
        } else {
            row.getParam("period").setValue(this.resourceUtil.getString("period" + row.getParam("period").getValue()));
        }
        param = new com.huawei.nglct.common.datainterface.Param();
        param.setName("beginTime");
        Calendar time = TEDateUtils.strToCalendar((String)TEDateUtils.byteStrToDateStr((String)row.getParam("startTime").getValue()));
        param.setValue(this.timeProccessor.calendarToTime(time));
        row.addParam(param);
        double peValue = TEPfmUtility.qx5Value2PfmValue((int)pfmMonObjID.m_ulNEID, (int)pfmMonObjID.m_usSlotID, (long)this.getPvalue(row.getParam("peValue").getValue()), (int)Integer.valueOf(row.getParam("peid").getValue()));
        row.getParam("peValue").setValue(String.valueOf(peValue));
    }

    private Integer getSlotidFromObjPara() {
        String objPara = this.outputData.getBussinessParams().getRowParams(0).getParam("objpara").getValue();
        return Integer.valueOf(objPara.substring(0, TEMaintenanceConstants.SPACE_LEN));
    }

    private long getPvalue(String value) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)value);
        long pValue = IOStreamConvertor.readLong((byte[])t, (int)0);
        if (pValue >= 0L) {
            return pValue;
        }
        return pValue + 1L;
    }

    private String getTestResult() {
        if (String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) {
            BussinessParams bus = this.outputData.getBussinessParams();
            int netype = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEType();
            boolean isEband = netype == 115;
            String testResultStr = this.resourceUtil.getString("check_result") + " ";
            testResultStr = bus == null ? (isEband ? testResultStr + this.resourceUtil.getString("amacChange2") + this.lineSep : testResultStr + this.resourceUtil.getString("amChange2") + this.lineSep) : (isEband ? testResultStr + this.resourceUtil.getString("amacChange1") + this.lineSep : testResultStr + this.resourceUtil.getString("amChange1") + this.lineSep);
            return testResultStr;
        }
        return "";
    }

    private void resetAmAtrr(String params) {
        this.initSetAmParam(params, true);
        this.inputData = this.parseParams(params);
        BussinessParams bus = this.inputData.getBussinessParams();
        RowParams row = null;
        com.huawei.nglct.common.datainterface.Param param = null;
        for (int i = 0; i < bus.getRowParamsCount(); ++i) {
            row = bus.getRowParams(i);
            Map<String, String> tmpAmAttr = this.amAttrs.get(row.getParam("slotid").getValue());
            if (tmpAmAttr == null) {
                bus.removeRowParams(row);
                --i;
                continue;
            }
            tmpAmAttr = this.amAttrs.get(row.getParam("slotid").getValue());
            row = bus.getRowParams(i);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("amstate");
            param.setValue(tmpAmAttr.get("amstate"));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("ensuremode");
            param.setValue(tmpAmAttr.get("ensuremode"));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("fullmode");
            param.setValue(tmpAmAttr.get("fullmode"));
            row.addParam(param);
            param = new com.huawei.nglct.common.datainterface.Param();
            param.setName("manualmode");
            param.setValue(tmpAmAttr.get("manualmode"));
            row.addParam(param);
        }
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)this.neid);
        if (this.opers.size() == 0) {
            return;
        }
        TECommuNEMgr.getInstance().sendCommand(this.neid, this.opers, 60, null);
    }
}

