/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nemgr.rtn.maintenance.ColInfoBean;
import com.huawei.nglct.nemgr.rtn.maintenance.TEMaintenanceConstants;
import com.huawei.nglct.nemgr.rtn.maintenance.TETestInter;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;

public abstract class TETestBase
implements TETestInter {
    TEResourceUtil resourceUtil;
    protected int neid;
    protected static final int TIME_OUT = 60;
    protected SubFunc subFunc;
    protected ArrayList<Operation> opers;
    protected Datainterface inputData;
    protected Datainterface outputData = new Datainterface();
    protected String[] heads;
    protected List<ColInfoBean> colInfo = new ArrayList<ColInfoBean>();
    protected String lineSep = System.getProperty("line.separator");

    protected byte[] getTestResInBytes() {
        byte[] remark = this.getHeadRemark();
        byte[] body = this.getBody();
        byte[] res = new byte[remark.length + body.length];
        System.arraycopy(remark, 0, res, 0, remark.length);
        System.arraycopy(body, 0, res, remark.length, body.length);
        return res;
    }

    @Override
    public byte[] startTest(int neid, String param, String extendparam) {
        this.initTestParam(neid, param);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)neid);
        if (null == this.opers || this.opers.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            OperationResult resultExtend = TECommuNEMgr.getInstance().sendCommand(neid, this.opers, 60, null);
            if (resultExtend.retCode == 0) {
                this.handleMessage(neid, this.opers, this.subFunc);
                if (String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode()) || String.valueOf(1).equals(this.outputData.getErrorMessage().getErrorcode())) {
                    this.getTableColInfo();
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)resultExtend.retCode));
            }
        }
        return this.getTestResInBytes();
    }

    @Override
    public byte[] startTest(int neid, String params) {
        this.initTestParam(neid, params);
        this.opers = TEDataConverter.convertToOperation((SubFunc)this.subFunc, (Datainterface)this.inputData, (int)neid);
        if (null == this.opers || this.opers.isEmpty()) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, this.opers, 60, null);
            if (result.retCode == 0) {
                this.handleMessage(neid, this.opers, this.subFunc);
                if (String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode()) || String.valueOf(1).equals(this.outputData.getErrorMessage().getErrorcode())) {
                    this.getTableColInfo();
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
            }
        }
        return this.getTestResInBytes();
    }

    private void initTestParam(int neid, String params) {
        this.neid = neid;
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)resPath);
        this.inputData = this.parseParams(params);
        this.subFunc = this.getSubFunc(params);
        this.heads = this.getHeads();
    }

    protected abstract Datainterface parseParams(String var1);

    protected abstract SubFunc getSubFunc(String var1);

    protected abstract String[] getHeads();

    protected abstract byte[] getHeadRemark();

    protected abstract String getErrBody();

    protected byte[] getBody() {
        StringBuilder res1 = new StringBuilder("");
        StringBuilder res2 = new StringBuilder("");
        String errCode = this.outputData.getErrorMessage().getErrorcode();
        if (!String.valueOf(0).equals(errCode)) {
            res2.append(this.outputData.getErrorMessage().getErrorinfo()).append(this.lineSep);
            BussinessParams bus = this.outputData.getBussinessParams();
            if (bus != null && bus.getRowParamsCount() > 0) {
                res2.append(this.getErrBody());
            }
            res2.append(this.lineSep);
        }
        if (String.valueOf(0).equals(errCode) || String.valueOf(1).equals(errCode)) {
            res1.append(this.getContentBody());
        }
        res1.append((CharSequence)res2);
        return res1.toString().getBytes();
    }

    protected String getContentBody() {
        StringBuilder res1 = new StringBuilder("");
        StringBuilder res2 = new StringBuilder("");
        ColInfoBean col = null;
        int len = this.colInfo.size();
        for (int i = 0; i < len; ++i) {
            col = this.colInfo.get(i);
            res1.append(this.getUnitStr(col.colName, col.colLen));
        }
        BussinessParams bus = this.outputData.getBussinessParams();
        RowParams row = null;
        Param param = null;
        int iLen = bus.getRowParamsCount();
        for (int i = 0; i < iLen; ++i) {
            row = bus.getRowParams(i);
            if (row.getRowErrors().length > 0) continue;
            int jLen = this.colInfo.size();
            for (int j = 0; j < jLen; ++j) {
                col = this.colInfo.get(j);
                param = row.getParam(col.id);
                if (param == null) break;
                res2.append(this.getUnitStr(param.getValue(), col.colLen));
            }
            res2.append(this.lineSep);
        }
        res1.append(this.lineSep);
        res2.append(this.lineSep);
        res1.append((CharSequence)res2);
        return res1.toString();
    }

    protected void handleMessage(int neid, ArrayList<Operation> opers, SubFunc subFunc) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subFunc, opers, (ArrayList)subFunc.getFilterErrCodeList());
        this.refactor();
    }

    protected void getTableColInfo() {
        ColInfoBean col = null;
        int len = this.heads.length;
        for (int i = 0; i < len; ++i) {
            col = new ColInfoBean();
            col.id = this.heads[i];
            col.colName = this.resourceUtil.getString(this.heads[i]);
            col.colLen = this.getMaxLen(col);
            this.colInfo.add(col);
        }
    }

    protected int getMaxLen(ColInfoBean col) {
        int curLen = this.getStrLength(col.colName);
        BussinessParams bus = this.outputData.getBussinessParams();
        RowParams row = null;
        String val = null;
        int tmpLen = 0;
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bus.getRowParams(i);
            if (row.getParam(col.id) == null || curLen >= (tmpLen = this.getStrLength(val = row.getParam(col.id).getValue()))) continue;
            curLen = tmpLen;
        }
        return curLen + TEMaintenanceConstants.SPACE_LEN;
    }

    protected int getMaxLen(ColInfoBean col, Datainterface outData) {
        int curLen = this.getStrLength(col.colName);
        BussinessParams bus = outData.getBussinessParams();
        RowParams row = null;
        String val = null;
        int tmpLen = 0;
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bus.getRowParams(i);
            if (row.getParam(col.id) == null || curLen >= (tmpLen = this.getStrLength(val = row.getParam(col.id).getValue()))) continue;
            curLen = tmpLen;
        }
        return curLen + TEMaintenanceConstants.SPACE_LEN;
    }

    protected int getStrLength(String value) {
        char[] charr = value.toCharArray();
        int length = 0;
        for (char ch : charr) {
            if (ch > '\u0080') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    protected void refactor() {
    }

    protected String getUnitStr(String val, int len) {
        int curLen = this.getStrLength(val);
        StringBuilder res = new StringBuilder(val);
        int iLen = len - curLen;
        for (int i = 0; i < iLen; ++i) {
            res.append(" ");
        }
        return res.toString();
    }

    protected String getBodyHead() {
        StringBuilder res = new StringBuilder("");
        ColInfoBean col = null;
        int len = this.colInfo.size();
        for (int i = 0; i < len; ++i) {
            col = this.colInfo.get(i);
            res.append(this.getUnitStr(col.colName, col.colLen));
        }
        res.append(this.lineSep);
        return res.toString();
    }
}

