/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.maintenance;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEAvailabeResQueryBean
implements TENEMgrInterface {
    private static final int AM_TEST = 1;
    private static final int J1_TEST = 2;
    private static final int ETH_TEST = 3;
    private static final int TDM_TEST = 4;
    private transient int neid;
    private transient Datainterface output;
    private static final transient Logger LOG = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams[] rowpa = inputData.getBussinessParams().getRowParams();
        int testType = Integer.parseInt(rowpa[0].getParam("testType").getValue());
        Vector boardList = TENEListMgr.getInstance().getNE(neid).getClonedBoardList();
        this.output = new Datainterface();
        this.output.setBussinessParams(new BussinessParams());
        switch (testType) {
            case 1: {
                this.getAMTestBoard(boardList);
                break;
            }
            case 2: {
                this.getJ1TestBoard(boardList);
                break;
            }
            case 3: {
                this.getETHTestBoard(boardList);
                break;
            }
            case 4: {
                this.getTDMTestBoard(boardList);
                break;
            }
            default: {
                LOG.error("no function!" + testType);
            }
        }
        this.output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return this.output;
    }

    private void getJ1TestBoard(List boardList) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_1J1PG");
        operationList.add(oper);
        Operation queryRadioState = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_RADIO_1J1PG_STATE");
        operationList.add(queryRadioState);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 20);
        if (result.retCode == 0) {
            Output[] radioOutputs = ((Operation)operationList.get(0)).getOutput();
            this.handleOutputOnSuccess(operationList, radioOutputs);
        }
    }

    private void handleOutputOnSuccess(List operationList, Output[] radioOutputs) {
        Output[] radioStateOutputs = ((Operation)operationList.get(1)).getOutput();
        int len = radioOutputs.length;
        for (int index = 0; index < len; ++index) {
            String workingSlot = "";
            String protectionSlot = "";
            String equipSlot = "";
            String protectionid = "";
            Output radioOutput = radioOutputs[index];
            if (!radioOutput.getFault()[0].getCode().equals("0")) continue;
            protectionSlot = radioOutput.getPartValue("protectionSlotId");
            workingSlot = radioOutput.getPartValue("workingSlotId");
            protectionid = radioOutput.getPartValue("groupId");
            try {
                radioOutput = radioStateOutputs[index];
                if (!radioOutput.getFault()[0].getCode().equals("0")) continue;
                equipSlot = radioOutput.getPartValue("equipSlotId");
                if (protectionSlot.equals(equipSlot)) {
                    String temp = protectionSlot;
                    protectionSlot = workingSlot;
                    workingSlot = temp;
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
            }
            if (workingSlot == null || workingSlot.equals("") || workingSlot.equals("0")) continue;
            TEBoard board = TENEListMgr.getInstance().getNE(this.neid).getBoard(Integer.parseInt(workingSlot));
            TEBoard pboard = TENEListMgr.getInstance().getNE(this.neid).getBoard(Integer.parseInt(protectionSlot));
            if (board.getBoardType() != 1548 && board.getBoardType() != 1549 && !TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TE_FUNC_RTN_CFG_IFINTERFACE", "TE_ATTR_RTN_ONETOUCHTEST_IS_LIKE_IFH_BOARD")) continue;
            RowParams rowparams = new RowParams();
            rowparams.addParam("groupid", protectionid);
            rowparams.addParam("slotid", workingSlot);
            rowparams.addParam("boardtype", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            rowparams.addParam("pslotid", protectionSlot);
            rowparams.addParam("pboardtype", String.valueOf(pboard.getBoardType()));
            rowparams.addParam("pboardname", pboard.getBoardName());
            this.output.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void getAMTestBoard(List boardList) {
        RowParams rowparams = null;
        TEBoard board = null;
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            if (board.getBoardType() != 1548 && board.getBoardType() != 1549 && board.getBoardType() != 2454 && !TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TE_FUNC_RTN_CFG_ONETOUCHTEST", "TE_ATTR_RTN_ONETOUCHTEST_BOARD_SUPPORT_AMTEST_BEFOREU2KV1R5")) continue;
            rowparams = new RowParams();
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardtype", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            this.output.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void getETHTestBoard(List boardList) {
        RowParams rowparams = null;
        TEBoard board = null;
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            if (board.getBoardType() != 1066 && board.getBoardType() != 1210 && board.getBoardType() != 1548 && board.getBoardType() != 2057 && board.getBoardType() != 1550 && board.getBoardType() != 2095 && board.getBoardType() != 2454 && !TESpecialAttrMgr.getInstance().isCPSupportByType(board.getBoardType(), "TE_FUNC_RTN_CFG_ONETOUCHTEST", "TE_ATTR_RTN_ONETOUCHTEST_BOARD_SUPPORT_ETHTEST")) continue;
            rowparams = new RowParams();
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardtype", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            this.output.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void getTDMTestBoard(List boardList) {
        RowParams rowparams = null;
        TEBoard board = null;
        int size = boardList.size();
        for (int j = 0; j < size; ++j) {
            board = (TEBoard)boardList.get(j);
            if (board.getBoardType() != 1030 && board.getBoardType() != 1031 && board.getBoardType() != 1179 && board.getBoardType() != 1180 && board.getBoardType() != 1217 && board.getBoardType() != 1218 && board.getBoardType() != 1551) continue;
            rowparams = new RowParams();
            rowparams.addParam("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam("boardtype", String.valueOf(board.getBoardType()));
            rowparams.addParam("boardname", board.getBoardName());
            this.output.getBussinessParams().addRowParams(rowparams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

