/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.linkalarm;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEQueryLinkParamsBean
extends TENEExplorerBean {
    private static final String DISABLE = "0";
    private static final int ETHBAND_UNIT = 1000;
    private static final String NARTN_DOMAIN = "nartn";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TEIFODUCommonBean.addServiceCapacityProcess(operationList);
        this.handleEthBandOperation(operationList);
        super.handleMessage(neid, operationList, subfunc);
        if (this.outputData.getBussinessParams().isEmpty()) {
            RowParams row = new RowParams();
            TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
            row.addParam("neid", String.valueOf(neid));
            row.addParam("nename", ne.getNEName());
            this.outputData.getBussinessParams().addRowParams(row);
        }
        this.refreshOutputData(neid, this.outputData);
    }

    private void refreshOutputData(int neid, Datainterface outputData) {
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        String domain = TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType());
        RowParams row = outputData.getBussinessParams().getRowParams(0);
        if (domain.equals(NARTN_DOMAIN)) {
            String[] displayAttr = new String[]{"IFPORT_ATTR_E1STATUS", "IFPORT_ATTR_ENSUREE1NUM_RANGE"};
            Param param = null;
            int len = displayAttr.length;
            for (int i = 0; i < len; ++i) {
                param = row.getParam(displayAttr[i]);
                if (param == null) continue;
                param.setValue("");
            }
        }
    }

    private void handleEthBandOperation(List<Operation> operationList) {
        String amStatus = this.getParamValueInOper(operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ACMENABLESTATUS");
        String ensureMode = this.getParamValueInOper(operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ENSURECALMODE");
        String fullMode = this.getParamValueInOper(operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_ALLCALMODE");
        String manualMode = this.getParamValueInOper(operationList, "NSCMD_PTN_CFG_GET_ACM_PARAM", "W32PORT_ATTR_MANUALMODE");
        String mode = "";
        int iLen = operationList.size();
        for (int i = 0; i < iLen; ++i) {
            Operation oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0)) || !"NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM_CFG".equals(oper.getName())) continue;
            Output ensureOutput = null;
            Output fullOutput = null;
            int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
            if (0 != errCode) continue;
            Output output = null;
            for (int j = oper.getOutputCount() - 1; j >= 0; --j) {
                output = oper.getOutput(j);
                if (output.getPart("ethband") == null) continue;
                mode = output.getPartValue("mode");
                output.setPartValue("ethband", this.countEthBand(output.getPartValue("ethband")));
                if (amStatus.equals(DISABLE)) {
                    if (manualMode.equals(mode)) {
                        ensureOutput = output;
                    }
                } else {
                    if (ensureMode.equals(mode)) {
                        ensureOutput = output;
                    }
                    if (mode.equals(fullMode)) {
                        fullOutput = output;
                    }
                }
                oper.removeOutput(j);
            }
            if (fullOutput != null) {
                String ethband = ensureOutput.getPartValue("ethband") + "-" + fullOutput.getPartValue("ethband");
                String e1capacity = ensureOutput.getPartValue("IFPORT_ATTR_ENSUREE1NUM") + "-" + fullOutput.getPartValue("IFPORT_ATTR_ENSUREE1NUM");
                String e1capacityrange = "0-" + fullOutput.getPartValue("IFPORT_ATTR_ENSUREE1NUM_RANGE");
                ensureOutput.setPartValue("ethband", ethband);
                ensureOutput.setPartValue("IFPORT_ATTR_ENSUREE1NUM", e1capacity);
                ensureOutput.setPartValue("IFPORT_ATTR_ENSUREE1NUM_RANGE", e1capacityrange);
            }
            if (ensureOutput == null) continue;
            oper.addOutput(ensureOutput);
        }
    }

    private String countEthBand(String ethvalue) {
        int value = Integer.parseInt(ethvalue);
        return String.valueOf((float)value / 1000.0f);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList errorList = super.getFilterErrorCodeList();
        errorList.add(38737);
        errorList.add(37898);
        errorList.add(38664);
        errorList.add(39185);
        errorList.add(38751);
        errorList.add(38737);
        return errorList;
    }

    private String getParamValueInOper(List<Operation> opers, String operName, String param) {
        String res = null;
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = opers.get(i);
            if (!operName.equals(oper.getName())) continue;
            Output output = oper.getOutput(0);
            res = output.getPartValue(param);
        }
        return res;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

