/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.linkalarm;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEAlarm;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmUtil;
import com.huawei.nglct.nemgr.rtn.linkalarm.TERTNProtectionBean;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class TEQueryLinkBoardBean
extends TENEExplorerBean {
    private static final String NSCMD_CFG_GET_RADIO_1J1PG_STATE = "NSCMD_CFG_GET_RADIO_1J1PG_STATE";
    private static final String NSCMD_CFG_GET_ODU_MUTE = "NSCMD_CFG_GET_ODU_MUTE";
    private static final String NSCMD_CFG_GET_ODU_RPOWER = "NSCMD_CFG_GET_ODU_RPOWER";
    private static final int INVALID_GROUP_ID = -1;
    private int slotRelation = 0;
    private boolean isQueryAlarm = true;
    private boolean isQueryODU = true;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams row;
        this.user = user;
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts() && 1 != currentNE.getLogStatus()) {
            TEHandleSbiInfo.getInstance().handleSBIConnectOnInter(neid);
        }
        if ((row = inputData.getBussinessParams().getRowParams(0)).getParam("isNoAlarm") != null && row.getParam("isNoAlarm").getValue().equals("true")) {
            this.isQueryAlarm = false;
        }
        if (row.getParam("isNoODU") != null && row.getParam("isNoODU").getValue().equals("true")) {
            this.isQueryODU = false;
        }
        this.TIME_OUT = 20;
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        int neType = TEConfigurationDataMgr.getInstance().getNE(neid).getNEType();
        this.slotRelation = TEEquipmentDescription.getInstance().getSlotRelation(TEGetNEDomainVersion.getInstance().getDevType(neType));
        BussinessParams inputBussiness = this.inputData.getBussinessParams();
        if (inputBussiness.getRowParamsCount() == 0 || inputBussiness.getRowParams(0).getParam("slotid") == null) {
            TELogFactory.getNormalLogger().warn("Input param slotid is null!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090732534));
            return;
        }
        int slotid = Integer.parseInt(inputBussiness.getRowParams(0).getParam("slotid").getValue());
        TERTNProtectionBean protection = null;
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            protection = this.getRTNProtection(this.outputData.getBussinessParams(), slotid);
        }
        if (protection != null) {
            protection = this.queryRTN1J1PGState(neid, protection);
        } else {
            protection = new TERTNProtectionBean();
            protection.setWorkSlotId(slotid);
        }
        if (this.isQueryODU) {
            this.getODUStatus(protection);
        }
        BussinessParams newBussiness = this.constructOutputData(neid, protection);
        BussinessParams outBussiness = this.outputData.getBussinessParams();
        if (outBussiness.getRowParamsCount() > 0 && outBussiness.getRowParams(0).getRowErrorsCount() > 0 && newBussiness.getRowParamsCount() > 0) {
            newBussiness.getRowParams(0).setRowErrors(outBussiness.getRowParams(0).getRowErrors());
        }
        this.outputData.setBussinessParams(newBussiness);
    }

    private List<Operation> getQueryODUStatusOperations(TERTNProtectionBean protection) {
        Operation operMute = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_CFG_GET_ODU_MUTE);
        Operation operPower = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_CFG_GET_ODU_RPOWER);
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        if (operMute == null || operPower == null) {
            TELogFactory.getNormalLogger().warn("operMute or operPower is null!");
            return operationList;
        }
        int oduslotid = protection.getWorkSlotId() + this.slotRelation;
        Operation operTemp = (Operation)operMute.clone();
        operTemp.getInput().setPartValue("slotid", String.valueOf(oduslotid));
        operationList.add(operTemp);
        operTemp = (Operation)operPower.clone();
        operTemp.getInput().setPartValue("slotid", String.valueOf(oduslotid));
        operationList.add(operTemp);
        if (protection.getGroupId() != -1) {
            oduslotid = protection.getProtectSlotId() + this.slotRelation;
            operTemp = (Operation)operMute.clone();
            operTemp.getInput().setPartValue("slotid", String.valueOf(oduslotid));
            operationList.add(operTemp);
            operTemp = (Operation)operPower.clone();
            operTemp.getInput().setPartValue("slotid", String.valueOf(oduslotid));
            operationList.add(operTemp);
        }
        return operationList;
    }

    private void getODUStatus(TERTNProtectionBean protection) {
        List<Operation> operationList = this.getQueryODUStatusOperations(protection);
        if (operationList.isEmpty()) {
            TELogFactory.getNormalLogger().warn("getODUStatus operationList is null!");
            return;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, this.TIME_OUT);
        if (result.retCode != 0) {
            TELogFactory.getNormalLogger().warn("getODUStatus sendMessage fail! errorCode=" + result.retCode);
            return;
        }
        this.refreshODUStatusFromOperation(protection, operationList);
    }

    private void refreshODUStatusFromOperation(TERTNProtectionBean protection, List<Operation> operationList) {
        Operation operTemp = null;
        Output output = null;
        int mute = -1;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            int workslotid;
            operTemp = operationList.get(i);
            output = operTemp.getOutput(0);
            if (!output.getFault(0).getCode().equals(String.valueOf(0))) continue;
            int oduslotid = Integer.parseInt(output.getPartValue("slotid"));
            if (operTemp.getName().equals(NSCMD_CFG_GET_ODU_MUTE)) {
                mute = Integer.parseInt(output.getPartValue("W32BRD_ATTR_SWITCHSTATUS"));
                if (oduslotid == protection.getWorkSlotId() + this.slotRelation) {
                    protection.setWorkODUStatus(mute);
                    continue;
                }
                protection.setProtectODUStatus(mute);
                continue;
            }
            if (!operTemp.getName().equals(NSCMD_CFG_GET_ODU_RPOWER) || oduslotid != (workslotid = protection.getWorkSlotId() + this.slotRelation)) continue;
            protection.setWorkODUTSL((short)new BigInteger(output.getPartValue("W32BRD_ATTR_ACTTRANSMITPOWER")).intValue());
            protection.setWorkODURSL((short)new BigInteger(output.getPartValue("W32BRD_ATTR_ACTRECEIVEPOWER")).intValue());
        }
    }

    public BussinessParams constructOutputData(int neid, TERTNProtectionBean protection) {
        BussinessParams outputBussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        Param param = new Param("groupid", String.valueOf(protection.getGroupId()));
        rowparams.addParam(param);
        param = new Param("grouptype", String.valueOf(protection.getGroupType()));
        rowparams.addParam(param);
        rowparams.addParam(new Param("neid", String.valueOf(neid)));
        TENE localNe = TEConfigurationDataMgr.getInstance().getNE(neid);
        String localNEIP = localNe.getNeIp();
        if (localNEIP == null || localNEIP.equals("")) {
            localNEIP = localNe.getNEGWAddress();
        }
        rowparams.addParam(new Param("neip", localNEIP));
        rowparams.addParam(new Param("nename", localNe.getNEName()));
        rowparams.addParam(new Param("realneid", String.valueOf(localNe.getRealNEID())));
        this.addBoardParam(rowparams, neid, protection.getWorkSlotId(), "wif");
        int oduslotid = this.slotRelation + protection.getWorkSlotId();
        this.addBoardParam(rowparams, neid, oduslotid, "wodu");
        param = new Param("wodumute", String.valueOf(protection.getWorkODUStatus()));
        rowparams.addParam(param);
        if (protection.getWorkODUTSL() != -1000) {
            param = new Param("wodutsl", String.valueOf((float)protection.getWorkODUTSL() / 10.0f));
            rowparams.addParam(param);
        }
        if (protection.getWorkODURSL() != -1000) {
            param = new Param("wodursl", String.valueOf((float)protection.getWorkODURSL() / 10.0f));
            rowparams.addParam(param);
        }
        if (protection.getGroupId() != -1) {
            this.addBoardParam(rowparams, neid, protection.getProtectSlotId(), "pif");
            oduslotid = this.slotRelation + protection.getProtectSlotId();
            this.addBoardParam(rowparams, neid, oduslotid, "podu");
            param = new Param("podumute", String.valueOf(protection.getProtectODUStatus()));
            rowparams.addParam(param);
        }
        outputBussiness.addRowParams(rowparams);
        return outputBussiness;
    }

    private void addBoardParam(RowParams rowparams, int neid, int slotid, String preFix) {
        TEConfigurationDataMgr cdatamgr = TEConfigurationDataMgr.getInstance();
        Param param = new Param(preFix + "slotid", String.valueOf(slotid));
        rowparams.addParam(param);
        int boardtype = cdatamgr.getBoardType(neid, slotid);
        param = new Param(preFix + "boardtype", String.valueOf(boardtype));
        rowparams.addParam(param);
        String boardName = cdatamgr.getBoardName(neid, slotid);
        if (boardName == null || boardName.isEmpty()) {
            boardName = "UNKOWN";
        }
        param = new Param(preFix + "boardname", boardName);
        rowparams.addParam(param);
        param = new Param(preFix + "boardstate", String.valueOf(this.isPhyBoard(neid, slotid, boardtype)));
        rowparams.addParam(param);
        if (this.isQueryAlarm) {
            param = new Param(preFix + "alarmlevel", String.valueOf(this.getBoardAlamLevel(neid, slotid)));
            rowparams.addParam(param);
        }
    }

    private int getBoardAlamLevel(int neid, int slotid) {
        int level = -1;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            ArrayList<Integer> slotList = new ArrayList<Integer>();
            slotList.add(slotid);
            List alarmList = TEAlarmUtil.queryNEAlarm((String)this.user, (int)neid, (int)((Object)((Object)this)).hashCode(), slotList);
            if (null != alarmList && !alarmList.isEmpty()) {
                int exigenceAlmCount = 0;
                int primaryAlmCount = 0;
                int secondaryAlmCount = 0;
                int promptAlmCount = 0;
                int size = alarmList.size();
                block6: for (int i = 0; i < size; ++i) {
                    TEAlarm tempAlm = (TEAlarm)alarmList.get(i);
                    switch (tempAlm.getAlarmLevel()) {
                        case 1: {
                            ++exigenceAlmCount;
                            continue block6;
                        }
                        case 2: {
                            ++primaryAlmCount;
                            continue block6;
                        }
                        case 3: {
                            ++secondaryAlmCount;
                            continue block6;
                        }
                        case 4: {
                            ++promptAlmCount;
                            continue block6;
                        }
                    }
                }
                level = exigenceAlmCount != 0 ? 1 : (primaryAlmCount != 0 ? 2 : (secondaryAlmCount != 0 ? 3 : (promptAlmCount != 0 ? 4 : 0)));
            }
        } else {
            TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
            level = ne.getCurTopLevelAlm(slotid);
        }
        return level;
    }

    private boolean isPhyBoard(int neid, int slotid, int boardtype) {
        boolean isPhyboard = false;
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        TEBoard board = ne.getPhyBoard(slotid);
        if (board != null && board.getBoardType() == boardtype) {
            isPhyboard = true;
        }
        return isPhyboard;
    }

    private TERTNProtectionBean queryRTN1J1PGState(int neid, TERTNProtectionBean protection) {
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_RADIO_1J1PG_STATE);
        if (oper == null) {
            return protection;
        }
        oper.getInput().setPartValue("groupId", String.valueOf(protection.getGroupId()));
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, this.TIME_OUT);
        if (result.retCode != 0) {
            return protection;
        }
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        if (output.getFault(0).getCode().equals(String.valueOf(0))) {
            int equipSlot = Integer.parseInt(output.getPartValue("equipSlotId"));
            if (protection.getProtectSlotId() == equipSlot) {
                equipSlot = protection.getWorkSlotId();
                protection.setWorkSlotId(protection.getProtectSlotId());
                protection.setProtectSlotId(equipSlot);
            }
        }
        return protection;
    }

    private TERTNProtectionBean getRTNProtection(BussinessParams bussiness, int slotid) {
        RowParams row = null;
        TERTNProtectionBean protection = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() != 0) continue;
            int groupID = Integer.parseInt(row.getParam("groupId").getValue());
            int groupType = Integer.parseInt(row.getParam("wMode").getValue());
            int workSlot = Integer.parseInt(row.getParam("workingSlotId").getValue());
            int protectSlot = Integer.parseInt(row.getParam("protectionSlotId").getValue());
            if (workSlot != slotid && protectSlot != slotid) continue;
            protection = new TERTNProtectionBean();
            protection.setGroupId(groupID);
            protection.setGroupType(groupType);
            protection.setWorkSlotId(workSlot);
            protection.setProtectSlotId(protectSlot);
            break;
        }
        return protection;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList errorList = super.getFilterErrorCodeList();
        errorList.add(38662);
        errorList.add(38410);
        errorList.add(38153);
        errorList.add(37898);
        return errorList;
    }
}

