/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.licensemgr_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.rtn.licensemgr_v2r8c01.HybridLincense;
import com.huawei.nglct.nemgr.rtn.licensemgr_v2r8c01.TEDownLoadLsReport;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TEGetHybridLicenseBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "rtn" + File.separator + "res" + File.separator + "licensemgr" + File.separator + "licensemgrres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static final String INVALID_VALUE = "65535";
    private static final String INVALID_VALUE_1 = "65534";
    private static final String AMFILE_VALUE = "1";
    private static final String E1_VALUE = "7";
    private static final String AIRCOMPRESS_VALUE = "9";
    private static final String GEPORTFILE_VALUE = "11";
    private static final String XPIC_VALUE = "12";
    private static final String STM_1_VALUE = "30";
    private static final String POE_VALUE = "31";
    private static final String LCS_1024QAM_VALUE = "16";
    private static final String CHANNEL250M_VALUE = "37";
    private String line = System.getProperty("line.separator");

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int faultCode = Integer.parseInt(output.getFault(0).getCode());
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        if (faultCode == 0 || this.getFilterErrorCodeList().contains(faultCode)) {
            RowParams[] rowdatas = this.outputData.getBussinessParams().getRowParams();
            int len = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                if (rowdatas[i].getParam("nename") == null) continue;
                rowdatas[i].getParam("nename").setValue(nename);
            }
        }
        this.createSaveAsFile(neid);
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(38664);
        list.add(47034);
        list.add(38663);
        list.add(44818);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSaveAsFile(int neid) {
        boolean isSuccess;
        String fileName = TEDownLoadLsReport.getSaveFilePath(neid);
        File file = new File(fileName);
        if (file.exists() && !(isSuccess = file.delete())) {
            TELogFactory.getNormalLogger().info("delete " + file.getName() + " failed!");
        }
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
            out.write(this.getSaveAsString());
            out.flush();
            this.safeCloseFileStream(out);
        }
        catch (IOException e) {
            try {
                TELogFactory.getNormalLogger().debug("save as file falil!", (Throwable)e);
                this.safeCloseFileStream(out);
            }
            catch (Throwable throwable) {
                this.safeCloseFileStream(out);
                throw throwable;
            }
        }
    }

    private void safeCloseFileStream(Writer fileStream) {
        if (fileStream != null) {
            try {
                fileStream.close();
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().info("close file stream failed!", (Throwable)ex);
            }
        }
    }

    private String getSaveAsString() {
        this.resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)STRING_SOURCE);
        ArrayList<String> column1 = new ArrayList<String>();
        column1.add(this.resourceUtil.getString("board"));
        ArrayList<String> column2 = new ArrayList<String>();
        column2.add(this.resourceUtil.getString("filetype"));
        ArrayList<String> column3 = new ArrayList<String>();
        column3.add(this.resourceUtil.getString("actualCapacity"));
        ArrayList<String> column4 = new ArrayList<String>();
        column4.add(this.resourceUtil.getString("load"));
        ArrayList<HybridLincense> licenseList = new ArrayList<HybridLincense>();
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        int m = bussinessParams.getRowParamsCount();
        for (int i = 0; i < m; ++i) {
            RowParams rp = bussinessParams.getRowParams(i);
            if (rp.getParamCount() == 0) continue;
            HybridLincense license = new HybridLincense();
            license.setObjecDes(this.getBoardDesc(rp));
            license.setFileType(this.getFileTypeDesc(rp));
            license.setActualCapacity(this.getActCapDesc(rp));
            license.setLoad(this.getLoadDesc(rp));
            licenseList.add(license);
        }
        Comparator<HybridLincense> licenseCompara = new Comparator<HybridLincense>(){

            @Override
            public int compare(HybridLincense o1, HybridLincense o2) {
                return o1.getObjecDes().compareToIgnoreCase(o2.getObjecDes());
            }
        };
        Collections.sort(licenseList, licenseCompara);
        for (int i = 0; i < licenseList.size(); ++i) {
            column1.add(((HybridLincense)licenseList.get(i)).getObjecDes());
            column2.add(((HybridLincense)licenseList.get(i)).getFileType());
            column3.add(((HybridLincense)licenseList.get(i)).getActualCapacity());
            column4.add(((HybridLincense)licenseList.get(i)).getLoad());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t").append(this.resourceUtil.getString("license")).append(this.line).append(this.line);
        int maxLength1 = this.getMaxLength(column1);
        int maxLength2 = this.getMaxLength(column2);
        int maxLength3 = this.getMaxLength(column3);
        int n = column1.size();
        for (int j = 0; j < n; ++j) {
            String str = (String)column1.get(j);
            sb.append(str).append(this.getSpace(maxLength1, str));
            str = (String)column2.get(j);
            sb.append(str).append(this.getSpace(maxLength2, str));
            str = (String)column3.get(j);
            sb.append(str).append(this.getSpace(maxLength3, str));
            str = (String)column4.get(j);
            sb.append(str).append(this.line);
        }
        return sb.toString();
    }

    private boolean isSupportFileType(String filetype) {
        boolean ret = false;
        int[] array = new int[]{4, 5, 6, 8, 10, 13, 14, 15, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36};
        for (int i = 0; i < array.length; ++i) {
            if (!Integer.toString(array[i]).equals(filetype)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private String getBoardDesc(RowParams rp) {
        Param filetypeParam = rp.getParam("filetype");
        String tmpFileTypeValue = filetypeParam.getValue();
        Param nameParam = rp.getParam("nename");
        String nename = null == nameParam ? "" : nameParam.getValue();
        Param slotParam = rp.getParam("slotid");
        Param boardName = rp.getParam("boardname");
        String neSlotBoardStr = null;
        for (int i = rp.getParamCount() - 1; i > 0; --i) {
            Param tmpParam = rp.getParam(i);
            if (!"boardname".equals(tmpParam.getName()) || "".equals(tmpParam.getValue())) continue;
            boardName = tmpParam;
            break;
        }
        neSlotBoardStr = this.isSupportFileType(tmpFileTypeValue) || GEPORTFILE_VALUE.equals(tmpFileTypeValue) ? nename : ((AMFILE_VALUE.equals(tmpFileTypeValue) || E1_VALUE.equals(tmpFileTypeValue) || AIRCOMPRESS_VALUE.equals(tmpFileTypeValue) || XPIC_VALUE.equals(tmpFileTypeValue) || LCS_1024QAM_VALUE.equals(tmpFileTypeValue) || "24".equals(tmpFileTypeValue) || CHANNEL250M_VALUE.equals(tmpFileTypeValue)) && INVALID_VALUE.equals(slotParam.getValue()) ? nename : nename + "-" + slotParam.getValue() + "-" + boardName.getValue());
        return neSlotBoardStr;
    }

    private String getFileTypeDesc(RowParams rp) {
        Param filetypeParam = rp.getParam("filetype");
        String tmpFileTypeValue = filetypeParam.getValue();
        String filetypeStr = "-";
        String[] filetypeArray = new String[]{this.resourceUtil.getString("amfile"), this.resourceUtil.getString("hbridfile"), this.resourceUtil.getString("tdmfile"), this.resourceUtil.getString("type1588file"), this.resourceUtil.getString("imafile"), this.resourceUtil.getString("radiofile"), this.resourceUtil.getString("e1file"), this.resourceUtil.getString("syncethfile"), this.resourceUtil.getString("compressfile"), this.resourceUtil.getString("mplsfile"), this.resourceUtil.getString("geportfile"), this.resourceUtil.getString("xpicfile"), this.resourceUtil.getString("erpsfile"), this.resourceUtil.getString("plafile"), this.resourceUtil.getString("e1capcityfile"), this.resourceUtil.getString("highmodefile"), this.resourceUtil.getString("plus1to1file"), this.resourceUtil.getString("enhancedqosfile"), this.resourceUtil.getString("combo9051cfile"), this.resourceUtil.getString("secondiffile"), this.resourceUtil.getString("mplstpoamfile"), this.resourceUtil.getString("fademarginfile"), this.resourceUtil.getString("wredfunctionfile"), this.resourceUtil.getString("amacfile"), this.resourceUtil.getString("l3file"), this.resourceUtil.getString("highqosfile"), this.resourceUtil.getString("l2dcnfile"), this.resourceUtil.getString("exty1731file"), this.resourceUtil.getString("lldpfile"), this.resourceUtil.getString("stm_1file"), this.resourceUtil.getString("poefile"), this.resourceUtil.getString("is3file"), this.resourceUtil.getString("fpmfile"), this.resourceUtil.getString("subchannel"), this.resourceUtil.getString("cpri_125g"), this.resourceUtil.getString("cpri_25g"), this.resourceUtil.getString("channel250M"), this.resourceUtil.getString("-")};
        for (int i = 0; i < filetypeArray.length; ++i) {
            if (!Integer.toString(i + 1).equals(tmpFileTypeValue)) continue;
            filetypeStr = filetypeArray[i];
            break;
        }
        return filetypeStr;
    }

    private String getActCapDesc(RowParams rp) {
        Param filetypeParam = rp.getParam("filetype");
        String tmpFileTypeValue = filetypeParam.getValue();
        Param actCapParam = rp.getParam("actualCapacity");
        String tmpActCapValue = actCapParam.getValue();
        Param cTypeParam = rp.getParam("actualCapacityType");
        String tmpCTypeValue = cTypeParam.getValue();
        Param tdmCapacity = rp.getParam("tdmCapacity");
        String tdmCapacityValue = tdmCapacity.getValue();
        String actCapStr = "-";
        Param slotParam = rp.getParam("slotid");
        if (AMFILE_VALUE.equals(tmpFileTypeValue) || E1_VALUE.equals(tmpFileTypeValue) || AIRCOMPRESS_VALUE.equals(tmpFileTypeValue) || GEPORTFILE_VALUE.equals(tmpFileTypeValue) || XPIC_VALUE.equals(tmpFileTypeValue) || LCS_1024QAM_VALUE.equals(tmpFileTypeValue) || "24".equals(tmpFileTypeValue) || CHANNEL250M_VALUE.equals(tmpFileTypeValue) || STM_1_VALUE.equals(tmpFileTypeValue) || POE_VALUE.equals(tmpFileTypeValue)) {
            actCapStr = INVALID_VALUE.equals(slotParam.getValue()) ? (INVALID_VALUE_1.equals(tmpActCapValue) ? "MAX" : (CHANNEL250M_VALUE.equals(tmpFileTypeValue) || AIRCOMPRESS_VALUE.equals(tmpFileTypeValue) || "24".equals(tmpFileTypeValue) || XPIC_VALUE.equals(tmpFileTypeValue) || AMFILE_VALUE.equals(tmpFileTypeValue) || LCS_1024QAM_VALUE.equals(tmpFileTypeValue) || E1_VALUE.equals(tmpFileTypeValue) || STM_1_VALUE.equals(tmpFileTypeValue) || POE_VALUE.equals(tmpFileTypeValue) ? tmpActCapValue + '*' + this.resourceUtil.getString("enabled") : (GEPORTFILE_VALUE.equals(tmpFileTypeValue) ? tmpActCapValue + '*' + this.resourceUtil.getString("port") : tdmCapacityValue + '*' + this.resourceUtil.getString("enabled")))) : (INVALID_VALUE.equals(tmpActCapValue) || INVALID_VALUE_1.equals(tmpActCapValue) ? "-" : this.resourceUtil.getString("amfile" + tmpActCapValue));
        } else if (this.isSupportFileType(tmpFileTypeValue)) {
            actCapStr = "0".equals(tmpActCapValue) ? this.resourceUtil.getString("amfile0") : this.resourceUtil.getString("amfile1");
        } else {
            String typeName = "capacity" + tmpCTypeValue;
            actCapStr = INVALID_VALUE.equals(tmpActCapValue) || INVALID_VALUE_1.equals(tmpActCapValue) ? "MAX" : tmpActCapValue + this.resourceUtil.getString(typeName);
        }
        return actCapStr;
    }

    private String getLoadDesc(RowParams rp) {
        Param loadParam = rp.getParam("load");
        String tmpLoadValue = loadParam.getValue();
        String loadStr = "-";
        if ("0".equals(tmpLoadValue)) {
            loadStr = this.resourceUtil.getString("loadno");
        } else if (AMFILE_VALUE.equals(tmpLoadValue)) {
            loadStr = this.resourceUtil.getString("loadyes");
        }
        return loadStr;
    }

    private int getMaxLength(List<String> column) {
        int maxLength = 0;
        for (String str : column) {
            int length = this.getChineseLength(str);
            if (length <= maxLength) continue;
            maxLength = length;
        }
        return maxLength;
    }

    private int getChineseLength(String value) {
        char[] charr = value.toCharArray();
        int length = 0;
        for (char ch : charr) {
            if (ch > '\u0080') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    private String getSpace(int length, String str) {
        StringBuilder sb = new StringBuilder();
        int m = length - this.getChineseLength(str);
        for (int i = 0; i < m; ++i) {
            sb.append(" ");
        }
        sb.append("\t");
        return sb.toString();
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        super.writeLog(neid, subfunc, this.getWriteLogInputData(inputData), user, ipAddress, outputData);
    }

    private Datainterface getWriteLogInputData(Datainterface inputData) {
        Datainterface newData = new Datainterface();
        BussinessParams newBussinessParams = new BussinessParams();
        newData.setBussinessParams(newBussinessParams);
        if (null == inputData || null == inputData.getBussinessParams()) {
            return inputData;
        }
        ArrayList rowparamsList = inputData.getBussinessParams().getRowParamList();
        int paramSize = rowparamsList.size();
        if (0 == paramSize || 1 == paramSize) {
            return inputData;
        }
        newBussinessParams.addRowParams((RowParams)((RowParams)rowparamsList.get(0)).clone());
        return newData;
    }
}

