/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.interfreinterface_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEQueryRPTPortsForLinkage
implements TENEMgrInterface {
    private static final int TIME_OUT = 10;
    private static final String CPRI_TYPE = "30";
    private final Logger logger = TELogFactory.getNormalLogger();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Datainterface data = new Datainterface();
        boolean isDynPortBoardType = false;
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int slotid = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid).getBoardType();
        isDynPortBoardType = TEConfigurationDataMgr.getInstance().isDynPortBoardType(neid, boardType);
        List portList = isDynPortBoardType ? this.getUseablePort(neid) : TEConfigurationDataMgr.getInstance().getPortListFromPortType(neid, boardType, 1799);
        if (portList.size() == 0) {
            data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        BussinessParams bParams = new BussinessParams();
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            int portid = Integer.valueOf(String.valueOf(portList.get(i)));
            RowParams rowParams = this.genPortRowParams(neid, slotid, boardType, portid);
            bParams.addRowParams(rowParams);
        }
        data.setBussinessParams(bParams);
        data.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        return data;
    }

    private RowParams genPortRowParams(int neid, int slotid, int boardType, int portid) {
        RowParams rowParams = new RowParams();
        String portName = TEConfigurationDataMgr.getInstance().getPortNameForPTN(neid, slotid, boardType, portid);
        Param param = new Param("slotid", slotid + "");
        rowParams.addParam(param);
        param = new Param("boardtype", TEConfigurationDataMgr.getInstance().getBoardName(neid, slotid));
        rowParams.addParam(param);
        param = new Param("portid", portid + "");
        rowParams.addParam(param);
        param = new Param("portname", portName);
        rowParams.addParam(param);
        return rowParams;
    }

    private List getUseablePort(int neid) {
        ArrayList<String> portIdList = new ArrayList<String>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_SUBBD_GET_PORT_WBID");
        if (null == oper) {
            this.logger.info("Can not get Operation for get sub port");
            return portIdList;
        }
        Input input = oper.getInput();
        Part part = input.getPart("slotid");
        part.setValue("1");
        part = input.getPart("port");
        part.setValue("0");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)10).retCode;
        if (result == 0) {
            for (Output output : oper.getOutput()) {
                Part portType;
                if (!"0".equals(output.getFault()[0].getCode()) || (portType = output.getPart("ATTR_ETHOVERPTN_LOGIC_PORTTYPE")) == null || CPRI_TYPE.equals(portType.getValue())) continue;
                portIdList.add(output.getPartValue("port"));
            }
        }
        return portIdList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

