/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.interfreinterface_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.explorer.beanplugin.TEMODBMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.dbmgr.QxOperation2DBMaping;
import com.huawei.nglct.nemgr.dbmgr.TENEQxDBMgrSuperBean;
import com.huawei.nglct.nemgr.dbmgr.TEWebLCTDBGenCfgUtil;
import com.huawei.nglct.po.embeddednemgrmo.gencfg.TEWebLCTBoardGenCfgMOPO;
import com.huawei.nglct.util.errinfo.TECommonResult;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEConvertEnsureE1AndFullE1ToDB
extends TENEQxDBMgrSuperBean {
    private int ID_OBJECT_TYPE_NE_BOARD_PORT = 61443;
    private String DEFAULT_ENSUREE1_NUM = "4";
    private String DEFAULT_FULLE1_NUM = "255";
    private String DBATTRNAME_ENSUREE1NUM = "IFPORT_ATTR_ENSUREE1NUM";
    private String DBATTRNAME_FULLE1NUM = "IFPORT_ATTR_FULLE1NUM";
    private String DBATTRNAME_ENSUREMODE = "W32PORT_ATTR_ENSURECALMODE";
    private String DBATTRNAME_ALLMODE = "W32PORT_ATTR_ALLCALMODE";
    private String DBATTRNAME_ETHBAND = "ethband";
    protected String QXATTRNAME_REPLACEABLE_ENSUREE1NUM = "IFPORT_ATTR_ENSUREE1NUM";
    protected String QXATTRNAME_REPLACEABLE_FULLE1NUM = "IFPORT_ATTR_ENSUREE1NUM_RANGE";
    protected String QXATTRNAME_REPLACEABLE_PORTID = "port";
    private final Logger logger = TELogFactory.getNormalLogger();

    public void processQxOperationFromDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        this.logger.info("TEConvertEnsureE1AndFullE1ToDB:start refactor operation from DB! the operation name is " + oper.getName());
        TEMODBMgr dbmgr = new TEMODBMgr();
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        int portid = Integer.parseInt(oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID));
        TEWebLCTBoardGenCfgMOPO ensureE1MO = this.queryBoardGenCfgMO(ne, oper, this.DBATTRNAME_ENSUREE1NUM);
        TEWebLCTBoardGenCfgMOPO fullE1MO = this.queryBoardGenCfgMO(ne, oper, this.DBATTRNAME_FULLE1NUM);
        TEErrInfoReturn result_ensure = new TEErrInfoReturn();
        TEErrInfoReturn result_full = new TEErrInfoReturn();
        if (ensureE1MO == null) {
            ensureE1MO = new TEWebLCTBoardGenCfgMOPO();
            ensureE1MO.setAttrName(this.DBATTRNAME_ENSUREE1NUM);
            ensureE1MO.setAttrValue(this.DEFAULT_ENSUREE1_NUM);
            ensureE1MO.setExtendPara1("");
            ensureE1MO.setExtendPara2("");
            ensureE1MO.setExtendPara3("");
            ensureE1MO.setGrade(-1);
            ensureE1MO.setLevel(-1);
            ensureE1MO.setObjectType(this.ID_OBJECT_TYPE_NE_BOARD_PORT);
            ensureE1MO.setPath(-1);
            ensureE1MO.setPort(portid);
            ensureE1MO.setSlotId(slotid);
            result_ensure = dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)ensureE1MO);
        }
        if (fullE1MO == null) {
            fullE1MO = new TEWebLCTBoardGenCfgMOPO();
            fullE1MO.setAttrName(this.DBATTRNAME_FULLE1NUM);
            fullE1MO.setAttrValue(this.DEFAULT_FULLE1_NUM);
            fullE1MO.setExtendPara1("");
            fullE1MO.setExtendPara2("");
            fullE1MO.setExtendPara3("");
            fullE1MO.setGrade(-1);
            fullE1MO.setLevel(-1);
            fullE1MO.setObjectType(this.ID_OBJECT_TYPE_NE_BOARD_PORT);
            fullE1MO.setPath(-1);
            fullE1MO.setPort(portid);
            fullE1MO.setSlotId(slotid);
            result_full = dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)fullE1MO);
        }
        TEErrInfoReturn finalResult = result_ensure.getResult() == 0 ? result_full : result_ensure;
        this.refactorOper(ne.getNEID(), finalResult, oper, ensureE1MO, fullE1MO);
        this.logger.info("TEConvertEnsureE1AndFullE1ToDB:start refactor operation from DB! the operation name is " + oper.getName());
    }

    private void refactorOper(int neid, TEErrInfoReturn result, Operation oper, TEWebLCTBoardGenCfgMOPO ensureE1MO, TEWebLCTBoardGenCfgMOPO fullE1MO) {
        TEErrInfoReturn errInfo = result;
        if (errInfo.getResult() != 0) {
            this.refactorFault(oper, errInfo);
            return;
        }
        oper.clearOutput();
        try {
            this.fillOutPut(neid, oper, ensureE1MO, fullE1MO);
        }
        catch (Exception e) {
            this.logger.info("TEConvertEnsureE1AndFullE1ToDB,fillOutput throws a Exception.", (Throwable)e);
        }
    }

    private void fillOutPut(int neid, Operation oper, TEWebLCTBoardGenCfgMOPO ensureE1MO, TEWebLCTBoardGenCfgMOPO fullE1MO) {
        this.addOutPut(neid, oper, ensureE1MO, fullE1MO, true);
        this.addOutPut(neid, oper, ensureE1MO, fullE1MO, false);
    }

    private void addOutPut(int neid, Operation oper, TEWebLCTBoardGenCfgMOPO ensureE1MO, TEWebLCTBoardGenCfgMOPO fullE1MO, boolean isEnsure) {
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        TENE currentNE = TENEListMgr.getInstance().getNE(neid);
        int bdType = currentNE.getBoard(slotid).getBoardType();
        boolean isIFBoard = TEConfigurationDataMgr.getInstance().isIFboard(bdType);
        if (!isIFBoard) {
            return;
        }
        TEWebLCTDBGenCfgUtil util = new TEWebLCTDBGenCfgUtil(neid);
        TEWebLCTBoardGenCfgMOPO ensureCalModeMO = util.queryAttrFromBoardDB(ensureE1MO.getSlotId(), this.DBATTRNAME_ENSUREMODE);
        TEWebLCTBoardGenCfgMOPO allCalModeMO = util.queryAttrFromBoardDB(ensureE1MO.getSlotId(), this.DBATTRNAME_ALLMODE);
        TEWebLCTBoardGenCfgMOPO e1Mo = isEnsure ? ensureE1MO : fullE1MO;
        TEWebLCTBoardGenCfgMOPO modeMo = isEnsure ? ensureCalModeMO : allCalModeMO;
        Output output = new Output();
        Fault fault = new Fault();
        fault.setCode(String.valueOf(0));
        output.addFault(fault);
        Part part = new Part();
        part.setName("slotid");
        part.setValue(String.valueOf(e1Mo.getSlotId()));
        output.addPart(part);
        part = new Part();
        part.setName("subslotid");
        part.setValue("255");
        output.addPart(part);
        part = new Part();
        part.setName(this.QXATTRNAME_REPLACEABLE_PORTID);
        part.setValue("" + e1Mo.getPort());
        output.addPart(part);
        part = new Part();
        part.setName("mode");
        part.setValue(modeMo.getAttrValue());
        output.addPart(part);
        part = new Part();
        part.setName(this.QXATTRNAME_REPLACEABLE_ENSUREE1NUM);
        part.setValue(e1Mo.getAttrValue());
        output.addPart(part);
        part = new Part();
        part.setName(this.QXATTRNAME_REPLACEABLE_FULLE1NUM);
        part.setValue("75");
        output.addPart(part);
        part = new Part();
        part.setName("ethband");
        part.setValue("0");
        output.addPart(part);
        oper.addOutput(output);
    }

    private void refactorFault(Operation oper, TEErrInfoReturn result) {
        Output out = oper.getOutput(0);
        out.clearFault();
        Fault newFault = new Fault();
        if (0 == result.getResult()) {
            newFault.setCode(String.valueOf(0));
        } else {
            newFault.setCode(String.valueOf(result.getResult()));
        }
        oper.getOutput(0).addFault(newFault);
    }

    private TEWebLCTBoardGenCfgMOPO queryBoardGenCfgMO(TENE ne, Operation oper, String attrName) {
        TEWebLCTBoardGenCfgMOPO resultMO = null;
        TEMODBMgr dbmgr = new TEMODBMgr();
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID);
        ArrayList<TEDaoNameValuePair> criteriaList = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair = new TEDaoNameValuePair();
        pair.setName("Port");
        pair.setValue(portid);
        criteriaList.add(pair);
        pair = new TEDaoNameValuePair();
        pair.setName("AttrName");
        pair.setValue(attrName);
        criteriaList.add(pair);
        TECommonResult moResult = dbmgr.getMOFromDB(ne.getNEID(), slotid, TEWebLCTBoardGenCfgMOPO.class, criteriaList);
        if (moResult.getErrInfoRet().getResult() == 0 && moResult.getReturnObject() != null && ((List)moResult.getReturnObject()).size() > 0) {
            resultMO = (TEWebLCTBoardGenCfgMOPO)((List)moResult.getReturnObject()).get(0);
        }
        return resultMO;
    }

    public void processQxOperationToDB(TENE ne, Operation oper, QxOperation2DBMaping mapping) {
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID);
        ArrayList<TEDaoNameValuePair> criteriaList = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair = new TEDaoNameValuePair();
        pair.setName("Port");
        pair.setValue(portid);
        criteriaList.add(pair);
        TEWebLCTDBGenCfgUtil util = new TEWebLCTDBGenCfgUtil(ne.getNEID());
        TEWebLCTBoardGenCfgMOPO ensureCalModeMO = util.queryAttrFromBoardDB(criteriaList, slotid, this.DBATTRNAME_ENSUREMODE);
        ArrayList<TEDaoNameValuePair> criteriaList1 = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair pair1 = new TEDaoNameValuePair();
        pair1.setName("Port");
        pair1.setValue(portid);
        criteriaList1.add(pair1);
        TEWebLCTBoardGenCfgMOPO allCalModeMO = util.queryAttrFromBoardDB(criteriaList1, slotid, this.DBATTRNAME_ALLMODE);
        ArrayList criteriaList2 = new ArrayList();
        TEDaoNameValuePair pair2 = new TEDaoNameValuePair();
        pair2.setName("Port");
        pair2.setValue(portid);
        criteriaList.add(pair2);
        TEWebLCTBoardGenCfgMOPO ensureCalModeMO2 = util.queryAttrFromBoardDB(criteriaList2, slotid, "W32PORT_ATTR_MANUALMODE");
        if (oper.getOutput() == null || oper.getOutput().length == 0) {
            return;
        }
        if (ensureCalModeMO == null || allCalModeMO == null) {
            return;
        }
        String ensureCalModeValue = ensureCalModeMO.getAttrValue();
        String allCalModeValue = allCalModeMO.getAttrValue();
        String manModeValue = ensureCalModeMO2.getAttrValue();
        TEMODBMgr dbmgr = new TEMODBMgr();
        String ethbandLow = "";
        String ethbandHigh = "";
        for (int i = 0; i < oper.getOutputCount(); ++i) {
            String mode = oper.getOutput(i).getPartValue("mode");
            if (mode == null) continue;
            if (mode.equals(ensureCalModeValue) || mode.equals(manModeValue)) {
                TEErrInfoReturn result_ensure;
                ethbandLow = oper.getOutput(i).getPartValue("ethband");
                if (mode.equals(manModeValue)) {
                    ethbandHigh = oper.getOutput(i).getPartValue("ethband");
                }
                if ((result_ensure = this.createOrUpdateEnsureE1NumToDB((TEMODBMgr<TEWebLCTBoardGenCfgMOPO>)dbmgr, ne, oper, i)).getResult() != 0) {
                    this.logger.info("TEConvertEnsureE1AndFullE1ToDB:Store Ensure E1 error.");
                    return;
                }
            }
            if (!mode.equals(allCalModeValue)) continue;
            ethbandHigh = oper.getOutput(i).getPartValue("ethband");
            TEErrInfoReturn result_full = this.createOrUpdateFullE1NumToDB((TEMODBMgr<TEWebLCTBoardGenCfgMOPO>)dbmgr, ne, oper, i);
            if (result_full.getResult() == 0) continue;
            this.logger.info("TEConvertEnsureE1AndFullE1ToDB:Store Full E1 error.");
            return;
        }
        this.createOrUpdateEthBandToDB((TEMODBMgr<TEWebLCTBoardGenCfgMOPO>)dbmgr, ne, oper, ethbandLow, ethbandHigh);
    }

    private TEErrInfoReturn createOrUpdateEnsureE1NumToDB(TEMODBMgr<TEWebLCTBoardGenCfgMOPO> dbmgr, TENE ne, Operation oper, int i) {
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID);
        String e1num = oper.getOutput(i).getPartValue(this.QXATTRNAME_REPLACEABLE_ENSUREE1NUM);
        TEWebLCTBoardGenCfgMOPO ensureE1MO = this.queryBoardGenCfgMO(ne, oper, this.DBATTRNAME_ENSUREE1NUM);
        TEErrInfoReturn result_ensure = new TEErrInfoReturn();
        if (ensureE1MO != null) {
            ensureE1MO.setAttrValue(e1num);
            result_ensure = dbmgr.updateMOToDB(ne.getNEID(), slotid, (Object)ensureE1MO);
        } else {
            ensureE1MO = new TEWebLCTBoardGenCfgMOPO();
            ensureE1MO.setAttrName(this.DBATTRNAME_ENSUREE1NUM);
            ensureE1MO.setAttrValue(e1num);
            ensureE1MO.setExtendPara1("");
            ensureE1MO.setExtendPara2("");
            ensureE1MO.setExtendPara3("");
            ensureE1MO.setGrade(-1);
            ensureE1MO.setLevel(-1);
            ensureE1MO.setObjectType(this.ID_OBJECT_TYPE_NE_BOARD_PORT);
            ensureE1MO.setPath(-1);
            ensureE1MO.setPort(Integer.parseInt(portid));
            ensureE1MO.setSlotId(slotid);
            result_ensure = dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)ensureE1MO);
        }
        return result_ensure;
    }

    private TEErrInfoReturn createOrUpdateFullE1NumToDB(TEMODBMgr<TEWebLCTBoardGenCfgMOPO> dbmgr, TENE ne, Operation oper, int i) {
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID);
        String e1num = oper.getOutput(i).getPartValue(this.QXATTRNAME_REPLACEABLE_ENSUREE1NUM);
        TEWebLCTBoardGenCfgMOPO fullE1MO = this.queryBoardGenCfgMO(ne, oper, this.DBATTRNAME_FULLE1NUM);
        TEErrInfoReturn result_ensure = new TEErrInfoReturn();
        if (fullE1MO != null) {
            fullE1MO.setAttrValue(e1num);
            result_ensure = dbmgr.updateMOToDB(ne.getNEID(), slotid, (Object)fullE1MO);
        } else {
            fullE1MO = new TEWebLCTBoardGenCfgMOPO();
            fullE1MO.setAttrName(this.DBATTRNAME_FULLE1NUM);
            fullE1MO.setAttrValue(e1num);
            fullE1MO.setExtendPara1("");
            fullE1MO.setExtendPara2("");
            fullE1MO.setExtendPara3("");
            fullE1MO.setGrade(-1);
            fullE1MO.setLevel(-1);
            fullE1MO.setObjectType(this.ID_OBJECT_TYPE_NE_BOARD_PORT);
            fullE1MO.setPath(-1);
            fullE1MO.setPort(Integer.parseInt(portid));
            fullE1MO.setSlotId(slotid);
            result_ensure = dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)fullE1MO);
        }
        return result_ensure;
    }

    private TEErrInfoReturn createOrUpdateEthBandToDB(TEMODBMgr<TEWebLCTBoardGenCfgMOPO> dbmgr, TENE ne, Operation oper, String ethbandLow, String ethbandHigh) {
        TEErrInfoReturn result_ensure = new TEErrInfoReturn();
        String slotidStr = oper.getInput().getPartValue("slotid");
        if (TEStringUtils.isEmpty((String)slotidStr)) {
            slotidStr = oper.getInput().getPartValue("ifslotid");
        }
        int slotid = Integer.parseInt(slotidStr);
        String portid = oper.getInput().getPartValue(this.QXATTRNAME_REPLACEABLE_PORTID);
        if (ethbandLow == null || ethbandHigh == null || "".equals(ethbandLow) && "".equals(ethbandHigh)) {
            return result_ensure;
        }
        String ethBandValue = ethbandLow.equals(ethbandHigh) ? "" + Float.parseFloat(ethbandLow) / 1000.0f : Float.parseFloat(ethbandLow) / 1000.0f + "-" + Float.parseFloat(ethbandHigh) / 1000.0f;
        TEWebLCTBoardGenCfgMOPO ethBandMO = this.queryBoardGenCfgMO(ne, oper, this.DBATTRNAME_ETHBAND);
        if (ethBandMO != null) {
            ethBandMO.setAttrValue(ethBandValue);
            result_ensure = dbmgr.updateMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
        } else {
            ethBandMO = new TEWebLCTBoardGenCfgMOPO();
            ethBandMO.setAttrName(this.DBATTRNAME_ETHBAND);
            ethBandMO.setAttrValue(ethBandValue);
            ethBandMO.setExtendPara1("");
            ethBandMO.setExtendPara2("");
            ethBandMO.setExtendPara3("");
            ethBandMO.setGrade(-1);
            ethBandMO.setLevel(-1);
            ethBandMO.setObjectType(this.ID_OBJECT_TYPE_NE_BOARD_PORT);
            ethBandMO.setPath(-1);
            ethBandMO.setPort(Integer.parseInt(portid));
            ethBandMO.setSlotId(slotid);
            result_ensure = dbmgr.createMOToDB(ne.getNEID(), slotid, (Object)ethBandMO);
        }
        return result_ensure;
    }
}

