/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.interfreinterface;

import com.huawei.nglct.nemgr.dbmgr.TEBoardScriptDescrip;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEIfCfgDataMgr {
    public static final int MODE_128QAM = 5;
    public static final int MODE_256QAM = 6;
    public static final int MODE_512QAM = 7;
    public static final int MODE_1024QAM = 8;
    public static final int MODE_512QAMLight = 11;
    public static final int MODE_1024QAMLight = 12;
    public static final int BANDWIDTH_7M = 2;
    public static final int BANDWIDTH_14M = 3;
    public static final int BANDWIDTH_28M = 4;
    public static final int BANDWIDTH_40M = 5;
    public static final int BANDWIDTH_56M = 6;
    public static final int BANDWIDTH_FCC50M = 9;
    private static TEIfCfgDataMgr instance = null;
    private static List<TEBoardScriptDescrip> supportAttrList = new ArrayList<TEBoardScriptDescrip>();
    private static Map<String, String> bandWidthMap = new Hashtable<String, String>();
    private static Map<String, String> modeMap = new Hashtable<String, String>();
    private static Map<String, Integer> modeStr2IntMap = new Hashtable<String, Integer>();
    private static Map<String, Integer> bandWidthStr2IntMap = new Hashtable<String, Integer>();

    public static synchronized TEIfCfgDataMgr getInstance() {
        if (null == instance) {
            instance = new TEIfCfgDataMgr();
        }
        return instance;
    }

    public List<TEBoardScriptDescrip> getSupportAttrList() {
        return supportAttrList;
    }

    private TEIfCfgDataMgr() {
        supportAttrList.add(new TEBoardScriptDescrip("link_id", "W32PORT_ATTR_RADIOLINKID", false));
        supportAttrList.add(new TEBoardScriptDescrip("work_mode", "W32PORT_ATTR_RADIOWORKMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("1588oh_en", "W32PORT_ATTR_1588GAPENABLED", false));
        supportAttrList.add(new TEBoardScriptDescrip("atpc_en", "W32PORT_ATTR_ATPCENABLE", false));
        supportAttrList.add(new TEBoardScriptDescrip("atpc_upperth", "W32PORT_ATTR_ATPCUPPER", false));
        supportAttrList.add(new TEBoardScriptDescrip("atpc_lowerth", "W32PORT_ATTR_ATPCLOWER", false));
        supportAttrList.add(new TEBoardScriptDescrip("service_type", "IFPORT_ATTR_SERVICETYPE", false));
        supportAttrList.add(new TEBoardScriptDescrip("bandwidth", "W32PORT_ATTR_CHANNELSPACE", false));
        supportAttrList.add(new TEBoardScriptDescrip("am_en", "W32PORT_ATTR_ACMENABLESTATUS", false));
        supportAttrList.add(new TEBoardScriptDescrip("am_guaranteed_mode", "W32PORT_ATTR_ENSURECALMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("am_full_mode", "W32PORT_ATTR_ALLCALMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("modulation_mode", "W32PORT_ATTR_MANUALMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("e1priority_en", "IFPORT_ATTR_E1STATUS", false));
        supportAttrList.add(new TEBoardScriptDescrip("guarantee_e1cap", "IFPORT_ATTR_ENSUREE1NUM", false));
        supportAttrList.add(new TEBoardScriptDescrip("full_e1cap", "IFPORT_ATTR_FULLE1NUM", false));
        supportAttrList.add(new TEBoardScriptDescrip("running_mode", "W32PORT_ATTR_IFRUNNINGMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_RECRADIOLINKID", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_PORTLOOPBACK", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_WAYSIDEENABLE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_WAYSIDEINPUT", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_350MWAVESTATE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_XPICENABLED", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_AMBOOSTSTATUS", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "IFPORT_ATTR_STM1NUM", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_SENDMODID", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_RECEIVEMODID", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_ENSUREAMMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_ALLAMMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_ACMSENDMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_ACMRECEIVEMODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32BRD_ATTR_FACTORYCODE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32BRD_ATTR_LOWFRE", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "IFPORT_ATTR_HYBRIDNUM", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_AMWORKMODE_RANGE_MIN", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32PORT_ATTR_AMWORKMODE_RANGE_MAX", false));
        supportAttrList.add(new TEBoardScriptDescrip("", "W32BRD_ATTR_CONFIGTRANSMITPOWER", false));
        bandWidthMap.put("1", "3.5M");
        bandWidthMap.put("2", "7M");
        bandWidthMap.put("3", "14M");
        bandWidthMap.put("4", "28M");
        bandWidthMap.put("5", "40M");
        bandWidthMap.put("6", "56M");
        bandWidthMap.put("9", "FCC50M");
        bandWidthMap.put("10", "250M");
        bandWidthMap.put("11", "500M");
        bandWidthMap.put("12", "750M");
        bandWidthMap.put("13", "FCC250M");
        bandWidthMap.put("14", "FCC500M");
        modeMap.put("1", "QPSK");
        modeMap.put("2", "16QAM");
        modeMap.put("3", "32QAM");
        modeMap.put("4", "64QAM");
        modeMap.put("5", "128QAM");
        modeMap.put("6", "256QAM");
        modeMap.put("7", "512QAM");
        modeMap.put("8", "1024QAM");
        modeMap.put("9", "QPSKStrong");
        modeMap.put("10", "16QAMStrong");
        modeMap.put("11", "512QAMLight");
        modeMap.put("12", "1024QAMLight");
        modeMap.put("13", "2048QAM");
        modeMap.put("14", "QPSKStrong_250M");
        modeMap.put("15", "QPSKStrong_500M");
        modeMap.put("255", "NULL");
        modeMap.put("-1", "NULL");
        bandWidthStr2IntMap.put("3.5M", 1);
        bandWidthStr2IntMap.put("7M", 2);
        bandWidthStr2IntMap.put("14M", 3);
        bandWidthStr2IntMap.put("28M", 4);
        bandWidthStr2IntMap.put("40M", 5);
        bandWidthStr2IntMap.put("56M", 6);
        bandWidthStr2IntMap.put("FCC50M", 9);
        bandWidthStr2IntMap.put("FCC40M", 8);
        bandWidthStr2IntMap.put("FCC30M", 7);
        bandWidthStr2IntMap.put("250M", 10);
        bandWidthStr2IntMap.put("500M", 11);
        bandWidthStr2IntMap.put("750M", 12);
        bandWidthStr2IntMap.put("FCC250M", 13);
        bandWidthStr2IntMap.put("FCC500M", 14);
        modeStr2IntMap.put("QPSKSTRONG", 9);
        modeStr2IntMap.put("QPSK", 1);
        modeStr2IntMap.put("16QAMSTRONG", 10);
        modeStr2IntMap.put("16QAM", 2);
        modeStr2IntMap.put("32QAM", 3);
        modeStr2IntMap.put("64QAM", 4);
        modeStr2IntMap.put("128QAM", 5);
        modeStr2IntMap.put("256QAM", 6);
        modeStr2IntMap.put("512QAM", 7);
        modeStr2IntMap.put("512QAMLIGHT", 11);
        modeStr2IntMap.put("1024QAM", 8);
        modeStr2IntMap.put("1024QAMLIGHT", 12);
        modeStr2IntMap.put("2048QAM", 13);
        modeStr2IntMap.put("QPSKStrong_250M", 14);
        modeStr2IntMap.put("QPSKStrong_500M", 15);
    }

    public Set<String> getSupportDBAttrList() {
        HashSet<String> set = new HashSet<String>();
        int len = supportAttrList.size();
        for (int i = 0; i < len; ++i) {
            set.add(supportAttrList.get(i).getDbName());
        }
        return set;
    }

    public String getBandWidthScriptDescrip(String key) {
        String value = bandWidthMap.get(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    public String getModeScriptDescrip(String key) {
        String value = modeMap.get(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    public int getModeIntValue(String key) {
        int result = 0;
        Integer value = modeStr2IntMap.get(key);
        if (value != null) {
            result = value;
        }
        return result;
    }

    public int getBandWidthIntValue(String key) {
        int result = 0;
        Integer value = bandWidthStr2IntMap.get(key);
        if (value != null) {
            result = value;
        }
        return result;
    }
}

