/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_v2r8c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public class TEQueryIFODUGroup
extends TENEExplorerBean {
    protected int IFODUSLOTVALUE = 20;
    private TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
    private LinkedHashSet<Integer> ifboardlist = new LinkedHashSet();
    private LinkedHashSet<Integer> ifphyboardlist = new LinkedHashSet();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Output output;
        try {
            this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryIFODUGroup fail!", (Throwable)e);
        }
        this.hadelboard();
        Operation operation = (Operation)operationList.get(0);
        int faultCode = -1;
        if (operation.getOutputCount() > 0 && (output = operation.getOutput(0)).getFault(0).getCode() != null) {
            faultCode = Integer.parseInt(output.getFault(0).getCode());
        }
        if (faultCode == 0) {
            if (this.outputData.getBussinessParams().getRowParamsCount() > 0) {
                this.handleData(this.outputData);
            }
        } else {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
        }
        Iterator ib = this.ifboardlist.iterator();
        while (ib.hasNext()) {
            int oduboardid;
            int boardid;
            int boardtype;
            TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
            if (!instance.isIFboard(boardtype = instance.getBoardType(neid, boardid = ((Integer)ib.next()).intValue())) || !this.ifboardlist.contains(oduboardid = boardid + this.IFODUSLOTVALUE)) continue;
            RowParams rowparm = new RowParams();
            rowparm.addParam("workingSlotId", boardid + "");
            if (this.ifphyboardlist.contains(boardid)) {
                rowparm.addParam("workifphy", "1");
            }
            rowparm.addParam("workingbdname", this.getBoardName(boardid));
            rowparm.addParam("workingbdtype", String.valueOf(boardtype));
            rowparm.addParam("workingbdrumode", "");
            rowparm.addParam("workoduid", oduboardid + "");
            if (this.ifphyboardlist.contains(oduboardid)) {
                rowparm.addParam("workoduphy", "1");
            }
            this.outputData.getBussinessParams().addRowParams(rowparm);
        }
        this.sortResultByBoard();
    }

    private void hadelboard() {
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        Vector boardList = ne.getClonedBoardList();
        Vector pboard = ne.getClonedPhyBoardList();
        block0: for (int i = pboard.size() - 1; i >= 0; --i) {
            for (int j = boardList.size() - 1; j >= 0; --j) {
                TEBoard phyBoard = (TEBoard)pboard.get(i);
                TEBoard logicalBoard = (TEBoard)boardList.get(j);
                if (phyBoard.getSlotID() != logicalBoard.getSlotID() || phyBoard.getBoardType() == logicalBoard.getBoardType()) continue;
                pboard.remove(i);
                continue block0;
            }
        }
        this.doBoardList(boardList, this.ifboardlist);
        this.doBoardList(pboard, this.ifphyboardlist);
    }

    private void doBoardList(Vector<TEBoard> boardList, LinkedHashSet<Integer> ifBoardList) {
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            TEBoard board = boardList.get(i);
            int slotId = board.getSlotID();
            int boardType = board.getBoardType();
            if (this.instance.isIFboard(boardType)) {
                ifBoardList.add(slotId);
            }
            if (boardType != 1405) continue;
            ifBoardList.add(slotId);
        }
    }

    private void handleData(Datainterface outputData) {
        RowParams[] rowdatas = outputData.getBussinessParams().getRowParams();
        int len = rowdatas.length;
        TEConfigurationDataMgr instance = TEConfigurationDataMgr.getInstance();
        for (int i = 0; i < len; ++i) {
            int workifid = 0;
            int protectifid = 0;
            Param para = rowdatas[i].getParam("workingSlotId");
            if (para != null && !"".equals(para.getValue())) {
                workifid = Integer.parseInt(para.getValue());
                rowdatas[i].addParam("workingbdname", this.getBoardName(workifid));
                rowdatas[i].addParam("workingbdtype", String.valueOf(instance.getBoardType(this.neid, workifid)));
                if (this.ifphyboardlist.contains(workifid)) {
                    rowdatas[i].addParam("workifphy", "1");
                }
                this.ifboardlist.remove(workifid);
            }
            if ((para = rowdatas[i].getParam("protectionSlotId")) == null || "".equals(para.getValue())) continue;
            protectifid = Integer.parseInt(para.getValue());
            rowdatas[i].addParam("protectbdname", this.getBoardName(protectifid));
            rowdatas[i].addParam("protectbdtype", String.valueOf(instance.getBoardType(this.neid, protectifid)));
            rowdatas[i].addParam("protectbdrumode", "");
            if (this.ifphyboardlist.contains(protectifid)) {
                rowdatas[i].addParam("protectifphy", "1");
            }
            this.ifboardlist.remove(protectifid);
            rowdatas[i].addParam("workoduid", workifid + this.IFODUSLOTVALUE + "");
            rowdatas[i].addParam("protectoduid", protectifid + this.IFODUSLOTVALUE + "");
            this.ifboardlist.remove(workifid + this.IFODUSLOTVALUE);
            this.ifboardlist.remove(protectifid + this.IFODUSLOTVALUE);
            if (this.ifphyboardlist.contains(workifid + this.IFODUSLOTVALUE)) {
                rowdatas[i].addParam("workoduphy", "1");
            }
            if (!this.ifphyboardlist.contains(protectifid + this.IFODUSLOTVALUE)) continue;
            rowdatas[i].addParam("protectoduphy", "1");
        }
    }

    private String getBoardName(int slotid) {
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board == null) {
            return "";
        }
        int boardtype = board.getBoardType();
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    protected void sortResultByBoard() {
        for (int i = this.outputData.getBussinessParams().getRowParamsCount(); i > 1; --i) {
            int jLength = this.outputData.getBussinessParams().getRowParamsCount() - 1;
            for (int j = 0; j < jLength; ++j) {
                String iworkingSlotId = this.outputData.getBussinessParams().getRowParams(j).getParam("workingSlotId").getValue();
                String jworkingSlotId = this.outputData.getBussinessParams().getRowParams(j + 1).getParam("workingSlotId").getValue();
                if (Integer.parseInt(iworkingSlotId) <= Integer.parseInt(jworkingSlotId)) continue;
                RowParams temp = this.outputData.getBussinessParams().getRowParams(j);
                this.outputData.getBussinessParams().setRowParams(j, this.outputData.getBussinessParams().getRowParams(j + 1));
                this.outputData.getBussinessParams().setRowParams(j + 1, temp);
            }
        }
    }
}

