/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.rtn.ifoduconfig_u2kv1r5global.TEIFODUCommonBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TESetIFODUBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String BASE_PATH = "rtn" + File.separator + "res" + File.separator;
    private static final String STRING_SOURCE = BASE_PATH + "ifoduconfig" + File.separator + "ifres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private static List<String> IFCmdList = new ArrayList<String>();
    private static List<String> ODUCmdList = new ArrayList<String>();
    private static List<String> TrasactionCmdList = new ArrayList<String>();
    private static final List<String> RefCmdList = new ArrayList<String>();
    private static final String TRASN_START = "NSCMD_CFG_TRANSACTION_BEGIN";
    private static final String TRASN_END = "NSCMD_CFG_TRANSACTION_END";
    private static int SET_TIME_OUT = 80;
    private static final String NSCMD_CFG_SET_RADIO_SERVICETYPE_WBID = "NSCMD_CFG_SET_RADIO_SERVICETYPE_WBID";
    private static final String NSCMD_CFG_SET_HYBRID_STM1CAPACITY_WBID = "NSCMD_CFG_SET_HYBRID_STM1CAPACITY_WBID";
    private static final String IFPORT_ATTR_SERVICETYPE = "IFPORT_ATTR_SERVICETYPE";
    private static final String IFPORT_ATTR_SERVICETYPE_1 = "1";
    private static final List<Operation> OPERS_OF_ADJUST_FORWARD = new ArrayList<Operation>();
    private static final List<Operation> OPERS_OF_ADJUST_BACKWARD = new ArrayList<Operation>();
    private static final List<Operation> OPERS_OF_ADJUST_BACKWARD_NEXT = new ArrayList<Operation>();
    private static final List<Operation> OPERS_OF_DELAY_SEND_ADJOINLINKID = new ArrayList<Operation>();

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        TEIFODUCommonBean.removeIndalidParam(rows);
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        this.processAfterGetOpers(operList);
        if (this.isNeedFilterOperationList(neid)) {
            TEIFODUCommonBean.filterOperationList(neid, operList, IFCmdList, ODUCmdList);
        }
        if (this.isNeedAddTransaction()) {
            this.addTransaction(operList);
        }
        return operList;
    }

    private void processAfterGetOpers(List<Operation> opers) {
        OPERS_OF_ADJUST_FORWARD.clear();
        OPERS_OF_ADJUST_BACKWARD.clear();
        OPERS_OF_ADJUST_BACKWARD_NEXT.clear();
        ArrayList<Operation> adjustOpers_forward = new ArrayList<Operation>();
        ArrayList<Operation> adjustOpers_backward = new ArrayList<Operation>();
        ArrayList<Operation> adjustOpers_backward_next = new ArrayList<Operation>();
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Operation oper = iter.next();
            if (NSCMD_CFG_SET_RADIO_SERVICETYPE_WBID.equals(oper.getName())) {
                String serviceType = oper.getInput().getPart(IFPORT_ATTR_SERVICETYPE).getValue();
                if (IFPORT_ATTR_SERVICETYPE_1.equals(serviceType)) {
                    adjustOpers_forward.add(oper);
                } else {
                    adjustOpers_backward.add(oper);
                }
                iter.remove();
            }
            if (NSCMD_CFG_SET_HYBRID_STM1CAPACITY_WBID.equals(oper.getName())) {
                adjustOpers_backward_next.add(oper);
                iter.remove();
            }
            if (!"NSCMD_CFG_SET_RADIO_ADJOIN_LINKID".equals(oper.getName())) continue;
            OPERS_OF_DELAY_SEND_ADJOINLINKID.add(oper);
            iter.remove();
        }
        OPERS_OF_ADJUST_FORWARD.addAll(adjustOpers_forward);
        OPERS_OF_ADJUST_BACKWARD.addAll(adjustOpers_backward);
        OPERS_OF_ADJUST_BACKWARD_NEXT.addAll(adjustOpers_backward_next);
        if (opers.isEmpty()) {
            opers.addAll(OPERS_OF_ADJUST_BACKWARD);
            if (!OPERS_OF_ADJUST_BACKWARD.isEmpty()) {
                OPERS_OF_ADJUST_BACKWARD_NEXT.addAll(0, opers);
            }
            OPERS_OF_ADJUST_BACKWARD.clear();
            if (opers.isEmpty()) {
                opers.addAll(OPERS_OF_ADJUST_BACKWARD_NEXT);
                OPERS_OF_ADJUST_BACKWARD_NEXT.clear();
                if (opers.isEmpty()) {
                    opers.addAll(OPERS_OF_ADJUST_FORWARD);
                    OPERS_OF_ADJUST_FORWARD.clear();
                }
            }
        } else if (OPERS_OF_ADJUST_BACKWARD.isEmpty()) {
            opers.addAll(OPERS_OF_ADJUST_BACKWARD_NEXT);
            OPERS_OF_ADJUST_BACKWARD_NEXT.clear();
        }
        if (!OPERS_OF_ADJUST_BACKWARD.isEmpty()) {
            OPERS_OF_ADJUST_BACKWARD_NEXT.addAll(0, opers);
        }
        if (opers.isEmpty()) {
            opers.addAll(OPERS_OF_DELAY_SEND_ADJOINLINKID);
            OPERS_OF_DELAY_SEND_ADJOINLINKID.clear();
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        errorList.add(37898);
        errorList.add(38737);
        return errorList;
    }

    private boolean isNeedFilterOperationList(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        return ne.getNEType() != 92 && ne.getNEType() != 115 && !TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IFBOARD_AND_ODUBOARD_INTEGRATION");
    }

    private boolean isNeedAddTransaction() {
        boolean confSupport = TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_NEVERSION_SUPPORT_TRANSACTION");
        if (confSupport) {
            return true;
        }
        TENE currentNE = TENEListMgr.getInstance().getNE(this.neid);
        int neType = currentNE.getNEType();
        boolean isRtn600 = false;
        if (neType == 54 || neType == 55 || neType == 60 || TESpecialAttrMgr.getInstance().isNESupport(this.neid, "TE_FUNC_RTN_CFG_HOPMGR", "TE_ATTR_RTN_HOPMGR_IS_PACKETMICROWAVE_NE")) {
            isRtn600 = true;
        }
        if (!isRtn600) {
            if (neType == 95 || neType == 92 || neType == 115) {
                return true;
            }
            String showVersion = currentNE.getShowNEVersion();
            String[] args = showVersion.split("\\.");
            String subVerHigh = args[2];
            String subVerLow = args[3];
            if (Integer.parseInt(subVerHigh) > 2 || Integer.parseInt(subVerHigh) == 2 && Integer.parseInt(subVerLow) >= 20) {
                return true;
            }
        }
        return false;
    }

    private void addTransaction(ArrayList<Operation> opers) {
        ArrayList<Operation> tmpOpers = new ArrayList<Operation>();
        Iterator<Operation> iter = opers.iterator();
        while (iter.hasNext()) {
            Operation oper = iter.next();
            if (!TrasactionCmdList.contains(oper.getName())) continue;
            tmpOpers.add(oper);
            iter.remove();
        }
        if (tmpOpers.isEmpty()) {
            return;
        }
        if (tmpOpers.size() > 1) {
            Operation trans_start_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)TRASN_START);
            Operation trans_end_oper = TECreateObjectFactory.getOperation((int)this.neid, (String)TRASN_END);
            tmpOpers.add(0, trans_start_oper);
            tmpOpers.add(trans_end_oper);
            opers.addAll(tmpOpers);
        } else if (tmpOpers.size() == 1) {
            opers.addAll(tmpOpers);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        List<Integer> errorList = this.processPreHandleMessage(operationList);
        int result = 0;
        if (!OPERS_OF_DELAY_SEND_ADJOINLINKID.isEmpty() && 0 == (result = TECommuNEMgr.getInstance().sendCommand((int)neid, (ArrayList)((ArrayList)TESetIFODUBean.OPERS_OF_DELAY_SEND_ADJOINLINKID), (int)this.getTimeOut(), (SubFunc)subfunc).retCode)) {
            operationList.addAll(OPERS_OF_DELAY_SEND_ADJOINLINKID);
        }
        if (!OPERS_OF_ADJUST_BACKWARD.isEmpty()) {
            result = TECommuNEMgr.getInstance().sendCommand((int)neid, (ArrayList)((ArrayList)TESetIFODUBean.OPERS_OF_ADJUST_BACKWARD), (int)this.getTimeOut(), (SubFunc)subfunc).retCode;
        }
        if (!OPERS_OF_ADJUST_BACKWARD_NEXT.isEmpty()) {
            result = TECommuNEMgr.getInstance().sendCommand((int)neid, (ArrayList)((ArrayList)TESetIFODUBean.OPERS_OF_ADJUST_BACKWARD_NEXT), (int)this.TIME_OUT, (SubFunc)subfunc).retCode;
            OPERS_OF_ADJUST_BACKWARD.addAll(OPERS_OF_ADJUST_BACKWARD_NEXT);
        }
        if (0 == result) {
            operationList.addAll(OPERS_OF_ADJUST_BACKWARD);
        }
        super.handleMessage(neid, operationList, subfunc);
        this.appendNoFilterErrorCode(neid, errorList);
        this.appendAttrIDErrorCode(neid);
        TEIFODUCommonBean.processRef(neid, RefCmdList, this.inputData);
    }

    private void appendNoFilterErrorCode(int neid, List<Integer> errorList) {
        if (!errorList.isEmpty() && this.outputData.getBussinessParams() != null) {
            RowParams row = new RowParams();
            int len = errorList.size();
            for (int i = 0; i < len; ++i) {
                RowErrors rowError = new RowErrors();
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorList.get(i)));
                rowError.addParam(new Param("neid", String.valueOf(neid)));
                TENE neObj = TENEListMgr.getInstance().getNE(neid);
                rowError.addParam(new Param("nename", neObj.getNEName()));
                row.addRowErrors(rowError);
            }
            this.outputData.getBussinessParams().addRowParams(row);
            if (String.valueOf(0).equals(this.outputData.getErrorMessage().getErrorcode())) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        }
    }

    private void appendAttrIDErrorCode(int neid) {
        if (this.outputData.getBussinessParams() != null) {
            RowParams row = null;
            int len = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                row = this.outputData.getBussinessParams().getRowParams(i);
                RowErrors[] rowErrors = row.getRowErrors();
                ArrayList<RowErrors> rowErrorList = new ArrayList<RowErrors>();
                for (int j = rowErrors.length - 1; j >= 0; --j) {
                    RowErrors vrowError = rowErrors[j];
                    rowErrorList.addAll(this.getNeedAddAtrrs(vrowError));
                }
                for (RowErrors rowErr : rowErrorList) {
                    if (rowErr == null) continue;
                    row.addRowErrors(rowErr);
                }
            }
        }
    }

    private List<RowErrors> getNeedAddAtrrs(RowErrors rowError) {
        ArrayList<RowErrors> needAddAtrrs = new ArrayList<RowErrors>();
        if (rowError == null) {
            return needAddAtrrs;
        }
        ArrayList<String> filterAtrrs = new ArrayList<String>();
        filterAtrrs.add("neid");
        filterAtrrs.add("nename");
        filterAtrrs.add("slotid");
        filterAtrrs.add("subslotid");
        filterAtrrs.add("boardtype");
        filterAtrrs.add("boardname");
        Param[] params = rowError.getParam();
        boolean isFirst = true;
        for (int i = params.length - 1; i >= 0; --i) {
            Param vParam = params[i];
            if (!"attrId".equalsIgnoreCase(vParam.getName()) || filterAtrrs.contains(vParam.getValue())) continue;
            if (isFirst) {
                isFirst = false;
                continue;
            }
            RowErrors tempRow = this.getCloneErrorRow(rowError, vParam.getValue());
            if (tempRow == null) continue;
            needAddAtrrs.add(tempRow);
        }
        return needAddAtrrs;
    }

    private RowErrors getCloneErrorRow(RowErrors vRowError, String attrID) {
        ArrayList<String> clonAtrrs = new ArrayList<String>();
        clonAtrrs.add("neid");
        clonAtrrs.add("nename");
        clonAtrrs.add("slotid");
        clonAtrrs.add("boardtype");
        clonAtrrs.add("boardname");
        clonAtrrs.add(attrID);
        RowErrors cloneObj = new RowErrors();
        int len = vRowError.getParamCount();
        for (int i = 0; i < len; ++i) {
            Param param = vRowError.getParam(i);
            if ("attrId".equalsIgnoreCase(param.getName()) && clonAtrrs.contains(param.getValue())) {
                cloneObj.addParam((Param)param.clone());
            }
            if ("attrId".equalsIgnoreCase(param.getName()) || !clonAtrrs.contains(param.getName())) continue;
            cloneObj.addParam((Param)param.clone());
        }
        if (null != vRowError.getErrorMessage()) {
            cloneObj.setErrorMessage((ErrorMessage)vRowError.getErrorMessage().clone());
        }
        if (cloneObj.getParam("attrId") == null) {
            cloneObj = null;
        }
        return cloneObj;
    }

    private List<Integer> processPreHandleMessage(ArrayList opers) {
        this.fillTransErrCodeToNoramlOper(opers);
        Iterator iter = opers.iterator();
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        ArrayList<Integer> filterErrors = this.getFilterErrorCodeList();
        while (iter.hasNext()) {
            String errorCode;
            Operation oper = (Operation)iter.next();
            if (TRASN_START.equals(oper.getName()) || TRASN_END.equals(oper.getName())) {
                iter.remove();
            }
            if (!"NSCMD_CFG_SET_ODU_WORK_FORHOP".equals(oper.getName()) && !"NSCMD_CFG_SET_ODU_TXPOWER_FORHOP".equals(oper.getName()) || (errorCode = oper.getOutput(0).getFault(0).getCode()) == null || errorCode.isEmpty() || !filterErrors.contains(Integer.parseInt(errorCode))) continue;
            errorList.add(Integer.valueOf(errorCode));
        }
        return errorList;
    }

    private void fillTransErrCodeToNoramlOper(List<Operation> opers) {
        int start = -1;
        int end = -1;
        String trans_errCode = String.valueOf(0);
        int len = opers.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = opers.get(i);
            if (TRASN_START.equals(oper.getName())) {
                start = opers.indexOf(oper);
            }
            if (!TRASN_END.equals(oper.getName())) continue;
            end = opers.indexOf(oper);
            trans_errCode = oper.getOutput(0).getFault(0).getCode();
        }
        List<Operation> tmpList = null;
        if (start >= 0 && end >= 0 && !String.valueOf(0).equals(trans_errCode)) {
            tmpList = opers.subList(start + 1, end);
        }
        if (tmpList == null) {
            return;
        }
        for (Operation oper : tmpList) {
            oper.getOutput(0).getFault(0).setCode(trans_errCode);
        }
    }

    public int getTimeOut() {
        return SET_TIME_OUT;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeAllLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        StringBuilder des = new StringBuilder();
        RowParams rowParams = null;
        int len = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            des.append(this.getOneRowOperaStr(rowParams));
        }
        return des.toString();
    }

    private String getOneRowOperaStr(RowParams rowParams) {
        String des = "";
        String attrs = "";
        int slotid = 0;
        String boardName = "";
        if (rowParams.getParam("slotid") != null && rowParams.getParamCount() > 3) {
            slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            boardName = this.getBoardName(slotid);
            if (boardName.toUpperCase().indexOf("ODU") >= 0) {
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCENABLE", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCUPPER", 10);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCLOWER", 10);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITFRE", 1000);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRINTERVAL", 1000);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITPOWER", 10);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_RECEIVEPOWER", 10);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_WORKSTATUS", 0);
            } else {
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_RADIOWORKMODE", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_RADIOLINKID", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ADJOINLINKID", 0);
                attrs = attrs + this.getParamString(rowParams, IFPORT_ATTR_SERVICETYPE, 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_CHANNELSPAC", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ACMENABLESTATUS", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_MANUALMODE", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ENSURECALMODE", 0);
                attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ALLCALMODE", 0);
                attrs = attrs + this.getParamString(rowParams, "IFPORT_ATTR_E1STATUS", 0);
                attrs = attrs + this.getParamString(rowParams, "IFPORT_ATTR_ENSUREE1NUM", 0);
                attrs = attrs + this.getParamString(rowParams, "IFPORT_ATTR_FULLE1NUM", 0);
                attrs = attrs + this.getParamString(rowParams, "IFPORT_ATTR_STM1NUM", 0);
                attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_ANTENNA_POLAR_WBID", 0);
                int netype = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEType();
                if (netype == 92 || netype == 115) {
                    attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCENABLE", 0);
                    attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCUPPER", 10);
                    attrs = attrs + this.getParamString(rowParams, "W32PORT_ATTR_ATPCLOWER", 10);
                    attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITFRE", 1000);
                    attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRINTERVAL", 1000);
                    attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_TRANSMITPOWER", 10);
                    attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_RECEIVEPOWER", 10);
                    attrs = attrs + this.getParamString(rowParams, "W32BRD_ATTR_WORKSTATUS", 0);
                }
            }
            if (!attrs.isEmpty() && attrs.endsWith(", ")) {
                attrs = attrs.substring(0, attrs.length() - 2);
            }
            if (!attrs.isEmpty()) {
                des = String.valueOf(slotid) + this.resourceUtil.getString("sep") + boardName + " , " + attrs;
            }
        }
        return des;
    }

    private String getParamString(RowParams rowParams, String name, int digit) {
        StringBuffer sb = new StringBuffer();
        String value_rtn = "";
        if (rowParams.getParam(name) != null) {
            String resValue;
            int neType = TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEType();
            if (neType == 115 && (name.equals("W32PORT_ATTR_ACMENABLESTATUS") || name.equals("W32PORT_ATTR_ENSURECALMODE") || name.equals("W32PORT_ATTR_ALLCALMODE"))) {
                String opString = name + "_EBAND";
                sb.append(this.resourceUtil.getString(opString)).append(":");
            } else {
                sb.append(this.resourceUtil.getString(name)).append(":");
            }
            value_rtn = rowParams.getParam(name).getValue();
            if (0 != digit) {
                long ivalue = Long.parseLong(value_rtn);
                value_rtn = Float.toString((float)ivalue / (float)digit);
            }
            if (null != (resValue = this.resourceUtil.getString(name + "_" + value_rtn)) && !(name + "_" + value_rtn).equals(resValue)) {
                value_rtn = resValue;
            }
            sb.append(value_rtn).append(" , ");
        }
        return sb.toString();
    }

    private String getBoardName(int slotid) {
        TEBoard board_rtn = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        if (board_rtn == null) {
            return "";
        }
        int boardtype = board_rtn.getBoardType();
        String boardname_rtn = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype);
        return boardname_rtn;
    }

    public int sendMessage(int neid, ArrayList operationList) {
        int retCode = 0;
        List<Operation> OPERS_OF_DOADJUSTBEFORE = this.getDoadjustForwardOperations();
        if (null != OPERS_OF_DOADJUSTBEFORE && !OPERS_OF_DOADJUSTBEFORE.isEmpty()) {
            retCode = TECommuNEMgr.getInstance().sendCommand((int)neid, (ArrayList)((ArrayList)OPERS_OF_DOADJUSTBEFORE), (int)this.TIME_OUT, (SubFunc)this.subfunc).retCode;
        }
        OperationResult result = TECommuNEMgr.getInstance().sendCommand(neid, operationList, this.getTimeOut(), this.subfunc);
        if (null != OPERS_OF_DOADJUSTBEFORE && !OPERS_OF_DOADJUSTBEFORE.isEmpty()) {
            operationList.addAll(OPERS_OF_DOADJUSTBEFORE);
        }
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public List<Operation> getDoadjustForwardOperations() {
        return OPERS_OF_ADJUST_FORWARD;
    }

    static {
        IFCmdList.add("NSCMD_CFG_SET_RADIO_LINKID_FORHOP");
        IFCmdList.add("NSCMD_CFG_SET_RADIO_IFMODE_FORHOP");
        IFCmdList.add(NSCMD_CFG_SET_RADIO_SERVICETYPE_WBID);
        IFCmdList.add("NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
        IFCmdList.add("NSCMD_PTN_CFG_SET_ACM_PARAM");
        IFCmdList.add("NSCMD_CFG_SET_E1PRIENABLE_CFG");
        IFCmdList.add("NSCMD_RTN_CFG_SET_ACM_E1NUM_FORHOP");
        IFCmdList.add("NSCMD_CFG_SET_ATPC_ENABLE");
        IFCmdList.add("NSCMD_CFG_SET_ATPC_THRESHOLD");
        IFCmdList.add(NSCMD_CFG_SET_HYBRID_STM1CAPACITY_WBID);
        IFCmdList.add("NSCMD_CFG_SET_RADIO_XPIC_ENABLE");
        IFCmdList.add("NSCMD_CFG_SET_XPIC_BDPOLAR_WBID");
        IFCmdList.add("NSCMD_CFG_SET_RADIO_ADJOIN_LINKID");
        IFCmdList.add("NSCMD_RTN_CFG_SET_ANTENNA_POLAR_WBID");
        IFCmdList.add("NSCMD_CFG_SET_HYBRID_CAPACITY_FORHOP");
        ODUCmdList.add("NSCMD_CFG_SET_ODU_TXFREQ");
        ODUCmdList.add("NSCMD_CFG_SET_ODU_TRSPACING");
        ODUCmdList.add("NSCMD_CFG_SET_ODU_TXPOWER_FORHOP");
        ODUCmdList.add("NSCMD_CFG_SET_ODU_SRSL");
        ODUCmdList.add("NSCMD_CFG_SET_ODU_WORK_FORHOP");
        TrasactionCmdList.add("NSCMD_PTN_CFG_SET_IF_CHANNELSPACE");
        TrasactionCmdList.add("NSCMD_PTN_CFG_SET_ACM_PARAM");
        TrasactionCmdList.add("NSCMD_RTN_CFG_SET_ACM_E1NUM_FORHOP");
        TrasactionCmdList.add("NSCMD_CFG_SET_E1PRIENABLE_CFG");
        TrasactionCmdList.add("NSCMD_CFG_SET_ATPC_ENABLE");
        TrasactionCmdList.add("NSCMD_CFG_SET_ATPC_THRESHOLD");
        TrasactionCmdList.add("NSCMD_CFG_SET_ODU_TXFREQ");
        TrasactionCmdList.add("NSCMD_CFG_SET_ODU_TRSPACING");
        TrasactionCmdList.add("NSCMD_CFG_SET_ODU_TXPOWER_FORHOP");
        TrasactionCmdList.add("NSCMD_CFG_SET_ODU_SRSL");
        TrasactionCmdList.add("NSCMD_CFG_SET_ODU_WORK_FORHOP");
        TrasactionCmdList.add(NSCMD_CFG_SET_HYBRID_STM1CAPACITY_WBID);
        RefCmdList.add("NSCMD_RTN_CFG_GET_EVERYMOD_E1NUM_CFG");
        RefCmdList.add("NSCMD_CFG_GET_AM_CURRCAPACITY");
    }
}

